define([
    'backbone',
    './lead-builder-form',
    './lead-builder-grid',
    './lead-score-rules-form',
    './lead-score-rules-grid',
    'text!../templates/clean-up/clean-up-unused-fields-block.html',
    'text!../templates/clean-up/clean-up-littleused-fields-li.html',
    'i18n!../../../nls/dashboard_'+$('#main-dashboard-system-language').val()+'_ln'
], function(Backbone, LeadBuilderFormView, LeadBuilderGridView, LeadScoreRulesFormView, LeadScoreViewGrid, CleanUpUnusedFieldsBlockTmpl, CleanUpLittleUsedFieldsLiTmpl, i18n
){

    var LeadsToolsMainView = Backbone.View.extend({
        el: $('#lead-tools-block'),
        events: {
            'click a[data-role=form-builder-detailed-view]': 'showFormBuilderDetailsScreen',
            'click #lead-tools-block-tabs-tab li' : 'showLeadToolsTabs',
            'click #form-builder-grid-back-link': 'returnFromFormBuilderMainTab',
            'click #score-rules-grid-back-link': 'returnFromScoreMainTab',
            'click a.form-field-rules-row-edit': 'showScoreRuleDetailsScreen',
            'click a.copy-path-link-information-info': 'leadScoringPath',
            'submit #unused-fields-form': 'deleteUnusedFields',
            'mouseover .delete-unsd-fields-btn': 'attentionMsg',
            'mouseout .delete-unsd-fields-btn': 'attentionMsg',
            'change .unsd-field': 'countUnusedFields',
            'change .unsd-field-selector': 'unsdFieldSelector',
            'click .check-refresh': 'checkOrRefresh',
            'click .delete-unused-fields': 'pullUnusedFields',
            'click .unused-little-used-type-switcher': 'switchUnusedLittleUsedType',
            'keyup #little-used-qty-field' : 'searchEnterLittleUsedAction',
            'click .search-little-used-btn': 'searchLittleUsedBtn',
        },
        templates: {},
        initialize: function(options){

        },
        render: function(){

        },
        leadScoringPath: function(e)
        {
            e.preventDefault();
            if (document.queryCommandSupported("copy")) {
                var copyFromEl = $('<textarea/>');
                copyFromEl.text($(e.currentTarget).data('element-id'));
                $('body').append(copyFromEl);
                copyFromEl.select();
                document.execCommand('copy', true);
                copyFromEl.remove();
                showMessage('Has been copied to clipboard.', false, 2000);
            }
        },
        checkOrRefresh: function (e) {
            e.preventDefault();
            var type = $(e.currentTarget).data('type');

            if (type == 'refresh') {
                var currentTab = $('.clean-up-content').find('button.current'),
                    tabType = currentTab.data('type');

                if(typeof tabType !== 'undefined' && tabType != '') {
                    var subTab = $('#range-type-block').find('button.current');
                    if(subTab.length && subTab.data('filter-type') == 'little-used') {
                        this.searchEnterLittleUsedAction({}, 1);
                        return true;
                    }

                    this.renderUnusedFields(tabType);
                }
            } else {
                $('.check-refresh').removeClass('checked-link');

                if(type == 'check-all') {
                    $('.check-all-link').addClass('checked-link');
                } else {
                    $('.uncheck-all-link').addClass('checked-link');
                }

                $('#unused-fields-form').find('input.unsd-field[type="checkbox"]').each(function(key, val){
                    if(type == 'check-all') {
                        if(!$(this).hasClass('disabled-checkbox')) {
                            $(this).closest('.order-field-row').addClass('order-field-checked');
                            $(this).prop('checked', true);
                        }
                    } else if (type == 'uncheck-all') {
                        if(!$(this).hasClass('disabled-checkbox')) {
                            $(this).closest('.order-field-row').removeClass('order-field-checked');
                            $(this).prop('checked', false);
                        }
                    }
                });

                this.countUnusedFields();
            }
        },
        unsdFieldSelector: function (e) {
            e.preventDefault();
            var selector = $(e.currentTarget);

            if (selector.is(':checked')) {
                selector.closest('.order-field-row').addClass('order-field-checked');
            } else {
                selector.closest('.order-field-row').removeClass('order-field-checked');
            }
        },
        countUnusedFields: function () {
            var checkedFields = $('#unused-fields-form').find('input.unsd-field[type="checkbox"]:checked');

            if(checkedFields.length) {
                $('.selected-elements-counter-zero').hide();
                $('.selected-elements-counter').show().find('.counter').text(checkedFields.length);
                $('.delete-unsd-fields-btn').removeAttr('disabled');
            } else {
                $('.selected-elements-counter').hide();
                $('.selected-elements-counter-zero').show();
                $('.delete-unsd-fields-btn').attr('disabled', true);
            }
        },
        attentionMsg: function (e) {
            var eventType = e.type;
            if(eventType == 'mouseover') {
                $('.attention-msg').show();
            } else {
                $('.attention-msg').hide();
            }
        },
        deleteUnusedFields: function (e)
        {
            e.preventDefault();
            var currentEl = $(e.currentTarget),
                type = currentEl.data('type'),
                checkedUnusedFields = [],
                removeMsg = (_.isUndefined(i18n['Are you sure want to remove selected unused custom lead fields?']) ? 'Are you sure want to remove selected unused custom lead fields?' : i18n['Are you sure want to remove selected unused custom lead fields?']),
                successMsg = (_.isUndefined(i18n['lead custom fields have been successfully removed']) ? 'lead custom fields have been successfully removed' : i18n['lead custom fields have been successfully removed']),
                littleUsed = false;

            var subTab = $('#range-type-block').find('button.current');
            if(subTab.length && subTab.data('filter-type') == 'little-used') {
                littleUsed = true;
            }

            if(type == 'organization-custom-fields') {
                removeMsg = (_.isUndefined(i18n['Are you sure want to remove selected unused custom organization fields?']) ? 'Are you sure want to remove selected unused custom organization fields?' : i18n['Are you sure want to remove selected unused custom organization fields?']);
                successMsg = (_.isUndefined(i18n['organization custom fields have been successfully removed']) ? 'organization custom fields have been successfully removed' : i18n['organization custom fields have been successfully removed']);
            } else if(type == 'lead-tags') {
                removeMsg = (_.isUndefined(i18n['Are you sure want to remove selected unused lead tags?']) ? 'Are you sure want to remove selected unused lead tags?' : i18n['Are you sure want to remove selected unused lead tags?']);
                successMsg = (_.isUndefined(i18n['lead tags have been successfully removed']) ? 'lead tags have been successfully removed' : i18n['lead tags have been successfully removed']);

                if(littleUsed) {
                    removeMsg = (_.isUndefined(i18n['Are you sure want to remove selected little-used lead tags?']) ? 'Are you sure want to remove selected little-used lead tags?' : i18n['Are you sure want to remove selected little-used lead tags?']);
                }
            } else if(type == 'lead-types') {
                removeMsg = (_.isUndefined(i18n['Are you sure want to remove selected unused lead types?']) ? 'Are you sure want to remove selected unused lead types?' : i18n['Are you sure want to remove selected unused lead types?']);
                successMsg = (_.isUndefined(i18n['lead types have been successfully removed']) ? 'lead types have been successfully removed' : i18n['lead types have been successfully removed']);
            } else if(type == 'lead-lifecycle-stages') {
                removeMsg = (_.isUndefined(i18n['Are you sure want to remove selected unused lead lifecycle stages?']) ? 'Are you sure want to remove selected unused lead lifecycle stages?' : i18n['Are you sure want to remove selected unused lead lifecycle stages?']);
                successMsg = (_.isUndefined(i18n['lead lifecycle stages have been successfully removed']) ? 'lead lifecycle stages have been successfully removed' : i18n['lead lifecycle stages have been successfully removed']);
            } else if(type == 'organizations-industries') {
                removeMsg = (_.isUndefined(i18n['Are you sure want to remove selected unused organization\'s industries?']) ? 'Are you sure want to remove selected unused organization\'s industries?' : i18n['Are you sure want to remove selected unused organization\'s industries?']);
                successMsg = (_.isUndefined(i18n['organization\'s industries have been successfully removed']) ? 'organization\'s industries have been successfully removed' : i18n['organization\'s industries have been successfully removed']);
            }

            currentEl.find('input.unsd-field[type="checkbox"]:checked').each(function(){
                checkedUnusedFields.push($(this).val());
            });

            if(!checkedUnusedFields.length) {
                showMessage((_.isUndefined(i18n['Nothing to remove']) ? 'Nothing to remove' : i18n['Nothing to remove']), false, 3000);
                return false;
            }

            if(checkedUnusedFields.length == 1) {
                removeMsg = (_.isUndefined(i18n['Are you sure want to remove selected unused custom lead field?']) ? 'Are you sure want to remove selected unused custom lead field?' : i18n['Are you sure want to remove selected unused custom lead field?']);
                if(type == 'organization-custom-fields') {
                    removeMsg = (_.isUndefined(i18n['Are you sure want to remove selected unused custom organization field?']) ? 'Are you sure want to remove selected unused custom organization field?' : i18n['Are you sure want to remove selected unused custom organization field?']);
                } else if(type == 'lead-tags') {
                    removeMsg = (_.isUndefined(i18n['Are you sure want to remove selected unused lead tag?']) ? 'Are you sure want to remove selected unused lead tag?' : i18n['Are you sure want to remove selected unused lead tag?']);

                    if(littleUsed) {
                        removeMsg = (_.isUndefined(i18n['Are you sure want to remove selected little-used lead tag?']) ? 'Are you sure want to remove selected little-used lead tag?' : i18n['Are you sure want to remove selected little-used lead tag?']);
                    }
                } else if(type == 'lead-types') {
                    removeMsg = (_.isUndefined(i18n['Are you sure want to remove selected unused lead type?']) ? 'Are you sure want to remove selected unused lead type?' : i18n['Are you sure want to remove selected unused lead type?']);
                } else if(type == 'lead-lifecycle-stages') {
                    removeMsg = (_.isUndefined(i18n['Are you sure want to remove selected unused lead lifecycle stage?']) ? 'Are you sure want to remove selected unused lead lifecycle stage?' : i18n['Are you sure want to remove selected unused lead lifecycle stage?']);
                } else if(type == 'organizations-industries') {
                    removeMsg = (_.isUndefined(i18n['Are you sure want to remove selected unused organization industry?']) ? 'Are you sure want to remove selected unused organization industry?' : i18n['Are you sure want to remove selected unused organization industry?']);
                }
            }

            showConfirm(removeMsg, function () {
                $('.delete-unsd-fields-btn').attr('disabled', true);

                showSpinner();
                $.ajax({
                    url: $('#website_url').val()+'plugin/leads/run/deleteUnusedFields/',
                    type: 'POST',
                    dataType: 'json',
                    data: {
                        'secureToken'         : $('#tools-leads-grid-token').val(),
                        'type'                : type,
                        'checkedUnusedFields' : checkedUnusedFields
                    }
                }).done(function (response) {
                    hideSpinner();
                    $('.delete-unsd-fields-btn').removeAttr('disabled');

                    if(response.error == '1') {
                        showMessage(response.responseText, true, 3000);
                    } else {
                        if(typeof response.responseText.deletedItems !== 'undefined') {
                            if(response.responseText.deletedItems == 1) {
                                successMsg = (_.isUndefined(i18n['lead custom field has been successfully removed']) ? 'lead custom field has been successfully removed' : i18n['lead custom field has been successfully removed']);
                                if(type == 'organization-custom-fields') {
                                    successMsg = (_.isUndefined(i18n['organization custom field has been successfully removed']) ? 'organization custom field has been successfully removed' : i18n['organization custom field has been successfully removed']);
                                } else if(type == 'lead-tags') {
                                    successMsg = (_.isUndefined(i18n['lead tag has been successfully removed']) ? 'lead tag has been successfully removed' : i18n['lead tag has been successfully removed']);
                                } else if(type == 'lead-types') {
                                    successMsg = (_.isUndefined(i18n['lead type has been successfully removed']) ? 'lead type has been successfully removed' : i18n['lead type has been successfully removed']);
                                } else if(type == 'lead-lifecycle-stages') {
                                    successMsg = (_.isUndefined(i18n['lead lifecycle stage has been successfully removed']) ? 'lead lifecycle stage has been successfully removed' : i18n['lead lifecycle stage has been successfully removed']);
                                } else if(type == 'organizations-industries') {
                                    successMsg = (_.isUndefined(i18n['organization industry has been successfully removed']) ? 'organization industry has been successfully removed' : i18n['organization industry has been successfully removed']);
                                }
                            }

                            showMessage(response.responseText.deletedItems + ' ' + successMsg, false, 3000);
                        } else {
                            showMessage(response.responseText, false, 3000);
                        }
                    }

                    $('.refresh-item').trigger('click');

                });
            });

        },
        showFormBuilderDetailsScreen: function(e)
        {
            var formId = $(e.currentTarget).closest('tr').data('rule-id');
            if (!formId) {
                return false;
            }
            window.appLeadToolsRouter.leadFormBuildDetails(formId);
        },
        showScoreRuleDetailsScreen: function(e)
        {
            var scoreId = $(e.currentTarget).data('cid');
            if (!scoreId) {
                return false;
            }
            window.appLeadToolsRouter.leadScoreDetails(scoreId);
        },
        returnFromFormBuilderMainTab: function(e)
        {
            e.preventDefault();
            $('#lead-form-builder-form-detailed-block').empty();
            $('#lead-tools-block-tabs-block').removeClass('hidden');
            $('.form-builder-form-type').first().trigger('click');

        },
        returnFromScoreMainTab: function(e)
        {
            e.preventDefault();
            $('#lead-score-detailed-block').empty();
            $('#lead-tools-block-tabs-block').removeClass('hidden');
        },
        showLeadToolsTabs: function(e)
        {
            var el = $(e.currentTarget),
                tabBlockContentId = el.data('tab-id'),
                tabContentName = el.data('tab-name'),
                tabBlockContentEl = $('#'+tabBlockContentId),
                self = this,
                tabContentBlock = el.closest('#lead-tools-block-tabs-block').find('.lead-tools-block-tabs-content');

            if (el.hasClass('current')) {
                return false;
            }

            $('#lead-event-create-rule-form-block').empty();
            $('#lead-form-builder-form-block').empty();

            if (tabBlockContentEl.hasClass('hidden')) {
                if (tabContentName === 'form-builder') {
                    if(!_.isUndefined(this.LeadBuilderGridView)) {
                        this.LeadBuilderGridView.$el.unbind();
                    }
                    if(!_.isUndefined(this.LeadBuilderFormView)) {
                        this.LeadBuilderFormView.$el.unbind();
                    }
                    this.LeadBuilderFormView = new LeadBuilderFormView();
                    this.LeadBuilderGridView = new LeadBuilderGridView();
                    self.assign({
                        '#lead-form-builder-grid-table': this.LeadBuilderGridView,
                        '#lead-form-builder-form-block' : this.LeadBuilderFormView
                    });

                    this.LeadBuilderFormView.$el.on('LeadBuilderFormGrid:created', _.bind(this.LeadBuilderGridView.render, this.LeadBuilderGridView));
                    self.hideTab(tabBlockContentEl, el);
                }

                if (tabContentName === 'lead-score-rules') {
                    if(!_.isUndefined(this.LeadScoreGridView)) {
                        this.LeadScoreGridView.$el.unbind();
                    }
                    if(!_.isUndefined(this.LeadScoreRulesFormView)) {
                        this.LeadScoreRulesFormView.$el.unbind();
                    }
                    this.LeadScoreRulesFormView = new LeadScoreRulesFormView();
                    this.LeadScoreGridView = new LeadScoreViewGrid();
                    self.assign({
                        '#lead-score-builder-grid-block': this.LeadScoreGridView,
                        '#lead-score-form-block' : this.LeadScoreRulesFormView
                    });

                    this.LeadScoreRulesFormView.$el.on('LeadScoreFormGrid:created', _.bind(this.LeadScoreGridView.render, this.LeadScoreGridView));
                    self.hideTab(tabBlockContentEl, el);
                }

                if (tabContentName === 'clean-up') {
                    self.hideTab(tabBlockContentEl, el);
                    self.renderUnusedFields('lead-custom-fields');
                }
            }

            tabContentBlock.addClass('hidden');
            $('#lead-tools-block-tabs-tab').find('li').removeClass('current');
            this.hideTab(tabBlockContentEl, el);
        },
        hideTab: function (tabBlockContentEl, el){
            tabBlockContentEl.removeClass('hidden');
            el.closest('li').addClass('current');
        },
        assign: function (selector, view) {
            var selectors;
            if (_.isObject(selector)) {
                selectors = selector;
            }
            else {
                selectors = {};
                selectors[selector] = view;
            }
            if (!selectors) return;
            _.each(selectors, function (view, selector) {
                view.setElement(this.$(selector)).render();
            }, this);
        },
        pullUnusedFields: function (e) {
           var type = $(e.currentTarget).data('type');

           if(typeof type !== 'undefined') {
               this.renderUnusedFields(type);
           }
        },
        renderUnusedFields: function (blockType) {
            var self = this;

            $.ajax({
                'url': $('#website_url').val()+'plugin/leads/run/getUnusedFields/',
                'type':'POST',
                'dataType':'json',
                'data': {
                    'secureToken' : $('#tools-leads-grid-token').val(),
                    'type'        : blockType
                }
            }).done(function(responseData){
                //self.$el.find('.unused-fields-info').remove();
                $('.delete-unused-fields').removeClass('current');

                if(blockType == 'lead-custom-fields') {
                    $('#unused-custom-lead-fields').addClass('current');
                }

                var blockHeader = (_.isUndefined(i18n['Unused lead custom fields in your CRM system']) ? 'Unused lead custom fields in your CRM system' : i18n['Unused lead custom fields in your CRM system']),
                    selectFieldsMsg = (_.isUndefined(i18n['Pick lead custom fields from the list below to clear them from the system.']) ? 'Pick lead custom fields from the list below to clear them from the system.' : i18n['Pick lead custom fields from the list below to clear them from the system.']),
                    attentionMsg = (_.isUndefined(i18n['Be careful, all selected lead custom fields will be permanently deleted from the system!']) ? 'Be careful, all selected lead custom fields will be permanently deleted from the system!' : i18n['Be careful, all selected lead custom fields will be permanently deleted from the system!']),
                    deleteBtn = (_.isUndefined(i18n['Remove selected lead custom fields']) ? 'Remove selected lead custom fields' : i18n['Remove selected lead custom fields']),
                    noFieldsFound = (_.isUndefined(i18n['No unused lead custom fields found']) ? 'No unused lead custom fields found' : i18n['No unused lead custom fields found']);
                if(blockType == 'organization-custom-fields') {
                    $('#unused-custom-organization-fields').addClass('current');
                    blockHeader = (_.isUndefined(i18n['Unused organization custom fields in your CRM system']) ? 'Unused organization custom fields in your CRM system' : i18n['Unused organization custom fields in your CRM system']);
                    selectFieldsMsg = (_.isUndefined(i18n['Pick organization custom fields from the list below to clear them from the system.']) ? 'Pick organization custom fields from the list below to clear them from the system.' : i18n['Pick organization custom fields from the list below to clear them from the system.']);
                    attentionMsg = (_.isUndefined(i18n['Be careful, all selected organization custom fields will be permanently deleted from the system!']) ? 'Be careful, all selected organization custom fields will be permanently deleted from the system!' : i18n['Be careful, all selected organization custom fields will be permanently deleted from the system!']);
                    deleteBtn = (_.isUndefined(i18n['Remove selected organization custom fields']) ? 'Remove selected organization custom fields' : i18n['Remove selected organization custom fields']);
                    noFieldsFound = (_.isUndefined(i18n['No unused organization custom fields found']) ? 'No unused organization custom fields found' : i18n['No unused organization custom fields found']);
                } else if(blockType == 'lead-tags') {
                    $('#unused-tags').addClass('current');
                    blockHeader = (_.isUndefined(i18n['Unused tags in your CRM system']) ? 'Unused tags in your CRM system' : i18n['Unused tags in your CRM system']);
                    selectFieldsMsg = (_.isUndefined(i18n['Pick tags from the list below to clear them from the system.']) ? 'Pick tags from the list below to clear them from the system.' : i18n['Pick tags from the list below to clear them from the system.']);
                    attentionMsg = (_.isUndefined(i18n['Be careful, all selected tags will be permanently deleted from the system!']) ? 'Be careful, all selected tags will be permanently deleted from the system!' : i18n['Be careful, all selected tags will be permanently deleted from the system!']);
                    deleteBtn = (_.isUndefined(i18n['Remove selected tags']) ? 'Remove selected tags' : i18n['Remove selected tags']);
                    noFieldsFound = (_.isUndefined(i18n['No unused tags found']) ? 'No unused tags found' : i18n['No unused tags found']);
                } else if(blockType == 'lead-types') {
                    $('#unused-lead-types').addClass('current');
                    blockHeader = (_.isUndefined(i18n['Unused lead types in your CRM system']) ? 'Unused lead types in your CRM system' : i18n['Unused lead types in your CRM system']);
                    selectFieldsMsg = (_.isUndefined(i18n['Pick lead types from the list below to clear them from the system.']) ? 'Pick lead types from the list below to clear them from the system.' : i18n['Pick lead types from the list below to clear them from the system.']);
                    attentionMsg = (_.isUndefined(i18n['Be careful, all selected lead types will be permanently deleted from the system!']) ? 'Be careful, all selected lead types will be permanently deleted from the system!' : i18n['Be careful, all selected lead types will be permanently deleted from the system!']);
                    deleteBtn = (_.isUndefined(i18n['Remove selected lead types']) ? 'Remove selected lead types' : i18n['Remove selected lead types']);
                    noFieldsFound = (_.isUndefined(i18n['No unused lead types found']) ? 'No unused lead types found' : i18n['No unused lead types found']);
                } else if(blockType == 'lead-lifecycle-stages') {
                    $('#unused-lead-lifecycle-stages').addClass('current');
                    blockHeader = (_.isUndefined(i18n['Unused lead lifecycle stages in your CRM system']) ? 'Unused lead lifecycle stages in your CRM system' : i18n['Unused lead lifecycle stages in your CRM system']);
                    selectFieldsMsg = (_.isUndefined(i18n['Pick lead lifecycle stages from the list below to clear them from the system.']) ? 'Pick lead lifecycle stages from the list below to clear them from the system.' : i18n['Pick lead lifecycle stages from the list below to clear them from the system.']);
                    attentionMsg = (_.isUndefined(i18n['Be careful, all selected lead lifecycle stages will be permanently deleted from the system!']) ? 'Be careful, all selected lead lifecycle stages will be permanently deleted from the system!' : i18n['Be careful, all selected lead lifecycle stages will be permanently deleted from the system!']);
                    deleteBtn = (_.isUndefined(i18n['Remove selected lead lifecycle stages']) ? 'Remove selected lead lifecycle stages' : i18n['Remove selected lead lifecycle stages']);
                    noFieldsFound = (_.isUndefined(i18n['No unused lead lifecycle stages found']) ? 'No unused lead lifecycle stages found' : i18n['No unused lead lifecycle stages found']);
                } else if(blockType == 'organizations-industries') {
                    $('#unused-organizations-industries').addClass('current');
                    blockHeader = (_.isUndefined(i18n['Unused organization\'s industries in your CRM system']) ? 'Unused organization\'s industries in your CRM system' : i18n['Unused organization\'s industries in your CRM system']);
                    selectFieldsMsg = (_.isUndefined(i18n['Pick organization\'s industries from the list below to clear them from the system.']) ? 'Pick organization\'s industries from the list below to clear them from the system.' : i18n['Pick organization\'s industries from the list below to clear them from the system.']);
                    attentionMsg = (_.isUndefined(i18n['Be careful, all selected organization\'s industries will be permanently deleted from the system!']) ? 'Be careful, all selected organization\'s industries will be permanently deleted from the system!' : i18n['Be careful, all selected organization\'s industries will be permanently deleted from the system!']);
                    deleteBtn = (_.isUndefined(i18n['Remove selected organization\'s industries']) ? 'Remove selected organization\'s industries' : i18n['Remove selected organization\'s industries']);
                    noFieldsFound = (_.isUndefined(i18n['No unused organization\'s industries found']) ? 'No unused organization\'s industries found' : i18n['No unused organization\'s industries found']);
                }

                var emptyData = 0;
                if (_.isEmpty(responseData.responseText.unusedFields)) {
                    emptyData = 1;
                }

                self.$el.find('#unused-fields-block').html(_.template(CleanUpUnusedFieldsBlockTmpl, {
                    'type': blockType,
                    'unusedFields': responseData.responseText.unusedFields,
                    'unusedFieldsCount': responseData.responseText.unusedFieldsCount,
                    'unusedFieldsCountSelected': responseData.responseText.unusedFieldsCountSelected,
                    'blockHeader': blockHeader,
                    'selectFieldsMsg': selectFieldsMsg,
                    'attentionMsg': attentionMsg,
                    'deleteBtn': deleteBtn,
                    'emptyData': emptyData,
                    'noFieldsFound': noFieldsFound,
                    'i18n': i18n
                }));
            });

        },
        switchUnusedLittleUsedType: function(e)
        {
            e.preventDefault();
            var el = $(e.currentTarget);

            $('.unused-little-used-type-switcher').removeClass('current');
            el.addClass('current');

            var tabType = $('#unused-fields-form').data('type'),
                filterType = $(e.currentTarget).data('filter-type');

            if(filterType == 'unused') {
                $('.little-used-block').addClass('hide');
                this.renderUnusedFields(tabType);
            }

            if(filterType == 'little-used') {
                $('.list-content').empty();
                $('.all-counter').text(0);
                this.countUnusedFields();
                $('.little-used-block').removeClass('hide');
                $('.check-refresh').addClass('checked-link');
            }
        },
        searchEnterLittleUsedAction: function(event, onDemand)
        {
            var self = this;

            if (event.keyCode === 13 || onDemand) {
                var searchedElVal = parseInt($('#little-used-qty-field').val());

                if(searchedElVal) {
                    var tabType = $('#unused-fields-form').data('type')

                    $.ajax({
                        'url': $('#website_url').val()+'plugin/leads/run/getLittleUsedFields/',
                        'type':'POST',
                        'dataType':'json',
                        'data': {
                            'secureToken' : $('#tools-leads-grid-token').val(),
                            'type'        : tabType,
                            'usedLimit'   : searchedElVal,
                        }
                    }).done(function(responseData){
                        $('.delete-unsd-fields-btn').attr('disabled', true);
                        $('.check-all-link').removeClass('checked-link');
                        $('.refresh-item').removeClass('checked-link');

                        var litlleUsedFieldsCount = responseData.responseText.litlleUsedFieldsCount,
                            littleUsedFieldsCountSelected = responseData.responseText.littleUsedFieldsCountSelected;

                        $('.selected-elements-counter').find('b.counter').text(0);

                        $('.all-counter').text(litlleUsedFieldsCount);

                        self.$el.find('#list-content').html(_.template(CleanUpLittleUsedFieldsLiTmpl, {
                            'littleUsedFields': responseData.responseText.littleUsedFields,
                            'i18n': i18n
                        }));
                    });

                } else {
                    $('.list-content').empty();
                    $('.all-counter').text(0);
                    $('.selected-elements-counter').find('b.counter').text(0);
                    showMessage(_.isUndefined(i18n['Please provide a number for the search']) ? 'Please provide a number for the search' : i18n['Please provide a number for the search'], true, 5000);
                    return false;
                }
            }
        },
        searchLittleUsedBtn: function(e)
        {
            e.preventDefault();
            $('.refresh-item').trigger('click');
        },
    });

    return LeadsToolsMainView;
});
