define([
    'backbone',
    '../models/form-builder',
    '../models/score-rules-config',
    './lead-builder-form',
    './lead-builder-grid',
    './lead-tools-main',
    './lead-builder-form-detailed-view',
    './score-rule-detailed-view',
    './lead-score-rules-form',
    './lead-score-rules-grid',
    'i18n!../../../nls/dashboard_'+$('#main-dashboard-system-language').val()+'_ln'
], function(Backbone, FormBuilderModel, ScoreRuleModel, FormBuilderForm, FormBuilderGridView, LeadToolsMainView, FormBuilderDetailedView, LeadScoreDetailedView, LeadScoreRulesFormView, LeadScoreGridView, i18n){
    var LeadsToolsRouter = Backbone.Router.extend({

        routes: {
            ''         : 'index',
            'formBuild/:id' : 'leadFormBuildDetails',
            'leadScore/:id' : 'leadScoreDetails'
        },
        index: function (){

            //init lead tools view
            $('#lead-tools-block').removeClass('hidden');
            this.LeadScoreRulesForm = new LeadScoreRulesFormView();
            this.LeadScoreRulesForm.render();

            this.LeadScoreGrid = new LeadScoreGridView(this.getParams());
            this.LeadScoreGrid.render();

            this.LeadScoreRulesForm.$el.on('LeadScoreFormGrid:created', _.bind(this.LeadScoreGrid.render, this.LeadScoreGrid));

            this.LeadsToolsMainView = new LeadToolsMainView();
            this.LeadsToolsMainView.render();
        },
        leadTooltipInfo: function (param) {

            var equal = _.isUndefined(i18n['Equal']) ? 'Equal' : i18n['Equal'],
                equalDescription = _.isUndefined(i18n['If you only want to match 1 item, like city, then type in its name, like']) ? 'If you only want to match 1 item, like city, then type in its name, like' : i18n['If you only want to match 1 item, like city, then type in its name, like'],
                notEqual = _.isUndefined(i18n['Not Equal']) ? 'Not Equal' : i18n['Not Equal'],
                notEqualDescription = _.isUndefined(i18n['If you want to match all items except one, then type in the name of the item you want to exclude']) ? 'If you want to match all items except one, then type in the name of the item you want to exclude' : i18n['If you want to match all items except one, then type in the name of the item you want to exclude'],
                contains = _.isUndefined(i18n['Contains']) ? 'Contains' : i18n['Contains'],
                containsDescription = _.isUndefined(i18n['If you want to match all items containing some specific word, then type in this specific word here']) ? 'If you want to match all items containing some specific word, then type in this specific word here' : i18n['If you want to match all items containing some specific word, then type in this specific word here'],
                any = _.isUndefined(i18n['Any']) ? 'Any' : i18n['Any'],
                exceptOf = _.isUndefined(i18n['Excluding']) ? 'Excluding' : i18n['Excluding'],
                exceptOfDescription = _.isUndefined(i18n['If you want to exclude any item out of some range']) ? 'If you want to exclude any item out of some range' : i18n['If you want to exclude any item out of some range'],
                anyDescription = _.isUndefined(i18n['If you want to match any item out of some range, then type in the list of items separated with comma']) ? 'If you want to match any item out of some range, then type in the list of items separated with comma' : i18n['If you want to match any item out of some range, then type in the list of items separated with comma'],
                greaterthan = _.isUndefined(i18n['Greater Than']) ? 'Greater Than' : i18n['Greater Than'],
                greaterthanDescription = _.isUndefined(i18n['Use when you want results that exceed the value you enter']) ? 'Use when you want results that exceed the value you enter' : i18n['Use when you want results that exceed the value you enter'],
                lessthan = _.isUndefined(i18n['Less Than']) ? 'Less Than' : i18n['Less Than'],
                lessthanDescription = _.isUndefined(i18n['Use for results that are less than the value you enter']) ? 'Use for results that are less than the value you enter' : i18n['Use for results that are less than the value you enter'];

            var description = '\'<b>'+equal+'</b>\' - '+equalDescription+' \'Boston\'. <br/>' +
                '\'<b>'+ notEqual +'</b>\' - '+ notEqualDescription +'. <br/>' +
                '\'<b>'+ contains +'</b>\' - '+ containsDescription +'. <br/>' +
                '\'<b>'+ any +'</b>\'- '+ anyDescription +'. <br/>' +
                '\'<b>'+ exceptOf +'</b>\'- '+ exceptOfDescription +'. <br/>' +
                '\'<b>'+ greaterthan +'</b>\'- '+ greaterthanDescription +'. <br/>' +
                '\'<b>'+ lessthan +'</b>\'- '+ lessthanDescription +'.';

            if(!_.isEmpty(param)){
                if(param == 'equal'){
                    description =  equalDescription +' \'Boston\'.';
                }else if(param == 'notequal'){
                    description = notEqualDescription +'.';
                }else if(param == 'like'){
                    description = containsDescription +'.';
                }else if(param == 'in'){
                    description = anyDescription +'.';
                }else if(param == 'notin'){
                    description = exceptOfDescription +'.';
                }else if(param == 'greaterthan'){
                    description = greaterthanDescription +'.';
                }else if(param == 'lessthan'){
                    description = lessthanDescription +'.';
                }
            }

            return description;
        },
        leadScoreDetails: function(leadScoreId)
        {
            if (!leadScoreId) {
                return false;
            }

            this.ScoreRuleModel =  new ScoreRuleModel();
            this.ScoreRuleModel.set('id', leadScoreId);
            this.ScoreRuleModel.fetch({data: { isGrid: true, detailedInfo:true},
                'success': function(ScoreModel){
                    if(_.isUndefined(ScoreModel.get('rule_name'))) {
                        window.location.href = window.location.pathname;
                    } else {
                        if (!_.isUndefined(this.leadScoreDetailed)) {
                            this.leadScoreDetailed.$el.unbind();
                        }

                        $('#lead-tools-block-tabs-block').addClass('hidden');
                        $('#lead-tools-block').removeClass('hidden');
                        this.leadScoreDetailed = new LeadScoreDetailedView(ScoreModel);
                        window.leadScoreDetailed = this.leadScoreDetailed;
                        this.leadScoreDetailed.render();
                        if (window.location.hash !== '') {
                            $('#score-grid-back-link').attr('href', $('#website_url').val()+'dashboard/tools/');
                        }
                    }
                }
            });
        },
        leadFormBuildDetails: function(formId)
        {
            if (!formId) {
                return false;
            }

            this.LeadFormBuilderModel =  new FormBuilderModel();
            this.LeadFormBuilderModel.set('id', formId);
            this.LeadFormBuilderModel.fetch({data: { isGrid: true, detailedInfo:true},
                'success': function(FormBuilderModel){
                    if(_.isUndefined(FormBuilderModel.get('form_name'))) {
                        window.location.href = window.location.pathname;
                    } else {
                        if (!_.isUndefined(this.leadFormBuilderDetailed)) {
                            this.leadFormBuilderDetailed.$el.unbind();
                        }

                        $('#lead-tools-block-tabs-block').addClass('hidden');
                        $('#lead-tools-block').removeClass('hidden');
                        this.leadFormBuilderDetailed = new FormBuilderDetailedView(FormBuilderModel);
                        window.leadFormBuilderDetailed = this.leadFormBuilderDetailed;
                        this.leadFormBuilderDetailed.render();
                        if (window.location.hash !== '') {
                            $('#form-builder-grid-back-link').attr('href', $('#website_url').val()+'dashboard/tools/');
                        }
                    }
                }
            });
        },
        getParams:  function () {
            var result = {},
                tmpData = [];
            location.search
                .substr(1)
                .split("&")
                .forEach(function (item) {
                    tmpData = item.split("=");
                    result[decodeURIComponent(tmpData[0])] = decodeURIComponent(tmpData[1]);
                });
            return result;
        }
    });

    var initialize = function() {
        window.appLeadToolsRouter = new LeadsToolsRouter;
        Backbone.history.start();
    };

    return {
        initialize: initialize
    };
});