define([
    'backbone',
    '../models/score-rules-config',
    'backbone.paginator'
], function(Backbone, ScoreRulesModel){

    var LeadScoreRulesConfigCollection = Backbone.Paginator.requestPager.extend({
        model: ScoreRulesModel,
        paginator_core: {
            type: 'GET',
            dataType: 'json',
            url: function(){
                return $('#website_url').val() + 'api/leads/leadscorerules/';
            }
        },
        paginator_ui: {
            firstPage:    0,
            currentPage:  0,
            perPage:     1000,
            totalPages:  1000
        },
        server_api: {
            count: true,
            limit: function() { return this.perPage; },
            offset: function() { return this.currentPage * this.perPage },
            key: function(){ return this.key; },
            isGrid: function(){ return this.isGrid; },
            detailedInfo: function(){ return this.detailedInfo; },
            order: function(){ return this.order; }
        },
        parse: function(response, xhr){
            if (this.server_api.count){
                this.totalRecords = response.totalRecords;
            } else {
                this.totalRecords = response.length;
            }

            this.leadOwners = response.leadOwners;
            this.customerGroups = response.customerGroups;
            this.countryCodes = response.countryCodes;
            this.scorePropertyActions = response.scorePropertyActions;
            this.scoreActions = response.scoreActions;
            this.stages = response.stages;
            this.industries = response.industries;
            this.ruleSetLegends = response.ruleSetLegends;
            this.leadTags = response.leadTags;
            this.leadsPredefinedValues = response.leadsPredefinedValues;
            this.opportunityStages = response.opportunityStages;
            this.opportunityTypes = response.opportunityTypes;
            this.totalPages = Math.floor(this.totalRecords / this.perPage);
            this.limitedAccess = response.limitedAccess;
            this.emailSequencies = response.emailSequencies;
            return this.server_api.count ? response.data : response;
        }

    });

    return LeadScoreRulesConfigCollection;
});