define([
    'backbone',
    '../models/form-builder-config',
    'backbone.paginator'
], function(Backbone, FormBuilderModel){

    var FormBuilderConfigCollection = Backbone.Paginator.requestPager.extend({
        model: FormBuilderModel,
        paginator_core: {
            type: 'GET',
            dataType: 'json',
            url: function(){
                return $('#website_url').val() + 'api/leads/formbuilderconfig/';
            }
        },
        paginator_ui: {
            firstPage:    0,
            currentPage:  0,
            perPage:     10,
            totalPages:  10
        },
        server_api: {
            count: true,
            limit: function() { return this.perPage; },
            offset: function() { return this.currentPage * this.perPage },
            key: function(){ return this.key; },
            isGrid: function(){ return this.isGrid; },
            additionalFieldGroupParams:  function(){ return this.additionalFieldGroupParams; },
            additionalLeadsCustomFields:  function(){ return this.additionalLeadsCustomFields; },
            additionalOrganizationsCustomFields:  function(){ return this.additionalOrganizationsCustomFields; }
        },
        parse: function(response, xhr){
            if (this.server_api.count){
                this.totalRecords = response.totalRecords;
            } else {
                this.totalRecords = response.length;
            }

            this.emailTemplates = response.emailTemplates;
            this.additionalFieldGroupParams = response.additionalFieldGroupParams;
            this.additionalLeadsCustomFields = response.additionalLeadsCustomFields;
            this.additionalOrganizationsCustomFields = response.additionalOrganizationsCustomFields;
            this.limitedAccess = response.limitedAccess;
            this.totalPages = Math.floor(this.totalRecords / this.perPage);
            return this.server_api.count ? response.data : response;
        }

    });

    return FormBuilderConfigCollection;
});