define([
    'backbone',
    '../collections/lead-general-reports',
    'text!../templates/general-stats.html',
    'i18n!../../../nls/dashboard_'+$('#lead-reports-system-language').val()+'_ln',
    'moment'
], function(Backbone, LeadGeneralReportsCollection, GeneralStatsTmpl, i18n, moment
){

    var LeadGeneralReportsView = Backbone.View.extend({
        el: $('#lead-general-stats'),
        events: {

        },
        templates: {
        },
        initialize: function(){
            this.LeadGeneralReportsCollection = new LeadGeneralReportsCollection();
            this.LeadGeneralReportsCollection.on('reset', this.renderContent, this);
            this.LeadGeneralReportsCollection.on('add', this.renderContent, this);
            this.LeadGeneralReportsCollection.on('destroy', this.renderContent, this);
        },
        render: function() {
            var tabEl = $('.lead-report-tab.current'),
                statsTypes = this.$el.data('stats').split(','),
                tabContentName =  $(tabEl).data('tab-name'),
                leadReportsCompare = 0,
                leadReportsFilterStartDate = ($('#lead-reports-filter-start-date').val()) ? $.datepicker.formatDate('yy-mm-dd', $('#lead-reports-filter-start-date').datepicker("getDate")): '',
                leadReportsFilterEndDate =  ($('#lead-reports-filter-end-date').val()) ? $.datepicker.formatDate('yy-mm-dd', $('#lead-reports-filter-end-date').datepicker("getDate")): '',
                leadReportsCompareFilterStartDate = ($('#lead-reports-filter-compare-start-date').val()) ? $.datepicker.formatDate('yy-mm-dd', $('#lead-reports-filter-compare-start-date').datepicker("getDate")): '',
                leadReportsCompareFilterEndDate = ($('#lead-reports-filter-compare-end-date').val()) ? $.datepicker.formatDate('yy-mm-dd', $('#lead-reports-filter-compare-end-date').datepicker("getDate")): '';


            if ($('#lead-reports-compare').is(':checked')) {
                leadReportsCompare = 1;
            }

            this.LeadGeneralReportsCollection.server_api.statsTypes = statsTypes;
            this.LeadGeneralReportsCollection.server_api.tabContentName = tabContentName;
            this.LeadGeneralReportsCollection.server_api.leadReportsCompare = leadReportsCompare;
            this.LeadGeneralReportsCollection.server_api.leadReportsFilterStartDate = leadReportsFilterStartDate;
            this.LeadGeneralReportsCollection.server_api.leadReportsFilterEndDate = leadReportsFilterEndDate;
            this.LeadGeneralReportsCollection.server_api.leadReportsCompareFilterStartDate = leadReportsCompareFilterStartDate;
            this.LeadGeneralReportsCollection.server_api.leadReportsCompareFilterEndDate = leadReportsCompareFilterEndDate;
            this.LeadGeneralReportsCollection.pager();
            return this;
        },
        renderContent: function() {
           this.$el.empty();
           this.$el.append(_.template(GeneralStatsTmpl, {'collection': this.LeadGeneralReportsCollection.stats, 'comparedTo': this.LeadGeneralReportsCollection.comparedTo, 'i18n': i18n}));
        }
    });

    return LeadGeneralReportsView;
});