define([
    'backbone',
    '../collections/lead-workflows-config',
    'text!../templates/paginator.html',
    'text!../templates/lead-workflows/workflow-rules-grid-row.html',
    'i18n!../../../nls/dashboard_'+$('#main-dashboard-system-language').val()+'_ln',
    'moment'
], function(Backbone,
            LeadWorkflowConfigCollection, PaginatorTmpl, LeadWorkflowGridRowTmpl, i18n, moment
){

    var LeadWorkflowGridView = Backbone.View.extend({
        el: $('#lead-workflow-grid-table-block'),
        events: {
            'click a[data-role=delete]': 'deleteRule',
            'click td.lead-workflow-paginator a.page': 'navigate',
            'change select.lead-workflow-filter-custom-paginator' :'customPaginate'
        },
        templates: {
            paginator: _.template(PaginatorTmpl)
        },
        initialize: function(options){
            this.$el.unbind();

            this.leadWorkflowConfig = new LeadWorkflowConfigCollection();
            this.leadWorkflowConfig.isGrid = true;

            this.leadWorkflowConfig.on('reset', this.renderRules, this);
            this.leadWorkflowConfig.on('add', this.renderRules, this);
            this.leadWorkflowConfig.on('destroy', this.renderRules, this);
        },
        render: function(){
            this.leadWorkflowConfig.server_api = _.extend(this.leadWorkflowConfig.server_api, {
            });
            this.leadWorkflowConfig.server_api.order = 'plwgc.created_at DESC';
            this.leadWorkflowConfig.pager();
        },
        customPaginate: function(e) {
            var el = $(e.currentTarget),
                paginationParam = el.val();

            this.leadWorkflowConfig.customPaginate = paginationParam;

            this.specialPageNavigator(this.leadWorkflowConfig.firstPage);
        },
        specialPageNavigator: function(pageNumber){
            var page = pageNumber;
            if ($.isNumeric(page)){
                this.leadWorkflowConfig.goTo(page);
            }
        },
        renderRules: function(){
            this.$el.find('tbody').empty();
            this.leadWorkflowConfig.each(this.renderRule, this);
            this.leadWorkflowConfig.info()['i18n'] = i18n;
            this.$el.find('td.lead-workflow-paginator').html(this.templates.paginator(this.leadWorkflowConfig.information));
            if (typeof tableResponsive === "function") {
                tableResponsive();
            }
        },
        renderRule: function(formRuleData){
            var actionTypes = {
                'assign_owner': _.isUndefined(i18n['Assign owner']) ? 'Assign owner' : i18n['Assign owner'],
                'assign_task': _.isUndefined(i18n['Assign task']) ? 'Assign task' : i18n['Assign task'],
                'assign_tags' : _.isUndefined(i18n['Assign/remove tags']) ? 'Assign/remove tags' : i18n['Assign/remove tags'],
                'assign_lifecycle' : _.isUndefined(i18n['Assign lifecycle']) ? 'Assign lifecycle' : i18n['Assign lifecycle'],
                'assign_sequence' : _.isUndefined(i18n['Assign email/sms sequence']) ? 'Assign email/sms sequence' : i18n['Assign email/sms sequence'],
                'assign_email_list' : _.isUndefined(i18n['Add to email list']) ? 'Add to email list' : i18n['Add to email list'],
                'assign_email_copy' : _.isUndefined(i18n['Notify user']) ? 'Notify user' : i18n['Notify user'],
                'send_review_request' : _.isUndefined(i18n['Send review request']) ? 'Send review request' : i18n['Send review request'],
                'assign_remarketing_list' : _.isUndefined(i18n['Add to Ad audience list']) ? 'Add to Ad audience list' : i18n['Add to Ad audience list'],
            };
            this.$el.find('tbody').append(_.template(LeadWorkflowGridRowTmpl, {'workflowModel': formRuleData, 'moment':moment, 'i18n': i18n, 'actionTypes': actionTypes}));
        },
        alphabeticalSort: function(obj){
            // convert object into array
            var sortable=[];
            for(var key in obj)
                if(obj.hasOwnProperty(key))
                    sortable.push([key, obj[key]]); // each item is an array in format [key, value]

            // sort items by value
            sortable.sort(function(a, b)
            {
                var x=a[1].toLowerCase(),
                    y=b[1].toLowerCase();
                return x<y ? -1 : x>y ? 1 : 0;
            });
            return sortable; // array in format [ [ key1, val1 ], [ key2, val2 ], ... ]
        },
        editAttribute: function(e)
        {
            var currentAttribute = $(e.currentTarget),
                currentValue = currentAttribute.val(),
                oldValue = currentAttribute.data('old-value'),
                ruleId = currentAttribute.data('cid'),
                ruleModel = this.formRules.get(ruleId),
                attrName =  currentAttribute.data('attrName');

            if (currentValue != oldValue) {
                ruleModel.set(attrName, currentValue);
                ruleModel.set('secureToken', $('#form-leads-grid-token').val());
                ruleModel.save(null, {
                    success: function(model, response){
                        currentAttribute.data('old-value', currentValue);
                        showMessage(response.responseText.message, false, 5000);
                    },
                    error: function(model, response){
                        currentAttribute.val(oldValue);
                        showMessage(response.responseJSON, true, 5000);
                    }
                });

            }

        },
        deleteRule: function(e){
            var cid = $(e.currentTarget).data('cid'),
                model = this.leadWorkflowConfig.get(cid);

            showConfirm(_.isUndefined(i18n['Are you sure want to delete'])?'Are you sure want to delete':i18n['Are you sure want to delete'], function(){
                if (model) {
                    model.destroy({
                        wait: true,
                        success: function(model, response){

                        },
                        error: function(model, response){
                            showMessage(response.responseJSON, true, 2000);
                        }
                    });
                }
            });
        },
        navigate: function(e){
            e.preventDefault();

            var page = $(e.currentTarget).data('page');
            if ($.isNumeric(page)){
                this.leadWorkflowConfig.goTo(page);
            } else {
                switch(page){
                    case 'first':
                        this.leadWorkflowConfig.goTo(this.leadWorkflowConfig.firstPage);
                        break;
                    case 'last':
                        this.leadWorkflowConfig.goTo(this.leadWorkflowConfig.information.lastPage);
                        break;
                    case 'prev':
                        this.leadWorkflowConfig.requestPreviousPage();
                        break;
                    case 'next':
                        this.leadWorkflowConfig.requestNextPage();
                        break;
                }
            }
        }
    });

    return LeadWorkflowGridView;
});
