define([
    'backbone',
    '../collections/form-rules',
    'text!../templates/paginator.html',
    'text!../templates/form-rules/form-rules-grid-row.html',
    'i18n!../../../nls/dashboard_'+$('#main-dashboard-system-language').val()+'_ln',
    'moment'
], function(Backbone,
            FormRulesCollection, PaginatorTmpl, FormRulesGridRowTmpl, i18n, moment
){

    var LeadsFormRulesGridView = Backbone.View.extend({
        el: $('#form-rules-grid-table'),
        events: {
            'click a[data-role=delete]': 'deleteRule',
            'click td.lead-form-rules-paginator a.page': 'navigate'
        },
        templates: {
            paginator: _.template(PaginatorTmpl)
        },
        initialize: function(options){
            this.$el.unbind();

            this.formRules = new FormRulesCollection();
            this.formRules.isGrid = true;

            this.formRules.on('reset', this.renderRules, this);
            this.formRules.on('add', this.renderRules, this);
            this.formRules.on('destroy', this.renderRules, this);
        },
        render: function(){
            this.formRules.server_api = _.extend(this.formRules.server_api, {
            });
            this.formRules.server_api.order = 'plfrgc.created_at DESC';
            this.formRules.pager();
        },
        renderRules: function(){
            this.$el.find('tbody').empty();
            this.formRules.each(this.renderRule, this);
            this.formRules.info()['i18n'] = i18n;
            this.$('td.lead-form-rules-paginator').html(this.templates.paginator(this.formRules.information));
            if (typeof tableResponsive === "function") {
                tableResponsive();
            }
        },
        renderRule: function(formRuleData){
            var actionTypes = {
                'assign_owner': _.isUndefined(i18n['Assign owner']) ? 'Assign owner' : i18n['Assign owner'],
                'assign_task': _.isUndefined(i18n['Assign task']) ? 'Assign task' : i18n['Assign task'],
                'assign_tags' : _.isUndefined(i18n['Assign/remove tags']) ? 'Assign/remove tags' : i18n['Assign/remove tags'],
                'assign_lifecycle' : _.isUndefined(i18n['Assign lifecycle']) ? 'Assign lifecycle' : i18n['Assign lifecycle'],
                'assign_sequence' : _.isUndefined(i18n['Assign email/sms sequence']) ? 'Assign email/sms sequence' : i18n['Assign email/sms sequence'],
                'assign_email_list' : _.isUndefined(i18n['Add to email list']) ? 'Add to email list' : i18n['Add to email list'],
                'assign_email_copy' : _.isUndefined(i18n['Notify user']) ? 'Notify user' : i18n['Notify user'],
                'assign_remarketing_list' : _.isUndefined(i18n['Add to Ad audience list']) ? 'Add to Ad audience list' : i18n['Add to Ad audience list']
            };
            this.$el.find('tbody').append(_.template(FormRulesGridRowTmpl, {'formRuleModel': formRuleData, 'moment':moment, 'i18n': i18n, 'actionTypes': actionTypes}));
        },
        alphabeticalSort: function(obj){
            // convert object into array
            var sortable=[];
            for(var key in obj)
                if(obj.hasOwnProperty(key))
                    sortable.push([key, obj[key]]); // each item is an array in format [key, value]

            // sort items by value
            sortable.sort(function(a, b)
            {
                var x=a[1].toLowerCase(),
                    y=b[1].toLowerCase();
                return x<y ? -1 : x>y ? 1 : 0;
            });
            return sortable; // array in format [ [ key1, val1 ], [ key2, val2 ], ... ]
        },
        editAttribute: function(e)
        {
            var currentAttribute = $(e.currentTarget),
                currentValue = currentAttribute.val(),
                oldValue = currentAttribute.data('old-value'),
                ruleId = currentAttribute.data('cid'),
                ruleModel = this.formRules.get(ruleId),
                attrName =  currentAttribute.data('attrName');

            if (currentValue != oldValue) {
                ruleModel.set(attrName, currentValue);
                ruleModel.set('secureToken', $('#form-leads-grid-token').val());
                ruleModel.save(null, {
                    success: function(model, response){
                        currentAttribute.data('old-value', currentValue);
                        showMessage(response.responseText.message, false, 5000);
                    },
                    error: function(model, response){
                        currentAttribute.val(oldValue);
                        showMessage(response.responseJSON, true, 5000);
                    }
                });

            }

        },
        deleteRule: function(e){
            var cid = $(e.currentTarget).data('cid'),
                model = this.formRules.get(cid);

            showConfirm(_.isUndefined(i18n['Are you sure want to delete'])?'Are you sure want to delete':i18n['Are you sure want to delete'], function(){
                if (model) {
                    model.destroy({
                        wait: true,
                        success: function(model, response){

                        },
                        error: function(model, response){
                            showMessage(response.responseJSON, true, 2000);
                        }
                    });
                }
            });
        },
        navigate: function(e){
            e.preventDefault();

            var page = $(e.currentTarget).data('page');
            if ($.isNumeric(page)){
                this.formRules.goTo(page);
            } else {
                switch(page){
                    case 'first':
                        this.formRules.goTo(this.formRules.firstPage);
                        break;
                    case 'last':
                        this.formRules.goTo(this.formRules.information.lastPage);
                        break;
                    case 'prev':
                        this.formRules.requestPreviousPage();
                        break;
                    case 'next':
                        this.formRules.requestNextPage();
                        break;
                }
            }
        }
    });

    return LeadsFormRulesGridView;
});
