define([
    'backbone',
    'text!../templates/form-rules/detailed-view.html',
    'text!../templates/form-rules/form-rules-field-row-detailed-view.html',
    'i18n!../../../nls/dashboard_'+$('#main-dashboard-system-language').val()+'_ln',
    'moment',
    'chosen',
    'tinyMCE',
    'leadshortcode',
], function(Backbone, FormRulesDetailedViewTmpl, FormRulesFieldRowTmpl, i18n, moment, chosen, tinymce, leadshortcode
){

    var LeadFormRuleDetailedView = Backbone.View.extend({
        el: $('#lead-form-rules-detailed-view-block'),
        events: {
            'click #add-field-to-form-rule-detailed-view': 'addField',
            'change .form-field-operator-value' : 'changeRuleOperator',
            'click .form-field-rules-row-delete-detailed-view': 'deleteFieldRow',
            'click #form-actions-list-block-detailed-view li a': 'changeFormAction',
            'click #create-lead-form-rule': 'updateLeadFormRule',
            'change #form-action-edit-assign-task-immediate': 'switchImmediate',
            'change #form-action-edit-assign-task-number-of-before-action-units': 'switchTaskUnits',
            'change #form-action-edit-assign-task-due-number-of-before-action-units': 'switchTaskDueUnits',
            'click input.switcher' : 'switcherAction',
            'click .form-action-assign-email-list-block-detailed-view-current-list' : 'getCurrentServiceList',
            'change #marketing-services': 'getServicesLists',
            'change #marketing-campaigns': 'getMarketingCampaigns',
            'click .form-action-assign-remarketing-list-block-detailed-view-current-list' : 'getCurrentServiceRemarketingList',
            'click #add-list-form-save': 'createNewAdList',
            'change #form-action-assign-task-preset-to-detailed-view':'changeTaskPreset'
        },
        templates: {
        },
        beforeSelectedCampaign: {
            'campaign': ''
        },
        campaignSelectedListsIds: {},
        campaignSelectedListsLabels: {},
        initialize: function(leadFormRuleModel){
            if (_.isEmpty(leadFormRuleModel)) {
                return false;
            }
            this.leadFormRuleModel = leadFormRuleModel;
        },
        render: function() {
            this.$el.empty();
            tinymce.remove();
            this.leadFormRuleModel.set('taskPresetsList', this.alphabeticalSort(this.leadFormRuleModel.get('taskPresets')));
            this.leadFormRuleModel.set('leadOwners', this.alphabeticalSort(this.leadFormRuleModel.get('leadOwners')));
            this.leadFormRuleModel.set('leadTags', this.alphabeticalSort(this.leadFormRuleModel.get('leadTags')));
            this.leadFormRuleModel.set('lifecycleStages', this.alphabeticalSort(this.leadFormRuleModel.get('lifecycleStages')));
            this.leadFormRuleModel.set('emailSequencies', this.alphabeticalSort(this.leadFormRuleModel.get('emailSequencies')));

            var leadFormRuleData = this.leadFormRuleModel.toJSON();
            if(!_.isUndefined(leadFormRuleData.actionsData.assign_remarketing_list)) {
                var serviceNameRemarketingParam = JSON.parse(leadFormRuleData.actionsData.assign_remarketing_list.action_config);

                var serviceRemarketingLists = JSON.parse(serviceNameRemarketingParam.lists);
                this.campaignSelectedListsIds = serviceRemarketingLists;

                var serviceRemarketingListsLabels = JSON.parse(serviceNameRemarketingParam.listsLabels);
                this.campaignSelectedListsLabels = serviceRemarketingListsLabels;
            }

            this.$el.html( _.template(FormRulesDetailedViewTmpl, {'leadFormRuleModel': this.leadFormRuleModel.toJSON(), 'moment': moment, 'i18n':i18n}));

            var assignEmailList = this.leadFormRuleModel.get('actionsData').assign_email_list;
            if(typeof assignEmailList !== 'undefined') {
                var savedEmailList = $('#marketing-services').val();
                if(savedEmailList != 'select') {
                    $('#marketing-services').trigger('change');
                }
            }

            var assignRemarketingList = this.leadFormRuleModel.get('actionsData').assign_remarketing_list;
            if(typeof assignRemarketingList !== 'undefined') {
                var savedRemarketingList = $('#marketing-campaigns').val();
                if(savedRemarketingList != 'select') {
                    $('#marketing-campaigns').trigger('change');
                }
            }

            $('#select-assign-lead-tags').chosen();
            $('#select-remove-lead-tags').chosen();
            //this.initTiny();
            return this;
        },
        changeTaskPreset: function(e) {
            var taskPresets = this.leadFormRuleModel.get('taskPresetsFull'),
                chosenPresetId = $(e.currentTarget).val();
            if (taskPresets.hasOwnProperty(chosenPresetId) === true) {
                $('#form-action-assign-task-title-detailed-view').val(taskPresets[chosenPresetId]['task_title']);
            } else {
                $('#form-action-assign-task-title-detailed-view').val('');
            }
        },
        alphabeticalSort: function(obj){
            // convert object into array
            var sortable=[];
            for(var key in obj)
                if(obj.hasOwnProperty(key))
                    sortable.push([key, obj[key]]); // each item is an array in format [key, value]

            // sort items by value
            sortable.sort(function(a, b)
            {
                var x=a[1].toLowerCase(),
                    y=b[1].toLowerCase();
                return x<y ? -1 : x>y ? 1 : 0;
            });
            return sortable; // array in format [ [ key1, val1 ], [ key2, val2 ], ... ]
        },
        addField: function()
        {
            var fieldName = $('#form-field-selection-detailed-view').val(),
                fieldKey = fieldName.replace(/\s/g, '');

            if (fieldKey === 'without_rule_value') {
                $('#form-field-rules-configuration-block-rows-detailed-view').find('.form-field-rule-row-block-detailed-view').remove();
            }

            $('#form-field-rules-configuration-block-detailed-view').removeClass('hidden');
            if ($('#form-field-rule-row-block-detailed-view-'+fieldKey).length == '0') {
                if ($('#form-field-rule-row-block-detailed-view-without_rule_value').length == '1') {
                    showMessage(_.isUndefined(i18n['You can\'t add additional rule if you have "without rule" rule']) ? 'You can\'t add additional rule if you have "without rule" rule' : i18n['You can\'t add additional rule if you have "without rule" rule'], true, 2000);
                    return false;
                }

                $('#form-field-rules-configuration-block-rows-detailed-view').append( _.template(FormRulesFieldRowTmpl, {'fieldKey': fieldKey, 'fieldName': fieldName, 'moment': moment, 'i18n':i18n}));
            } else {
                showMessage(_.isUndefined(i18n['Field already exists']) ? 'Field already exists' : i18n['Field already exists'], true, 5000);
            }
        },
        changeRuleOperator: function(e)
        {
            var el = $(e.currentTarget),
                ruleOperator = el.val(),
                valueEl = el.closest('div').find('.form-field-rules-row-value'),
                infoTooltip = window.appLeadFormRouter.leadTooltipInfo(ruleOperator);

            el.prop('title', infoTooltip);

            if (ruleOperator === 'in') {
                valueEl.replaceWith('<textarea placeholder="'+(_.isUndefined(i18n['separate the values with commas']) ? 'separate the values with commas' : i18n['separate the values with commas'])+'" class="form-field-rules-row-value field-rule-row-last grid_5 alpha omega" name="'+valueEl.prop('name')+'">'+valueEl.val()+'</textarea>');
            } else if(!valueEl.is('input')) {
                valueEl.replaceWith('<input type="text" class="form-field-rules-row-value field-rule-row-last grid_5 alpha omega" name="'+valueEl.prop('name')+'" value="'+valueEl.val()+'" />');
            }

        },
        deleteFieldRow: function(e)
        {
            e.preventDefault();
            showConfirm(_.isUndefined(i18n['Are you sure want to delete?']) ? 'Are you sure want to delete?' : i18n['Are you sure want to delete?'], function () {
                $(e.currentTarget).closest('.form-field-rule-row-block-detailed-view').remove();
            });

        },
        switchTaskUnits: function(e)
        {
            if ($(e.currentTarget).val() == 'hour') {
                $('#lead-task-start-time-detailed-view').prop('disabled', true).addClass('exclude-from-disable');
            } else {
                $('#lead-task-start-time-detailed-view').prop('disabled', false).removeClass('exclude-from-disable');
            }
        },
        switchTaskDueUnits: function(e)
        {
            if ($(e.currentTarget).val() == 'hour') {
                $('#lead-task-due-time-detailed-view').prop('disabled', true).addClass('exclude-from-disable');
            } else {
                $('#lead-task-due-time-detailed-view').prop('disabled', false).removeClass('exclude-from-disable');
            }
        },
        switchImmediate: function(e)
        {
            var taskUnitsType = $('#form-action-edit-assign-task-number-of-before-action-units').val();
            if ($(e.currentTarget).is(':checked')) {
                $('.disable-immediate').prop('disabled', true);
                $('#lead-task-start-time-detailed-view').prop('disabled', true);
                $('#form-action-edit-assign-task-number-of-before-action').addClass('exclude-from-disable');
                $('#form-action-edit-assign-task-number-of-before-action-units').addClass('exclude-from-disable');
            } else {
                $('.disable-immediate').prop('disabled', false);
                if (taskUnitsType === 'hour') {
                    $('#lead-task-start-time-detailed-view').prop('disabled', true);
                } else {
                    $('#lead-task-start-time-detailed-view').prop('disabled', false);
                }
                $('#form-action-edit-assign-task-number-of-before-action').removeClass('exclude-from-disable');
                $('#form-action-edit-assign-task-number-of-before-action-units').removeClass('exclude-from-disable');
            }
        },
        switcherAction:function (e) {
            var el      = $(e.currentTarget),
                tabId        = el.closest('li').find('a').data('tab-id'),
                currentTabEl = $('#'+tabId),
                actionType   = currentTabEl.data('action-type'),
                elSwitcher   = el.closest('li').find('input'),
                elSelect     = currentTabEl.find('select'),
                elInput      = currentTabEl.find('input'),
                elTextarea   = currentTabEl.find('textarea');

            this.disabledAction(elSwitcher, actionType, elSelect, elInput, elTextarea);
        },
        disabledAction: function (elSwitcher, actionType, elSelect, elInput, elTextarea) {
            var elTags  = $('#select_assign_lead_tags_chosen .chosen-results'),
                rmTags = $('#select_remove_lead_tags_chosen .chosen-results');

            if(elSwitcher.is(':checked')){
                if(actionType == 'assign_tags'){
                    elTags.css({'display' : ''});
                    rmTags.css({'display' : ''});
                    if(elInput.length > 0 && elInput.attr('type') === 'checkbox'){
                        elInput.prop('disabled', false);
                    }
                }else{
                    if(elSelect.length > 0){
                        _.each(elSelect, function(elSel){
                            if (!$(elSel).hasClass('exclude-from-disable')) {
                                $(elSel).prop('disabled', false);
                            }
                        });
                    }
                    if(elInput.length > 0){
                        _.each(elInput, function(elInp){
                            if (!$(elInp).hasClass('exclude-from-disable')) {
                                $(elInp).prop('disabled', false);
                            }
                        });
                    }
                    if(elTextarea.length > 0){
                        elTextarea.prop('disabled', false);
                    }
                }
            }else {
                if(actionType == 'assign_tags'){
                    elTags.css({'display' : 'none'});
                    rmTags.css({'display' : 'none'});
                    if(elInput.length > 0 && elInput.attr('type') === 'checkbox'){
                        elInput.prop('disabled', true);
                    }
                }else{
                    if(elSelect.length > 0){
                        elSelect.prop('disabled', true);
                    }
                    if(elInput.length > 0){
                        elInput.prop('disabled', true);
                    }
                    if(elTextarea.length > 0){
                        elTextarea.prop('disabled', true);
                    }
                }
            }
        },
        changeFormAction: function(e)
        {
            e.preventDefault();
            var el = $(e.currentTarget),
                tabId = el.data('tab-id'),
                currentTabEl = $('#'+tabId),
                actionType   = currentTabEl.data('action-type'),
                elSwitcher   = el.closest('li').find('input'),
                elSelect     = currentTabEl.find('select'),
                elInput      = currentTabEl.find('input'),
                elTextarea   = currentTabEl.find('textarea');
            if (actionType === 'assign_task') {
                this.initTiny();
                setTimeout(function () {
                    if (!_.isNull(tinymce.activeEditor) && '' === tinymce.activeEditor.getContent()) {
                        tinymce.activeEditor.setContent('Hello! ' +
                            'You have a task for this lead: {$lead:leadfullnamelink} from {$lead:organizationnamelink}.');
                    }
                }, 500);
            }
            this.disabledAction(elSwitcher, actionType, elSelect, elInput, elTextarea);

            $('#form-actions-list-block-detailed-view li').removeClass('current');

            $('.action-single-block-detailed-view').addClass('hidden');
            currentTabEl.removeClass('hidden');

            el.closest('li').addClass('current');
        },
        updateLeadFormRule: function(e)
        {
            e.preventDefault();
            var ruleConfigBlocks = $('.form-field-rule-row-block-detailed-view'),
                actionSwitchers = $('#form-actions-list-block-detailed-view').find('input.switcher'),
                switchersChosen = false,
                error = false,
                fieldsConfigData = [],
                self = this,
                actionsData = [],
                ruleId = $('#form-rules-form-id-detailed-view').val(),
                formName = $('#form-rules-form-name-detailed-view').val(),
                formType = $('#form-rules-form-type-detailed-view').val(),
                formRuleName = $('#form-rule-name-general-detailed-view').val(),
                assignLeadOwnerId = $('#select-assign-lead-owner-detailed-view').val(),
                assignTaskBy = $('#form-action-assign-task-by-detailed-view').val(),
                assignTaskTo = $('#form-action-assign-task-to-detailed-view').val(),
                assignTaskNotes = $('#form-action-assign-task-notes-detailed-view').val(),
                assignTaskTitle = $('#form-action-assign-task-title-detailed-view').val(),
                assignTaskStartTime = $('#lead-task-start-time-detailed-view').val(),
                assignTaskDueTime = $('#lead-task-due-time-detailed-view').val(),
                taskDelayDueUnits = $('#form-action-edit-assign-task-due-number-of-before-action-units').val(),
                taskDueDelay= parseInt($('#form-action-edit-assign-task-due-number-of-before-action').val()),
                taskImmediate = 0,
                taskDelayUnits = $('#form-action-edit-assign-task-number-of-before-action-units').val(),
                taskDelay= parseInt($('#form-action-edit-assign-task-number-of-before-action').val()),
                taskTimezone = $('#user-task-timezone').val(),
                assignTaskStart = 0,
                assignDueTime = 0,
                userTimezoneOffset = $('#task-rule-edit-user-timezone-offset').val(),
                tagIds =  $('#select-assign-lead-tags').val(),
                removeTagIds =  $('#select-remove-lead-tags').val(),
                lifeCycleId = $('#select-assign-lead-lifecycle').val(),
                sequenceId = $('#select-assign-lead-sequence').val(),
                emailsToCopyRow = $('#email-copy-emails').val(),
                triggerNewLeadOnly = 0,
                unassignSequence = 0,
                emailServiceName = $("#marketing-services").val(),
                checkedLists = $('#subscribe-list').find("input.subscribe-to-email-service-list:checked"),
                remarketingServiceName = $("#marketing-campaigns").val(),
                checkedRemarketingLists = $('#subscribe-remarketing-list').find("input.subscribe-to-remarketing-list:checked");


            if (ruleConfigBlocks.length === 0) {
                showMessage(_.isUndefined(i18n['Please create at least one rule']) ? 'Please create at least one rule' : i18n['Please create at least one rule'], true, false);
                return false;
            }

            $.each(ruleConfigBlocks, function(ruleConfigBlock) {
                fieldsConfigData.push({'field_name': $(this).data('field-name'), 'rule_comparison_operator' : $(this).find('.form-field-operator-value').val(), 'field_value' : $(this).find('.form-field-rules-row-value').val()});
            });

            $.each(actionSwitchers, function(switcher) {
                if ($(this).is(':checked') === true) {
                    var actionType = $(this).data('action-type');
                    switchersChosen = true;
                    if (actionType === 'assign_owner') {
                        if (assignLeadOwnerId == '0') {
                            showMessage(_.isUndefined(i18n['Please choose lead owner for the assign owner action']) ? 'Please choose lead owner for the assign owner action' : i18n['Please choose lead owner for the assign owner action'], true, false);
                            error = true;
                            return false;
                        } else {
                            triggerNewLeadOnly = 0;
                            if ($('#assign-lead-owner-only-for-new-lead-detailed-view').is(':checked')) {
                                triggerNewLeadOnly = 1;
                            }
                            actionsData.push({'assign_to' : assignLeadOwnerId, 'actionType': actionType, 'triggerNewLeadOnly':triggerNewLeadOnly});
                        }
                    }

                    if (actionType === 'assign_task') {
                        if (assignTaskTitle === '') {
                            showMessage(_.isUndefined(i18n['Please provide task title']) ? 'Please provide task title' : i18n['Please provide task title'], true, false);
                            error = true;
                            return false;
                        }

                        if (taskDueDelay === '' || _.isNaN(taskDueDelay)) {
                            showMessage(_.isUndefined(i18n['Please specify due delay']) ? 'Please specify due delay' : i18n['Please specify due delay'], true, false);
                            error = true;
                            return false;
                        }

                        if (assignTaskDueTime === '' || _.isNaN(assignTaskDueTime)) {
                            showMessage(_.isUndefined(i18n['Please specify task due time']) ? 'Please specify task due time' : i18n['Please specify task due time'], true, false);
                            error = true;
                            return false;
                        }

                        if ($('#form-action-edit-assign-task-immediate').is(':checked')) {
                            taskImmediate = 1;
                        } else if (isNaN(taskDelay)) {
                            showMessage(_.isUndefined(i18n['Please enter task delay amount']) ? 'Please enter task delay amount' : i18n['Please enter task delay amount'], true, false);
                            error = true;
                            return false;
                        }

                        if (assignTaskStartTime.length == 1) {
                            assignTaskStart = '0' + assignTaskStartTime+':00:00';
                        } else {
                            assignTaskStart = assignTaskStartTime+':00:00';
                        }

                        if (assignTaskDueTime.length == 1) {
                            assignDueTime = '0' + assignTaskDueTime+':00:00';
                        } else {
                            assignDueTime = assignTaskDueTime+':00:00';
                        }

                        triggerNewLeadOnly = 0;
                        if ($('#assign-task-only-for-new-lead-detailed-view').is(':checked')) {
                            triggerNewLeadOnly = 1;
                        }

                        actionsData.push({
                            'actionType': actionType,
                            'creator_id': assignTaskBy,
                            'user_id': assignTaskTo,
                            'notes': assignTaskNotes,
                            'title': assignTaskTitle,
                            'taskImmediate': taskImmediate,
                            'taskDelayUnits': taskDelayUnits,
                            'assignTaskDueTime': assignTaskDueTime,
                            'taskDueDelay': taskDueDelay,
                            'taskDelayDueUnits': taskDelayDueUnits,
                            'taskDelay': taskDelay,
                            'assignTaskTime': assignTaskStart,
                            'assignDueTime': assignDueTime,
                            'assignTaskStartTime': assignTaskStartTime,
                            'taskTimezone' : taskTimezone,
                            'userTimezoneOffset' : userTimezoneOffset,
                            'triggerNewLeadOnly':triggerNewLeadOnly
                        });
                    }

                    if (actionType === 'assign_tags') {
                        if (tagIds.length === 0 && removeTagIds.length === 0) {
                            showMessage(_.isUndefined(i18n['Please choose at least one tag']) ? 'Please choose at least one tag' : i18n['Please choose at least one tag'], true, false);
                            error = true;
                            return false;
                        } else {
                            triggerNewLeadOnly = 0;
                            if ($('#assign-tags-only-for-new-lead-detailed-view').is(':checked')) {
                                triggerNewLeadOnly = 1;
                            }
                            actionsData.push({'tagIds' : tagIds, 'removeTagIds': removeTagIds, 'actionType': actionType, 'triggerNewLeadOnly':triggerNewLeadOnly});
                        }
                    }

                    if (actionType === 'assign_lifecycle') {
                        if (lifeCycleId == '0') {
                            showMessage(_.isUndefined(i18n['Please choose lifecycle']) ? 'Please choose lifecycle' : i18n['Please choose lifecycle'], true, false);
                            error = true;
                            return false;
                        } else {
                            triggerNewLeadOnly = 0;
                            if ($('#assign-lifecycle-only-for-new-lead-detailed-view').is(':checked')) {
                                triggerNewLeadOnly = 1;
                            }
                            actionsData.push({'lifecycleId' : lifeCycleId, 'actionType': actionType, 'triggerNewLeadOnly':triggerNewLeadOnly});
                        }
                    }

                    if (actionType === 'assign_sequence') {
                        if (sequenceId == '0') {
                            showMessage(_.isUndefined(i18n['Please choose email/sms sequence']) ? 'Please choose email/sms sequence' : i18n['Please choose email/sms sequence'], true, false);
                            error = true;
                            return false;
                        } else {
                            triggerNewLeadOnly = 0;
                            if ($('#assign-email-sequence-only-for-new-lead-detailed-view').is(':checked')) {
                                triggerNewLeadOnly = 1;
                            }
                            unassignSequence = 0;
                            if ($('#unassign-sequence-detailed-view').is(':checked')) {
                                unassignSequence = 1;
                            }
                            actionsData.push({'sequenceId' : sequenceId, 'actionType': actionType, 'triggerNewLeadOnly':triggerNewLeadOnly, 'unassignSequence':unassignSequence});
                        }
                    }

                    if(actionType === 'assign_email_list') {
                        if(emailServiceName == 'select'){
                            showMessage(_.isUndefined(i18n['Please choose service'])?'Please choose service':i18n['Please choose service'], true, 5000);
                            error = true;
                            return false;
                        }
                        var lists = [];
                        var listsLabels = [];
                        var listsToString = '',
                            unsubscribe = 0;

                        if ($('#unsubscribe-email-marketing').is(':checked')) {
                            unsubscribe = 1;
                        }

                        if(checkedLists.length > 0){
                            checkedLists.each(function(key, value) {
                                lists.push($(this).val());
                                listsLabels.push($(this).data('list-name'));
                            });
                            listsToString = lists.join(',');
                            listsLabels = listsLabels.join(',');
                        }

                        var emailListDetailedViewBlock = $('#form-action-assign-email-list-block-detailed-view');

                        emailListDetailedViewBlock.data('service-name', emailServiceName);
                        emailListDetailedViewBlock.data('service-value', listsToString);

                        var requestType = 'assign';
                        if ($('#unassign-email-marketing').is(':checked')) {
                            requestType = 'unassign';
                        }

                        actionsData.push({
                            'actionType': actionType,
                            'type': 'email',
                            'serviceName' : emailServiceName,
                            'lists' : listsToString,
                            'listsLabels' : listsLabels,
                            'requestType' : requestType,
                            'unsubscribe' : unsubscribe
                        });
                    }

                    if(actionType === 'assign_remarketing_list') {
                        if(remarketingServiceName == 'select'){
                            showMessage(_.isUndefined(i18n['Please choose remarketing service'])?'Please choose remarketing service':i18n['Please choose remarketing service'], true, 5000);
                            error = true;
                            return false;
                        }

                        self.campaignSelectedListsIds[remarketingServiceName] = [];
                        self.campaignSelectedListsLabels[remarketingServiceName] = [];

                        var lists = [],
                            audinceListsIds = [],
                            audinceListsLabels = [];

                        checkedRemarketingLists.each(function() {
                            var listId = $(this).val(),
                                listLabel = $(this).data('label');
                            audinceListsIds.push(listId);
                            audinceListsLabels.push(listLabel);
                        });

                        self.campaignSelectedListsIds[remarketingServiceName] = audinceListsIds;
                        self.campaignSelectedListsLabels[remarketingServiceName] = audinceListsLabels;

                        lists['ids'] = self.campaignSelectedListsIds;
                        lists['names'] = self.campaignSelectedListsLabels;

                        var requestType = 'assign';
                        if ($('#unassign-remarketing').is(':checked')) {
                            requestType = 'unassign';
                        }

                        actionsData.push({'actionType': actionType, 'serviceName' : remarketingServiceName, 'lists' : JSON.stringify(lists['ids']), 'listsLabels' : JSON.stringify(lists['names']), 'requestType' : requestType});
                    }

                    if (actionType === 'assign_email_copy') {
                        var emailsToCopy = $.trim(emailsToCopyRow).split(','),
                            emailValidation = /^(([^<>()\[\]\.,;:\s@\"]+(\.[^<>()\[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i;
                        $.each(emailsToCopy, function(key, email){
                            email = $.trim(email);
                            var status = emailsToCopyRow === '{leadowner:email}' ? true : emailValidation.test(email);
                            if (status === false) {
                                var emailErrMsg = (_.isUndefined(i18n['The']) ? 'The' : i18n['The']) + ' ' + email + ' ' + (_.isUndefined(i18n['isn\'t valid.']) ? 'isn\'t valid.' : i18n['isn\'t valid.']) + ' ';
                                var validEmailAddressMsg = _.isUndefined(i18n['Please specify valid email address']) ? 'Please specify valid email address' : i18n['Please specify valid email address'];

                                showMessage(emailErrMsg + validEmailAddressMsg, true, false);
                                error = true;
                                return false;
                            }
                        });
                        if (_.isEmpty(emailsToCopy) || emailsToCopy === '') {
                            showMessage(_.isUndefined(i18n['Please specify email']) ? 'Please specify email' : i18n['Please specify email'], true, false);
                            error = true;
                            return false;
                        } else {
                            triggerNewLeadOnly = 0;
                            if ($('#assign-email-copy-only-for-new-lead-detailed-view').is(':checked')) {
                                triggerNewLeadOnly = 1;
                            }
                            actionsData.push({'emailsToCopy' : emailsToCopyRow, 'actionType': actionType, 'triggerNewLeadOnly':triggerNewLeadOnly});
                        }
                    }
                }
            });

            if (error === true) {
                return false;
            }

            if (switchersChosen === false) {
                showMessage(_.isUndefined(i18n['Please activate at least one action']) ? 'Please activate at least one action' : i18n['Please activate at least one action'], true, false);
                return false;
            }

            if (formRuleName === '') {
                showMessage(_.isUndefined(i18n['Please specify rule name']) ? 'Please specify rule name' : i18n['Please specify rule name'], true, false);
                return false;
            }

            var data = {'secureToken': $('#form-leads-grid-token').val(), 'ruleId': ruleId,'rule_name': formRuleName, 'form_name': formName, 'form_type': formType, 'actionsData' :actionsData, 'fieldsData' : fieldsConfigData};

            $.ajax({
                url: $('#website_url').val()+'api/leads/leadsformrules',
                type: 'PUT',
                data: data,
                dataType: 'json'
            }).done(function(response) {
                $('.removed-email-list').hide();
                showMessage(response.responseText.message, false, 5000);
            }).fail(function(response){
                showMessage(response.responseJSON, true, 5000);
            });
            return false;
        },
        hideLeadDetailsScreen: function(e)
        {
            var href = $(e.currentTarget).attr('href');
            if (href.match(/http(.*)/)) {
                window.location.href = href;
            } else {
                $('#lead-block-detailed-view').empty();
                $('#lead-table-block').show();
                $('.filters').show();
                $('#lead-grid-back-link').addClass('hidden');
                $('#lead-additional-filters').show();
            }
        },
        assign: function (selector, view) {
            var selectors;
            if (_.isObject(selector)) {
                selectors = selector;
            }
            else {
                selectors = {};
                selectors[selector] = view;
            }
            if (!selectors) return;
            _.each(selectors, function (view, selector) {
                view.setElement(this.$(selector)).render();
            }, this);
        },
        changeAttribute: function(e)
        {
            var el = $(e.currentTarget),
                attributeName = el.data('lead-attr'),
                oldVal = el.data('lead-old-val'),
                currentVal = el.val();

            if (oldVal == currentVal) {
                return false;
            }

            this.updateFormAttribute(el, attributeName, currentVal);
        },
        updateFormAttribute: function(el, attributeName, currentVal)
        {
            var self = this;

            this.leadModel.set(attributeName, currentVal);
            this.leadModel.set('secureToken', $('#lead-grid-token').val());
            this.leadModel.save(null,{
                success: function(model, response){
                    showMessage(response.responseText.message, false, 5000);
                    el.data('lead-old-val', currentVal);
                },
                error: function(model, response){
                    showMessage(response.responseJSON, true, 5000);
                }
            });
        },
        getCurrentServiceList: function (e) {
            e.preventDefault();
            $('#marketing-services').trigger('change');
        },
        getServicesLists: function (e) {
            var cuurentElValue = $(e.currentTarget).val(),
                emailListDetailedViewBlock = $('#form-action-assign-email-list-block-detailed-view'),
                savedServiceValue = emailListDetailedViewBlock.data('service-value'),
                self = this;

            $.ajax({
                url: $('#website_url').val()+'plugin/leads/run/getAppsService/serviceName/'+cuurentElValue,
                type: 'GET',
                dataType: 'json'
            }).done(function(response) {
                $('.removed-email-list').hide();
                $('#subscribe-list').remove();
                if(response.error != 1){
                    if(savedServiceValue !== '') {
                        savedServiceValue = savedServiceValue.toString().split(',');
                    }
                    var subscribeList = '<div class="grid_12 mt10px scroll" id="subscribe-list" style="height:265px;">',
                        list = self.alphabeticalSort(response.responseText.list);

                    if(list.length > 0) {
                        $.each(list, function(value, listName){
                            var checkedparam = '';

                            if(savedServiceValue.length > 0 &&  savedServiceValue.includes(listName[0])) {
                                checkedparam = 'checked';
                            }
                            subscribeList += '<label class="mr30px pointer"> <input type="checkbox" '+ checkedparam +' class="subscribe-to-email-service-list" name="list" data-list-name="'+ listName[1] +'" value="'+ listName[0] +'"/> <span>'+ listName[1] +'</span></label>'
                        });

                        if(savedServiceValue.length > 0) {
                            $.each(savedServiceValue, function(key, serviceId){
                                if(parseInt(serviceId) && typeof response.responseText.list[parseInt(serviceId)] === 'undefined') {
                                    $('.removed-email-list').show();
                                }
                            });
                        }
                    } else {
                        if($('#marketing-services').val() == 'constantContact') {
                            if(response.responseText.hasError) {
                                subscribeList += (_.isUndefined(i18n['<p><b>Can not get any data.</b></p> '+response.responseText.message])?'<p><b>Can not get any data.</b></p> '+response.responseText.message:i18n['<p><b>Can not get any data.</b></p> '+response.responseText.message]);
                            } else {
                                subscribeList += (_.isUndefined(i18n['<p><b>No list is available.</b></p> Please make sure if the list is created and you can get access to it.'])?'<p><b>No list is available.</b></p> Please make sure if the list is created and you can get access to it.':i18n['<p><b>No list is available.</b></p> Please make sure if the list is created and you can get access to it.']);
                            }
                        } else {
                            subscribeList += (_.isUndefined(i18n['<p><b>No list is available.</b></p> Private lists are not shown here. Make sure your lists are set as "shared" or "managed" types in your Marketing Operating System so that we can display them here for you to select.'])?'<p><b>No list is available.</b></p> Private lists are not shown here. Make sure your lists are set as "shared" or "managed" types in your Marketing Operating System so that we can display them here for you to select.':i18n['<p><b>No list is available.</b></p> Private lists are not shown here. Make sure your lists are set as "shared" or "managed" types in your Marketing Operating System so that we can display them here for you to select.']);
                        }
                    }

                    subscribeList += '</div>';

                    $('#email-service-detailed-info').val(response.responseText.detailedInfo);
                    $('#marketing-services').after(subscribeList);
                }
            });
        },
        getCurrentServiceRemarketingList: function (e) {
            e.preventDefault();
            $('#marketing-campaigns').trigger('change');
        },
        getMarketingCampaigns: function (e) {
            e.stopImmediatePropagation();
            var cuurentElValue = $(e.currentTarget).val(),
                self = this,
                checkedListsEl = $("input.subscribe-to-remarketing-list:checked");

            if(checkedListsEl.length) {
                var audinceListsIds = [],
                    audinceListsLabels = [];
                checkedListsEl.each(function() {
                    var listId = $(this).val(),
                        listLabel = $(this).data('label');
                    audinceListsIds.push(listId);
                    audinceListsLabels.push(listLabel);
                });

                self.campaignSelectedListsIds[self.beforeSelectedCampaign.campaign] = audinceListsIds;
                self.campaignSelectedListsLabels[self.beforeSelectedCampaign.campaign] = audinceListsLabels;
            }

            if(cuurentElValue !== 'select') {
                self.beforeSelectedCampaign.campaign = $('#marketing-campaigns').val();
            } else {
                self.beforeSelectedCampaign.campaign = '';
            }

            $('#add-new-lists').addClass('hidden');
            if (cuurentElValue != 'select') {
                $.ajax({
                    url: $('#website_url').val()+'plugin/leads/run/getAdvertisingService/serviceName/'+cuurentElValue,
                    type: 'GET',
                    dataType: 'json'
                }).done(function(response) {
                    if(response.error == 1){
                        if(response.responseText.message == 'No ad account assigned to this website') {
                            var googleAdAccount = 'Google Adwords',
                                facebookAdAccount = 'Facebook Ad',
                                accountName = facebookAdAccount;

                            if(cuurentElValue == 'adwords') {
                                accountName = googleAdAccount;
                            }
                            var connectionMessage = (_.isUndefined(i18n['You need first to connect a '+ accountName +' account. Click'])?'You need first to connect a '+ accountName +' account. Click':i18n['You need first to connect a '+ accountName +' account. Click'])
                                + ' ' + '<a href="' + $('#website_url').val() + '/plugin/leads/run/advertiserAccountConfig/" target="_blank" title="Click to open config" style="text-decoration: underline;">' + (_.isUndefined(i18n['here'])?'here':i18n['here']) +'</a>'
                                + ' ' + (_.isUndefined(i18n['to access the configuration panel'])?'to access the configuration panel':i18n['to access the configuration panel']);
                            showMessage(connectionMessage, true, 6000);
                        } else {
                            showMessage(_.isUndefined(i18n[response.responseText.message])?response.responseText.message:i18n[response.responseText.message], false, 1000);
                        }

                        $('#subscribe-remarketing-list').remove();
                        $('#add-new-lists').addClass('hidden');
                        $('#marketing-campaigns').val('select');
                        return false;
                    }else{
                        $('#subscribe-remarketing-list').remove();

                        var subscribeList = '<div class="grid_12 mt10px scroll" id="subscribe-remarketing-list" style="height:250px;">',
                            list = response.responseText.list;

                        if(list !== null && list.length > 0) {
                            $.each(list, function(key, listData){
                                var isChecked = '';
                                if(typeof self.campaignSelectedListsIds[cuurentElValue] !== 'undefined' && self.campaignSelectedListsIds[cuurentElValue].indexOf(listData.id.toString()) !== -1) {
                                    isChecked = 'checked';
                                }

                                subscribeList += '<label class="mr30px pointer"> <input type="checkbox" '+ isChecked +' class="subscribe-to-remarketing-list" name="list" value="'+ listData.id +'" data-label="'+ listData.name +'"/><span>'+ listData.name + ' (id: ' + listData.id + ')' + '</span></label>';
                            });
                        } else {
                            subscribeList += (_.isUndefined(i18n['No available lists'])?'No available lists':i18n['No available lists']);
                        }
                        subscribeList += '</div>';
                        $('#marketing-campaigns').after(subscribeList);
                        $('#add-new-lists').removeClass('hidden');
                    }
                });
            }else{
                $('#subscribe-remarketing-list').remove();
            }
        },
        createNewAdList: function (e)
        {
            e.preventDefault();
            var account = $("#marketing-campaigns").val(),
                listName = $('#list-name').val().replace(/[^a-zA-Z0-9-_ ]/g, '');

            if(listName != '') {
                $('#list-name').val(listName);
                showConfirm(_.isUndefined(i18n['Are you sure want add new list?'])?'Are you sure want add new list?':i18n['Are you sure want add new list?'], function(){
                    $.ajax({
                        'url': $('#website_url').val() + 'plugin/leads/run/addAdvertiserlist/',
                        'type': 'POST',
                        'dataType': 'json',
                        'data': {
                            'secureToken' : $('#form-leads-grid-token').val(),
                            'listName': listName,
                            'account': account
                        }
                    }).done(async function (response) {
                        hideLoader();
                        if (response.error == '1') {
                            showMessage(response.responseText.message, true, 2000);
                            return false;
                        } else {
                            if(typeof response.responseText.listId === 'undefined') {
                                showMessage(response.responseText.message, true, 2000);
                            } else {
                                showMessage('(list: '+response.responseText.listId+') created successfully', false, 2000);
                                var newList = '<label class="mr30px pointer"> <input type="checkbox" class="subscribe-to-remarketing-list" name="list" value="'+ response.responseText.listId +'" data-label="'+ listName +'"/><span>'+ listName + ' (id: ' + response.responseText.listId + ')' + '</span></label>';
                                $('#subscribe-remarketing-list').prepend(newList);
                            }
                            $('#list-name').val('');
                        }

                    }).fail(async function(response){
                        hideLoader();
                        showMessage(_.isUndefined(i18n['Can\'t add list'])?'Can\'t add list':i18n['Can\'t add list'], true, 2000);
                    });
                }, function () {
                    return false;
                });
            } else {
                showMessage(_.isUndefined(i18n['Please enter list name'])?'Please enter list name':i18n['Please enter list name'], true, 2000);
            }
        },
        initTiny: function (){
            tinymce.remove();
            var websiteUrl = $('#website_url').val(), self = this;
            tinymce.init({
                script_url              : websiteUrl+'system/js/external/tinymce/tinymce.gzip.php',
                selector                : "#form-action-assign-task-notes-detailed-view",
                skin                    : 'seotoaster',
                menubar                 : false,
                browser_spellcheck      : true,
                resize                  : false,
                convert_urls            : false,
                relative_urls           : false,
                statusbar               : false,
                allow_script_urls       : false,
                force_p_newlines        : false,
                forced_root_block       : false,
                entity_encoding         : "raw",
                plugins                 :  ["leadshortcode fullscreen code link"],
                toolbar1                : "leadshortcode | fullscreen | code | link unlink ",
                image_advtab            : false,
                extended_valid_elements : false,
                setup                   : function(ed){
                    var keyTime = null;
                    ed.on('change blur keyup', function(ed, e){
                        self.dispatchEditorKeyup(ed, e, keyTime);
                        this.save();
                    });
                }
            });

            this.tinimce = tinymce;
        },
        dispatchEditorKeyup: function(editor, event, keyTime) {
            var keyTimer = keyTime;
            if(keyTimer === null) {
                keyTimer = setTimeout(function() {
                    keyTimer = null;
                }, 1000)
            }
        }
    });

    return LeadFormRuleDetailedView;
});
