define([
    'backbone',
    './lead-event-rules-grid',
    './lead-event-rules-form',
    './lead-form-rules',
    './lead-form-rules-grid',
    './lead-workflow-form',
    './lead-workflow-grid',
    'i18n!../../../nls/dashboard_'+$('#main-dashboard-system-language').val()+'_ln'
], function(Backbone, LeadEventRulesView, LeadEventRulesFormView, LeadFormRulesView, LeadFormRulesGridView,
            LeadWorkflowFormView, LeadWorkflowGridView, i18n
){

    var LeadsFormMainView = Backbone.View.extend({
        el: $('#lead-form-block'),
        events: {
            'click a[data-role=lead-rules-detailed-view]': 'showLeadFormDetailsScreen',
            'click a[data-role=event-rules-detailed-view]': 'showLeadEventDetailsScreen',
            'click a[data-role=form-builder-detailed-view]': 'showFormBuilderDetailsScreen',
            'click a[data-role=workflows-rules-detailed-view]': 'showWorkflowDetailsScreen',
            'click #lead-form-block-tabs-tab li' : 'showLeadFormTabs',
            'click #form-rules-grid-back-link': 'returnRulesMainTab',
            'click #event-rules-grid-back-link': 'returnFromEventToMainTab',
            'click #form-builder-grid-back-link': 'returnFromFormBuilderMainTab',
            'click #lead-workflow-grid-back-link': 'returnWorkflowMainTab',
            'click a.copy-path-link-information-info': 'leadWorkflowScoringPath'
        },
        templates: {},
        initialize: function(options){

        },
        render: function(){

        },
        leadScoringPath: function(e)
        {
            e.preventDefault();
            if (document.queryCommandSupported("copy")) {
                var copyFromEl = $('<textarea/>');
                copyFromEl.text($(e.currentTarget).data('element-id'));
                $('body').append(copyFromEl);
                copyFromEl.select();
                document.execCommand('copy', true);
                copyFromEl.remove();
                showMessage('Has been copied to clipboard.', false, 2000);
            }
        },
        leadWorkflowScoringPath: function(e)
        {
            e.preventDefault();
            if (document.queryCommandSupported("copy")) {
                var copyFromEl = $('<textarea/>');
                copyFromEl.text($(e.currentTarget).data('element-id'));
                $('body').append(copyFromEl);
                copyFromEl.select();
                document.execCommand('copy', true);
                copyFromEl.remove();
                showMessage('Has been copied to clipboard.', false, 2000);
            }
        },
        showWorkflowDetailsScreen: function(e)
        {
            var ruleId = $(e.currentTarget).closest('tr').data('rule-id');
            if (!ruleId) {
                return false;
            }
            window.appLeadFormRouter.leadWorkflowDetails(ruleId);
        },
        showLeadFormDetailsScreen: function(e)
        {
            var ruleId = $(e.currentTarget).closest('tr').data('rule-id');
            if (!ruleId) {
                return false;
            }
            window.appLeadFormRouter.leadFormRulesDetails(ruleId);
        },
        showLeadEventDetailsScreen: function(e)
        {
            var ruleId = $(e.currentTarget).closest('tr').data('rule-id');
            if (!ruleId) {
                return false;
            }
            window.appLeadFormRouter.leadEventsDetails(ruleId);
        },
        showFormBuilderDetailsScreen: function(e)
        {
            var formId = $(e.currentTarget).closest('tr').data('rule-id');
            if (!formId) {
                return false;
            }
            window.appLeadFormRouter.leadFormBuildDetails(formId);
        },
        returnRulesMainTab: function(e)
        {
            e.preventDefault();
            tinymce.remove();
            this.initTiny();
            $('#lead-form-rules-detailed-view-block').empty();
            $('#lead-form-block-tabs-tab').removeClass('hidden');
            $('#lead-form-block-tabs-block').removeClass('hidden');

            $('#lead-form-create-form-rule-block').trigger('LeadFormRulesFormGrid:created');

        },
        returnFromEventToMainTab: function(e)
        {
            e.preventDefault();
            tinymce.remove();
            this.initTiny();
            $('#lead-event-rules-detailed-view-block').empty();
            $('#lead-event-block-tabs-tab').removeClass('hidden');
            $('#lead-form-block-tabs-block').removeClass('hidden');

            $('#lead-event-create-rule-form-block').trigger('LeadEventRulesGrid:created');

        },
        returnFromFormBuilderMainTab: function(e)
        {
            e.preventDefault();
            $('#lead-form-builder-form-detailed-block').empty();
            $('#lead-event-block-tabs-tab').removeClass('hidden');
            $('#lead-form-block-tabs-block').removeClass('hidden');
            $('.form-builder-form-type').first().trigger('click');

        },
        returnWorkflowMainTab: function(e)
        {
            e.preventDefault();
            tinymce.remove();
            this.initTiny();
            $('#lead-workflows-detailed-block').empty();
            $('#lead-form-block-tabs-block').removeClass('hidden');
            $('#lead-workflows-tab-block').removeClass('hidden');
            $('#lead-form-block-tabs-tab').removeClass('hidden');

            $('#lead-workflow-form-block').trigger('LeadWorkflowFormGrid:created');
        },
        showLeadFormTabs: function(e)
        {
            var el = $(e.currentTarget),
                tabBlockContentId = el.data('tab-id'),
                tabContentName = el.data('tab-name'),
                tabBlockContentEl = $('#'+tabBlockContentId),
                self = this,
                tabContentBlock = el.closest('#lead-form-block-tabs-block').find('.lead-form-block-tabs-content');

            if (el.hasClass('current')) {
                return false;
            }

            $('#lead-form-create-form-rule-block').empty();
            $('#lead-event-create-rule-form-block').empty();
            $('#lead-form-builder-form-block').empty();
            $('#lead-workflow-form-block').empty();

            if (tabBlockContentEl.hasClass('hidden')) {
                if (tabContentName === 'form-rules') {
                    if(!_.isUndefined(this.formRulesFormView)) {
                        this.formRulesFormView.$el.unbind();
                    }
                    if(!_.isUndefined(this.formRulesGridView)) {
                        this.formRulesGridView.$el.unbind();
                    }
                    this.formRulesFormView = new LeadFormRulesView();
                    this.formRulesGridView = new LeadFormRulesGridView();
                    self.assign({
                        '#form-rules-grid-table': this.formRulesGridView,
                        '#lead-form-create-form-rule-block' : this.formRulesFormView
                    });

                    this.formRulesFormView.$el.on('LeadFormRulesFormGrid:created', _.bind(this.formRulesGridView.render, this.formRulesGridView));
                    self.hideTab(tabBlockContentEl, el);
                }

                if (tabContentName === 'lead-workflows') {
                    if(!_.isUndefined(this.LeadWorkflowGridView)) {
                        this.LeadWorkflowGridView.$el.unbind();
                    }
                    if(!_.isUndefined(this.LeadWorkflowFormView)) {
                        this.LeadWorkflowFormView.$el.unbind();
                    }
                    this.LeadWorkflowFormView = new LeadWorkflowFormView();
                    this.LeadWorkflowGridView = new LeadWorkflowGridView();
                    self.assign({
                        '#lead-workflow-grid-table': this.LeadWorkflowGridView,
                        '#lead-workflow-form-block' : this.LeadWorkflowFormView
                    });

                    this.LeadWorkflowFormView.$el.on('LeadWorkflowFormGrid:created', _.bind(this.LeadWorkflowGridView.render, this.LeadWorkflowGridView));
                    self.hideTab(tabBlockContentEl, el);
                }


                if (tabContentName === 'event-rules') {
                    if(!_.isUndefined(this.eventRulesGridView)) {
                        this.eventRulesGridView.$el.unbind();
                    }
                    if(!_.isUndefined(this.eventRulesFormView)) {
                        this.eventRulesFormView.$el.unbind();
                    }
                    this.eventRulesGridView = new LeadEventRulesView();
                    this.eventRulesFormView = new LeadEventRulesFormView();
                    self.assign({
                        '#event-rules-grid-table': this.eventRulesGridView,
                        '#lead-event-create-rule-form-block' : this.eventRulesFormView
                    });

                    this.eventRulesFormView.$el.on('LeadEventRulesGrid:created', _.bind(this.eventRulesGridView.render, this.eventRulesGridView));
                    self.hideTab(tabBlockContentEl, el);
                }
            }

            tabContentBlock.addClass('hidden');
            $('#lead-form-block-tabs-tab').find('li').removeClass('current');
            this.hideTab(tabBlockContentEl, el);
        },
        hideTab: function (tabBlockContentEl, el){
            tabBlockContentEl.removeClass('hidden');
            el.closest('li').addClass('current');
        },
        assign: function (selector, view) {
            var selectors;
            if (_.isObject(selector)) {
                selectors = selector;
            }
            else {
                selectors = {};
                selectors[selector] = view;
            }
            if (!selectors) return;
            _.each(selectors, function (view, selector) {
                view.setElement(this.$(selector)).render();
            }, this);
        },
        initTiny: function (){
            var websiteUrl = $('#website_url').val(), self = this;
            tinymce.init({
                script_url              : websiteUrl+'system/js/external/tinymce/tinymce.gzip.php',
                selector                : '#form-action-assign-task-notes',
                skin                    : 'seotoaster',
                menubar                 : false,
                browser_spellcheck      : true,
                resize                  : false,
                convert_urls            : false,
                relative_urls           : false,
                statusbar               : false,
                allow_script_urls       : false,
                force_p_newlines        : false,
                forced_root_block       : false,
                entity_encoding         : "raw",
                plugins                 :  ["fullscreen code link"],
                toolbar1                : " fullscreen | code | link unlink ",
                image_advtab            : false,
                extended_valid_elements : false,
                setup                   : function(ed){
                    var keyTime = null;
                    ed.on('change blur keyup', function(ed, e){
                        self.dispatchEditorKeyup(ed, e, keyTime);
                        this.save();
                    });
                }
            });

            this.tinimce = tinymce;
        },
        dispatchEditorKeyup: function(editor, event, keyTime) {
            var keyTimer = keyTime;
            if(keyTimer === null) {
                keyTimer = setTimeout(function() {
                    keyTimer = null;
                }, 1000)
            }
        }
    });

    return LeadsFormMainView;
});