define([
    'backbone',
    '../collections/organization-custom-params.js',
    'text!../templates/paginator.html',
    'text!../templates/organization-custom-param-grid-row.html',
    'text!../templates/organization-custom-param-grid-select-value-row.html',
    'i18n!../../../nls/config_'+$('#lead-organization-custom-fields-leads-config-system-language').val()+'_ln.js'
], function(Backbone,
            OrganizationsCustomParamsCollection, PaginatorTmpl, OrganizationCustomParamsRowTmpl, OrganizationCustomGridSelectValueTmpl, i18n
){

    var OrganizationCustomParamsGridView = Backbone.View.extend({
        el: $('#organization-custom-params-grid-table'),
        events: {
            'click a[data-role=delete]': 'deleteCustomParam',
            'click td.organization-custom-params-grid-paginator a.page': 'navigate',
            'blur .organization-custom-param-edit-attribute'  : 'editOrganizationCustomParam',
            'click a[data-role=edit-checkbox]' : 'editOrganizationCustomParamCheckbox',
            'click a[data-role=edit-select]' : 'editOrganizationCustomParamSelect'
        },
        templates: {
            paginator: _.template(PaginatorTmpl)
        },
        initialize: function(options){
            this.organizationParams = new OrganizationsCustomParamsCollection();
            this.$el =  $('#organization-custom-params-grid-table');
            this.organizationParams.on('reset', this.renderOrganizationCustomParams, this);
            this.organizationParams.on('add', this.renderOrganizationCustomParams, this);
            this.organizationParams.on('destroy', this.renderOrganizationCustomParams, this);
        },
        render: function(){
            this.organizationParams.pager();
        },
        renderOrganizationCustomParams: function(){
            this.$el.find('tbody').empty();
            this.organizationParams.each(this.renderOrganizationCustomParam, this);
            this.organizationParams.info()['i18n'] = i18n;
            if((this.organizationParams.length == 0) && (this.organizationParams.currentPage != 0)){
                this.organizationParams.requestPreviousPage();
            }
            this.$('td.organization-custom-params-grid-paginator').html(this.templates.paginator(this.organizationParams.information));
        },
        renderOrganizationCustomParam: function(organizationsCustomParamsData){
            this.$el.find('tbody').append(_.template(OrganizationCustomParamsRowTmpl, {'organizationsCustomParamsData': organizationsCustomParamsData, 'i18n': i18n}));
        },
        deleteCustomParam: function(e){
            var self = this,
                cid = $(e.currentTarget).data('cid'),
                model = this.organizationParams.get(cid);

            showConfirm(_.isUndefined(i18n['Are you sure want to delete'])?'Are you sure want to delete':i18n['Are you sure want to delete'], function(){
                if (model){
                    model.destroy();
                    self.render();
                }
            });
        },
        editOrganizationCustomParamSelect: function (e) {
            var el = $(e.currentTarget),
                paramType = el.data('type'),
                organizationCustomParamId = el.closest('tr').data('organization-custom-param-id'),
                organizationCustomParamModel = this.organizationParams.get(organizationCustomParamId),
                organizationCustomParamsForm = $('#organization-custom-params-form-dropdown'),
                optionValueIds = [],
                optionValues = [];

            organizationCustomParamsForm.find('#organization-field-type').val(paramType);
            organizationCustomParamsForm.find('#organization-custom-param-type').val(paramType);
            organizationCustomParamsForm.find('.param_name').val(organizationCustomParamModel.attributes.param_name);
            organizationCustomParamsForm.find('.param_label').val(organizationCustomParamModel.attributes.label);
            organizationCustomParamsForm.find('.organization-custom-param-id').val(organizationCustomParamId);

            if((organizationCustomParamModel.attributes.option_ids != null) && (organizationCustomParamModel.attributes.option_values != null)){
                optionValueIds = organizationCustomParamModel.attributes.option_ids.split(',');
                optionValues = organizationCustomParamModel.attributes.option_values.split(',');

                $('.wrap').remove();
                _.each(optionValueIds, function (value, key) {
                    var optionData = {'selection_id': value, 'selection_value': optionValues[key]};
                    $('.option-list-holder').append(_.template(OrganizationCustomGridSelectValueTmpl, {'optionData': optionData}));
                });
            }
            $('#manage-organization-dropdown-container').show('slide', { direction: 'right'});
        },
        editOrganizationCustomParamCheckbox: function(e){
            var el = $(e.currentTarget),
                organizationCustomParamId = el.closest('tr').data('organization-custom-param-id'),
                organizationCustomParamModel = this.organizationParams.get(organizationCustomParamId),
                organizationCustomParamsForm = $('#organization-custom-params-form');

            $('#organization-custom-params-form-save').val(_.isUndefined(i18n['Edit custom field'])?'Edit custom field':i18n['Edit custom field']);

            organizationCustomParamsForm.find('#organization-field-type').val('checkbox');

            organizationCustomParamsForm.find('.param_name').val(organizationCustomParamModel.attributes.param_name);
            organizationCustomParamsForm.find('.param_label').val(organizationCustomParamModel.attributes.label);

            var optionValues = organizationCustomParamModel.attributes.option_values.split(',');

            if(optionValues.length > 0){
                organizationCustomParamsForm.find('.checkbox-yes').val(optionValues[0]);
            }
            organizationCustomParamsForm.find('.organization-custom-param-id').val(organizationCustomParamId);
            organizationCustomParamsForm.find('.checkbox-default-values').show();
        },
        editOrganizationCustomParam: function(e)
        {
            var el = $(e.currentTarget),
                currentValue = el.val(),
                oldValue = el.data('old-value'),
                organizationCustomParamId = el.closest('tr').data('organization-custom-param-id'),
                organizationCustomParamModel = this.organizationParams.get(organizationCustomParamId),
                attrName =  el.data('attrName');

            if (currentValue != oldValue) {
                el.data('old-value', currentValue);
                organizationCustomParamModel.set(attrName, currentValue);
                organizationCustomParamModel.set('secureToken', $('#organization-custom-param-secure-token').val());
                organizationCustomParamModel.save(null, {
                    success: function(model, response){
                        showMessage(response.responseText, false, 5000);
                    },
                    error: function(model, response){
                        showMessage(response.responseJSON, true, 5000);
                    }
                });

            }
        },
        navigate: function(e){
            e.preventDefault();

            var page = $(e.currentTarget).data('page');
            if ($.isNumeric(page)){
                this.organizationParams.goTo(page);
            } else {
                switch(page){
                    case 'first':
                        this.organizationParams.goTo(this.organizationParams.firstPage);
                        break;
                    case 'last':
                        this.organizationParams.goTo(this.organizationParams.information.lastPage);
                        break;
                    case 'prev':
                        this.organizationParams.requestPreviousPage();
                        break;
                    case 'next':
                        this.organizationParams.requestNextPage();
                        break;
                }
            }
        }
    });

    return OrganizationCustomParamsGridView;
});
