define([
    'backbone',
    'i18n!../../../nls/config_'+$('#lead-source-leads-config-system-language').val()+'_ln.js'
], function(Backbone, i18n){
    var LeadSourceFormView = Backbone.View.extend({
        el: $('#lead-source-form'),
        events: {
            'submit': 'submit'
        },
        templates: {

        },
        initialize: function(){
            this.$el = $('#lead-source-form');
            this.$el.attr('action', $('#website_url').val()+'api/leads/leadsource');
        },
        render: function(){
            return this;
        },
        submit: function(e){
            e.preventDefault();

            var self = this,
                form = $(e.currentTarget),
                isValid = true;

            _.each(form.find('.required'), function(el){
                if (!$(el).val()){
                    isValid = false;
                }
            });

            if (!isValid){
                showMessage(_.isUndefined(i18n['Missing required field'])?'Missing required field':i18n['Missing required field'], true);
                return false;
            }

            var formParams = form.serialize();

            $.ajax({
                url: form.attr('action'),
                type:  'POST',
                data: formParams,
                dataType: 'json'
            }).done(function(response) {
                 self.$el.trigger('LeadSourceForm:created');
                 showMessage(response.responseText, false, 5000);
                 form.find('input[type="text"]').val('');
            }).fail(function(response){
                showMessage(response.responseJSON, true, 5000);
            });
            return false;

        }
    });

    return LeadSourceFormView;
});