define([
    'backbone',
    '../collections/lead-events.js',
    'text!../templates/paginator.html',
    'text!../templates/events-row.html',
    'i18n!../../../nls/config_'+$('#lead-events-leads-config-system-language').val()+'_ln.js'
], function(Backbone,
            LeadsEventsCollection, PaginatorTmpl, LeadEventsRowTmpl, i18n
){

    var LeadEventsGridView = Backbone.View.extend({
        el: $('#lead-events-grid-table'),
        events: {
            'click a[data-role=delete]': 'deleteLeadEvent',
            'blur .lead-event-edit-attribute'  : 'editLeadEvent',
            'click td.lead-events-grid-paginator a.page': 'navigate'
        },
        templates: {
            paginator: _.template(PaginatorTmpl)
        },
        initialize: function(options){
            this.leadEvents = new LeadsEventsCollection();
            this.$el =  $('#lead-events-grid-table');
            this.leadEvents.on('reset', this.renderLeadEvents, this);
            this.leadEvents.on('add', this.renderLeadEvents, this);
            this.leadEvents.on('destroy', this.renderLeadEvents, this);
        },
        render: function(){
            this.leadEvents.pager();
        },
        renderLeadEvents: function(){
            this.$el.find('tbody').empty();
            this.leadEvents.each(this.renderLeadEvent, this);
            this.leadEvents.info()['i18n'] = i18n;
            if((this.leadEvents.length == 0) && (this.leadEvents.currentPage != 0)){
                this.leadEvents.requestPreviousPage();
            }
            this.$('td.lead-events-grid-paginator').html(this.templates.paginator(this.leadEvents.information));
        },
        renderLeadEvent: function(leadsEventsData){
            this.$el.find('tbody').append(_.template(LeadEventsRowTmpl, {'leadsEventsData': leadsEventsData}));
            return false;
        },
        deleteLeadEvent: function(e){
            var self = this,
                cid = $(e.currentTarget).data('cid'),
                model = this.leadEvents.get(cid);

            showConfirm(_.isUndefined(i18n['Are you sure want to delete'])?'Are you sure want to delete':i18n['Are you sure want to delete'], function(){
                if (model){
                    model.destroy();
                    self.render();
                }
            });
        },
        editLeadEvent: function(e)
        {
            var el = $(e.currentTarget),
                currentValue = el.val(),
                oldValue = el.data('old-value'),
                leadEventId = el.closest('tr').data('lead-event-id'),
                leadEventModel = this.leadEvents.get(leadEventId),
                attrName =  el.data('attrName');
console.log(attrName);
            if (currentValue != oldValue) {
                el.data('old-value', currentValue);
                leadEventModel.set(attrName, currentValue);
                leadEventModel.set('secureToken', $('#lead-events-secure-token').val());
                leadEventModel.save(null, {
                    success: function(model, response){
                        showMessage(response.responseText, false, 5000);
                    },
                    error: function(model, response){
                        showMessage(response.responseJSON, true, 5000);
                    }
                });

            }

        },
        navigate: function(e){
            e.preventDefault();

            var page = $(e.currentTarget).data('page');
            if ($.isNumeric(page)){
                this.leadEvents.goTo(page);
            } else {
                switch(page){
                    case 'first':
                        this.leadEvents.goTo(this.leadEvents.firstPage);
                        break;
                    case 'last':
                        this.leadEvents.goTo(this.leadEvents.information.lastPage);
                        break;
                    case 'prev':
                        this.leadEvents.requestPreviousPage();
                        break;
                    case 'next':
                        this.leadEvents.requestNextPage();
                        break;
                }
            }
        }
    });

    return LeadEventsGridView;
});