define([
    'backbone',
    '../collections/lead-custom-params.js',
    'text!../templates/paginator.html',
    'text!../templates/lead-custom-param-grid-row.html',
    'text!../templates/lead-custom-param-grid-select-value-row.html',
    'i18n!../../../nls/config_'+$('#lead-custom-params-leads-config-system-language').val()+'_ln.js'
], function(Backbone,
            LeadsCustomParamsCollection, PaginatorTmpl, LeadCustomParamsRowTmpl, LeadCustomGridSelectValueTmpl, i18n
){

    var LeadCustomParamsGridView = Backbone.View.extend({
        el: $('#lead-custom-params-grid-table'),
        events: {
            'click a[data-role=delete]': 'deleteCustomParam',
            'click td.lead-custom-params-grid-paginator a.page': 'navigate',
            'blur .lead-custom-param-edit-attribute'  : 'editLeadCustomParam',
            'click a[data-role=edit-checkbox]' : 'editLeadCustomParamCheckbox',
            'click a[data-role=edit-select]' : 'editLeadCustomParamSelect'
        },
        templates: {
            paginator: _.template(PaginatorTmpl)
        },
        initialize: function(options){
            this.leadParams = new LeadsCustomParamsCollection();
            this.$el =  $('#lead-custom-params-grid-table');
            this.leadParams.on('reset', this.renderLeadCustomParams, this);
            this.leadParams.on('add', this.renderLeadCustomParams, this);
            this.leadParams.on('destroy', this.renderLeadCustomParams, this);
        },
        render: function(){
            this.leadParams.pager();
        },
        renderLeadCustomParams: function(){
            this.$el.find('tbody').empty();
            this.leadParams.each(this.renderLeadCustomParam, this);
            this.leadParams.info()['i18n'] = i18n;
            if((this.leadParams.length == 0) && (this.leadParams.currentPage != 0)){
                this.leadParams.requestPreviousPage();
            }
            this.$('td.lead-custom-params-grid-paginator').html(this.templates.paginator(this.leadParams.information));
        },
        renderLeadCustomParam: function(leadsCustomParamsData){
            this.$el.find('tbody').append(_.template(LeadCustomParamsRowTmpl, {'leadsCustomParamsData': leadsCustomParamsData, 'i18n': i18n }));
        },
        deleteCustomParam: function(e){
            var self = this,
                cid = $(e.currentTarget).data('cid'),
                model = this.leadParams.get(cid);

            showConfirm(_.isUndefined(i18n['Are you sure want to delete'])?'Are you sure want to delete':i18n['Are you sure want to delete'], function(){
                if (model){
                    model.destroy();
                    self.render();
                }
            });
        },
        editLeadCustomParamSelect: function (e) {
            var el = $(e.currentTarget),
                paramType = el.data('type'),
                leadCustomParamId = el.closest('tr').data('lead-custom-param-id'),
                leadCustomParamModel = this.leadParams.get(leadCustomParamId),
                leadCustomParamsForm = $('#lead-custom-params-form-dropdown'),
                optionValueIds = [],
                optionValues = [];

            leadCustomParamsForm.find('#lead-field-type').val(paramType);
            leadCustomParamsForm.find('#lead-custom-param-type').val(paramType);
            leadCustomParamsForm.find('.param_name').val(leadCustomParamModel.attributes.param_name);
            leadCustomParamsForm.find('.param_label').val(leadCustomParamModel.attributes.label);
            leadCustomParamsForm.find('.lead-custom-param-id').val(leadCustomParamId);

            if((leadCustomParamModel.attributes.option_ids != null) && (leadCustomParamModel.attributes.option_values != null)){
                optionValueIds = leadCustomParamModel.attributes.option_ids.split(',');
                optionValues = leadCustomParamModel.attributes.option_values.split(',');

                $('.wrap').remove();
                _.each(optionValueIds, function (value, key) {
                    var optionData = {'selection_id': value, 'selection_value': optionValues[key]};
                    $('.option-list-holder').append(_.template(LeadCustomGridSelectValueTmpl, {'optionData': optionData, 'i18n': i18n}));
                });
            }
            $('#manage-lead-dropdown-container').show('slide', { direction: 'right'});
        },
        editLeadCustomParamCheckbox: function(e){
            var el = $(e.currentTarget),
                leadCustomParamId = el.closest('tr').data('lead-custom-param-id'),
                leadCustomParamModel = this.leadParams.get(leadCustomParamId),
                leadCustomParamsForm = $('#lead-custom-params-form');

            $('#lead-custom-params-form-save').val(_.isUndefined(i18n['Edit custom field'])?'Edit custom field':i18n['Edit custom field']);

            leadCustomParamsForm.find('#lead-field-type').val('checkbox');

            leadCustomParamsForm.find('.param_name').val(leadCustomParamModel.attributes.param_name);
            leadCustomParamsForm.find('.param_label').val(leadCustomParamModel.attributes.label);

            var optionValues = leadCustomParamModel.attributes.option_values.split(',');

            if(optionValues.length > 0){
                leadCustomParamsForm.find('.checkbox-yes').val(optionValues[0]);
            }
            leadCustomParamsForm.find('.lead-custom-param-id').val(leadCustomParamId);
            leadCustomParamsForm.find('.checkbox-default-values').show();
        },
        editLeadCustomParam: function(e)
        {
            var el = $(e.currentTarget),
                currentValue = el.val(),
                oldValue = el.data('old-value'),
                leadCustomParamId = el.closest('tr').data('lead-custom-param-id'),
                leadCustomParamModel = this.leadParams.get(leadCustomParamId),
                attrName =  el.data('attrName');

            if (currentValue != oldValue) {
                el.data('old-value', currentValue);
                leadCustomParamModel.set(attrName, currentValue);
                leadCustomParamModel.set('secureToken', $('#lead-custom-param-secure-token').val());
                leadCustomParamModel.save(null, {
                    success: function(model, response){
                        showMessage(response.responseText, false, 5000);
                    },
                    error: function(model, response){
                        showMessage(response.responseJSON, true, 5000);
                    }
                });

            }
        },
        navigate: function(e){
            e.preventDefault();

            var page = $(e.currentTarget).data('page');
            if ($.isNumeric(page)){
                this.leadParams.goTo(page);
            } else {
                switch(page){
                    case 'first':
                        this.leadParams.goTo(this.leadParams.firstPage);
                        break;
                    case 'last':
                        this.leadParams.goTo(this.leadParams.information.lastPage);
                        break;
                    case 'prev':
                        this.leadParams.requestPreviousPage();
                        break;
                    case 'next':
                        this.leadParams.requestNextPage();
                        break;
                }
            }
        }
    });

    return LeadCustomParamsGridView;
});
