define([
    'backbone',
    'text!../templates/lead-custom-param-grid-select-value-row.html',
    'i18n!../../../nls/config_'+$('#lead-custom-params-leads-config-system-language').val()+'_ln.js'
], function(Backbone, LeadCustomGridSelectValueTmpl, i18n){
    var LeadCustomParamsFormView = Backbone.View.extend({
        el: $('#lead-custom-params-main-div'),
        events: {
            'submit #lead-custom-params-form': 'submit',
            'submit #lead-custom-params-form-dropdown': 'submitDropdownForm',
            'keyup .param_name': 'updateParamsLabel',
            'click #lead-field-type': 'selectType',
            'click .add-selection-btn': 'addSelection',
            'click button.item-remove': 'deleteSelection',
            'click .close-screen': 'closeDropdownScreen'
        },
        templates: {

        },
        initialize: function(){
            this.$el = $('#lead-custom-params-main-div');
            this.$el.find('#lead-custom-params-form').attr('action', $('#website_url').val()+'api/leads/leadcustomparamsconfig');
            this.$el.find('#lead-custom-params-form-dropdown').attr('action', $('#website_url').val()+'api/leads/leadcustomparamsconfig');
        },
        render: function(){
            return this;
        },
        updateParamsLabel: function(e) {
            var currentName = $(e.currentTarget).val();
            $(e.currentTarget).closest('form').find('.param_label').val(currentName);
        },
        selectType: function(e){
            var target = $(e.currentTarget);
            this.$el.find('.checkbox-default-values').hide();

            $('.param_name').val('');
            $('.param_label').val('');
            $('#lead-custom-params-form-save').val('Add custom field');

            if(!$('.message').hasClass('mt20px')){
                $('.message').addClass('mt20px');
            }

            if(target.val() == 'checkbox'){
                this.$el.find('.checkbox-default-values').show();
                $('.message').removeClass('mt20px');
            }else if(target.val() == 'select' || target.val() == 'radio'){
               $('.wrap').remove();
               $('#lead-custom-param-type').val(target.val());
               $('#manage-lead-dropdown-container').show('slide', { direction: 'right'});
            }else{
                this.$el.find('.lead-custom-param-id').val('');
            }
        },
        addSelection: function(){
            $('.option-list-holder').append(_.template(LeadCustomGridSelectValueTmpl, {'optionData': '', 'i18n':i18n}));
        },
        deleteSelection: function(e){
            e.preventDefault();
            var thisEl = $(e.currentTarget),
                selectionId = thisEl.data('cid');
                if (selectionId != '') {
                    showConfirm(_.isUndefined(i18n['Are you sure want to delete'])?'Are you sure want to delete':i18n['Are you sure want to delete'], function() {
                        $.ajax({
                            url: $('#website_url').val() + 'api/leads/leadcustomparamsconfig/id/' + selectionId + '/customDropdownSelectionFlag/customDropdownSelectionFlag',
                            type: 'DELETE'
                        }).done(function (response) {
                            thisEl.closest('.wrap').remove();
                            showMessage('deleted', false, 5000);
                        }).fail(function (response) {
                            showMessage('error', true, 5000);
                        });
                        return false;
                    });
                }else{
                    thisEl.closest('.wrap').remove();
                }
        },
        closeDropdownScreen: function(){
            var self= this;

            $('#manage-lead-dropdown-container').hide('slide', { direction: 'right'});
            self.$el.trigger('LeadCustomParamsForm:created');
        },
        submitDropdownForm: function (e) {
            e.preventDefault();
            var self = this,
                form = $(e.currentTarget),
                isValid = true,
                dropdownValues = $('.wrap'),
                dropdownValRes = [],
                dropdownIdsRes = [];

            _.each(form.find('.required'), function(el){
                if (!$(el).val()){
                    isValid = false;
                }
            });

            if (!isValid){
                showMessage(_.isUndefined(i18n['Missing required field'])?'Missing required field':i18n['Missing required field'], true);
                return false;
            }

            if(!dropdownValues.length){
                showMessage(_.isUndefined(i18n['Add one selection please'])?'Add one selection please':i18n['Add one selection please'], true);
                return false;
            }

            _.each(dropdownValues, function (el) {
                if($(el).find('input').val() != ''){
                    var selectionId = $(el).find('input').data('selection-id');
                    if(selectionId != '') {
                        dropdownIdsRes.push(selectionId);
                    }
                    dropdownValRes.push($(el).find('input').val());
                }
            });
            dropdownValRes = dropdownValRes.join(',');
            $('#lead-custom-param-name').val(dropdownValRes);

            dropdownIdsRes = dropdownIdsRes.join(',');
            $('#lead-custom-param-options-ids').val(dropdownIdsRes);

            var formParams = form.serialize();

            this.sendAjax(formParams, form, self);
        },
        submit: function(e){
            e.preventDefault();
            var self = this,
                form = $(e.currentTarget),
                isValid = true;

            _.each(form.find('.required'), function(el){
                if (!$(el).val()){
                    isValid = false;
                }
            });

            if (!isValid){
                showMessage(_.isUndefined(i18n['Missing required field'])?'Missing required field':i18n['Missing required field'], true);
                return false;
            }

            var formParams = form.serialize();

            this.sendAjax(formParams, form, self);
        },
        sendAjax: function (formParams, form, self) {
            $.ajax({
                url: form.attr('action'),
                type: 'POST',
                data: formParams,
                dataType: 'json'
            }).done(function(response) {
                self.$el.trigger('LeadCustomParamsForm:created');
                showMessage(response.responseText, false, 5000);
                $('#manage-lead-dropdown-container').hide('slide', { direction: 'right'});
                $('#lead-field-type').val('text');
                form.find('input[type="text"]').val('');
                form.find('.checkbox-default-values').hide();
            }).fail(function(response){
                showMessage(response.responseJSON, true, 5000);
            });
            return false;
        }

    });

    return LeadCustomParamsFormView;
});
