import D3Funnel from 'd3-funnel';
import c3 from 'c3';
import * as d3 from "d3";

export const getGeneralWelcomeScreenData = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leadsdashboard/welcomescreen/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'id': payload.id
            }
        }).done(async  function(response){
            if (response.status !== 'error') {
                commit('setConfigDataInfo', response.data);
                commit('setAdditionalInfo', response.additionalInfo);
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const getTasksMeetingsNotesData = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        showSpinner('#tasks-meetings-notes-block', 'tasks-meetings-notes-spinner dashboard-spinner');
        $.ajax({
            'url': $('#website_url').val()+'api/leadsdashboard/taskmeetingsnotes/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'userId': payload.userId,
                'queryType' : payload.queryType,
                'querySubType' : payload.querySubType,
                'limit': state.pagination.leadTasksMeetingsNotes.itemsPerPage,
                'offset': (state.pagination.leadTasksMeetingsNotes.currentPage - 1) * state.pagination.leadTasksMeetingsNotes.itemsPerPage
            }
        }).done(async  function(response){
            hideSpinner('.tasks-meetings-notes-spinner');
            if (response.status !== 'error') {
                commit('setPaginationData', {leadTasksMeetingsNotes: {totalItems: response.totalRecords}});
                commit('setLeadMeetingsNotesData', response.data);
                commit('setTotalItemsFound', response.totalRecords)
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const getOpportunitiesClosingSoonData = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        showSpinner('#opportunities-closing-soon-block', 'opportunities-closing-soon-spinner dashboard-spinner');
        $.ajax({
            'url': $('#website_url').val()+'api/leadsdashboard/opportunitiesclosingsoon/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'userId': payload.userId,
                'oppStage' : payload.oppStage,
                'limit': state.pagination.opportunitiesClosingSoon.itemsPerPage,
                'offset': (state.pagination.opportunitiesClosingSoon.currentPage - 1) * state.pagination.opportunitiesClosingSoon.itemsPerPage,
                'subType':payload.subType
            }
        }).done(async  function(response){
            hideSpinner('.opportunities-closing-soon-spinner');
            if (response.status !== 'error') {
                commit('setPaginationData', {opportunitiesClosingSoon: {totalItems: response.totalRecords}});
                commit('setOpportunitiesClosingSoonData', response.data);
                commit('setOpportunitiesAdditionalInfo', response.opportunitiesAdditionalInfo);
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const getEngagedLeadsData = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        showSpinner('#engaged-leads-block', 'engaged-leads-spinner dashboard-spinner');
        $.ajax({
            'url': $('#website_url').val()+'api/leadsdashboard/engagedleads/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'userId': payload.userId,
                'actionType' : payload.actionType,
                'limit': state.pagination.engagedLeads.itemsPerPage,
                'offset': (state.pagination.engagedLeads.currentPage - 1) * state.pagination.engagedLeads.itemsPerPage
            }
        }).done(async  function(response){
            hideSpinner('.engaged-leads-spinner');
            if (response.status !== 'error') {
                commit('setPaginationData', {engagedLeads: {totalItems: response.totalRecords}});
                commit('setEngagedLeadsInfo', response.data);
                commit('setEngagedLeadsAdditionalInfo', response.engagedLeadsAdditionalInfo);
                commit('setCurrencyInfo', response.currencyInfo);
                commit('setOppStats', response.oppStats);
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const deletePreset = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        showSpinner('#latest-leads-block', 'latest-leads-spinner dashboard-spinner');
        $.ajax({
            'url': $('#website_url').val()+'api/leads/tablecolumnorder/id/'+payload.id,
            'type': 'DELETE',
            'dataType': 'json',
            'data': {}
        }).done(async  function(response){
            hideSpinner('.latest-leads-spinner');
            resolve(response);
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};


export const getLatestLeadsData = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        showSpinner('#latest-leads-block', 'latest-leads-spinner dashboard-spinner');
        $.ajax({
            'url': $('#website_url').val()+'api/leadsdashboard/latestleads/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'userId': payload.userId,
                'limit': state.pagination.latestLeads.itemsPerPage,
                'offset': (state.pagination.latestLeads.currentPage - 1) * state.pagination.latestLeads.itemsPerPage
            }
        }).done(async  function(response){
            hideSpinner('.latest-leads-spinner');
            if (response.status !== 'error') {
                commit('setPaginationData', {latestLeads: {totalItems: response.totalRecords}});
                commit('setLatestLeadsInfo', response.data);
                commit('setLatestLeadsAdditionalInfo', response.latestLeadsAdditionalInfo);
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const completeTask = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'plugin/leads/run/changeTaskStatus/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'notificationEmails': payload.taskNotifyEmails.split(','),
                'additionalComment': payload.taskComment,
                'isClosed': '1',
                'taskId': payload.taskId,
                'secureToken':$('#welcome-screen-config-token').val(),
                'dashboardResponseFormat': '1'
            }
        }).done(async  function(response){
            resolve(response);
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const completeTasks = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leadsdashboard/changetasks/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'additionalComment': payload.taskComment,
                'secureToken':$('#welcome-screen-config-token').val(),
                'tasksIds' : payload.tasksIds,
                'filter':payload.filter,
                'applyFullFilter':payload.applyFullFilter,
                'offset': payload.offset,
                'limit': payload.limit,
                'specialCloseType':payload.specialCloseType
            }
        }).done(async  function(response){
            resolve(response);
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const countTasksToComplete = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leadsdashboard/counttaskstocomplete/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'secureToken':$('#welcome-screen-config-token').val(),
                'tasksIds' : payload.tasksIds,
                'specialCloseType':payload.specialCloseType
            }
        }).done(async  function(response){
            resolve(response);
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const deleteLead = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leads/id/'+payload.id,
            'type': 'DELETE',
            'dataType': 'json',
            'data': {

            }
        }).done(async  function(response){
            resolve(response);
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const getGeneralOppAndSalesStats = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        showSpinner('#opportunities-and-sales-stats-block', 'opportunities-and-sales-stats-spinner dashboard-spinner');
        $.ajax({
            'url': $('#website_url').val()+'api/leadsdashboard/oppsalesgeneralinfo/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'userId':payload.userId,
                'filterDateFrom':payload.filterDateFrom,
                'filterDateTo':payload.filterDateTo,
                'filterPeriodMonths':payload.filterPeriodMonths
            }
        }).done(async  function(response){
            hideSpinner('.opportunities-and-sales-stats-spinner');
            if (response.status !== 'error') {
                commit('setOppSalesGeneralInfo', response.data);
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const getSalesGoalData = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        showSpinner('#sales-goals-block', 'sales-goals-block-spinner dashboard-spinner');
        $.ajax({
            'url': $('#website_url').val()+'api/leadsdashboard/salesgoal/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'userId':payload.userId,
                'filterDateFrom':payload.filterDateFrom,
                'filterDateTo':payload.filterDateTo,
                'filterPeriodMonths':payload.filterPeriodMonths
            }
        }).done(async  function(response){
            hideSpinner('.sales-goals-block-spinner');
            if (response.status !== 'error') {
                commit('setSalesGoalData', response.data);
                commit('setSalesAdditionalInfo', response.salesAdditionalInfo);
                commit('setSalesGoalGraphData', response.graphs);
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const getOpportunityGoalData = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        showSpinner('#opportunity-goals-block', 'opportunity-goals-spinner dashboard-spinner');
        $.ajax({
            'url': $('#website_url').val()+'api/leadsdashboard/opportunitygoal/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'userId':payload.userId,
                'filterDateFrom':payload.filterDateFrom,
                'filterDateTo':payload.filterDateTo,
                'queryType':payload.queryType,
                'oppType':payload.oppType,
                'filterPeriodMonths':payload.filterPeriodMonths
            }
        }).done(async  function(response){
            hideSpinner('.opportunity-goals-spinner');
            if (response.status !== 'error') {
                commit('setOpportunityGoalData', response.data);
                commit('setOpportunityGoalGraphData', response.graphs);
                commit('setOpportunityGoalAdditionalInfo', response.opportunitiesAdditionalInfo);
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};


export const getGraphData = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        showSpinner(payload.elName, 'total-pipeline-by-stage-spinner dashboard-spinner');
        $.ajax({
            'url': $('#website_url').val()+'api/leadsdashboard/graphs/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'userId': payload.userId,
                'graphType':payload.graphType,
                'filterDateFrom':payload.filterDateFrom,
                'filterDateTo':payload.filterDateTo,
                'leadReportsFunnelDateOrigin':payload.leadReportsFunnelDateOrigin,
                'leadReportsFunnelToDateOrigin':payload.leadReportsFunnelToDateOrigin
            }
        }).done(async  function(response){
            hideSpinner('.total-pipeline-by-stage-spinner');
            if (response.status !== 'error') {
                if (typeof response.storageName !== 'undefined') {
                    let storageName = response.storageName;
                    commit('setState', {[storageName]: []});
                    commit('setState', {[storageName]: response.graphs});
                }
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const updatePreset = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/tablecolumnorder/',
            'type': 'PUT',
            'dataType': 'json',
            'data': JSON.stringify({
                'id': payload.id,
                'isDefault': payload.isDefault,
                'secureToken':$('#welcome-screen-config-token').val(),
                'tableName':payload.tableName
            })
        }).done(async  function(response){
            resolve(response);
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const saveColumnTableOrder = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/tablecolumnorder/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'tableName': payload.tableName,
                'tableColumnOrder': payload.tableColumnOrder,
                'applyToAll': payload.applyToAll,
                'secureToken':$('#welcome-screen-config-token').val(),
                'presetName' :payload.presetName,
                'presetId' :payload.presetId,
            }
        }).done(async  function(response){
            resolve(response);
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};


export const drawFunnel = ({state, getters}, payload) => {

    let customParamsData = payload.customParamsData;

    let height = getters.processWidth(payload.percentHeight),
        width  = getters.processWidth(payload.percentWidth);

    if (typeof customParamsData !== 'undefined' && typeof customParamsData.percentFromEl !== 'undefined') {
        height = getters.processWidth(payload.percentHeight, chartEl);
        width  = getters.processWidth(payload.percentWidth, chartEl);
    }

    const options = {
        chart: {
            width: width,
            height: height,
            curve: 'enabled',
            bottomWidth: 3 / 8,
            bottomPinch: 0

        },
        block: {
            minHeight: 10,
            dynamicHeight: true,
            highlight: true
        },
        label: {
            format: function(label, value){
                if (typeof customParamsData !== 'undefined' && typeof customParamsData.allData !== 'undefined') {
                    let opportunityValue = label.replace(/(.*)((\d){2}%)$/ui, function(a, b, c){
                        return c;
                    });

                    let amount = getters.toCurrency(Math.round(customParamsData.allData[opportunityValue]['amount']), 0);
                    return value + ' ' + 'opps in' + ' ' + customParamsData.allData[opportunityValue]['leadsCount'] + ' ' + 'accounts' + ': ' + amount + ' ' + 'total at' + ' ' + opportunityValue + ' ' + 'stage';
                } else {
                    return label+': '+value;
                }
            }
        },
        events: {
            click: {
                block: function(d) {
                    if (typeof customParamsData !== 'undefined' && typeof customParamsData.axesAdditionalInfo !== 'undefined' && customParamsData.axesAdditionalInfo !== '') {

                        let id = d.index,
                            filterFromDate = customParamsData.filterStartDate,
                            filterToDate = customParamsData.filterEndDate,
                            filterType = customParamsData.filterType,
                            filterTypeId = customParamsData.axesAdditionalInfo[id],
                            defaultFilterFromDateNameField = customParamsData.defaultFilterFromDateNameField,
                            defaultFilterToDateNameField = customParamsData.defaultFilterToDateNameField;

                        if (typeof customParamsData.filterFromDateCustom !== 'undefined' && customParamsData.filterFromDateCustom !== '') {
                            defaultFilterFromDateNameField = customParamsData.filterFromDateCustom;
                        }

                        if (typeof customParamsData.filterToDateCustom !== 'undefined' && customParamsData.filterToDateCustom !== '') {
                            defaultFilterToDateNameField = customParamsData.filterToDateCustom;
                        }

                        if (typeof filterType !== 'undefined' && filterType !== '') {
                            let filterFinalUrl = $('#website_url').val() + 'dashboard/leads/?filter=1&'+defaultFilterFromDateNameField+'='+filterFromDate+'&'+defaultFilterToDateNameField+'='+filterToDate+'&'+filterType+'=' + filterTypeId;

                            if (typeof customParamsData.leadOwnerId !== 'undefined' && customParamsData.leadOwnerId != '0') {
                                filterFinalUrl = filterFinalUrl+'&owner_id='+customParamsData.leadOwnerId;
                            }

                            window.open(filterFinalUrl, '_blank');
                        }
                    }
                }
            }
        },
        tooltip : {
            enabled: false,
            format: '{l}'+' '+'quantity'+ ' ' + '({f})'
        }

    };

    const chart = new D3Funnel(payload.elId);
    chart.draw(payload.chartData, options);
};

export const destroyFunnel = ({state, getters}, payload) => {

    const chart = new D3Funnel(payload.elId);
    chart.destroy();
};

export const drawDonutGraph = ({state, getters}, payload) => {
    let barWidth = getters.processWidth(payload.percentWidth),
        colorPattern = [],
        title = '',
        showLegend = false,
        legendPosition = 'bottom',
        customParamsData = payload.customParamsData;

    if (typeof customParamsData.colorPattern !== 'undefined') {
        colorPattern = customParamsData.colorPattern;
    }

    if (typeof customParamsData.title !== 'undefined') {
        title = customParamsData.title;
    }

    if (typeof customParamsData.showLegend !== 'undefined'){
        showLegend = true;
    }

    if(typeof customParamsData.legendPosition !== 'undefined'){
        legendPosition = customParamsData.legendPosition;
    }

    let chart = c3.generate({
        bindto: payload.elId,
        onresize: function(){
            chart.resize({
                width:  barWidth,
                height: barWidth/2
            });
        },
        size: {
            width: barWidth,
            height: barWidth/2
        },
        data: {
            columns: payload.chartData,
            type : 'donut',
            onclick: function (d, i) {
                if (typeof customParamsData  !== 'undefined' &&  typeof customParamsData.axesAdditionalInfo !== 'undefined' && typeof customParamsData.disableRedirect === 'undefined') {

                    let id = arguments[0]['id'],
                        axeXValue = arguments[0]['index'],
                        filterFromDate = customParamsData.filterStartDate,
                        filterToDate = customParamsData.filterEndDate,
                        pieComparison = '',
                        defaultFilterFromDateNameField = customParamsData.defaultFilterFromDateNameField,
                        defaultFilterToDateNameField = customParamsData.defaultFilterToDateNameField,
                        filterTypeId = customParamsData.axesAdditionalInfo[axeXValue],
                        filterFromDateNameAlternative = customParamsData.filterFromDateNameAlternative,
                        filterToDateNameAlternative = customParamsData.filterToDateNameAlternative,
                        filterType = customParamsData.filterType,
                        predefinedFilterParams = customParamsData.predefinedParams,
                        oppTypes = customParamsData.opportunityTypes;

                    if (filterTypeId === '99') {
                        filterTypeId = '10,20,30,40,50,60,70,80,90';
                    }

                    if (typeof filterFromDateNameAlternative !== 'undefined' && filterFromDateNameAlternative !== '') {
                        defaultFilterFromDateNameField = filterFromDateNameAlternative;
                    }

                    if (typeof filterToDateNameAlternative !== 'undefined' && filterToDateNameAlternative !== '') {
                        defaultFilterToDateNameField = filterToDateNameAlternative;
                    }

                    if (typeof filterType !== 'undefined' && filterType !== '') {
                        let filterFinalUrl = $('#website_url').val() + 'dashboard/leads/?filter=1&' + defaultFilterFromDateNameField + '=' + filterFromDate + '&' + defaultFilterToDateNameField + '=' + filterToDate + '&' + filterType + '=' + filterTypeId;

                        if (typeof predefinedFilterParams !== 'undefined' && predefinedFilterParams !== '') {
                            filterFinalUrl = filterFinalUrl+'&'+predefinedFilterParams;
                        }

                        if (typeof oppTypes !== 'undefined' && oppTypes !== '') {
                            filterFinalUrl = filterFinalUrl+'&lead_opportunity_types='+oppTypes;
                        }

                        if (typeof customParamsData.leadOwnerId !== 'undefined' && customParamsData.leadOwnerId != '0') {
                            filterFinalUrl = filterFinalUrl+'&owner_id='+customParamsData.leadOwnerId;
                        }

                        window.open(filterFinalUrl, '_blank');
                    }
                }
            }
        },
        donut: {
            label: {
                format: function (value, ratio, id) {
                    return '';
                }
            }
        },
        title: {
            text: title,
            position: 'center'
        },
        color: {
            pattern: colorPattern
        },
        //Alternative tooltip
        tooltip: {
            format: {
                title: function(d){return '';},
                value: function (value, ratio, id, title) {
                    if (typeof customParamsData.amountComparison !== 'undefined') {
                        let amount = getters.toCurrency(value, 0);
                        if (id.match(/(.*)Won/ui)) {
                            if (!_.isEmpty(customParamsData.amountComparison.labelsData)) {
                                if (typeof customParamsData.subType !== 'undefined' && customParamsData.subType === 'count') {
                                    return customParamsData.amountComparison.labelsData.Won;
                                } else {
                                    return amount + ' ' + customParamsData.amountComparison.labelsData.Won;
                                }
                            } else {
                                return amount
                            }
                        } else if(id.match(/(.*)Lost/ui)) {
                            if (!_.isEmpty(customParamsData.amountComparison.labelsData)) {
                                if (typeof customParamsData.subType !== 'undefined' && customParamsData.subType === 'count') {
                                    return customParamsData.amountComparison.labelsData.Lost;
                                } else {
                                    return amount + ' ' + customParamsData.amountComparison.labelsData.Lost;
                                }
                            } else {
                                return amount
                            }
                        } else {
                            if (!_.isEmpty(customParamsData.amountComparison.labelsData)) {
                                if (typeof customParamsData.subType !== 'undefined' && customParamsData.subType === 'count') {
                                    return customParamsData.amountComparison.labelsData.Open;
                                } else {
                                    return amount + ' ' + customParamsData.amountComparison.labelsData.Open;
                                }
                            } else {
                                return amount
                            }
                        }
                    }
                },
                name: function(){return '';}
            }
        },
        legend: {
            show: showLegend,
            position: legendPosition

        }
    });

    // find all the labels
    d3.selectAll(".c3-chart-arc>text")
        .attr("transform", function(d,i){
            let r = 90, //<-- adjust this to move the labels
                a = (d.startAngle + d.endAngle) / 2 - (Math.PI / 2);
            // compute the new centroid
            return "translate(" + (Math.cos(a) * r) + "," + (Math.sin(a) * r) + ")";
        });
};



export const drawBarGraph = ({state, getters}, payload) => {
    let barWidth = getters.processWidth(payload.percentWidth),
        yAxisTick =  {
            centered: true,
            outer: false,
            multiline: true
        },
        showLegend = false,
        groups = [],
        order = null,
        colorPattern = [],
        labels = [],
        title = '',
        tooltip = true,
        compare = false,
        roughData = {},
        self = this,
        customParamsData = payload.customParamsData;


    if (typeof customParamsData !== 'undefined') {
        if(typeof customParamsData.showLegend !== 'undefined'){
            showLegend = true;
        }

        if (typeof customParamsData.customYAxisFormat !== 'undefined') {
            if (customParamsData.customYAxisFormat.type === 'currency') {
                yAxisTick.format = function(d) { return customParamsData.customYAxisFormat.sign + d3.format(",")(d); }
            }

            if (customParamsData.customYAxisFormat.type === 'onlyInteger') {
                yAxisTick.format = d3.format("d")
            }
        }

        if (typeof customParamsData.groups !== 'undefined') {
            groups = customParamsData.groups;
        }

        if (typeof customParamsData.colorPattern !== 'undefined') {
            colorPattern = customParamsData.colorPattern;
        }

        if (typeof customParamsData.title !== 'undefined') {
            title = customParamsData.title;
        }

        if (typeof customParamsData.labels !== 'undefined') {
            if (typeof customParamsData.labels.type !== 'undefined' && customParamsData.labels.type === 'currency') {
                labels = {
                    format: function (v, id, i, j) {
                        if (v !== 0) {
                            return customParamsData.labels.sign + d3.format(",")(v);
                        }
                    }
                }
            } else {
                labels = {
                    format: function (v, id, i, j) {
                        if (v !== 0) {
                            return v;
                        }
                    }
                }
            }
        }

        if (typeof customParamsData.tooltip !== 'undefined') {
            if (customParamsData.tooltip.compare !== 'undefined' && customParamsData.tooltip.compare === true) {
                compare = true;
            }

            if (customParamsData.tooltip.roughData !== 'undefined') {
                roughData = customParamsData.tooltip.roughData;
            }

            tooltip = {
                format: {
                },
                contents: function (d, defaultTitleFormat, defaultValueFormat, color) {
                    let $$ = this, config = $$.config,
                        titleFormat = config.tooltip_format_title || defaultTitleFormat,
                        nameFormat = config.tooltip_format_name || function (name) { return name; },
                        valueFormat = config.tooltip_format_value || defaultValueFormat,
                        text, i, title, value, name, bgcolor,
                        dataParams = {},
                        usedParams = {},
                        textItemRow = '';

                    for (i = 0; i < d.length; i++) {
                        if (! (d[i] && (d[i].value || d[i].value === 0))) { continue; }
                        name = nameFormat(d[i].name);
                        value = valueFormat(d[i].value, d[i].ratio, d[i].id, d[i].index);
                        bgcolor = $$.levelColor ? $$.levelColor(d[i].value) : color(d[i].id);
                        title = titleFormat ? titleFormat(d[i].x) : d[i].x;
                        dataParams[name] = {'value' : value, 'bgcolor' : bgcolor, 'line': d[i].id};
                        if (!_.isEmpty(roughData)) {
                            let roughDataItem = _.find(roughData, function(item) {
                                if (name.match(/\*/) !== null && compare === true) {
                                    return (item.full_name == title && item.type == 'previous' && item.description == name.substring(1));
                                } else {
                                    return (item.full_name == title && item.type == 'current' && item.description == name);
                                }
                            });

                            dataParams[name].amount = accounting.formatMoney(Math.round(roughDataItem.amount), JSON.parse(self.LeadReportsCollection.moneyFormat));
                            dataParams[name].count = roughDataItem.count;
                        } else {
                            dataParams[name].amount = '';
                            dataParams[name].count = '';
                        }

                    }

                    for (const key in dataParams) {
                        if (!text) {
                            text = "<table class='" + $$.CLASS.tooltip + "'>" + "<tr><th style='text-align: center'>" + title + "</th><th style='text-align: center'>"+customParamsData.tooltip.filterFromDate+"</th>";
                            if (compare === true) {
                                text += "<th style='text-align: center'>"+customParamsData.tooltip.filterToDate+"</th></tr>";
                            }
                        }


                        if ((typeof usedParams[key] !== 'undefined' || typeof usedParams[key.substring(1)] !== 'undefined') && compare === true) {
                            continue;
                        }

                        text += "<tr class='" + $$.CLASS.tooltipName + "-" + key + "'>";


                        if (key.match(/\*/) !== null) {
                            text += "<td class='name'><span style='background-color:" + dataParams[key]['bgcolor'] + "'></span>" + key.substring(1)+"</td>";
                        } else {
                            text += "<td class='name'><span style='background-color:" + dataParams[key]['bgcolor'] + "'></span>" + key+"</td>";
                        }

                        if (key.match(/\*/) !== null && compare === true) {
                            if (typeof dataParams[key.substring(1)] !== 'undefined') {
                                if (typeof dataParams[key.substring(1)]['count'] !== 'undefined' && dataParams[key.substring(1)]['count'] !== '') {
                                    textItemRow = dataParams[key.substring(1)]['value']  + ' ('+dataParams[key.substring(1)]['count']+')';
                                } else {
                                    textItemRow = dataParams[key.substring(1)]['value'];
                                }
                                text += "<td  style='text-align:center;' class='value'>" + textItemRow + "</td>";

                            } else {
                                text += "<td  style='text-align:center;' class='value'>" + 0 + "</td>";
                            }
                            if (typeof dataParams[key]['count'] !== 'undefined' && dataParams[key]['count'] !== '') {
                                textItemRow = dataParams[key]['value'] + ' ('+ dataParams[key]['count']+')';
                            } else {
                                textItemRow =  dataParams[key]['value'];
                            }
                            text += "<td  style='text-align:center;' class='value'>"+ textItemRow + "</td>";
                        } else if (compare === true){
                            if (typeof dataParams[key]['count'] !== 'undefined' && dataParams[key]['count'] !== '') {
                                textItemRow = dataParams[key]['value'] + ' ('+ dataParams[key]['count']+ ')';
                            } else {
                                textItemRow = dataParams[key]['value'];
                            }
                            text += "<td  style='text-align:center;'  class='value'>"+ textItemRow + "</td>";
                            if (typeof dataParams['*'+key] !== 'undefined') {
                                if (typeof dataParams['*'+key]['count'] !== 'undefined' && dataParams['*'+key]['count'] !== '') {
                                    textItemRow = dataParams['*'+key]['value'] + ' ('+ dataParams['*'+key]['count']+ ')';
                                } else {
                                    textItemRow = dataParams['*'+key]['value'];
                                }
                                text += "<td  style='text-align:center;' class='value'>" + textItemRow + "</td>";
                            } else {
                                text += "<td  style='text-align:center;' class='value'>" + 0 + "</td>";
                            }
                        } else {
                            if (typeof dataParams[key]['count'] !== 'undefined' && dataParams[key]['count'] !== '') {
                                textItemRow =  dataParams[key]['value'] + ' ('+dataParams[key]['count']+')';
                            } else {
                                textItemRow = dataParams[key]['value'];
                            }
                            text += "<td  style='text-align:center;' class='value'>" + textItemRow + "</td>";
                        }


                        text += "</tr>";

                        usedParams[key] = true;
                    }
                    return text + "</table>";
                }
            }
        }
    }

    let chart = c3.generate({
        bindto: payload.elId,
        size: {
            width: barWidth,
            height: barWidth/2.5
        },
        onresize: function(){
            if (typeof window.device !== 'undefined') {
                if (window.device.tablet() || window.device.mobile()) {
                    let koef = 1.1;
                    if (window.device.mobile()) {
                        if (!window.device.landscape()) {
                            koef = 1.6;
                        }
                    }
                    chart.resize({
                        width: getters.processWidth()/koef,
                        height: getters.processWidth() / 2.5
                    });
                }
            } else {
                chart.resize({
                    width: barWidth,
                    height: barWidth / 2.5
                });
            }
        },
        data: {
            x: 'x',
            columns:payload.chartData,
            type: 'bar',
            groups:groups,
            order: order,
            labels: labels,
            onclick: function () {
                if (typeof customParamsData  !== 'undefined' &&  typeof customParamsData.axesAdditionalInfo !== 'undefined') {

                    let id = arguments[0]['id'],
                        axeXValue = arguments[0]['x'],
                        filterFromDate = customParamsData.filterStartDate,
                        filterToDate = customParamsData.filterEndDate,
                        filterTypeId = customParamsData.axesAdditionalInfo[axeXValue+1],
                        defaultFilterFromDateNameField = customParamsData.defaultFilterFromDateNameField,
                        defaultFilterToDateNameField = customParamsData.defaultFilterToDateNameField,
                        additionalFilter = customParamsData.additionalFilter,
                        filterFromDateNameAlternative = customParamsData.filterFromDateNameAlternative,
                        filterToDateNameAlternative = customParamsData.filterToDateNameAlternative,
                        predefinedFilterParams = customParamsData.predefinedParams,
                        rangeOptions = customParamsData.rangeOptions,
                        filterType = customParamsData.filterType;

                    if(typeof customParamsData.additionalFilterPreset !== 'undefined') {
                        additionalFilter = customParamsData.additionalFilterPreset[axeXValue+1];
                    }

                    if (typeof filterFromDateNameAlternative !== 'undefined' && filterFromDateNameAlternative !== '') {
                        defaultFilterFromDateNameField = filterFromDateNameAlternative;
                    }

                    if (typeof filterToDateNameAlternative !== 'undefined' && filterToDateNameAlternative !== '') {
                        defaultFilterToDateNameField = filterToDateNameAlternative;
                    }

                    if (typeof filterType !== 'undefined' && filterType !== '') {
                        let additionalFilterParams = '';

                        if(typeof additionalFilter !== 'undefined') {
                            additionalFilterParams = additionalFilter;
                        }

                        let filterFinalUrl = $('#website_url').val() + 'dashboard/leads/?filter=1&'+defaultFilterFromDateNameField+'='+filterFromDate+'&'+defaultFilterToDateNameField+'='+filterToDate+'&'+filterType+'=' + filterTypeId + '&range_options=' + rangeOptions + additionalFilterParams;

                        if (typeof predefinedFilterParams !== 'undefined' && predefinedFilterParams !== '') {
                            filterFinalUrl = filterFinalUrl+'&'+predefinedFilterParams;
                        }

                        if (typeof customParamsData.leadOwnerId !== 'undefined' && customParamsData.leadOwnerId != '0') {
                            filterFinalUrl = filterFinalUrl+'&owner_id='+customParamsData.leadOwnerId;
                        }

                        window.open(filterFinalUrl, '_blank');
                    }
                }
            }
        },
        color: {
            pattern: colorPattern
        },
        axis: {
            rotated: true,
            x: {
                type: 'category',
                show: true,
                tick: {
                    centered: true,
                    multiline:true,
                    width: 150

                }
            },
            y:{
                show: true,
                tick: yAxisTick
            }
        },
        grid: {
            x: {
                show: true
            }
        },
        title: {
            text: title,
            position: 'top-center'
        },
        legend: {
            show: showLegend,
            position: 'bottom'
        },
        tooltip: tooltip

    });

    $(payload.elId).data('c3-chart', chart);
};

export const destroyGraph = ({state, getters}, payload) => {
    let chart = c3.generate({
        bindto: payload.elId,
        padding: {},
        data: {
            columns: [
            ],
        },
    });

    chart.destroy();
};

export const deleteCustomLegend = ({state, getters}, payload) => {
    let legend = payload.legend;
    $('.chart-legend', legend).remove();
};

export const createCustomLegend = ({state, getters}, payload) => {

    let legend = payload.legend,
        chartEl = payload.chartEl,
        xValues = payload.xValues,
        fullColorPattern = payload.fullColorPattern;

    $('.chart-legend', legend).remove();
    d3.select(legend).append('ul').attr('class', 'chart-legend pl0px')
        .selectAll('li')
        .data(xValues)
        .enter()
        .append('li')
        .style('white-space', 'nowrap')
        .attr('data-id', function (id) { return id; })
        .on('mouseover', function (el, id) {
            if(!$(this).hasClass('clicked')) {
                $(chartEl).data('c3-chart').focus(id);
                $('li:not([data-id="' + id + '"])', legend).css('opacity', '0.3');
            }
        })
        .on('mouseout', function (el, id) {
            $(chartEl).data('c3-chart').revert();
            $('li:not(".clicked")', legend).css('opacity', '1');
        })
        .on('click', function (el, id) {
            if (id.match(/\*/) !== null) {
                $(chartEl).data('c3-chart').toggle(id);
                $(chartEl).data('c3-chart').toggle(id.substring(1));
            } else {
                $(chartEl).data('c3-chart').toggle(id);
                $(chartEl).data('c3-chart').toggle('*'+id);
            }

            $(chartEl).data('c3-chart').revert();
            if(!$(this).hasClass('clicked')) {
                $(this).addClass('clicked');
                $(this).css('opacity', '0.3');
                $('li:not(".clicked")', legend).css('opacity', '1');
            }
            else{
                $('li:not(".clicked")', legend).css('opacity', '0.3');
                $(this).removeClass('clicked');
                $(this).css('opacity', '1');
                if (id.match(/\*/) !== null) {
                    $(chartEl).data('c3-chart').focus(id);
                    $(chartEl).data('c3-chart').focus(id.substring(1))
                } else {
                    $(chartEl).data('c3-chart').focus(id);
                    $(chartEl).data('c3-chart').focus('*'+id)
                }
            }
        })
        .append('span')
        .each(function (id) {

            let colorId = id;
            if (!_.has(fullColorPattern, id)) {
                colorId = '*'+id;
            }

            let color = fullColorPattern[colorId];

            d3.select(this).style('background-color', color);
            $(this).after('<i> '+ id + '</i>');
        });
};