import {mapGetters} from 'vuex';
import lodash from 'lodash';
import localeMapping from '../../../localizationLanguages';
import pagination from '../../pagination';
import D3Funnel from 'd3-funnel';
import moment from 'moment';
export default {
    data () {
        return {
            loadedScreen: false,
            websiteUrl: $('#website_url').val(),
            graphType: 'opportunityStageFunnelOriginal',
            graphDataExists: false,
            expectionDataExists: false,
            salesExpectation : 0,
            filterDateFromForDatepicker:'',
            filterDateToForDatepicker:'',
            filterDateFrom :'',
            filterDateTo :'',
            locale: $('#dashboard-system-language').val(),
            minDate: null,
            datepickerLanguage: {

            },
            elName:'#total-pipeline-by-stage-block'
        }
    },
    components: {
        pagination: pagination
    },
    computed: {
        ...mapGetters({
            formatDate: 'formatDate',
            formatOnlyDate: 'formatOnlyDate',
            formatTimeOnly: 'formatTimeOnly',
            configDataInfo:'getConfigDataInfo',
            additionalInfo:'getAdditionalInfo',
            sortByColumn: 'sortByColumn',
            truncateText: 'truncateText',
            toCurrency: 'toCurrency',
            selectedUserId: 'getSelectedUserId',
            graphFunnelData:'getGraphFunnelData',
            formatDateForGraphs:'formatDateForGraphs'
        })
    },
    watch: {
        selectedUserId (newUserId, oldUseId) {
            console.log(`Old user id ${oldUseId} - new user id ${newUserId}`);
            if (newUserId !== oldUseId) {
                this.drawGraph();
            }
        }
    },
    methods: {
        async applyFilter(selectedDate) {
            this.filterDateFrom = moment(this.filterDateFromForDatepicker).format('YYYY-MM-DD HH:mm:ss');
            this.filterDateTo = moment(selectedDate).format('YYYY-MM-DD HH:mm:ss');
            this.drawGraph();
        },
        async setDefaultDate() {
            let userDateFrom = moment(this.additionalInfo.userDate),
                userDateTo = moment(this.additionalInfo.userDate);

            this.filterDateFromForDatepicker = userDateFrom.startOf('day').toDate();
            this.minDate = this.filterDateFromForDatepicker;
            this.filterDateFrom = moment(this.filterDateFromForDatepicker).format('YYYY-MM-DD HH:mm:ss');
        },
        async drawGraph() {
            const result = await this.$store.dispatch('getGraphData', {'router':this.$router, 'userId':this.selectedUserId, 'graphType':this.graphType, leadReportsFunnelDateOrigin:this.filterDateFrom, 'leadReportsFunnelToDateOrigin':this.filterDateTo, 'elName':this.elName});

            this.$store.dispatch('destroyFunnel', {
                'elId': '#lead-report-opportunity-stage-funnel',
                'router': this.$router
            });

            if(result.status === 'error') {
                showMessage('Please re-login', true, 3000);
            } else {
                let graphFunnelData = this.graphFunnelData,
                    chartData = [];

                if (typeof graphFunnelData[this.graphType]['data'] !== 'undefined') {
                    _.each(graphFunnelData[this.graphType]['data'], function (opportunityData, opportunity) {
                        chartData.push([opportunityData.stageName + ' ' + opportunity, parseInt(opportunityData.count), opportunityData.color]);
                    });
                }

                let leadOwnerId = this.selectedUserId;
                if (this.selectedUserId == '-2') {
                    leadOwnerId = this.additionalInfo.loggedUserId;
                }

                if (this.selectedUserId == '-1') {
                    leadOwnerId = 0;
                }

                if (this.selectedUserId == '') {
                    leadOwnerId = this.additionalInfo.loggedUserId;
                }

                if (chartData.length > 0) {
                    this.graphDataExists = true;
                    this.expectionDataExists = true;
                    this.$store.dispatch('drawFunnel', {
                        'elId': '#lead-report-opportunity-stage-funnel',
                        'chartData': chartData,
                        'percentHeight': 35,
                        'percentWidth': 60,
                        'customParamsData': {
                            'axesAdditionalInfo': graphFunnelData[this.graphType].axesAdditionalInfo,
                            'allData': graphFunnelData[this.graphType]['data'],
                            'filterStartDate':this.formatDateForGraphs(graphFunnelData[this.graphType].filterStartDate),
                            'filterEndDate':this.formatDateForGraphs(graphFunnelData[this.graphType].filterEndDate),
                            'filterFromDateCustom':'expected_date_from',
                            'filterToDateCustom':'expected_date_to',
                            'filterType':'lead_opportunity_stages',
                            'defaultFilterFromDateNameField':'created_at_from',
                            'defaultFilterToDateNameField':'created_at_to',
                            'leadOwnerId':leadOwnerId
                        },
                        'router': this.$router
                    });

                    this.salesExpectation = graphFunnelData[this.graphType].salesExpectation;
                } else {
                    this.expectionDataExists = false;
                }

                this.loadedScreen = true;

            }

        }
    },
    async created(){

    },
    async updated() {
        this.$nextTick(function () {
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        })
    },
    async mounted()  {
        this.graphDataExists = true;
        this.setDefaultDate();
        this.drawGraph();
    }
}
