import merge from 'lodash/merge';
import moment from 'moment';
import lodash from 'lodash';
import unescape from "lodash/unescape";

let defaultState = {
    configDataInfo: [],
    additionalInfo: [],
    currencyInfo :[],
    userGridInfo :[],
    usersAdditionalInfo :[],
    filterInfo:[],
    checkedItems:{},
    activeMassAction:0,
    totalItemsFound:0,
    changeMainTabRemote:'',
    filterData:{},
    isMassActionActive: false,
    additionalInfoDetailedScreen: []
};

let state = {};
merge(state, defaultState);

const actions = {

};

const mutations = {
    setConfigDataInfo : (state, payload) => {
        state.configDataInfo = payload;
    },
    setAdditionalInfo : (state, payload) => {
        state.additionalInfo = payload;
    },
    setCurrencyInfo: (state, payload) => {
        state.currencyInfo = payload
    },
    setUserGridInfo:(state, payload) => {
        state.userGridInfo = payload;
    },
    setUsersAdditionalInfo:(state, payload) => {
        state.usersAdditionalInfo = payload;
    },
    setChangeMainTabRemote:(state, payload) => {
        state.changeMainTabRemote = payload;
    },
    setChangeFilter : (state, payload) => {
        state.filterInfo = payload;
    },
    setStageCompletedInfo : (state, payload) => {
        state.stageCompletedInfo = payload;
    },
    setCheckedItems : (state, payload) => {
        state.checkedItems = payload;
    },
    setActiveMassAction : (state, payload) => {
        state.activeMassAction = payload;
    },
    setTotalItemsFound: (state, payload) => {
        state.totalItemsFound = payload
    },
    setFilterData: (state, payload) => {
        state.filterData = payload
    },
    setIsMassActionActive: (state, payload) => {
        state.isMassActionActive = payload
    },
    setAdditionalInfoDetailedScreen: (state, payload) => {
        state.additionalInfoDetailedScreen = payload
    }

};

const getters = {
    getConfigDataInfo : (state) => {
        return state.configDataInfo
    },
    getAdditionalInfo : (state) => {
        return state.additionalInfo
    },
    getCurrencyInfo : (state) => {
        return state.currencyInfo
    },
    getChangeFilter : (state) => {
        return state.filterInfo
    },
    getUserGridInfo : (state) => {
        return state.userGridInfo
    },
    getUsersAdditionalInfo : (state) => {
        return state.usersAdditionalInfo
    },
    getChangeMainTabRemote : (state) => {
        return state.changeMainTabRemote
    },
    getCheckedItems : (state) => {
        return state.checkedItems
    },
    getActiveMassAction : (state) => {
        return state.activeMassAction
    },
    getTotalItemsFound : (state) => {
        return state.totalItemsFound
    },
    getFilterData : (state) => {
        return state.filterData
    },
    getIsMassActionActive : (state) => {
        return state.isMassActionActive
    },
    getAdditionalInfoDetailedScreen : (state) => {
        return state.additionalInfoDetailedScreen
    },
    formatDate : (state) => {
        return (date) => {
            let finalDate =  moment(date).format('DD MMM YYYY hh:mm a');
            if (finalDate === 'Invalid date') {
                return '';
            }

            return finalDate;
        }
    },
    formatOnlyDate: (state) => {
        return (date) => {
            let finalDate = moment(date).format('DD MMM YYYY');
            if (finalDate === 'Invalid date') {
                return '';
            }

            return finalDate;
        }
    },
    formatTimeOnlyWithPartOfTheDay: (state) => {
        return (date) => {
            let finalDate = moment(date).format('hh:mm A');
            if (finalDate === 'Invalid date') {
                return '';
            }

            return finalDate;
        }
    },
    formatTimeOnly: (state) => {
        return (date) => {
            let finalDate = moment(date).format('HH:mm');
            if (finalDate === 'Invalid date') {
                return '';
            }

            return finalDate;
        }
    },
    formatDateForGraphs : (state) => {
        return (date) => {
            return moment(date).format('DD-MMM-YYYY');
        }
    },
    sortByColumn : (state) => {
        return (data, columnName, reverse) => {
            if (typeof reverse !== 'undefined') {
                return _.orderBy(data, columnName).reverse();
            }

            return _.orderBy(data, columnName);
        }
    },
    truncateText : (state) => {
        return (text, limit) => {
            if (text.length > limit) {
                text = text.substring(0, (limit - 3)) + '...';
            }

            return text;
        }
    },
    cleanText : (state) => {
        return (text, replaceTo) => {
            let replaceToSymbol = '';

            if (typeof replaceTo !== 'undefined') {
                replaceToSymbol = replaceTo;
            }

            text = text.replace(/(<([^>]+)>)/gi, replaceToSymbol);

            return text;
        }
    },
    countOnlySymbols : (state) => {
        return (text) => {
            let replaceToSymbol = text.replaceAll(/[.,?!;:\-—\[\]{}() ]/g, "").length;

            return replaceToSymbol;
        }
    },
    toCurrency : (state) => {
        return (value, decimals) => {
            let result = parseFloat(value),
                minDecimals = 2;

            if (typeof decimals !== 'undefined') {
                minDecimals = decimals;
            }

            if (isNaN(result)) {
                return '';
            }

            if (state.currencyInfo) {
                result = result.toLocaleString(state.currencyInfo.locale, { style: 'currency', currency: state.currencyInfo.currency, minimumFractionDigits: minDecimals, maximumFractionDigits: minDecimals });
            }

            return result;
        }
    },
    currencyOnly: (state) => {
       return (value) => {
          let result ='';

          result = (0).toLocaleString(state.currencyInfo.locale, { style: 'currency', currency:state.currencyInfo.currency, minimumFractionDigits: 0, maximumFractionDigits: 0 }).replace(/\d/g, '').trim()

          return result;
      }
    },
    unescapeValue: (state) => {
        return (value) => {
            return unescape(value);
        }
    }
};
export default {
    state,
    actions,
    getters,
    mutations
};
