import {mapGetters} from 'vuex';
import lodash from 'lodash';
import localeMapping from '../../../localizationLanguages';
import pagination from '../../pagination';
import { isProxy, toRaw } from 'vue';
export default {
    data () {
        return {
            loadedScreen: false,
            websiteUrl: $('#website_url').val(),
            perPageDataValues : {
                '10':10,
                '25':25,
                '50':50,
                '100':100
            },
            searchData:'',
            planId:0,
            localeMapping: localeMapping,
            locale: $('#dashboard-system-language').val()
        }
    },
    components: {
        pagination: pagination
    },
    computed: {
        ...mapGetters({
            formatDate: 'formatDate',
            formatOnlyDate: 'formatOnlyDate',
            formatTimeOnly: 'formatTimeOnly',
            configDataInfo:'getConfigDataInfo',
            additionalInfo:'getAdditionalInfo',
            sortByColumn: 'sortByColumn',
            truncateText: 'truncateText',
            changeFilter: 'getChangeFilter',
            unescapeValue:'unescapeValue',
            userGridInfoData: 'getUserGridInfo',
            checkedItems:'getCheckedItems',
            activeMassAction:'getActiveMassAction',
            massActionActive:'getIsMassActionActive',
            filterData:'getFilterData',
        })
    },
    watch: {
        changeFilter (newData, originalData) {
            this.$store.commit('setPaginationData',
            {
                userGrid: {
                    currentPage: 1,
                    itemsPerPage: 10,
                    totalItems: 0,
                    visiblePages: 4
                }
            });

            if (typeof newData.searchData !== 'undefined') {
                if (isProxy(newData.searchData)) {
                    let filterDataObject = {};
                    if (newData.searchData.byRoleId !== 'undefined') {
                        filterDataObject.byRoleId = toRaw(newData.searchData.byRoleId);
                    }
                    if (newData.searchData.byText !== 'undefined') {
                        filterDataObject.byText = toRaw(newData.searchData.byText);
                    }

                    this.searchData = filterDataObject;
                } else {
                    this.searchData = newData.searchData;
                }
            } else {
                this.searchData = '';
            }

            this.applyFilter();
        },
        activeMassAction  (newData, originalData) {
            if (newData == '0') {
                this.$store.commit('setIsMassActionActive', false);
            } else {
                this.$store.commit('setIsMassActionActive', true);
            }
        }

    },
    methods: {
        async applyFilter() {
            let filterData = this.filterData;
            if (typeof filterData.registrationStatus !== 'undefined') {
                this.searchData = filterData['searchData'];
            }
            const result = await this.$store.dispatch('getUsersGridData', {'router':this.$router, 'searchData':this.searchData});
            if(result.status === 'error') {
                showMessage('Please re-login', true, 3000);
            } else {
                this.loadedScreen = true;
            }
        },
        async goToUserDetailsScreen(id)
        {
            this.$router.push({ name: 'user', params: {'id': id}});
        },
        async loginAsUser(userId)
        {
            const result = await this.$store.dispatch('reLoginAsUser', {'router':this.$router, 'userId':userId});
            if (result.error == '1') {
                showMessage(result.message, true, 2000);
                this.formProcessing = false;
                return false;
            } else {
                showMessage(result.message, false, 2000);
                window.location.href = result.redirectUrl;
            }
        },
        async deleteUser(userId)
        {
            showConfirm(this.$t('message.areYouSureWantToDeleteUser'), async () => {
                const result = await this.$store.dispatch('deleteUser', {'router':this.$router, 'userId':userId});
                if (result.error == '1') {
                    showMessage(result.message, true, 2000);
                    this.formProcessing = false;
                    return false;
                } else {
                    showMessage(result.message, false, 2000);
                    this.applyFilter();
                }
            }, async () => {

            });
        },
        changeMassAction: function(e) {
            let activeMassAction = e.target.value;
            if (activeMassAction != 0 && Object.keys(this.checkedItems).length === 0) {
                showMessage(this.$t('message.missingCheckedItems'), true, 3000);
                this.$store.commit('setActiveMassAction', '0');
                e.target.value = '0';
            } else {
                this.$store.commit('setActiveMassAction', activeMassAction);
            }
        },
        addRemoveItem: function(e, itemKey) {
            if (e.target.checked) {
                this.addCheckedItem(itemKey);
            } else {
                this.removeCheckedItem(itemKey);
            }

            this.forceUpdate();
        },
        addCheckedItem: function(itemKey) {
            let currentItems = this.checkedItems;
            if (_.isNull(currentItems)) {
                currentItems = {};
            }
            currentItems[itemKey] = itemKey;
            this.$store.commit('setCheckedItems', currentItems);
            this.$store.commit('setAllCheckedItemsTracking', {'items': currentItems});
        },
        removeCheckedItem: function(itemKey){
            let currentItems = this.checkedItems;
            if (currentItems !== null && currentItems.hasOwnProperty(itemKey)) {
                delete currentItems[itemKey];
                this.$store.commit('setCheckedItems', currentItems);
                this.$store.commit('setAllCheckedItemsTracking', {'items': currentItems});
            }
        },
        isCheckedItem: function(itemKey){
            let currentItems = this.checkedItems;

            if (currentItems !== null && currentItems.hasOwnProperty(itemKey)) {
                return true;
            }
            return false;
        },
        checkRemoveAllItemsOnPage: function(e)
        {
            let currentCheckedItems = this.checkedItems,
                userGridInfoData = this.userGridInfoData;

            if (e.target.checked && userGridInfoData.length > 0) {
                userGridInfoData.forEach(function(userGridInfo) {
                    currentCheckedItems[userGridInfo.id] = userGridInfo.id;
                });

            } else {
                userGridInfoData.forEach(function(userGridInfo) {
                    delete currentCheckedItems[userGridInfo.id];
                });
            }

            this.$store.commit('setCheckedItems', currentCheckedItems);
            this.$store.commit('setAllCheckedItemsTracking', {'items': currentCheckedItems});
            this.forceUpdate();
        },
        isAllChecked() {
            let currentCheckedItems = this.checkedItems,
                userGridInfoData = this.userGridInfoData,
                allKeyExists = true;

            userGridInfoData.forEach(function(userGridInfo) {
                if (!currentCheckedItems.hasOwnProperty(userGridInfo.id)) {
                    allKeyExists = false;
                }
            });

            return allKeyExists;
        },
        forceUpdate() {
            // ...
            this.$forceUpdate();  // Notice we have to use a $ here
            // ...
        },

    },
    async created(){
        if (typeof this.localeMapping[this.locale] !== 'undefined') {
            this.$i18n.locale = this.localeMapping[this.locale];
        }

        this.applyFilter();
    },
    async updated() {
        this.$nextTick(function () {
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        })
    }
}
