import {mapGetters} from 'vuex';
import lodash from 'lodash';
import localeMapping from '../../../localizationLanguages';
import moment from 'moment';

import "tinymce/tinymce";
import 'tinymce/models/dom';
import 'tinymce/themes/silver';
import 'tinymce/icons/default';
import 'tinymce/skins/ui/oxide/skin.min.css';
import 'tinymce/skins/ui/oxide/content.min.css';
import 'tinymce/plugins/link';
import 'tinymce/plugins/autolink';
import 'tinymce/plugins/advlist';
import 'tinymce/plugins/image';
import 'tinymce/plugins/lists';
import 'tinymce/plugins/charmap';
import 'tinymce/plugins/preview';
import 'tinymce/plugins/fullscreen';
import 'tinymce/plugins/code';

import Editor from "@tinymce/tinymce-vue";

export default {
    data () {
        return {
            loadedScreen: false,
            websiteUrl: $('#website_url').val(),
            localeMapping: localeMapping,
            locale: $('#dashboard-system-language').val(),
            userPrefix:'',
            userFullName:'',
            userEmail:'',
            userRole:'',
            userPassword:'',
            userMobileCountryCode:'',
            userMobileNumber:'',
            userDesktopCountryCode:'',
            userDesktopNumber:'',
            userSubscribed:0,
            voipPhone:'',
            userTimezone:'',
            personalCalendarUrl:'',
            avatarLink:'',
            signature:'',
            formProcessing:false,
            allowedTabNames:[],
            userId:'',
            customUserAttribute:0,
            listOfCustomAttributes:[],
            userCustomAttributes:[],
            customParamsList:[],
            displayCustomFields: false,
            displayReportsBlock: true,
            preferableTime:2,
            reportCcEmail:'',
            enabledReports:0,
            reportsTypesList:[],
            reportsTypesOptions:[{
                'report_name':'tasks'
            }, {
                'report_name':'meetings'
            }, {
                'report_name':'notes'
            }],
            timezoneAbbr:'',
            mfaEnabled:0,
            enabledExcludeWeekends:0
        }
    },
    components: {
        'editor': Editor
    },
    computed: {
        ...mapGetters({
            formatDate: 'formatDate',
            formatOnlyDate: 'formatOnlyDate',
            formatTimeOnly: 'formatTimeOnly',
            truncateText: 'truncateText',
            additionalInfo:'getAdditionalInfoDetailedScreen',
            sortByColumn: 'sortByColumn',
            changeFilter: 'getChangeFilter',
            unescapeValue:'unescapeValue',
            toCurrency:'toCurrency',
            changeMainTabRemote:'getChangeMainTabRemote'
        }),
    },
    watch: {
        changeMainTabRemote(newData, originalData) {
            if (typeof newData.tabName !== 'undefined' && newData.tabName !== '') {
                this.changeTab(newData.tabName);
            }
        }
    },
    methods: {
        backToGrid() {
            this.$router.push({ name: 'grid'});
        },
        changeTab(activeTabName){
            this.activeTab = activeTabName;
            this.$router.push({ name: 'user', params: {'id': this.userId },  query: {tabName: activeTabName}});
        },
        getParams(pathParams) {
            let result = {},
                tmpData = [];

            pathParams
                .split("&")
                .forEach(function (item) {
                    tmpData = item.split("=");
                    if (tmpData[0] !== '') {
                        result[decodeURIComponent(tmpData[0])] = decodeURIComponent(tmpData[1]);
                    }
                });
            return result;
        },
        async loginAsUser()
        {
            const result = await this.$store.dispatch('reLoginAsUser', {'router':this.$router, 'userId':this.userId});
            if (result.error == '1') {
                showMessage(result.message, true, 2000);
                return false;
            } else {
                showMessage(result.message, false, 2000);
                window.location.href = result.redirectUrl;
            }
        },
        async deleteUser()
        {
            showConfirm(this.$t('message.areYouSureWantToDeleteUser'), async () => {
                const result = await this.$store.dispatch('deleteUser', {'router':this.$router, 'userId':this.userId});
                if (result.error == '1') {
                    showMessage(result.message, true, 2000);
                    return false;
                } else {
                    showMessage(result.message, false, 2000);
                    this.backToGrid();
                }
            }, async () => {

            });
        },
        async saveUserInfo()
        {
            if (this.formProcessing === true) {
                return false;
            }

            this.formProcessing = true;

            const result = await this.$store.dispatch('saveUserDetailedScreenInfo', {
                'userId': this.userId
            });

            if (result.error == '1') {
                showMessage(result.message, true, 2000);
                this.formProcessing = false;
                return false;
            } else {
                showMessage(result.message, false, 2000);
            }

            this.formProcessing = false;
        },
        async changeUserTimezone()
        {
            const result = await this.$store.dispatch('changeTimezone', {
                'timezone': this.userTimezone
            });

            if (result.error == '1') {
                showMessage(result.message, true, 2000);
                return false;
            } else {
                this.timezoneAbbr = result.responseText.timezoneAbbr;
            }
        },
        hideShowCustomParamsList()
        {
            if (this.displayCustomFields === true) {
                this.displayCustomFields = false;
            } else {
                this.displayCustomFields = true;
            }
        },
        changeMobileCountryCode()
        {
            if (typeof this.additionalInfo.mobileMasks[this.userMobileCountryCode] !== 'undefined') {
                $(document).find('#user-mobile-number').mask(this.additionalInfo.mobileMasks[this.userMobileCountryCode].mask_value, {autoclear: false});
            } else {
                $(document).find('#user-mobile-number').mask('(999) 999 9999', {autoclear: false});
            }
        },
        changeDesktopCountryCode()
        {
            if (typeof this.additionalInfo.desktopMasks[this.userDesktopCountryCode] !== 'undefined') {
                $(document).find('#user-desktop-number').mask(this.additionalInfo.desktopMasks[this.userDesktopCountryCode].mask_value, {autoclear: false});
            } else {
                $(document).find('#user-desktop-number').mask('(999) 999 9999', {autoclear: false});
            }
        },
        async updateUserAndInvite()
        {
            this.updateUser(1);
        },
        async updateUser(withInvite)
        {
            if (this.formProcessing === true) {
                return false;
            }

            this.formProcessing = true;

            let sendInvite = 0;
            if (withInvite === 1) {
                sendInvite = 1;
            }

            let desktopNumber = $(document).find('#user-desktop-number').val();
            this.userDesktopNumber = desktopNumber;
            let mobileNumber = $(document).find('#user-mobile-number').val();
            this.userMobileNumber = mobileNumber;

            if (this.userFullName === '') {
                showMessage(this.$t('message.pleaseSpecifyFullName'), true, 2000);
                this.formProcessing = false;
                return false;
            }

            if (this.userEmail === '') {
                showMessage(this.$t('message.pleaseSpecifyEmail'), true, 2000);
                this.formProcessing = false;
                return false;
            }

            if (this.userRole === '') {
                showMessage(this.$t('message.pleaseSpecifyRole'), true, 2000);
                this.formProcessing = false;
                return false;
            }

            if (this.enabledReports === 1 && Object.keys(this.reportsTypesList).length === 0) {
                showMessage(this.$t('message.pleaseSpecifyReportType'), true, 2000);
                this.formProcessing = false;
                return false;
            }

            let reportTypes = [];

            _.each(this.reportsTypesList, function(reportType){
                reportTypes.push(reportType.report_name);
            });

            const result = await this.$store.dispatch('updateUser', {
                'userId':this.userId,
                'fullName': this.userFullName,
                'userPrefix':this.userPrefix,
                'desktopNumber': this.userDesktopNumber,
                'userDesktopCountryCode': this.userDesktopCountryCode,
                'mobileNumber': this.userMobileNumber,
                'userMobileCountryCode': this.userMobileCountryCode,
                'email': this.userEmail,
                'sendInvite':sendInvite,
                'voipPhone':this.voipPhone,
                'userRole':this.userRole,
                'userPassword':this.userPassword,
                'userTimezone':this.userTimezone,
                'avatarLink':this.avatarLink,
                'signature':this.signature,
                'userSubscribed':this.userSubscribed,
                'personalCalendarUrl':this.personalCalendarUrl,
                'userCustomAttributes':this.userCustomAttributes,
                'listOfCustomAttributes':this.listOfCustomAttributes,
                'enabledReports': this.enabledReports,
                'preferableTime': this.preferableTime,
                'reportCcEmail': this.reportCcEmail,
                'reportTypes':reportTypes,
                'mfaEnabled':this.mfaEnabled,
                'enabledExcludeWeekends':this.enabledExcludeWeekends,
            });

            if (result.error == '1') {
                showMessage(result.message, true, 2000);
                this.formProcessing = false;
                return false;
            } else {
                showMessage(result.message, false, 2000);
                this.listOfCustomAttributes = [];
                this.customUserAttribute = 0;
                this.loadData();
            }

            this.formProcessing = false;
        },
        deleteCustomParam(customAttrIndex)
        {
            if (typeof this.userCustomAttributes[customAttrIndex] !== 'undefined') {
                this.userCustomAttributes.splice(customAttrIndex, 1);
            }
        },
        addCustomParam()
        {
            let name = '';

            if (parseInt(this.customUserAttribute) !== 0) {
                name = this.customUserAttribute;
            }

            this.listOfCustomAttributes.push({
                name: name,
                value: ''
            });
        },
        deleteTemporaryCustomParam(customAttrIndex)
        {
            if (typeof this.listOfCustomAttributes[customAttrIndex] !== 'undefined') {
                this.listOfCustomAttributes.splice(customAttrIndex, 1);
            }
        },
        async loadData()
        {
            const result = await this.$store.dispatch('getUserDataInfo', {
                'router': this.$router,
                'id': this.userId
            });

            if (typeof result.id === 'undefined') {
                this.$router.push({ name: 'grid'});
            } else {
                this.userPrefix = result.prefix;
                this.userFullName = result.full_name;
                this.userRole = result.role_id;
                this.userMobileCountryCode = result.mobile_country_code;
                this.userTimezone = result.timezone;
                this.userDesktopCountryCode = result.desktop_country_code;
                this.personalCalendarUrl = result.personal_calendar_url;
                this.voipPhone = result.voip_phone;
                this.avatarLink = result.avatar_link;
                this.signature = result.signature;
                this.userSubscribed = result.subscribed;
                this.userEmail = result.email;
                this.userCustomAttributes = result.userCustomAttributes;
                this.customParamsList = result.customParamsList;
                this.enabledReports = parseInt(result.receive_reports);
                this.enabledExcludeWeekends = parseInt(result.exclude_weekends);
                this.timezoneAbbr = result.timezoneAbbr;
                this.mfaEnabled = parseInt(result.enabled_mfa);
                if (result.receive_reports_preferable_time && parseInt(result.receive_reports_preferable_time) > 0) {
                    this.preferableTime = result.receive_reports_preferable_time;
                }

                this.reportCcEmail = result.receive_reports_cc_email;
                if (typeof result.receive_reports_types_list !== 'undefined' && result.receive_reports_types_list) {
                    let reportTypesList = [];
                    _.each(result.receive_reports_types_list.split(','), function(type) {
                        reportTypesList.push({
                            'report_name': type
                        })
                    });

                    this.reportsTypesList = reportTypesList;
                } else {
                    this.reportsTypesList = [];
                }


                if (!this.userMobileCountryCode) {
                    this.userMobileCountryCode = this.additionalInfo.userDefaultMobileCountryCode;
                }

                if (!this.userDesktopCountryCode) {
                    this.userDesktopCountryCode = this.additionalInfo.userDefaultMobileCountryCode;
                }

                this.loadedScreen = true;

                if (result.mobile_phone) {
                    $(document).find('#user-mobile-number').val(result.mobile_phone);
                }
                if (result.desktop_phone) {
                    $(document).find('#user-desktop-number').val(result.desktop_phone);
                }

                this.changeMobileCountryCode();
                this.changeDesktopCountryCode();
                this.displayCustomFields = false;

                if (typeof this.$route.query.tabName !== 'undefined' && this.allowedTabNames.includes(this.$route.query.tabName)) {
                    this.activeTab = this.$route.query.tabName;
                } else {
                    this.activeTab = this.defaultActiveTabName;
                }
            }
        }
    },
    async created(){
        if (typeof this.localeMapping[this.locale] !== 'undefined') {
            this.$i18n.locale = this.localeMapping[this.locale];
        }

        this.userId = this.$route.params.id;

        this.loadData();
    },
    async updated() {
        this.$nextTick(function () {
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        })
    },
    mounted() {
        let vm = this;
        window.onpopstate = function(event) {
            let pathParams = decodeURI(event.state.current);
            let additionalParams = '';
            const regex = /(\btabName=[\w]*)/i;
            if (pathParams.indexOf('?') > -1 && pathParams.match(regex) && pathParams.match(regex).length >= 1) {
                additionalParams = vm.getParams(pathParams.match(regex)[0].trim());
                if (typeof additionalParams.tabName !== 'undefined' &&  vm.allowedTabNames.includes(additionalParams.tabName)) {
                    vm.changeTab(additionalParams.tabName);
                }
            }
        }
    }


}
