import {mapGetters} from 'vuex';
import lodash from 'lodash';
import localeMapping from '../../../localizationLanguages';
import { isProxy, toRaw } from 'vue';
import "tinymce/tinymce";
import 'tinymce/models/dom';
import 'tinymce/themes/silver';
import 'tinymce/icons/default';
import 'tinymce/skins/ui/oxide/skin.min.css';
import 'tinymce/skins/ui/oxide/content.min.css';
import 'tinymce/plugins/fullscreen';
import 'tinymce/plugins/code';
import 'tinymce/plugins/link';
import leadshortcode from '../../../../../../tinymce-vue-plugins/leadshortcode/plugin';

import Editor from "@tinymce/tinymce-vue";
import moment from "moment";

export default {
    props: ['leadId'],
    data () {
        return {
            loadedScreen: true,
            websiteUrl: $('#website_url').val(),
            taskPreset:0,
            taskTitle:'',
            taskAssignToId:0,
            immediateFlag:false,
            allowCreateTaskFlag:false,
            taskStartDate: new Date(),
            taskStartDateTime:8,
            taskStartDateTimeMinutes: '00',
            taskDueDate:new Date(),
            taskDueDateTime:9,
            taskDueDateTimeMinutes:'00',
            timezoneAbbreviation:'',
            defaultTimezoneAbbreviation:'',
            timezoneFull:'',
            componentDatepickerKey:1,
            minDateFrom:new Date(),
            minDateTo:new Date(),
            sendImmediateNotification:0,
            taskNotes:'You have a task for this lead: {$lead:leadfullnamelink} from {$lead:organizationnamelink}.',
            defaultTaskNotes:'You have a task for this lead: {$lead:leadfullnamelink} from {$lead:organizationnamelink}.',
            locale: $('#dashboard-system-language').val(),
            localeMapping: localeMapping,
            maxDate:'',
            createTaskProcessing:false,
            immediateSwitcher:0
        }
    },
    components: {
        'editor': Editor
    },
    computed: {
        ...mapGetters({
            formatDate: 'formatDate',
            formatOnlyDate: 'formatOnlyDate',
            formatTimeOnly: 'formatTimeOnly',
            formatTimeOnlyWithPartOfTheDay: 'formatTimeOnlyWithPartOfTheDay',
            configDataInfo:'getAdditionalInfoDetailedScreen',
            sortByColumn: 'sortByColumn',
            truncateText: 'truncateText',
            toCurrency:'toCurrency',
            unescapeValue:'unescapeValue',
            additionalInfo:'getTaskAdditionalSubTabData',
            taskData: 'getTaskSubTabData',
            leadData:'getDetailedScreenLeadData',
            generalAdditionalInfo:'getAdditionalInfoDetailedScreen',
        })
    },
    methods: {
        async loadData() {

            const result = await this.$store.dispatch('getTaskTabData', {'router':this.$router});

            if (parseInt(result.error) === 1) {
                showMessage(result.message, true, 3000);
                return false;
            } else {
                this.timezoneAbbreviation = this.generalAdditionalInfo.leadOwnerTimezoneOffset;
                this.defaultTimezoneAbbreviation = this.generalAdditionalInfo.leadOwnerTimezoneOffset;
            }

            this.loadedScreen = true;
        },
        async changeImmediateSwitcher(event)
        {
            if (event.target.checked === true) {
                this.immediateFlag = true;
            } else {
                this.immediateFlag = false;
            }

            if (this.immediateFlag === true) {

                const result = await this.$store.dispatch('getCurrentDate', {'router':this.$router});

                if (parseInt(result.error) === 1) {
                    showMessage(result.message, true, 3000);
                    return false;
                } else {
                    if (!this.taskStartDate) {
                        this.taskStartDate = result.responseText.currentDate;
                    }

                    if (!this.taskDueDate) {
                        this.taskDueDate = result.responseText.currentDate;
                    }

                    this.taskDueDateTime = result.responseText.dateDue;
                }
            }

            this.checkMandatory();
        },
        changeTaskPreset()
        {
            if (typeof this.taskData.taskPresetsFull[this.taskPreset] !== 'undefined') {
                this.taskTitle = this.taskData.taskPresetsFull[this.taskPreset]['task_title'];
            } else {
                this.taskTitle = '';
            }

            this.checkMandatory();
        },
        changeDate(selectedDate, datepickerType){
            if (datepickerType === 'date-from') {
                this.minDateTo = selectedDate;
            } else {
                this.maxDate = selectedDate;
            }
            this.componentDatepickerKey += 1;
        },
        changeStartTime()
        {
            if (parseInt(this.taskStartDateTime) < 23) {
                this.taskDueDateTime = parseInt(this.taskStartDateTime) + 1;
            } else if (parseInt(this.taskStartDateTime) === 23) {
                this.taskDueDateTime = 23;
            }

            this.checkMandatory();
        },
        async changeAssignUser()
        {
            const result = await this.$store.dispatch('getUserTimezone', {'router':this.$router, 'userId':this.taskAssignToId});

            if (parseInt(result.error) === 1) {
                showMessage(result.message, true, 3000);
                return false;
            } else {
                this.timezoneAbbreviation = result.timezoneAbbreviation;
                this.timezoneFull = result.timezoneFull;
            }

            this.checkMandatory();
        },
        checkMandatory()
        {
            if ((this.taskTitle.trim() !== '' && this.taskStartDate !== '') || (this.taskTitle.trim() !== '' &&  this.immediateFlag === true)) {
                this.allowCreateTaskFlag = true;
            } else {
                this.allowCreateTaskFlag = false;
            }
        },
        copyPathInfo: function(e, path)
        {
            e.preventDefault();
            if (document.queryCommandSupported("copy")) {
                var copyFromEl = $('<textarea/>');
                copyFromEl.text(path);
                $('body').append(copyFromEl);
                copyFromEl.select();
                document.execCommand('copy', true);
                copyFromEl.remove();
                showMessage(this.$t('message.tasksSubHasBeenCopied'), false, 2000);
            }
        },
        async createTask()
        {

            if (this.createTaskProcessing === true) {
                return false;
            }

            this.createTaskProcessing = true;

            let immediate = 0;
            if (this.immediateFlag === true) {
                immediate = 1;
            }

            let expiredAt = moment(this.taskStartDate).format('YYYY-MM-DD');
            if (expiredAt !== 'Invalid date') {
                expiredAt = expiredAt +' '+this.taskStartDateTime+':'+this.taskStartDateTimeMinutes+':00';
            }

            let dueDate = moment(this.taskDueDate).format('YYYY-MM-DD');
            if (dueDate !== 'Invalid date') {
                dueDate = dueDate +' '+this.taskDueDateTime+':'+this.taskDueDateTimeMinutes+':00';
            }

            const result = await this.$store.dispatch('createLeadTask', {
                'router':this.$router,
                'leadId':this.leadId,
                'userId':this.taskAssignToId,
                'title':this.taskTitle,
                'timezoneFull':this.timezoneFull,
                'notes':this.taskNotes,
                'immediate':immediate,
                'immediateEmail':this.sendImmediateNotification,
                'expiredAt':expiredAt,
                'dueDate':dueDate,
            });

            if (parseInt(result.error) === 1) {
                showMessage(result.message, true, 5000);
                this.createTaskProcessing = false;
                return false;
            } else {
                showMessage(result.responseText, false, 5000);
                this.$store.commit('setTimelineLogChangeFilter', Date.now());
                this.resetTaskScreenData();
                this.createTaskProcessing = false;
            }
        },
        resetTaskScreenData()
        {
            this.taskPreset = 0;
            this.taskTitle = '';
            this.taskAssignToId = 0;
            this.immediateFlag = false;
            this.allowCreateTaskFlag = false;
            this.taskStartDate = new Date();
            this.taskStartDateTime = 8;
            this.taskStartDateTimeMinutes = '00';
            this.taskDueDate = new Date();
            this.taskDueDateTime = 9;
            this.taskDueDateTimeMinutes = '00';
            this.timezoneAbbreviation = this.defaultTimezoneAbbreviation;
            this.timezoneFull = '';
            this.componentDatepickerKey = 1;
            this.minDateFrom = new Date();
            this.minDateTo = new Date();
            this.sendImmediateNotification = 0;
            this.taskNotes = this.defaultTaskNotes;
            this.maxDate = '';
            this.immediateSwitcher = 0;
        }
    },
    async created(){
        if (typeof this.localeMapping[this.locale] !== 'undefined') {
            this.$i18n.locale = this.localeMapping[this.locale];
        }

        this.loadData();
    },
    async updated() {
        this.$nextTick(function () {
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        })
    }
}
