import {mapGetters} from 'vuex';
import lodash from 'lodash';
import localeMapping from '../../../localizationLanguages';
import pagination from '../../pagination';
import { isProxy, toRaw } from 'vue';
import plupload from "plupload";

import "tinymce/tinymce";
import 'tinymce/models/dom';
import 'tinymce/themes/silver';
import 'tinymce/icons/default';
import 'tinymce/skins/ui/oxide/skin.min.css';
import 'tinymce/skins/ui/oxide/content.min.css';
import 'tinymce/plugins/fullscreen';
import leadshortcode from '../../../../../../tinymce-vue-plugins/leadshortcode/plugin';
import leadtestsms from '../../../../../../tinymce-vue-plugins/leadtestsms/plugin';
import spellcheck from '../../../../../../tinymce-vue-plugins/spellcheck/plugin';
import charlimit from '../../../../../../tinymce-vue-plugins/charlimit/plugin';
import reviewrequestlinks from '../../../../../../tinymce-vue-plugins/reviewrequestlinks/plugin';

import Editor from "@tinymce/tinymce-vue";

export default {
    props: ['leadId'],
    data () {
        return {
            loadedScreen: true,
            locale: $('#dashboard-system-language').val(),
            localeMapping: localeMapping,
            websiteUrl: $('#website_url').val(),
            loadedScreenData:false,
            showMmsUploader:false,
            smsText:'',
            emailSequences:[],
            mobileCountryCode:'',
            leadMobile:'',
            smsProcessing:false,
            callDeviceType:'mobile',
            mmsPicturesUploader:'',
            uploadedSizeCount:0,
            uploadedFiles:[],
            uploadedFilesList:[],
            failedFilesUpload:[],
            maxUploadedFiles:0
        }
    },
    components: {
        'editor': Editor
    },
    computed: {
        ...mapGetters({
            formatDate: 'formatDate',
            formatOnlyDate: 'formatOnlyDate',
            formatTimeOnly: 'formatTimeOnly',
            formatTimeOnlyWithPartOfTheDay: 'formatTimeOnlyWithPartOfTheDay',
            configDataInfo:'getAdditionalInfoDetailedScreen',
            sortByColumn: 'sortByColumn',
            truncateText: 'truncateText',
            toCurrency:'toCurrency',
            unescapeValue:'unescapeValue',
            additionalInfo:'getSmsAdditionalSubTabData',
            smsData: 'getSmsSubTabData',
            leadData:'getDetailedScreenLeadData',
            generalAdditionalInfo:'getAdditionalInfoDetailedScreen',
        })
    },
    methods: {
        async loadData() {

            this.mobileCountryCode = toRaw(this.leadData.lead_mobile_country_code);
            this.leadMobile = toRaw(this.leadData.lead_mobile);

            const result = await this.$store.dispatch('getSmsTabData', {'router':this.$router, 'leadId': this.leadId});

            if (parseInt(result.error) === 1) {
                showMessage(result.message, true, 3000);
                return false;
            } else {

            }

            this.loadedScreenData = true;
        },
        initUploadPhotos() {
            let allowedUploadData = {
                'fileSize':5,
                'fileUploads':1
            };

            let options = {
                runtimes: 'html5,flash,html4',
                browse_button: 'upload-mms-button',
                container: 'uploader-mms-images-block',
                rename         : true,
                max_file_size  : allowedUploadData.fileSize+'mb',
                max_file_count : allowedUploadData.fileUploads,
                url: this.websiteUrl+'api/leads/leadmms/',
                multi_selection: false,
                unique_names: false,
                multipart_params: {
                    'secureToken':document.getElementById('leads-screen-config-token').value,
                    'leadId':this.leadId,
                }
            };

            if (this.mmsPicturesUploader === '') {

                this.mmsPicturesUploader = new plupload.Uploader(options);

                this.mmsPicturesUploader.init();

                this.mmsPicturesUploader.bind('BeforeUpload', _.bind(this.beforePhotoUpload, this));
                this.mmsPicturesUploader.bind('FilesAdded', _.bind(this.filesPhotoAdded, this));
                this.mmsPicturesUploader.bind('UploadProgress', _.bind(this.uploadPhotoProgress, this));
                this.mmsPicturesUploader.bind('FileUploaded', _.bind(this.filePhotoUploaded, this));
                this.mmsPicturesUploader.bind('Error', _.bind(this.handleUploadErrorsPhoto, this));
                this.mmsPicturesUploader.bind('UploadComplete', _.bind(this.uploadCompletePhoto, this));
            }
        },
        beforePhotoUpload: function(up, file) {
            if (this.maxUploadedFiles >= 10) {
                let extraFile = up.getFile(file.id);
                up.removeFile(extraFile);
                up.stop();
                showMessage(this.$t('message.smsSubMessagesLimit'), true, 500);
                return false;
            }
        },
        uploadPhotoProgress: function(up, file) {

        },
        uploadCompletePhoto: function(up, files, response) {
            if (this.maxUploadedFiles  < 10) {
                $('#progressbar-uploader-photo-documents-file').delay(800).fadeOut();
                $('#progressbar-uploader-photo-documents-text').delay(800).fadeOut();
                let msg = '';
                if (this.failedFilesUploadAdditional.length) {
                    let msg = 'Photos uploaded';
                    if (this.failedFilesUpload.length) {
                        _.each(this.failedFilesUpload, function (fileName, key) {
                            msg += fileName;
                        });
                    }
                    msg += '</ul>';
                    showMessage(msg, true, 3000);
                } else {
                    if (this.failedFilesUpload.length) {
                        if (up.files.length === this.failedFilesUpload.length) {
                            if (up.files.length > 1) {
                                let msg = this.$t('message.smsSubFilesNotUploaded') + '</br>';
                            } else {
                                let msg = this.$t('message.smsSubFilesNotUploaded') + '</br>';
                            }

                            msg += '<ul>';
                            _.each(this.failedFilesUpload, function (fileName, key) {
                                msg += fileName;
                            });
                            msg += '</ul>';

                            showMessage(msg, true, 3000);
                        } else if (up.files.length > this.failedFilesUpload.length) {
                            let msg = 'Photos uploaded';
                            msg += ' </br>' + 'Except:' + '</br>';
                            msg += '<ul>';
                            _.each(this.failedFilesUpload, function (fileName, key) {
                                msg += fileName;
                            });
                            msg += '</ul>';
                            showMessage(msg, true, 3000);
                        }
                    } else {

                    }
                }

                if (!this.failedFilesUpload.length && !this.failedFilesUploadAdditional.length) {
                    showMessage(this.$t('message.smsSubFilesUploaded'), false, 3000);
                }

                this.failedFilesUploadAdditional = {};
                this.mmsPicturesUploader.splice();
            }
        },
        filesPhotoAdded (up, files) {
            let failedFilesUploadAdditionalFiltered = [];

            this.failedFilesUploadAdditional = {};

            if (files.length) {
                _.each(this.failedFilesUploadAdditional, function (fileName, key) {
                    _.each(files, function (fileN, k) {
                        if (parseInt(fileN.id) === parseInt(key)) {
                            failedFilesUploadAdditionalFiltered.push(fileName);
                        }
                    });

                });

                if (failedFilesUploadAdditionalFiltered.length) {
                    this.failedFilesUploadAdditional = failedFilesUploadAdditionalFiltered;
                } else {
                    this.failedFilesUploadAdditional = {};
                }
            }

            this.mmsPicturesUploader.settings.multipart_params.multipleFiles = 0;
            if (files.length > 1) {
                this.mmsPicturesUploader.settings.multipart_params.multipleFiles = 1;
            }

            this.mmsPicturesUploader.settings.multipart_params.generalFileSize = this.uploadedSizeCount;
            this.mmsPicturesUploader.settings.multipart_params.secureToken = document.getElementById('leads-screen-config-token').value;
            this.failedFilesUpload = [];
            this.mmsPicturesUploader.start();
        },
        filePhotoUploaded: function (up, file, info) {
            if (this.maxUploadedFiles < 10) {
                let response = JSON.parse(info.response);
                if (parseInt(response.error) === 0) {
                    this.uploadedSizeCount = parseFloat(response.generalFileSize.toFixed(2));

                    this.uploadedFiles.push(response.fileStoredName);
                    this.uploadedFilesList.push({
                        'name': file.name,
                        'fileStoredName': response.fileStoredName,
                        'size': file.size
                    });
                    this.maxUploadedFiles += 1;
                } else {
                    let errorMessage = '';
                    if (typeof response.fileName !== 'undefined' && response.fileName != '') {
                        if (typeof (response.message) === 'object') {
                            for (var i in response.message) {
                                errorMessage += '<li>' + response.message[i] + '</li>';
                            }
                        } else {
                            errorMessage += '<li> ' + 'File' + ' \'' + response.fileName + '\' (' + response.message + ')' + '</li>';
                        }
                    }

                    if (typeof response.fileName !== 'undefined' && response.type === 'mmsMaxSize') {
                        if (errorMessage !== '') {
                            errorMessage + '</br>' + response.message;
                        } else {
                            errorMessage = response.message;
                        }
                    }

                    this.failedFilesUpload.push(errorMessage);
                }
            }
        },
        handleUploadErrorsPhoto: function(up, err) {
            this.failedFilesUploadAdditional = {};

            let errorMessage = '';

            if (err.code === -600) {
                errorMessage = '<li> ' + 'The file ' + ' \'\"' + (err.file ? err.file.name : "") + '\" size exceeds the limit allowed and cannot be uploaded' + '</li>';
            } else {
                errorMessage = '<li> ' + 'File' + ' \'' + (err.file ? err.file.name : "") + '\' (' + err.message + ')' + '</li>';
            }

            this.failedFilesUploadAdditional[err.file.id] = errorMessage;
            showMessage(errorMessage, true, 3000);
        },
        async sendTestSms()
        {
            this.sendSms(1);
        },
        async sendSms(testSmsFlag){
            if (this.smsProcessing === true) {
                return false;
            }

            this.smsProcessing = true;

            let emailSequenceId = 0,
                isTestSms = testSmsFlag || 0,
                mediaFiles = '';

            if (typeof this.emailSequences.id !== 'undefined') {
                emailSequenceId = this.emailSequences.id;
            }

            if (this.showMmsUploader === true) {
                mediaFiles = this.uploadedFiles.join(',');
            }

            const result = await this.$store.dispatch('sendSmsFromEmailTab', {
                'router':this.$router,
                'leadId': this.leadId,
                'testSms': isTestSms,
                'callDeviceType': this.callDeviceType,
                'leadCallCountryCode': this.mobileCountryCode,
                'leadCallNumber': this.leadMobile,
                'leadSmsFollowUpSequences': emailSequenceId,
                'smsContent': this.smsText,
                'mediaFiles':mediaFiles
            });

            if (parseInt(result.error) === 1) {
                showMessage(result.message, true, 3000);
                this.smsProcessing = false;
                return false;
            } else {
                showMessage(result.responseText, false, 3000);
                if (!isTestSms) {
                    this.resetSmsForm();
                    await this.loadData();
                }
                this.smsProcessing = false;
            }
        },
        processPhoneMobileCountryCodesSelectors()
        {
            if (typeof this.generalAdditionalInfo.mobileMasks[this.mobileCountryCode] !== 'undefined') {
                $(document).find('#lead-call-number').mask(this.generalAdditionalInfo.mobileMasks[this.mobileCountryCode].mask_value, {autoclear: false});
            } else {
                $(document).find('#lead-call-number').mask('(999) 999 9999', {autoclear: false});
            }
        },
        resetSmsForm()
        {
            this.emailSequences = [];
            this.callDeviceType = 'mobile';
            this.showMmsUploader = false;
            this.smsText = '';
            this.uploadedSizeCount = 0;
            this.uploadedFiles = [];
            this.uploadedFilesList = [];
            this.failedFilesUpload = [];
            this.maxUploadedFiles = 0;
            this.mmsPicturesUploader = '';
            $(document).find('#lead-sms-tab-textarea-limit-symbols').text(1600).data('data-maxlength', 1600);
        },
        changeCallDevice()
        {
            if (this.callDeviceType === 'mobile') {
                this.leadMobile = toRaw(this.leadData.lead_mobile);
                this.mobileCountryCode = toRaw(this.leadData.lead_mobile_country_code);
            }

            if (this.callDeviceType === 'organization-mobile') {
                this.leadMobile = toRaw(this.leadData.organization_mobile);
                this.mobileCountryCode = toRaw(this.leadData.organization_mobile_country_code);
            }
        },
        changeMobileNumber(event)
        {
            this.leadMobile = event.target.value;
        },
        switchMmsUploader(event)
        {
            if (event.target.checked) {
                let self = this;
                this.showMmsUploader = true;
                setTimeout(() => self.initUploadPhotos(),  300);
            } else {
                this.mmsPicturesUploader = '';
                this.showMmsUploader = false;
            }
        },
        async deleteTemporaryMmsImg(index, fileName, fileSize)
        {
            let self= this;

            showConfirm(this.$t('message.smsSubAreYouSureYouWantToDeleteFile'), async () => {
                const result = await this.$store.dispatch('deleteSmsFile', {
                    'router': this.$router,
                    'leadId': this.leadId,
                    'fileName': fileName,
                    'fileSize': fileSize,
                    'generalFileSize': this.uploadedSizeCount,
                });

                if (result.error === 1) {
                    showMessage(result.message, true, 5000);
                    return false;
                } else {
                    self.uploadedFiles.splice(index, 1);
                    self.uploadedFilesList.splice(index, 1);
                    self.maxUploadedFiles -= 1;
                    this.uploadedSizeCount = parseFloat(result.generalFileSize.toFixed(2));
                    showMessage(result.message, false, 2000);
                }
            }, async () => {
                return false;
            });
        }
    },
    async created(){
        if (typeof this.localeMapping[this.locale] !== 'undefined') {
            this.$i18n.locale = this.localeMapping[this.locale];
        }

        this.loadData();
    },
    async updated() {
        this.$nextTick(function () {
            this.processPhoneMobileCountryCodesSelectors();

            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        })
    }
}
