import {mapGetters} from 'vuex';
import lodash from 'lodash';
import localeMapping from '../../../localizationLanguages';
import { isProxy, toRaw } from 'vue';
import moment from "moment";

export default {
    props: ['leadId'],
    data () {
        return {
            loadedScreen: true,
            locale: $('#dashboard-system-language').val(),
            localeMapping: localeMapping,
            websiteUrl: $('#website_url').val(),
            loadedScreenData:false,
            componentDatepickerKey:0,
            opportunityFrom:new Date(),
            opportunityTo:new Date(new Date().setMonth( new Date().getMonth()+ 1)),
            minDateFrom:'',
            minDateTo:new Date(),
            leadOpportunityName:'',
            leadOpportunityValue:'',
            opportunityCreateOption:'no_quote',
            oldNewOpportunitySwitcher:'new',
            existingOpportunityId:0,
            quoteTemplatesSearchResults:[],
            searchable:true,
            options: [],
            duplicateQuoteId: '',
            opportunityType: '0',
            opportunityStage: '1',
            processingNewOpportunity:false,
            createQuoteBlock:false,
            opportunityNameError:false,
            opportunityValueError:false,
            quoteLabel:'',
            quoteLabelError:false,
            processingQuoteForm:false,
            quoteOpportunityId:'',
            defaultStage: 1
        }
    },
    components: {

    },
    computed: {
        ...mapGetters({
            formatDate: 'formatDate',
            formatOnlyDate: 'formatOnlyDate',
            formatTimeOnly: 'formatTimeOnly',
            formatTimeOnlyWithPartOfTheDay: 'formatTimeOnlyWithPartOfTheDay',
            configDataInfo:'getAdditionalInfoDetailedScreen',
            sortByColumn: 'sortByColumn',
            truncateText: 'truncateText',
            toCurrency:'toCurrency',
            unescapeValue:'unescapeValue',
            additionalInfo:'getOpportunityAdditionalSubTabData',
            opportunityData: 'getOpportunitySubTabData',
            leadData:'getDetailedScreenLeadData',
            generalAdditionalInfo:'getAdditionalInfoDetailedScreen',
            preChosenOpportunityId:'getPreChosenOpportunityId',
        })
    },
    methods: {
        async loadData() {

            const result = await this.$store.dispatch('getOpportunitySubTabData',
                {
                    'router':this.$router,
                    'leadId':this.leadId,
                    'excludeEmptyOpportunityStages':true,
                });

            if (parseInt(result.error) === 1) {
                showMessage(result.message, true, 3000);
                return false;
            } else {
                if (this.preChosenOpportunityId !== 0) {
                    this.existingOpportunityId = this.preChosenOpportunityId;
                    this.oldNewOpportunitySwitcher = 'old';
                    this.$store.commit('setPreChosenOpportunityId', 0);
                    this.changeExistingOpportunity();
                } else if (typeof result.defaultStage !== 'undefined' && Object.keys(result.defaultStage).length > 0){
                    this.opportunityStage = result.defaultStage[0]['id'];
                }

                this.loadedScreenData = true;
            }
        },
        changeExistingOpportunity()
        {
            if (parseInt(this.existingOpportunityId) !== 0) {
                for (let i = 0; i < this.opportunityData.data.length; i++) {
                    let obj = this.opportunityData.data[i];

                    if (parseInt(obj.id) === parseInt(this.existingOpportunityId)) {
                        this.minDateFrom = '';
                        this.minDateTo = obj.created_at;
                        this.opportunityFrom = obj.created_at;
                        this.opportunityTo = obj.expected_close_date;
                        this.leadOpportunityName = this.unescapeValue(obj.opportunity_name);
                        this.leadOpportunityValue = parseInt(obj.opportunity_value);
                        this.opportunityType = obj.opportunity_type_id;
                        this.opportunityStage = obj.opportunity_stage_id;
                    }
                }
            } else {
                this.leadOpportunityName = '';
                this.leadOpportunityValue = '';
                this.opportunityType = '0';
                this.opportunityStage = '1';
                this.opportunityFrom = new Date();
                this.opportunityTo = new Date(new Date().setMonth( new Date().getMonth()+ 1));
            }
        },
        getOpportunityStageLabel(opportunityStageId)
        {
            let opportunityStageLabel = '';

            if (parseInt(opportunityStageId) === 1 || parseInt(opportunityStageId) === 100) {
                if (parseInt(opportunityStageId) === 1) {
                    opportunityStageLabel = this.$t('message.opportunitySubLost');
                }

                if (parseInt(opportunityStageId) === 100) {
                    opportunityStageLabel = this.$t('message.opportunitySubWon');
                }
            } else {
                opportunityStageLabel = this.opportunityData.opportunityStages[opportunityStageId] +' '+opportunityStageId+'%';
            }

            return opportunityStageLabel;
        },
        changeDate(selectedDate, datepickerType)
        {
            if (datepickerType === 'date-to-from') {
                this.minDateTo = selectedDate;
                if (selectedDate && this.opportunityTo === '') {
                    this.opportunityTo = selectedDate;
                }

                if (selectedDate && this.opportunityTo !== ''){
                    let createdAtDate = moment(selectedDate).startOf('day').format('YYYY-MM-DD');
                    let endDate = moment(this.opportunityTo).endOf('day').format('YYYY-MM-DD');
                    if (endDate !== '' && createdAtDate !== '') {
                        if(createdAtDate > endDate) {
                            this.opportunityTo = selectedDate;
                        }
                    }
                }
            } else {
                if (selectedDate && this.opportunityFrom === '') {
                    this.opportunityFrom = selectedDate;
                }
                this.minDateFrom = selectedDate;
            }
            this.componentDatepickerKey += 1;
        },
        allowOnlyDigits(event)
        {
            let value = event.target.value;
            let validNumber = parseInt(value);

            if (isNaN(validNumber) && value !== ''){
                this.leadOpportunityValue = '';
                showMessage(this.$t('message.opportunitySubYouCanUseOnly'), true);
                return false;
            } else if(!isNaN(validNumber)) {
                this.leadOpportunityValue = validNumber;
            } else{
                this.leadOpportunityValue = '';
            }

            if (this.leadOpportunityValue !== '') {
                this.opportunityValueError = false;
            }
        },
        leadOpportunityNameChange()
        {
            if (this.leadOpportunityName !== '') {
                this.opportunityNameError = false;
            }
        },
        quoteTitleChange()
        {
            if (this.quoteLabel !== '') {
                this.quoteLabelError = false;
            }
        },
        async getQuoteTemplateOptions(query)
        {
            if (!query) {
                return false;
            }

            const result = await this.$store.dispatch('getQuoteTemplates', {'router':this.$router, 'searchTerm':query});
            if (result.error == '1') {
                this.options = [];
                return false;
            }

            this.options = result;
        },
        changeTemplate(event)
        {
            if (typeof event[0] !== 'undefined') {
                this.duplicateQuoteId = event[0].id;
            }
        },
        removeDuplicatedTemplateId()
        {
            this.duplicateQuoteId = '';
        },
        resetOpportunityForm()
        {
            this.leadOpportunityName = '';
            this.leadOpportunityValue = '';
            this.opportunityType = '0';
            this.opportunityStage = '1';
            this.opportunityFrom = new Date();
            this.existingOpportunityId = 0;
            this.opportunityTo = new Date(new Date().setMonth( new Date().getMonth()+ 1));
            this.opportunityCreateOption = 'no_quote';
            this.oldNewOpportunitySwitcher = 'new';
            this.quoteLabel = '';
            this.createQuoteBlock = false;
            this.quoteOpportunityId = '';
            this.processingNewOpportunity = false;
            this.processingQuoteForm = false;
            this.duplicateQuoteId = '';
            this.quoteTemplatesSearchResults = [];
        },
        async createQuote()
        {

            if (this.processingQuoteForm === true) {
                return false;
            }

            this.processingQuoteForm = true;

            let errorMessage = '',
                isValid = true;

            if (!this.quoteLabel) {
                errorMessage += this.$t('message.opportunitySubPleaseSpecifyQuoteTitle')+ '<br/>';
                this.quoteLabelError = true;
                isValid = false;
            }

            if (isValid === false){
                showMessage(errorMessage, true);
                this.processingQuoteForm = false;
                return false;
            }

            const result = await this.$store.dispatch('createQuoteForOpportunity',
                {
                    'router': this.$router,
                    'leadId': this.leadId,
                    'opportunityId': this.quoteOpportunityId,
                    'quoteTitle': this.quoteLabel,
                    'duplicateQuoteId': this.duplicateQuoteId,
                });


            if (parseInt(result.error) === 1) {
                if (typeof result.responseText !== 'undefined' && typeof result.responseText.message !== 'undefined') {
                    showMessage(result.responseText.message, true, 5000);
                    this.processingQuoteForm = false;
                    return false;
                } else {
                    showMessage(result.message, true, 5000);
                    this.processingQuoteForm = false;
                    return false;
                }
            } else {
                showMessage(result.responseText.message, false, 5000);
                this.processingQuoteForm = false;
                this.resetOpportunityForm();
                this.loadData();
                this.$store.commit('setOpportunitiesLogChangeFilter', Date.now());
            }

        },
        async createNewOpportunity() {

            if (this.processingNewOpportunity === true) {
                return false;
            }

            this.processingNewOpportunity = true;

            let errorMessage = '',
                isValid = true;

            if (!this.leadOpportunityName) {
                errorMessage += this.$t('message.opportunitySubPleaseSpecifyOpportunityName') + '<br/>';
                this.opportunityNameError = true;
                isValid = false;
            }

            if (!this.leadOpportunityValue) {
                errorMessage += this.$t('message.opportunitySubPleaseSpecifyOpportunityValue') + '<br/>';
                this.opportunityValueError = true;
                isValid = false;
            }

            if (!this.opportunityTo) {
                errorMessage += this.$t('message.opportunitySubPleaseSpecifyExpectedClosedDate') + '<br/>';
                isValid = false;
            }

            if (this.opportunityCreateOption === 'create_quote_duplicate' && this.duplicateQuoteId === '') {
                showMessage(this.$t('message.opportunitySubOriginalQuoteNotFound'), true);
                this.processingNewOpportunity = false;
                return false;
            }

            if (isValid === false) {
                showMessage(errorMessage, true);
                this.processingNewOpportunity = false;
                return false;
            }

            if (this.oldNewOpportunitySwitcher === 'old' && this.existingOpportunityId === 0) {
                showMessage(this.$t('message.opportunitySubPleaseSelectOpportunityFrom'), true, 5000);
                this.processingNewOpportunity = false;
                return false;
            }

            let opportunityStartDate = moment(this.opportunityFrom).format('YYYY-MM-DD'),
                createdAt = '';

            if (opportunityStartDate !== 'Invalid date') {
                createdAt = opportunityStartDate;
            }

            let opportunityEndDate = moment(this.opportunityTo).format('YYYY-MM-DD'),
                expectedCloseDate = '';

            if (opportunityEndDate !== 'Invalid date') {
                expectedCloseDate = opportunityEndDate;
            }

            let result = '';

            if (this.existingOpportunityId === 0) {
                result = await this.$store.dispatch('createNewOpportunity',
                    {
                        'router': this.$router,
                        'leadId': this.leadId,
                        'opportunityStageId': this.opportunityStage,
                        'opportunityValue': this.leadOpportunityValue,
                        'createdAt': createdAt,
                        'expectedCloseDate': expectedCloseDate,
                        'opportunityName': this.leadOpportunityName,
                        'opportunityTypeId': this.opportunityType,
                        'duplicateQuoteId': this.duplicateQuoteId
                    });
            } else {
                result = await this.$store.dispatch('updateOpportunity',
                    {
                        'router': this.$router,
                        'leadId': this.leadId,
                        'opportunityStageId': this.opportunityStage,
                        'opportunityValue': this.leadOpportunityValue,
                        'createdAt': createdAt,
                        'expectedCloseDate': expectedCloseDate,
                        'opportunityName': this.leadOpportunityName,
                        'opportunityTypeId': this.opportunityType,
                        'duplicateQuoteId': this.duplicateQuoteId,
                        'opportunityId': this.existingOpportunityId,
                    });
            }

            if (parseInt(result.error) === 1) {
                if (typeof result.responseText !== 'undefined' && typeof result.responseText.missingParams !== 'undefined') {
                    let errMessage = this.$t('message.opportunitySubMissingMandatoryParams') + ':';

                    for (const [key, value] of Object.entries(result.responseText.missingParams)) {
                        errMessage += '<p> ' + value + '</p>';
                    }

                    showMessage(errMessage, true, 5000);
                } else {
                    showMessage(result.message, true, 5000);
                }

                this.processingNewOpportunity = false;
                return false;
            } else {
                showMessage(result.responseText.message, false, 5000);
                if (this.opportunityCreateOption === 'create_new_quote' || this.opportunityCreateOption === 'create_quote_duplicate') {
                    this.createQuoteBlock = true;
                    this.quoteOpportunityId = result.responseText.opportunityId;
                } else {
                    this.processingNewOpportunity = false;
                    this.resetOpportunityForm();
                    this.loadData();
                }

                this.$store.commit('setOpportunitiesLogChangeFilter', Date.now());
            }
        }
    },
    async created(){
        if (typeof this.localeMapping[this.locale] !== 'undefined') {
            this.$i18n.locale = this.localeMapping[this.locale];
        }

        this.loadData();
    },
    async updated() {
        this.$nextTick(function () {
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        })
    }
}
