import {mapGetters} from 'vuex';
import localeMapping from '../../../localizationLanguages';
import pagination from '../../pagination';
import { isProxy, toRaw } from 'vue';
import Swiper from 'swiper';
import { Navigation, Pagination } from 'swiper/modules';
import 'swiper/css';
import 'swiper/css/navigation';
import 'swiper/css/pagination';
export default {
    props: ['leadId'],
    data () {
        return {
            loadedScreen: true,
            localeMapping: localeMapping,
            locale: $('#dashboard-system-language').val(),
            websiteUrl: $('#website_url').val(),
            newNoteText:'',
            noteFormProcessing:false,
            swiperObject:{},
        }
    },
    components: {
        pagination: pagination
    },
    computed: {
        ...mapGetters({
            formatDate: 'formatDate',
            formatOnlyDate: 'formatOnlyDate',
            formatTimeOnly: 'formatTimeOnly',
            formatTimeOnlyWithPartOfTheDay: 'formatTimeOnlyWithPartOfTheDay',
            configDataInfo:'getAdditionalInfoDetailedScreen',
            sortByColumn: 'sortByColumn',
            truncateText: 'truncateText',
            toCurrency:'toCurrency',
            unescapeValue:'unescapeValue',
            additionalInfo:'getNotesAdditionalSubTabData',
            notesData: 'getNotesSubTabData',
            leadData:'getDetailedScreenLeadData',
        })
    },
    methods: {
        async loadData() {

            const result = await this.$store.dispatch('getLeadNotes', {'router':this.$router, 'leadId':this.leadId});

            if (parseInt(result.error) === 1) {
                showMessage(result.message, true, 3000);
                return false;
            } else {

            }

            this.loadedScreen = true;

            this.initSwipper()
        },
        async updateNotes(event, elementName)
        {
            let newValue = event.target.value,
                data = toRaw(this.leadData),
                oldValue = data[elementName];

            if (oldValue === newValue || (oldValue === null && newValue === '')) {
                return false;
            }

            data[elementName] = newValue;

            const result = await this.$store.dispatch('updateParam', {'router':this.$router, 'id':this.leadId, 'data':data});

            if (parseInt(result.error) === 1) {
                showMessage(result.message, true, 3000);
                return false;
            } else {
                this.leadData[elementName] = newValue;
                data =  Object.assign({}, this.leadData);
                this.$store.commit('setDetailedScreenLeadData', data);
                showMessage(result.responseText.message, false, 2000);
            }
        },
        async addNote()
        {

            if (this.noteFormProcessing === true) {
                return false;
            }

            this.noteFormProcessing = true;

            if (!this.newNoteText) {
                showMessage(this.$t('message.notesSubNoteTextIsMissing'),true, 2000);
                this.noteFormProcessing = false;
                return false;
            }

            const result = await this.$store.dispatch('addNote', {'router':this.$router, 'leadId':this.leadId, 'note':this.newNoteText});

            if (parseInt(result.error) === 1) {
                showMessage(result.message, true, 3000);
                this.noteFormProcessing = false;
                return false;
            } else {
                this.notesData.push(result.responseText.model);
                this.newNoteText = '';
                setTimeout(() =>  this.initSwipper(),  200);
                showMessage(result.responseText.message, false, 2000);
                this.noteFormProcessing = false;
            }
        },
        async deleteNote(noteId, indexId)
        {
            showConfirm(this.$t('message.areYouSureYouWantToDelete'), async () => {
                const result = await this.$store.dispatch('deleteNote', {
                    'router': this.$router, 'id':noteId
                });

                this.notesData.splice(indexId, 1);
                this.initSwipper();

             }, async () => {
                return false;
            });
        },
        initSwipper(){
            if (Object.keys(this.swiperObject).length > 0) {
                this.swiperObject.destroy();
            }

            if (Object.keys(this.notesData).length === 0) {
                return false;
            }

            const swiper = new Swiper('.swiper-container', {
                modules: [Navigation, Pagination],
                slidesPerView: 2,
                spaceBetween: 10,
                pagination: {
                    el: '.swiper-pagination',
                    clickable: true
                },
                navigation: {
                    nextEl: ".swiper-button-next",
                    prevEl: ".swiper-button-prev",
                }
            });

            this.swiperObject = swiper;
        }
    },
    async created(){
        if (typeof this.localeMapping[this.locale] !== 'undefined') {
            this.$i18n.locale = this.localeMapping[this.locale];
        }

        this.loadData();
    },
    async updated() {
        this.$nextTick(function () {
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        })
    }
}
