import {mapGetters} from 'vuex';
import lodash from 'lodash';
import localeMapping from '../../../localizationLanguages';
import { isProxy, toRaw } from 'vue';

import "tinymce/tinymce";
import 'tinymce/models/dom';
import 'tinymce/themes/silver';
import 'tinymce/icons/default';
import 'tinymce/skins/ui/oxide/skin.min.css';
import 'tinymce/skins/ui/oxide/content.min.css';
import 'tinymce/plugins/fullscreen';
import 'tinymce/plugins/code';
import 'tinymce/plugins/link';
import leadshortcode from '../../../../../../tinymce-vue-plugins/leadshortcode/plugin';
import spellcheck from '../../../../../../tinymce-vue-plugins/spellcheck/plugin';

import Editor from "@tinymce/tinymce-vue";
import moment from "moment";

export default {
    props: ['leadId'],
    data () {
        return {
            loadedScreen: true,
            websiteUrl: $('#website_url').val(),
            locale: $('#dashboard-system-language').val(),
            localeMapping: localeMapping,
            timezoneAbbreviation:'',
            meetingType:'new',
            showStatusBlock:false,
            minDateFromNew:new Date(),
            minDateToNew:new Date(),
            maxDateNew:'',
            meetingNewStartDate:'',
            meetingNewDueDate:'',
            componentDatepickerKeyNew:0,
            allDayNewMeetingFlag:0,
            leadMeetingStartTimeNew:8,
            leadMeetingStartTimeMinutesNew:'00',
            leadMeetingEndTimeNew:8,
            leadMeetingEndTimeMinutesNew:'00',
            leadMeetingFirstNotification:'',
            leadMeetingFirstNotificationUnits:'minute',
            leadMeetingSecondNotification:'',
            leadMeetingSecondNotificationUnits:'minute',
            sendNotificationSmsFlag:0,
            newMeetingLocation:'',
            meetingInviteAttendees:'',
            meetingSubject:'',
            sendToGoogleCalendarFlag:0,
            sendImmediateSmsFlag:0,
            leadMeetingStartTimeManual:8,
            leadMeetingStartTimeMinutesManual:'00',
            leadMeetingEndTimeNewManual:8,
            leadMeetingEndTimeMinutesManual:'00',
            meetingStatusManual:0,
            manualMeetingLocation:'',
            meetingInviteAttendeesManual:'',
            meetingSubjectManual:'',
            allDayNewMeetingFlagManual:0,
            componentDatepickerKeyManual:0,
            minDateToManual:'',
            maxDateManual:'',
            meetingManualStartDate:'',
            minDateFromManual:'',
            meetingManualDueDate:'',
            meetingAdditionalInfo:'',
            meetingDetails :'',
            meetingDetailsManual :'',
            processingNewMeeting:false,
            processingNewMeetingManual:false,
        }
    },
    components: {
        'editor': Editor
    },
    computed: {
        ...mapGetters({
            formatDate: 'formatDate',
            formatOnlyDate: 'formatOnlyDate',
            formatTimeOnly: 'formatTimeOnly',
            formatTimeOnlyWithPartOfTheDay: 'formatTimeOnlyWithPartOfTheDay',
            configDataInfo:'getAdditionalInfoDetailedScreen',
            sortByColumn: 'sortByColumn',
            truncateText: 'truncateText',
            toCurrency:'toCurrency',
            unescapeValue:'unescapeValue',
            additionalInfo:'getMeetingAdditionalSubTabData',
            meetingData: 'getMeetingSubTabData',
            leadData:'getDetailedScreenLeadData',
            generalAdditionalInfo:'getAdditionalInfoDetailedScreen',
        })
    },
    methods: {
        async loadData() {

            this.timezoneAbbreviation = this.generalAdditionalInfo.leadOwnerTimezoneOffset;
            this.loadedScreen = true;
        },
        async createMeeting()
        {
            if (this.processingNewMeeting === true) {
                return false;
            }

            this.processingNewMeeting = false;

            let period = 'fixed',
                startTimeDate = '',
                endTimeDate = '';

            let leadMeetingStartDate = moment(this.meetingNewStartDate).format('YYYY-MM-DD');

            if (leadMeetingStartDate === 'Invalid date') {
                showMessage(this.$t('message.meetingSubStartDate'), true, 3000);
                return false;
            }

            let leadMeetingEndTimeNew = moment(this.meetingNewDueDate).format('YYYY-MM-DD');

            if (leadMeetingEndTimeNew === 'Invalid date') {
                showMessage(this.$t('message.meetingSubEndDate'), true, 3000);
                return false;
            }

            if (this.allDayNewMeetingFlag === 1) {
                period = 'all_day';
            } else {
                startTimeDate = leadMeetingStartDate+' '+this.leadMeetingStartTimeNew+':'+this.leadMeetingStartTimeMinutesNew+':00';
                endTimeDate = leadMeetingEndTimeNew+' '+this.leadMeetingEndTimeNew+':'+this.leadMeetingEndTimeMinutesNew+':00';
            }

            const result = await this.$store.dispatch(
                'createMeeting', {
                    'router':this.$router,
                    'startTimeDate':startTimeDate,
                    'endTimeDate':endTimeDate,
                    'location':this.newMeetingLocation,
                    'inviteAttendees':this.meetingInviteAttendees,
                    'period':period,
                    'subject':this.meetingSubject,
                    'details':this.meetingDetails,
                    'googleCalendar':this.sendToGoogleCalendarFlag,
                    'startTime':this.leadMeetingStartTimeNew,
                    'endTime':this.leadMeetingEndTimeNew,
                    'firstNotification':this.leadMeetingFirstNotification,
                    'secondNotification':this.leadMeetingSecondNotification,
                    'firstNotificationUnits':this.leadMeetingFirstNotificationUnits,
                    'secondNotificationUnits':this.leadMeetingSecondNotificationUnits,
                    'sendSms':this.sendImmediateSmsFlag,
                    'sendNotificationSms':this.sendNotificationSmsFlag,
                    'leadId':this.leadId
                });

            if (parseInt(result.error) === 1) {
                showMessage(result.message, true, 3000);
                this.processingNewMeeting = false;
                return false;
            } else {
                showMessage(result.responseText, false, 3000);
                this.$store.commit('setTimelineLogChangeFilter', Date.now());
                this.processingNewMeeting = false;
                this.resetMeetingForm();
            }
        },
        async createMeetingManual()
        {
            if (this.processingNewMeetingManual === true) {
                return false;
            }

            this.processingNewMeetingManual = false;

            let period = 'fixed',
                startTimeDate = '',
                endTimeDate = '',
                meetingType = '',
                manualMeeting = 0;

            let meetingManualStartDate = moment(this.meetingManualStartDate).format('YYYY-MM-DD');

            if (meetingManualStartDate === 'Invalid date') {
                showMessage(this.$t('message.meetingSubStartDate'), true, 3000);
                return false;
            }

            let meetingManualDueDate = moment(this.meetingManualDueDate).format('YYYY-MM-DD');

            if (meetingManualDueDate === 'Invalid date') {
                showMessage(this.$t('message.meetingSubEndDate'), true, 3000);
                return false;
            }

            if (this.allDayNewMeetingFlagManual === 1) {
                period = 'all_day';
            } else {
                startTimeDate = meetingManualStartDate+' '+this.leadMeetingStartTimeManual+':'+this.leadMeetingStartTimeMinutesManual+':00';
                endTimeDate = meetingManualDueDate+' '+this.leadMeetingEndTimeNewManual+':'+this.leadMeetingEndTimeMinutesManual+':00';
            }

            if (this.meetingType === 'log_external') {
                meetingType = 'manual';
                manualMeeting = 1;
            }

            const result = await this.$store.dispatch('createMeetingManual', {
                'router':this.$router,
                'startTimeDate':startTimeDate,
                'endTimeDate':endTimeDate,
                'location':this.manualMeetingLocation,
                'inviteAttendees':this.meetingInviteAttendeesManual,
                'period':period,
                'subject':this.meetingSubjectManual,
                'details':this.meetingDetailsManual,
                'startTime':this.leadMeetingStartTimeManual,
                'endTime':this.leadMeetingEndTimeNewManual,
                'meetingType':meetingType,
                'manualMeeting':manualMeeting,
                'meetingStatus':this.meetingStatusManual,
                'additionalNotes':this.meetingDetailsManual,
                'leadId':this.leadId
            });

            if (parseInt(result.error) === 1) {
                showMessage(result.message, true, 3000);
                this.processingNewMeetingManual = false;
                return false;
            } else {
                showMessage(result.responseText, false, 3000);
                this.processingNewMeetingManual = false;
                this.$store.commit('setTimelineLogChangeFilter', Date.now());
                this.resetMeetingForm();
            }
        },
        resetMeetingForm()
        {
            this.meetingType = 'new';
            this.showStatusBlock = false;
            this.minDateFromNew = new Date();
            this.minDateToNew = new Date();
            this.maxDateNew = '';
            this.meetingNewStartDate = '';
            this.meetingNewDueDate = '';
            this.allDayNewMeetingFlag = 0;
            this.leadMeetingStartTimeNew = 8;
            this.leadMeetingStartTimeMinutesNew = '00';
            this.leadMeetingEndTimeNew = 8;
            this.leadMeetingEndTimeMinutesNew = '00';
            this.leadMeetingFirstNotification = '';
            this.leadMeetingFirstNotificationUnits = 'minute';
            this.leadMeetingSecondNotification = '';
            this.leadMeetingSecondNotificationUnits = 'minute';
            this.sendNotificationSmsFlag = 0;
            this.newMeetingLocation = '';
            this.meetingInviteAttendees = '';
            this.meetingSubject = '';
            this.sendToGoogleCalendarFlag = 0;
            this.sendImmediateSmsFlag = 0;
            this.leadMeetingStartTimeManual = 8;
            this.leadMeetingStartTimeMinutesManual = '00';
            this.leadMeetingEndTimeNewManual = 8;
            this.leadMeetingEndTimeMinutesManual = '00';
            this.meetingStatusManual = 0;
            this.manualMeetingLocation = '';
            this.meetingInviteAttendeesManual = '';
            this.meetingSubjectManual = '';
            this.allDayNewMeetingFlagManual = 0;
            this.componentDatepickerKeyManual = 0;
            this.minDateToManual = '';
            this.maxDateManual = '';
            this.meetingManualStartDate = '';
            this.minDateFromManual = '';
            this.meetingManualDueDate = '';
            this.meetingAdditionalInfo = '';
            this.meetingDetails = '';
            this.meetingDetailsManual = '';
        },
        switchMeetingType(type)
        {
            this.meetingType = type;
        },
        changeDateNew(selectedDate, datepickerType){
            if (datepickerType === 'date-from-new') {
                this.minDateToNew = selectedDate;
                if (selectedDate && this.meetingNewDueDate === '') {
                    this.meetingNewDueDate = selectedDate;
                }
            } else {
                this.maxDateNew = selectedDate;
            }
            this.componentDatepickerKeyNew += 1;
        },
        changeDateManual(selectedDate, datepickerType){
            if (datepickerType === 'date-from-manual') {
                this.minDateToManual = selectedDate;
                if (selectedDate && this.meetingManualDueDate === '') {
                    this.meetingManualDueDate = selectedDate;
                }

                if (selectedDate && selectedDate < new Date()) {
                    this.showStatusBlock = true;
                } else {
                    this.showStatusBlock = false;
                    this.meetingStatusManual = 0;
                }

            } else {
                this.maxDateManual = selectedDate;
            }
            this.componentDatepickerKeyManual += 1;
        },
        changeStartTime()
        {
            if (parseInt(this.leadMeetingStartTimeNew) < 23) {
                this.leadMeetingEndTimeNew = parseInt(this.leadMeetingStartTimeNew) + 1;
            } else if (parseInt(this.leadMeetingStartTimeNew) === 23) {
                this.leadMeetingEndTimeNew = 23;
            }

            this.leadMeetingEndTimeMinutesNew = this.leadMeetingStartTimeMinutesNew;
        },
        changeStartTimeManual()
        {
            if (parseInt(this.leadMeetingStartTimeManual) < 23) {
                this.leadMeetingEndTimeNewManual = parseInt(this.leadMeetingStartTimeManual) + 1;
            } else if (parseInt(this.leadMeetingStartTimeManual) === 23) {
                this.leadMeetingEndTimeNewManual = 23;
            }

            this.leadMeetingEndTimeMinutesManual = this.leadMeetingStartTimeMinutesManual;
        },
        changeMeetingEndMinutes()
        {
            this.leadMeetingEndTimeMinutesNew = this.leadMeetingStartTimeMinutesNew;
        },
        changeMeetingEndMinutesManual()
        {
            this.leadMeetingEndTimeMinutesManual = this.leadMeetingStartTimeMinutesManual;
        },
        copyPathInfo: function(e, path)
        {
            e.preventDefault();
            if (document.queryCommandSupported("copy")) {
                var copyFromEl = $('<textarea/>');
                copyFromEl.text(path);
                $('body').append(copyFromEl);
                copyFromEl.select();
                document.execCommand('copy', true);
                copyFromEl.remove();
                showMessage(this.$t('message.meetingSubHasBeenCopied'), false, 2000);
            }
        },
    },
    async created(){
        if (typeof this.localeMapping[this.locale] !== 'undefined') {
            this.$i18n.locale = this.localeMapping[this.locale];
        }

        this.loadData();
    },
    async updated() {
        this.$nextTick(function () {
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        })
    }
}
