import {mapGetters} from 'vuex';
import lodash from 'lodash';
import localeMapping from '../../../localizationLanguages';
import pagination from '../../pagination';
import moment from 'moment';
import { isProxy, toRaw } from 'vue';

export default {
    data () {
        return {
            loadedScreen: false,
            websiteUrl: $('#website_url').val(),
            localeMapping: localeMapping,
            locale: $('#dashboard-system-language').val(),
            itemsQuantity:0,
            itemsProcessed:0,
            emailValidateBalance:0,
            emailBalanceLink:'',
            quantityBlock:false,
            matchingFilter:0,
            disabled:false,
        }
    },
    components: {
    },
    computed: {
        ...mapGetters({
            configDataInfo:'getConfigDataInfo',
            additionalInfo:'getAdditionalInfo',
            truncateText: 'truncateText',
            unescapeValue:'unescapeValue',
            checkedItemsData:'getCheckedItems',
            totalFoundItems:'getTotalItemsFound',
            filterData:'getFilterData',
            ucFirstAllText:'ucFirstAllText',
        })
    },
    watch: {

    },
    methods: {
        closeMassAction() {
            this.$store.commit('setActiveMassAction', 0);
        },
        async submitRegularForm()
        {
            let filters = toRaw(this.filterData),
                self = this;

            if (Object.keys(filters).length === 0) {
                filters = {};
            }

            this.disabled = true;
            this.itemsProcessed = 0;

            if (this.itemsQuantity >= 100) {
                showConfirm(this.$t('message.jobRunInTheBackground'), function(){
                    self.sendToValidateEmailService(0);
                }, function () {
                    this.disabled = false;
                });
            } else {
                this.sendToValidateEmailService(0);
            }
        },
        async sendToValidateEmailService(stepSendEmailService)
        {
            let filters = toRaw(this.filterData),
                matchingFilter = 0;

            if (Object.keys(filters).length === 0) {
                filters = {};
            }

            if(this.matchingFilter) {
                matchingFilter = 1;
            }

            const result = await this.$store.dispatch('validateLeadEmailsMassAction', {
                'router': this.$router,
                'leadIds': Object.keys(this.checkedItemsData).join(','),
                'filters': filters,
                'matchingFilter': matchingFilter,
                'stepSendEmailService': stepSendEmailService,
                'filterQuantity': this.itemsQuantity,
            });

            if (typeof result.responseText !== 'undefined' && typeof result.responseText.quantity !== 'undefined') {
                this.quantityBlock = true;
                this.itemsProcessed = this.itemsProcessed + result.responseText.quantity;
            }

            if (result.error == 0) {
                this.sendToValidateEmailService(stepSendEmailService+1);
            } else {
                if (typeof result.responseText === 'undefined') {
                    showMessage(result.message, false, 5000);
                } else {
                    showMessage(result.responseText.message, false, 5000);
                }

                this.disabled = false;
            }

            if (typeof result.responseText !== 'undefined' && typeof result.responseText.pointsBalance !== 'undefined') {
                this.emailValidateBalance = parseInt(result.responseText.pointsBalance)
            }
        },
        async countLeads(event)
        {
            let isChecked = event.target.checked;

            this.quantityBlock = false;

            this.matchingFilter = 1;
            let filters = toRaw(this.filterData);

            if (Object.keys(filters).length === 0) {
                filters = {};
            }

            const result = await this.$store.dispatch('countLeadsMassAction', {
                'router': this.$router,
                'filters': filters,
                'existMobileNumber': 0,
                'leadIds': Object.keys(this.checkedItemsData).join(','),
                'uniqueEmail': 1,
            });

            if (result.error === 1) {
                showMessage(this.$t('message.smsNoMassActionRecordsFound'), true, 3000);
                this.closeMassAction();
                return false;
            } else {
                if (isChecked === true) {
                    this.totalItemsQuantity = parseInt(result.responseText.quantity);
                    this.itemsQuantity = parseInt(result.responseText.additionalQuantity);
                } else {
                    this.matchingFilter = 0;
                    this.totalItemsQuantity = parseInt(result.responseText.additionalQuantity);
                    this.itemsQuantity = parseInt(result.responseText.quantity);
                }
            }

        },
        async getInitialData()
        {
            if (Object.keys(this.checkedItemsData).length === 0) {
                showMessage(this.$t('message.pleaseChooseAtLeastOneLead'), true, 3000);
                this.closeMassAction();
            }

            let filters = toRaw(this.filterData);

            if (Object.keys(filters).length === 0) {
                filters = {};
            }

            const result = await this.$store.dispatch('countLeadsMassAction', {
                'router': this.$router,
                'filters': filters,
                'leadIds': Object.keys(this.checkedItemsData).join(','),
                'uniqueEmail': 1,
                'validateEmailBalance': 1,
                'existMobileNumber': 0,
            });

            if(result.error != 1) {
                this.itemsQuantity = parseInt(result.responseText.quantity);
                this.emailValidateBalance = result.responseText.emailValidateBalance;
                this.emailBalanceLink = result.responseText.emailBalanceLink;
            } else {
                showMessage(this.$t('message.noLeadsHaveBeenFoundWithEmailAddress'), true, 5000);
            }

            if (this.itemsQuantity > 0) {
                this.loadedScreen = true;
            }
        },
    },
    async created(){
        if (typeof this.localeMapping[this.locale] !== 'undefined') {
            this.$i18n.locale = this.localeMapping[this.locale];
        }

        this.getInitialData();
    },
    async updated() {
        this.$nextTick(function () {
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        })
    }
}
