import {mapGetters} from 'vuex';
import lodash from 'lodash';
import localeMapping from '../../../localizationLanguages';
import pagination from '../../pagination';
import moment from 'moment';
import { isProxy, toRaw } from 'vue';

export default {
    data () {
        return {
            loadedScreen: false,
            websiteUrl: $('#website_url').val(),
            localeMapping: localeMapping,
            locale: $('#dashboard-system-language').val(),
            itemsQuantity:0,
            additionalCountSelectedLeads:0,
            leadSendEmailServiceQuantity:this.$t('message.contactsHaveBeenSuccessfullyAdded'),
            enabledServices:[],
            service:'select',
            useFilter:false,
            emailMarketingFunction:'assign',
            originalLabel:this.$t('message.recordsWithAnEmailAddressToYourMailingList'),
            additionalLabel:this.$t('message.recordsWithAnEmailAddressMatchingYourFilterToYourMailingList'),
            originalLabelMain2:this.$t('message.recordsMatchingYourFilter'),
            additionalLabelMain2:this.$t('message.selectedRecords'),
            subscribeList:[],
            detailedInfo:0,
            itemsProcessed:0,
            checkedLists:[],
            emailServiceBlock:'hidden',
            informationMsg:this.$t('message.toEnsureThatAllContactsAdded'),
            sendToEmailService:this.$t('message.addContactToList'),
            originalLabel1:this.$t('message.youreNowAdding'),
            originalLabel2:this.$t('message.checkThisBoxIfYouWishToAddAll'),
            additionalLabel1:this.$t('message.youreNowAddingAll'),
            additionalLabel2:this.$t('message.uncheckThisBoxIfYouWishToAdd'),
            originalLabelEl:'',
            additionalLabelEl:'hide',
            sendToEmailServiceEl:'hidden',
            horizontalLineEl:'hidden',
            leadSendEmailServiceQuantityBlockEl:'hidden',
            disabled:false,
            leadSendEmailServiceQuantityBlockProcessing:'hidden',
            leadsErrorBtnEl:'hide',
            downloadErrFileLink:'',

        }
    },
    components: {
    },
    computed: {
        ...mapGetters({
            configDataInfo:'getConfigDataInfo',
            additionalInfo:'getAdditionalInfo',
            truncateText: 'truncateText',
            unescapeValue:'unescapeValue',
            checkedItemsData:'getCheckedItems',
            totalFoundItems:'getTotalItemsFound',
            filterData:'getFilterData',
            ucFirstAllText:'ucFirstAllText',
            alphabeticalSort:'alphabeticalSort',
        })
    },
    watch: {

    },
    methods: {
        closeMassAction() {
            this.$store.commit('setActiveMassAction', 0);
        },
        async submitRegularForm()
        {
            let self = this;

            this.itemsProcessed = 0;
            this.emailServiceBlock = 'hidden';
            this.leadSendEmailServiceQuantityBlockEl = 'hidden';
            this.leadsErrorBtnEl = 'hide';

            let emailServiceName = this.service,
                checkedLists = this.checkedLists;

            if (emailServiceName === 'select'){
                showMessage(this.$t('message.pleaseChooseService'), true, 5000);
                this.emailServiceBlock = '';
                return false;
            }

            if (checkedLists.length === 0){
                showMessage(this.$t('message.pleaseChooseList'), true, 5000);
                this.emailServiceBlock = '';
                return false;
            }

            this.disabled = true;
            let lists = [];

            lists['ids'] = [];
            lists['labels'] = [];

            this.checkedLists.forEach(function(listId, index) {
                lists['ids'].push(listId);
                lists['labels'].push(self.subscribeList[listId]);
            });

            this.sendToEmailServiceProcedure(lists, 0, []);
        },
        async sendToEmailServiceProcedure(lists, stepSendEmailService, invalidLeads)
        {
            let filters = toRaw(this.filterData),
                matchingFilter = 0;

            if (Object.keys(filters).length === 0) {
                filters = {};
            }

            if(this.useFilter) {
                matchingFilter = 1;
            }

            const resultSendToEmailService = await this.$store.dispatch('sendToEmailServiceMassAction', {
                'router': this.$router,
                'leadIds': Object.keys(this.checkedItemsData).join(','),
                'emailServiceName': this.service,
                'lists': lists['ids'].join(','),
                'listsLabels': lists['labels'].join(','),
                'detailedInfo': this.detailedInfo,
                'filters' : filters,
                'matchingFilter': matchingFilter,
                'stepSendEmailService' : stepSendEmailService,
                'invalidLeads': invalidLeads,
                'filterQuantity': this.itemsQuantity,
                'requestType': this.emailMarketingFunction
            });

            this.leadSendEmailServiceQuantityBlockProcessing = '';

            if (parseInt(resultSendToEmailService.error) === 1 && typeof resultSendToEmailService.message !== 'undefined') {
                showMessage(resultSendToEmailService.message, true, 5000);
                return false;
            }

            let quantity = parseInt(resultSendToEmailService.responseText.quantity);
            this.itemsProcessed = this.itemsProcessed + quantity;

            if (parseInt(resultSendToEmailService.error) === 0){
                let invalidLeads = [];
                if(resultSendToEmailService.responseText.invalidLeads) {
                    invalidLeads = resultSendToEmailService.responseText.invalidLeads;
                }

                this.sendToEmailServiceProcedure(lists, stepSendEmailService + 1, invalidLeads);
            } else {
                this.leadSendEmailServiceQuantityBlockProcessing = 'hidden';
                if (typeof resultSendToEmailService.responseText.errorFileName !== 'undefined') {
                    let errorMessage = resultSendToEmailService.responseText.message,
                        downloadErrFileLnk = '<a class="btn error fl-right grid_12" href="'+this.websiteUrl+'plugin/leads/run/downloadFile/?fileName='+resultSendToEmailService.responseText.errorFileName+'" >'+(this.$t('message.downloadErrorLog'))+'</a>'+ '';

                    showMessage(errorMessage, true, 5000);
                    this.leadsErrorBtnEl = '';
                    this.downloadErrFileLink = downloadErrFileLnk;
                } else {
                    this.leadSendEmailServiceQuantityBlockEl = '';

                    if (this.emailMarketingFunction === 'assign') {
                        showMessage(this.$t('message.contactsAdded'), false, 5000);
                    } else {
                        showMessage(this.$t('message.contactsRemoved'), false, 5000);
                    }
                    this.disabled = false;
                    this.emailServiceBlock = '';
                    //this.emailMarketingFunction = 'assign';
                }
            }
        },
        async getInitialData()
        {
            if (Object.keys(this.checkedItemsData).length === 0) {
                showMessage(this.$t('message.pleaseChooseAtLeastOneLead'), true, 3000);
                this.closeMassAction();
            }

            let filters = toRaw(this.filterData);

            if (Object.keys(filters).length === 0) {
                filters = {};
            }

            const result = await this.$store.dispatch('countLeadsMassAction', {
                'router': this.$router,
                'filters': filters,
                'leadIds': Object.keys(this.checkedItemsData).join(','),
                'uniqueEmail': 1,
            });

            if (parseInt(result.error) !== 1) {
                this.itemsQuantity = parseInt(result.responseText.quantity);
                this.additionalCountSelectedLeads = parseInt(result.responseText.additionalQuantity);

                if(this.itemsQuantity === 1) {
                    this.leadSendEmailServiceQuantity = this.$t('message.contactHasBeenSuccessfullyAdded');
                } else {
                    this.leadSendEmailServiceQuantity = this.$t('message.contactsHaveBeenSuccessfullyAdded');
                }

                if (this.itemsQuantity > 0) {
                    let customerIds = [1];

                    const resultServices = await this.$store.dispatch('getEnabledAppsServicesMassAction', {
                        'router': this.$router,
                        'customerIds': customerIds,
                    });

                    if(resultServices.error === 1) {
                        showMessage(this.$t('message.noAvailableServices'), true, 5000);
                        return false;
                    } else {
                        this.enabledServices = resultServices.responseText.enabledServices;
                        if(this.itemsQuantity === 1) {
                            this.originalLabel = this.$t('message.recordToYourMailingList');
                            this.additionalLabel = this.$t('message.recordMatchingYourFilterToYourMailingList');
                        }

                        if(this.additionalCountSelectedLeads === 1) {
                            this.originalLabelMain2 = this.$t('message.recordMatchingYourFilter');
                            this.additionalLabelMain2 = this.$t('message.selectedRecord');
                        }

                        this.loadedScreen = true;
                    }
                }
            } else {
                showMessage(this.$t('message.noLeadsHaveBeenFoundWithEmailAddress'), true, 5000);
                this.closeMassAction();
            }
        },
        async selectService()
        {
            let checkedLeadRows = Object.keys(this.checkedItemsData).join(','),
                filters = toRaw(this.filterData);

            if (Object.keys(filters).length === 0) {
                filters = {};
            }

            this.checkedLists = [];

            if (this.useFilter) {
                this.countServiceLeads(filters, 0, checkedLeadRows);
                this.originalLabelEl = 'hide';
                this.additionalLabelEl = '';
            } else {
                this.countServiceLeads(filters, checkedLeadRows, null);
                this.originalLabelEl = '';
                this.additionalLabelEl = 'hide';
            }

            this.leadSendEmailServiceQuantityBlockEl = 'hidden';
            this.leadSendEmailServiceQuantityBlockProcessing = 'hidden';
            this.itemsProcessed = 0;
            this.emailServiceBlock = 'hidden';
            if (this.service !== 'select') {
                const resultService = await this.$store.dispatch('getAppsServiceMassAction', {
                    'router': this.$router,
                    'serviceName': this.service,
                });

                if(parseInt(resultService.error) === 1){
                    let errorMsg = '';
                    if(this.service === 'constantContact') {
                        if(resultService.responseText.hasError) {
                            errorMsg = '<p><b>'+this.$t('message.canNotGetAnyData')+'</b></p> '+resultService.responseText.message;
                        } else {
                            errorMsg = '<p><b>'+this.$t('message.noListIsAvailable')+'</b></p> '+this.$t('message.pleaseMakeSureIfTheListIsCreatedAndYouCanGetAccess');
                        }
                    } else {
                        errorMsg = '<p><b>'+this.$t('message.noListIsAvailable')+'</b></p> '+this.$t('message.privateListsAreNotShownHere');
                    }
                    showMessage(errorMsg, false, 5000);

                    this.subscribeList = [];
                    this.sendToEmailServiceEl = 'hidden';
                    this.emailServiceBlock = 'hidden';
                    this.horizontalLineEl = 'hidden';
                    this.service = 'select';
                    return false;
                } else {
                    this.subscribeList = [];
                    let list = resultService.responseText.list;

                    if(!_.isEmpty(list)) {
                        this.subscribeList = list;
                    } else {
                        let errorMsg = '';
                        if (this.service === 'constantContact') {
                            if(resultService.responseText.hasError) {
                                errorMsg = '<p><b>'+this.$t('message.canNotGetAnyData')+'</b></p> '+resultService.responseText.message;
                            } else {
                                errorMsg = '<p><b>'+this.$t('message.noListIsAvailable')+'</b></p> '+this.$t('message.pleaseMakeSureIfTheListIsCreatedAndYouCanGetAccess');
                            }
                        } else {
                            errorMsg = '<p><b>'+this.$t('message.noListIsAvailable')+'</b></p> '+this.$t('message.privateListsAreNotShownHere');
                        }
                        showMessage(errorMsg, false, 5000);
                    }

                    this.detailedInfo = resultService.responseText.detailedInfo;
                    this.sendToEmailServiceEl = '';
                    this.emailServiceBlock = '';
                    this.horizontalLineEl = '';
                }
            } else {
                this.sendToEmailServiceEl = 'hidden';
                this.horizontalLineEl = 'hidden';
                this.subscribeList = [];
            }
        },
        async matchingFilter(event)
        {
            let isChecked = event.target.checked,
                filters = toRaw(this.filterData),
                checkedLeads = Object.keys(this.checkedItemsData).join(',');

            if (Object.keys(filters).length === 0) {
                filters = {};
            }

            this.useFilter = false;

            if (isChecked === true) {
                this.useFilter = true;
                this.countServiceLeads(filters, 0, checkedLeads);
                this.originalLabelEl = 'hide';
                this.additionalLabelEl = '';
            } else {
                this.countServiceLeads(filters, checkedLeads, null);
                this.originalLabelEl = '';
                this.additionalLabelEl = 'hide';
            }
        },
        async changeEmailMarketing(event)
        {
            if (this.emailMarketingFunction === 'unassign') {
                this.informationMsg = this.$t('message.toEnsureThatAllContactsRemoved');
                this.sendToEmailService = this.$t('message.removeContactFromList');
                this.originalLabel1 = this.$t('message.youreNowRemoving');
                this.originalLabel2 = this.$t('message.checkThisBoxIfYouWishToRemoveAll');
                this.additionalLabel1 = this.$t('message.youreNowRemovingAll');
                this.additionalLabel2 = this.$t('message.uncheckThisBoxIfYouWishToRemove');

                if (parseInt(this.itemsQuantity) === 1) {
                    this.leadSendEmailServiceQuantity = this.$t('message.contactHasBeenSuccessfullyRemoved');
                    this.originalLabel = this.$t('message.recordWithAnEmailAddressFromYourMailingList');
                    this.additionalLabel = this.$t('message.recordWithAnEmailAddressMatchingYourFilterFromYourMailingList');
                } else {
                    this.leadSendEmailServiceQuantity = this.$t('message.contactsHaveBeenSuccessfullyRemoved');
                    this.originalLabel = this.$t('message.recordsWithAnEmailAddressFromYourMailingList');
                    this.additionalLabel = this.$t('message.recordsWithAnEmailAddressMatchingYourFilterFromYourMailingList');
                }
            } else {
                this.informationMsg = this.$t('message.toEnsureThatAllContactsAdded');
                this.sendToEmailService = this.$t('message.addContactToList');
                this.originalLabel1 = this.$t('message.youreNowAdding');
                this.originalLabel2 = this.$t('message.checkThisBoxIfYouWishToAddAll');
                this.additionalLabel1 = this.$t('message.youreNowAddingAll');
                this.additionalLabel2 = this.$t('message.uncheckThisBoxIfYouWishToAdd');

                if (parseInt(this.itemsQuantity) === 1) {
                    this.leadSendEmailServiceQuantity = this.$t('message.contactHasBeenSuccessfullyAdded');
                    this.originalLabel = this.$t('message.recordWithAnEmailAddressToYourMailingList');
                    this.additionalLabel = this.$t('message.recordWithAnEmailAddressMatchingYourFilterToYourMailingList');
                } else {
                    this.leadSendEmailServiceQuantity = this.$t('message.contactsHaveBeenSuccessfullyAdded');
                    this.originalLabel = this.$t('message.recordsWithAnEmailAddressToYourMailingList');
                    this.additionalLabel = this.$t('message.recordsWithAnEmailAddressMatchingYourFilterToYourMailingList');
                }
            }
        },
        async countServiceLeads(filters, checkedLeads, additionalParams)
        {
            const result = await this.$store.dispatch('countLeadsMassAction', {
                'router': this.$router,
                'filters': filters,
                'leadIds': checkedLeads,
                'uniqueEmail': 1,
                'additionalParams': additionalParams,
            });

            this.itemsQuantity = parseInt(result.responseText.quantity);
            this.additionalCountSelectedLeads = parseInt(result.responseText.additionalQuantity);

            let countSelectedLeads = this.itemsQuantity,
                additionalCountSelectedLeads = this.additionalCountSelectedLeads;

            this.originalLabel = this.$t('message.recordsWithAnEmailAddressToYourMailingList');
            this.additionalLabel = this.$t('message.recordsWithAnEmailAddressMatchingYourFilterToYourMailingList');
            this.originalLabelMain2 = this.$t('message.recordsMatchingYourFilter');
            this.additionalLabelMain2 = this.$t('message.selectedRecords');

            if (this.emailMarketingFunction === 'unassign') {
                this.originalLabel = this.$t('message.recordsWithAnEmailAddressFromYourMailingList');
                this.additionalLabel = this.$t('message.recordsWithAnEmailAddressMatchingYourFilterFromYourMailingList');

                this.leadSendEmailServiceQuantity = this.$t('message.contactsHaveBeenSuccessfullyRemoved');
                if (parseInt(countSelectedLeads) === 1) {
                    this.leadSendEmailServiceQuantity = this.$t('message.contactHasBeenSuccessfullyRemoved');
                }
            } else {
                this.leadSendEmailServiceQuantity = this.$t('message.contactsHaveBeenSuccessfullyAdded');
                if (parseInt(countSelectedLeads) === 1) {
                    this.leadSendEmailServiceQuantity = this.$t('message.contactHasBeenSuccessfullyAdded');
                }
            }

            if (parseInt(countSelectedLeads) === 1) {
                this.originalLabel = this.$t('message.recordWithAnEmailAddressToYourMailingList');
                this.additionalLabel = this.$t('message.recordMatchingYourFilterToYourMailingList');

                if(this.emailMarketingFunction === 'unassign') {
                    this.originalLabel = this.$t('message.recordWithAnEmailAddressFromYourMailingList');
                    this.additionalLabel = this.$t('message.recordMatchingYourFilterFromYourMailingList');
                }
            }

            if (parseInt(additionalCountSelectedLeads) === 1) {
                this.originalLabelMain2 = this.$t('message.recordMatchingYourFilter');
                this.additionalLabelMain2 = this.$t('message.selectedRecord');
            }
        },
    },
    async created(){
        if (typeof this.localeMapping[this.locale] !== 'undefined') {
            this.$i18n.locale = this.localeMapping[this.locale];
        }

        this.getInitialData();
    },
    async updated() {
        this.$nextTick(function () {
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        })
    }
}
