import {mapGetters} from 'vuex';
import lodash from 'lodash';
import localeMapping from '../../../localizationLanguages';
import pagination from '../../pagination';
import { isProxy, toRaw } from 'vue';

import "tinymce/tinymce";
import 'tinymce/models/dom';
import 'tinymce/themes/silver';
import 'tinymce/icons/default';
import 'tinymce/skins/ui/oxide/skin.min.css';
import 'tinymce/skins/ui/oxide/content.min.css';
import 'tinymce/plugins/fullscreen';

import spellcheck from '../../../../../../tinymce-vue-plugins/spellcheck/plugin';
import Editor from "@tinymce/tinymce-vue";

export default {
    props: ['leadId'],
    data () {
        return {
            loadedScreen: true,
            locale: $('#dashboard-system-language').val(),
            localeMapping: localeMapping,
            websiteUrl: $('#website_url').val(),
            loadedScreenData: false,
            callCountryCode:'',
            leadCallNumber:'',
            callDeviceType:'mobile',
            callDeviceTypeFrom:'mobile',
            callDuration:0,
            callText:'',
            callDurationManual:'',
            showZopierBlock:false,
            manualCallLogProcessing:false,
            callLogProcessing:false
        }
    },
    components: {
        'editor': Editor
    },
    computed: {
        ...mapGetters({
            formatDate: 'formatDate',
            formatOnlyDate: 'formatOnlyDate',
            formatTimeOnly: 'formatTimeOnly',
            formatTimeOnlyWithPartOfTheDay: 'formatTimeOnlyWithPartOfTheDay',
            configDataInfo:'getAdditionalInfoDetailedScreen',
            sortByColumn: 'sortByColumn',
            truncateText: 'truncateText',
            toCurrency:'toCurrency',
            unescapeValue:'unescapeValue',
            additionalInfo:'getCallAdditionalSubTabData',
            callData: 'getCallSubTabData',
            leadData:'getDetailedScreenLeadData',
            generalAdditionalInfo:'getAdditionalInfoDetailedScreen',
        })
    },
    methods: {
        async loadData() {
            this.callCountryCode = toRaw(this.leadData.lead_mobile_country_code);
            this.leadCallNumber = toRaw(this.leadData.lead_mobile);

            this.loadedScreenData = true;

            let self = this;
            setTimeout(() => self.processPhoneMobileCountryCodesSelectors(),  100);
        },
        changeMobileNumber(event)
        {
            this.leadCallNumber = event.target.value;
        },
        changeCallDevice()
        {
            if (this.callDeviceType === 'mobile') {
                this.leadCallNumber = toRaw(this.leadData.lead_mobile);
                this.callCountryCode = toRaw(this.leadData.lead_mobile_country_code);
            }

            if (this.callDeviceType === 'desktop') {
                this.leadCallNumber = toRaw(this.leadData.lead_phone);
                this.callCountryCode = toRaw(this.leadData.lead_phone_country_code);
            }

            if (this.callDeviceType === 'organization-mobile') {
                this.leadCallNumber = toRaw(this.leadData.organization_mobile);
                this.callCountryCode = toRaw(this.leadData.organization_mobile_country_code);
            }

            if (this.callDeviceType === 'organization-phone') {
                this.leadCallNumber = toRaw(this.leadData.organization_phone);
                this.callCountryCode = toRaw(this.leadData.organization_phone_country_code);
            }
        },
        changeCallDeviceFrom()
        {
            if (this.callDeviceTypeFrom === 'mobile') {
                this.showZopierBlock = false;
            }

            if (this.callDeviceTypeFrom === 'desktop') {
                this.showZopierBlock = false;
            }

            if (this.callDeviceTypeFrom === 'voip-phone') {
                this.showZopierBlock = true;
            }
        },
        processPhoneMobileCountryCodesSelectors()
        {
            if (typeof this.generalAdditionalInfo.mobileMasks[this.callCountryCode] !== 'undefined') {
                $(document).find('#lead-call-number').mask(this.generalAdditionalInfo.mobileMasks[this.callCountryCode].mask_value, {autoclear: false});
            } else {
                $(document).find('#lead-call-number').mask('(999) 999 9999', {autoclear: false});
            }
        },
        addShortCut(shortcut)
        {
            tinymce.activeEditor.insertContent(shortcut);
        },
        async logCallManually()
        {

            if (this.manualCallLogProcessing === true)  {
                return false;
            }

            this.manualCallLogProcessing = true;

            const result = await this.$store.dispatch('logManualCall', {
                'router':this.$router,
                'leadId': this.leadId,
                'callDeviceType': this.callDeviceType,
                'leadCallCountryCode': this.callCountryCode,
                'leadCallNumber': this.leadCallNumber,
                'callFromDeviceType': this.callDeviceTypeFrom,
                'callNotes': this.callText,
                'callDurationDropdown': this.callDuration,
                'callDurationManual': this.callDurationManual,
            });

            if (parseInt(result.error) === 1) {
                showMessage(result.responseText, true, 3000);
                this.manualCallLogProcessing = false;
                return false;
            } else {
                showMessage(result.responseText, false, 2000);
                this.manualCallLogProcessing = false;
                this.resetCallForm();
            }
        },
        async callLog()
        {
            if (this.callLogProcessing === true)  {
                return false;
            }

            this.callLogProcessing = true;

            const result = await this.$store.dispatch('callLeadSubTab', {
                'router':this.$router,
                'leadId': this.leadId,
                'callDeviceType': this.callDeviceType,
                'leadCallCountryCode': this.callCountryCode,
                'leadCallNumber': this.leadCallNumber,
                'callFromDeviceType': this.callDeviceTypeFrom,
                'callNotes': this.callText,
                'callDurationDropdown': this.callDuration,
                'callDurationManual': this.callDurationManual,
            });

            if (parseInt(result.error) === 1) {
                showMessage(result.responseText, true, 3000);
                this.callLogProcessing = false;
                return false;
            } else {
                showMessage(result.responseText, false, 2000);
                this.callLogProcessing = false;
                this.resetCallForm();
            }
        },
        resetCallForm()
        {
            this.callDuration = 0;
            this.callText = '';
            this.callDurationManual = '';
        }
    },
    async created(){
        if (typeof this.localeMapping[this.locale] !== 'undefined') {
            this.$i18n.locale = this.localeMapping[this.locale];
        }

        this.loadData();
    },
    async updated() {
        this.$nextTick(function () {
            this.processPhoneMobileCountryCodesSelectors();
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        })
    }
}
