import {mapGetters} from 'vuex';
import localeMapping from '../../../localizationLanguages';
import pagination from '../../pagination';
export default {
    data () {
        return {
            loadedForm: false,
            loadedGrid: false,
            ruleInfoGrid: false,
            loadedDetails:false,
            presetName: '',
            taskTitle:'',
            taskNotes:'',
            presetId: 0,
            websiteUrl: $('#website_url').val(),
            localeMapping: localeMapping,
            locale: $('#system-language-tasks-config').val()
        }
    },
    components: {
        pagination: pagination
    },
    computed: {
        configDataInfo: function() {
            return this.$store.getters.getConfigDataInfo;
        },
        getAdditionalInfo: function() {
            return this.$store.getters.getAdditionalInfo;
        }
    },
    methods: {
        async ruleDetails(presetId) {

            const result = await this.$store.dispatch('getConfigSavedData', {'router':this.$router, 'presetId':presetId});

            if(result.status === 'error') {
                showMessage('Please re-login', true, 3000);
            } else {
                this.presetId = result.id;
                this.presetName = result.preset_name;
                this.taskTitle = result.task_title;
                this.taskNotes = result.taskNotes;

                this.loadedGrid = false;
                this.loadedDetails = true;
            }

        },
        async saveConfig(e){
            if (this.presetName === '') {
                showMessage(this.$t('message.pleaseSpecifyPresetName'), true, 2000);
                return false;
            }

            if (this.taskTitle === '') {
                showMessage(this.$t('message.pleaseSpecifyTaskTitle'), true, 2000);
                return false;
            }

            const result = await this.$store.dispatch('saveConfigData', {'presetName':this.presetName, 'taskTitle':this.taskTitle, 'taskNotes':this.taskNotes});

            if (result.error == '1') {
                showMessage(result.message, true, 2000);
                return false;
            } else {
                showMessage(result.message, false, 2000);
                this.resetParams();

                const resultConfigData = await this.$store.dispatch('getConfigSavedData', {'router':this.$router});
                if(result.status === 'error') {

                } else {
                    this.loadedGrid = true;
                }
            }
        },
        async updateConfig(presetId) {
            if (this.presetName === '') {
                showMessage(this.$t('message.pleaseSpecifyPresetName'), true, 2000);
                return false;
            }

            if (this.taskTitle === '') {
                showMessage(this.$t('message.pleaseSpecifyTaskTitle'), true, 2000);
                return false;
            }

            const result = await this.$store.dispatch('updateConfigData', {'presetId':presetId, 'presetName':this.presetName, 'taskTitle':this.taskTitle, 'taskNotes':this.taskNotes});

            if (result.error == '1') {
                showMessage(result.message, true, 2000);
                return false;
            } else {
                showMessage(result.message, false, 2000);
            }
        },
        async deleteConfigItem(presetId){
            showConfirm(this.$t('message.areYouSure'), async () => {
                const result = await this.$store.dispatch('deleteConfigRecord', {'id': presetId});

                if (result.status === 'error') {
                    showMessage(result.message, true, 2000);
                    return false;
                } else {
                    showMessage(result.message, false, 2000);
                    const resultConfigData = await this.$store.dispatch('getConfigSavedData', {'router':this.$router});
                    if(result.status === 'error') {

                    } else {
                        this.loadedGrid = true;
                    }
                }
            });
        },
        backToMainGrid() {
            this.renderGrid()
        },
        async renderGrid()
        {
            const result = await this.$store.dispatch('getConfigSavedData', {'router':this.$router});

            if(result.status === 'error') {
                showMessage('Please re-login', true, 3000);
            } else {
                this.loadedDetails = false;
                this.loadedGrid = true;
                this.resetParams();
            }
        },
        resetParams(){
            this.presetName = '';
            this.taskTitle = '';
            this.presetId = 0;
        }

    },
    async created(){
        this.$i18n.locale = this.localeMapping[this.locale];
        this.renderGrid();
    },
    async updated() {
        this.$nextTick(function () {
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        })
    }
}
