export const getConfigSavedData = ({commit, state, dispatch}, payload) => {
    showLoader();

    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadorganizecustomfieldsconfig/',
            'type': 'GET',
            'dataType': 'json',
            'data': {}
        }).done(async  function(response){
            hideLoader();
            if (response.status !== 'error') {
                commit('setConfigLeadsDataInfo', response.organizeCustomFieldsData.leads);
                commit('setConfigOrganizationsDataInfo', response.organizeCustomFieldsData.organizations);
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
}

export const setDraggableCustomFields = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        if(payload.type == 'leads') {
            var customFieldsSort = $('#leads-custom-fields-sortable').find('li');
        } else if(payload.type == 'organizations') {
            var customFieldsSort = $('#organizations-custom-fields-sortable').find('li');
        }

        let draggableParamsIds = [];
        if(customFieldsSort.length) {
            $.each(customFieldsSort, function(key, liEl) {
                let paramId = $(liEl).data('param-id');
                draggableParamsIds.push(paramId);
            });
        }

        $.ajax({
            'url': $('#website_url').val() + 'api/leads/leadorganizecustomfieldsconfig/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'type': payload.type,
                'draggableParamsIds': draggableParamsIds,
                'secureToken': $('#custom-fields-config-token').val()
            }
        }).done(function (response) {
            if (response.responseText.status === 'error') {
                resolve(response);
            } else {
                resolve(response);
            }
        }).fail(function (response) {
            resolve({name: 'login', 'message': 'Please re-login'});
        });
    });
}
