import {mapGetters} from 'vuex';
import localeMapping from '../../../localizationLanguages';
export default {
    data () {
        return {
            loadedGrid: false,
            websiteUrl: $('#website_url').val(),
            customParams: {},
            customTabId: null,
            localeMapping: localeMapping,
            locale: $('#system-language-custom-fields').val()
        }
    },
    components: {
    },
    computed: {
        configLeadsDataInfo: function() {
            return this.$store.getters.getConfigLeadsDataInfo;
        },
        configOrganizationsDataInfo: function() {
            return this.$store.getters.getConfigOrganizationsDataInfo;
        }
    },
    methods: {
        processDragableCustomFields: function (event) {
            let type = event.target.getAttribute('data-type');
            const resultCustomFieldsData = this.$store.dispatch('setDraggableCustomFields', {'type': type});
        }
    },
    async created(){
        if (typeof this.localeMapping[this.locale] !== 'undefined') {
            this.$i18n.locale = this.localeMapping[this.locale];
        }

        const result = await this.$store.dispatch('getConfigSavedData', {'router':this.$router});
        console.log('created', result);
        if(result.status === 'error') {
            showMessage('Please re-login', true, 3000);
        } else {

        }
        if(result.status === 'error') {

        } else {
            this.loadedGrid = true;
            $('#leads-custom-fields-sortable').sortable({
                deactivate: this.processDragableCustomFields
            });
            $('#organizations-custom-fields-sortable').sortable({
                deactivate: this.processDragableCustomFields
            });
        }
    },
    async updated() {
        this.$nextTick(function () {
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        })
    }
}
