import {mapGetters} from 'vuex';
import localeMapping from '../../../localizationLanguages';
import pagination from '../../pagination';
export default {
    data () {
        return {
            loadedForm: false,
            loadedGrid: false,
            ruleInfoGrid: false,
            loadedDetails:false,
            ruleName: '',
            ruleEmail:'',
            imapConfigId: '0',
            ruleId: 0,
            websiteUrl: $('#website_url').val(),
            customParams: {},
            localeMapping: localeMapping,
            locale: $('#system-language-imap-rules').val(),
            ruleElements: [],
            numberOfWordsAfterTheText:{
                '1':'1',
                '2':'2',
                '3':'3',
                '4':'4',
                '5':'5',
                '6':'6',
                '7':'7',
                '8':'8',
                '9':'9',
                '0':'all'
            },
            disableNumberOfWords: {
                'lead_email':'lead_email',
                'lead_mobile_country_code':'lead_mobile_country_code',
                'lead_mobile':'lead_mobile',
                'lead_phone_country_code':'lead_phone_country_code',
                'lead_phone':'lead_phone',
                'lead_country_code':'lead_country_code',
                'lead_social_service_linkedin':'lead_social_service_linkedin',
                'lead_organization_website':'lead_organization_website'
            },
            blockAddRuleButton:false
        }
    },
    components: {
        pagination: pagination
    },
    computed: {
        configDataInfo: function() {
            return this.$store.getters.getConfigDataInfo;
        },
        getAdditionalInfo: function() {
            return this.$store.getters.getAdditionalInfo;
        }
    },
    methods: {
        async ruleDetails(ruleId) {

            const result = await this.$store.dispatch('getConfigSavedData', {'router':this.$router, 'ruleId':ruleId});

            if(result.status === 'error') {
                showMessage('Please re-login', true, 3000);
            } else {
                this.ruleName = result.rule_name;
                this.ruleEmail = result.rule_email;
                this.imapConfigId = result.imapConfigId;
                this.ruleId = result.id;

                if (result.subRulesConfig.length > 0) {
                    this.ruleElements = [];

                    let self = this,
                        disabled = false;

                    _.each(result.subRulesConfig, function (subRule) {
                        disabled = false;

                        if (typeof self.disableNumberOfWords[subRule.assignToAttribute] !== 'undefined') {
                            disabled = true;
                        }

                        self.ruleElements.push({
                            numberOfWords: subRule.numberOfWords,
                            afterTheText: subRule.afterTheText,
                            assignToAttribute: subRule.assignToAttribute,
                            disabled: disabled,
                            stopWord:subRule.stopWord
                        });
                    });
                }

                this.loadedGrid = false;
                this.loadedDetails = true;
            }

        },
        addAdditionalRuleElement: function()
        {
            let assignToAttribute = 'lead_email';
            let assignToAttributes = Object.assign({}, this.getAdditionalInfo.assignToAttributes);
            let disabledNumberOfWords = false;

            if (this.ruleElements.length > 0) {
                _.each(this.ruleElements, function (ruleElem) {
                    delete assignToAttributes[ruleElem.assignToAttribute];
                });

                if (Object.keys(assignToAttributes).length === 0) {
                    this.blockAddRuleButton = true;
                    return false;
                }

                assignToAttribute = Object.keys(assignToAttributes)[0];
            }

            if (typeof this.disableNumberOfWords[assignToAttribute] !== 'undefined') {
                disabledNumberOfWords = true;
            }

            this.ruleElements.push({
                numberOfWords: '1',
                afterTheText: '',
                assignToAttribute:assignToAttribute,
                stopWord:'',
                disabled:disabledNumberOfWords
            });

        },
        changeAssignField: function(event, ruleElement){
            let chosenElement = event.target.value,
                elementExists = false,
                disableNumberOfWords = this.disableNumberOfWords,
                oldVal = ruleElement.assignToAttribute;

            if (this.ruleElements.length > 0) {
                _.each(this.ruleElements, function (ruleElem) {
                    if (chosenElement == ruleElem.assignToAttribute) {
                        elementExists = true;
                        if (typeof disableNumberOfWords[chosenElement] !== 'undefined') {
                            ruleElem.disabled = true;
                            ruleElem.numberOfWords = 1;
                        } else {
                            ruleElem.disabled = false;
                        }
                    }
                });
            }

            if (elementExists === true) {
                if (chosenElement !== oldVal) {
                    ruleElement.assignToAttribute = oldVal;
                    event.target.value = oldVal;
                    showMessage(this.$t('message.youAlreadyHaveARule'), true, 2000);
                }
            } else {
                ruleElement.assignToAttribute = chosenElement;
            }

            _.each(this.ruleElements, function (ruleElem) {
                if (typeof disableNumberOfWords[ruleElem.assignToAttribute] !== 'undefined') {
                    ruleElem.disabled = true;
                    ruleElem.numberOfWords = 1;
                } else {
                    ruleElem.disabled = false;
                }
            });

        },
        deleteRuleElement: function(index)
        {
            this.ruleElements.splice(index,1);
            this.blockAddRuleButton = false;
        },
        async updateRule(ruleId) {
            if (this.ruleName === '') {
                showMessage(this.$t('message.pleaseSpecifyRuleName'), true, 2000);
                return false;
            }

            // if (this.ruleEmail === '') {
            //     showMessage(this.$t('message.pleaseSpecifyEmail'), true, 2000);
            //     return false;
            // }

            if (parseInt(this.imapConfigId) === 0) {
                showMessage(this.$t('message.pleaseChooseImapConfig'), true, 2000);
                return false;
            }

            if (this.ruleElements.length < 1){
                showMessage(this.$t('message.pleaseSpecifyAtLeastOneRule'), true, 2000);
                return false;
            }

            let missingEmailAssignField = true,
                missingFirstNameEmailField = true,
                missingSearchableText = false;

            _.each(this.ruleElements, function(ruleElem){
                if (ruleElem.assignToAttribute === 'lead_email') {
                    missingEmailAssignField = false;
                }
                if (ruleElem.assignToAttribute === 'lead_first_name') {
                    missingFirstNameEmailField = false;
                }

                if (ruleElem.afterTheText == '') {
                    missingSearchableText = true;
                }
            });

            if (missingEmailAssignField === true) {
                showMessage(this.$t('message.pleaseAssignLeadEmailField'), true, 2000);
                return false;
            }

            if (missingFirstNameEmailField === true) {
                showMessage(this.$t('message.pleaseAssignLeadFirstNameField'), true, 2000);
                return false;
            }

            if (missingSearchableText === true) {
                showMessage(this.$t('message.pleaseSpecifySearchableText'), true, 2000);
                return false;
            }

            const result = await this.$store.dispatch('updateConfigData', {'ruleName':this.ruleName, 'ruleEmail':this.ruleEmail, 'imapConfigId':this.imapConfigId, 'ruleElements':this.ruleElements, 'ruleId':ruleId});

            if (result.error == '1') {
                showMessage(result.message, true, 2000);
                return false;
            } else {
                showMessage(result.message, false, 2000);
            }
        },
        async addNewRule(e){

            if (this.ruleName === '') {
                showMessage(this.$t('message.pleaseSpecifyRuleName'), true, 2000);
                return false;
            }

            // if (this.ruleEmail === '') {
            //     showMessage(this.$t('message.pleaseSpecifyEmail'), true, 2000);
            //     return false;
            // }

            if (parseInt(this.imapConfigId) === 0) {
                showMessage(this.$t('message.pleaseChooseImapConfig'), true, 2000);
                return false;
            }

            if (this.ruleElements.length < 1){
                showMessage(this.$t('message.pleaseSpecifyAtLeastOneRule'), true, 2000);
                return false;
            }

            let missingEmailAssignField = true,
                missingFirstNameEmailField = true,
                missingSearchableText = false;

            _.each(this.ruleElements, function(ruleElem){
                if (ruleElem.assignToAttribute === 'lead_email') {
                    missingEmailAssignField = false;
                }
                if (ruleElem.assignToAttribute === 'lead_first_name') {
                    missingFirstNameEmailField = false;
                }
                if (ruleElem.afterTheText == '') {
                    missingSearchableText = true;
                }
            });

            if (missingEmailAssignField === true) {
                showMessage(this.$t('message.pleaseAssignLeadEmailField'), true, 2000);
                return false;
            }

            if (missingFirstNameEmailField === true) {
                showMessage(this.$t('message.pleaseAssignLeadFirstNameField'), true, 2000);
                return false;
            }

            if (missingSearchableText === true) {
                showMessage(this.$t('message.pleaseSpecifySearchableText'), true, 2000);
                return false;
            }

            const result = await this.$store.dispatch('saveConfigData', {'ruleName':this.ruleName, 'ruleEmail':this.ruleEmail, 'imapConfigId':this.imapConfigId, 'ruleElements':this.ruleElements});

            if (result.error == '1') {
                showMessage(result.message, true, 2000);
                return false;
            } else {
                showMessage(result.message, false, 2000);
                this.resetParams();

                const resultConfigData = await this.$store.dispatch('getConfigSavedData', {'router':this.$router});
                if(result.status === 'error') {

                } else {
                    this.loadedGrid = true;
                }
            }
        },
        async deleteConfigItem(id){
            showConfirm(this.$t('message.areYouSure'), async () => {
                const result = await this.$store.dispatch('deleteConfigRecord', {'id': id});

                if (result.status === 'error') {
                    showMessage(result.message, true, 2000);
                    return false;
                } else {
                    showMessage(result.message, false, 2000);
                    const resultConfigData = await this.$store.dispatch('getConfigSavedData', {'router':this.$router});
                    if(result.status === 'error') {

                    } else {
                        this.loadedGrid = true;
                    }
                }
            });
        },
        backToMainGrid() {
            this.renderGrid()
        },
        async renderGrid()
        {
            const result = await this.$store.dispatch('getConfigSavedData', {'router':this.$router});

            if(result.status === 'error') {
                showMessage('Please re-login', true, 3000);
            } else {
                this.loadedDetails = false;
                this.loadedGrid = true;
                this.resetParams();
            }
        },
        resetParams(){
            this.ruleElements = [];
            this.ruleName = '';
            this.ruleEmail = '';
            this.imapConfigId = '0';
            this.ruleId = 0;
        }

    },
    async created(){
        if (typeof this.localeMapping[this.locale] !== 'undefined') {
            this.$i18n.locale = this.localeMapping[this.locale];
        }
        this.renderGrid();
    },
    async updated() {
        this.$nextTick(function () {
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        })
    }
}
