import {mapGetters} from 'vuex';
//import lodash from 'lodash';
import localeMapping from '../../../localizationLanguages';
import pagination from '../../pagination';
import userli from '../userli';
export default {
    data () {
        return {
            loadedScreen: false,
            leadOwnerId: 0,
            companyName: '',
            websiteUrl: $('#website_url').val(),
            localeMapping: localeMapping,
            locale: $('#system-language-goal-app').val()
        }
    },
    components: {
        pagination: pagination,
        userli: userli
    },
    computed: {
        ...mapGetters({
            formatDate: 'formatDate',
            configDataInfo:'getConfigDataInfo',
            additionalInfo: 'getAdditionalInfo',
            globalStats: 'getGlobalStats',
            sortByColumn: 'sortByColumn'
        }),
    },
    methods: {
        async addNewOwner(){
            if(this.leadOwnerId == '0') {
                showMessage(this.$t('message.specifyOwner'), true, 2000);
                return false;
            }

            const result = await this.$store.dispatch('addLeadOwner', {
                'user_id':this.leadOwnerId
            });

            if (result.status === 'error') {
                showMessage(result.message, true, 2000);
                return false;
            } else {
                showMessage(result.message, false, 2000);
                const resultConfigData = await this.$store.dispatch('getConfigSavedData', {'router':this.$router});
                if(result.status === 'error') {

                } else {
                    this.loadedScreen = true;
                    this.leadOwnerId = 0;
                    if (this.configDataInfo.length == 1) {
                        this.$router.push({name: 'goalsdetails', params: {'id': this.configDataInfo[0].id}});
                    }
                }
            }
        }
    },
    async created(){
        if (typeof this.localeMapping[this.locale] !== 'undefined') {
            this.$i18n.locale = this.localeMapping[this.locale];
        }

        const result = await this.$store.dispatch('getConfigSavedData', {'router':this.$router});
        if(result.status === 'error') {
            showMessage('Please re-login', true, 3000);
        } else {
            this.loadedScreen = true;
            if (this.configDataInfo.length > 0) {
                let configData = this.sortByColumn(this.configDataInfo, 'full_name');
                this.$router.push({name: 'goalsdetails', params: {'id': configData[0].id}});
            }
        }

    },
    async updated() {
        this.$nextTick(function () {
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        })
    }
}
