
export const saveConfigData = ({commit, state, dispatch}, payload) => {
    showLoader();
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val() + 'api/leads/leadcustomtabsconfig/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken' : $('#custom-fields-config-token').val(),
                'customTabFieldType': payload.customTabFieldType,
                'customTabName': payload.customTabName,
                'customTabLabel': payload.customTabLabel
            }
        }).done(async function (response) {
            hideLoader();
            if (response.status === 'error') {
                resolve(response);
            } else {
                resolve(response);
            }

        }).fail(async function(response){
            hideLoader();
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
}

export const deleteConfigRecord = ({commit, state, dispatch}, payload) => {
        showLoader();
        return new Promise((resolve, reject) => {
            $.ajax({
                'url': $('#website_url').val() + 'api/leads/leadcustomtabsconfig/id/' + payload.id+'/secureToken/'+ $('#custom-fields-config-token').val(),
                'type': 'DELETE',
                'dataType': 'json'
            }).done(async function (response) {
                hideLoader();
                if (response.status === 'error') {
                    resolve(response);
                } else {
                    resolve(response);
                }

            }).fail(async function (response) {
                hideLoader();
                resolve({name: 'login', 'message': 'Please re-login'});
            });
        });
}

export const getConfigSavedData = ({commit, state, dispatch}, payload) => {
    showLoader();

    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadcustomtabsconfig/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'limit': state.pagination.customTabsConfig.itemsPerPage,
                'offset': (state.pagination.customTabsConfig.currentPage - 1) * state.pagination.customTabsConfig.itemsPerPage
            }
        }).done(async  function(response){
            hideLoader();
            if (response.status !== 'error') {
                commit('setPaginationData', {customTabsConfig: {totalItems: response.customTabsData.totalRecords}});
                commit('setConfigDataInfo', response.customTabsData.data);
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
}

export const updateTabLabel = ({commit, state, dispatch}, payload) => {
    showLoader();

    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadcustomtabsconfig/',
            'type': 'PUT',
            'dataType': 'json',
            'data': JSON.stringify({
                'id': payload.id,
                'tabLabel': payload.tabLabel,
                'secureToken': $('#custom-fields-config-token').val()
            })
        }).done(function(response){
            hideLoader();
            if (response.status === 'error') {
                resolve(response);
            } else {
                resolve(response);
            }
        }).fail(async function(response){
            hideLoader();
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
}

export const getCustomFieldsData = ({commit, state, dispatch}, payload) => {
    showLoader();
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val() + 'api/leads/leadcustomtabsfields/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'id': payload.id,
                'secureToken': $('#custom-fields-config-token').val()
            }
        }).done(async function (response) {
            hideLoader();
            if (response.status === 'error') {
                resolve(response);
            } else {
                resolve(response);
            }
        }).fail(async function (response) {
            hideLoader();
            resolve({name: 'login', 'message': 'Please re-login'});
        });
    });
}

export const updateCustomField = ({commit, state, dispatch}, payload) => {
    showLoader();
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val() + 'api/leads/leadcustomtabsfields/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'customTabId': payload.customTabId,
                'customFieldId': payload.customFieldId,
                'tabType': payload.tabType,
                'secureToken': $('#custom-fields-config-token').val()
            }
        }).done(async function (response) {
            hideLoader();
            if (response.status === 'error') {
                resolve(response);
            } else {
                resolve(response);
            }
        }).fail(async function (response) {
            hideLoader();
            resolve({name: 'login', 'message': 'Please re-login'});
        });
    });
}
export const setDraggableCustomFieldsData = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        let customFieldsSort = $('#custom-fields-tabs-sortable').find('li'),
            draggableParamsIds = [];
        if(customFieldsSort.length) {
            $.each(customFieldsSort, function(key, liEl) {
                let paramId = $(liEl).data('param-id');
                draggableParamsIds.push(paramId);
            });
        }

        $.ajax({
            'url': $('#website_url').val() + 'plugin/leads/run/saveDraggableCustomTabsFields/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'id': payload.customTabId,
                'draggableParamsIds': draggableParamsIds,
                'secureToken': $('#custom-fields-config-token').val()
            }
        }).done(function (response) {
            if (response.responseText.status === 'error') {
                resolve(response);
            } else {
                resolve(response);
            }
        }).fail(function (response) {
            resolve({name: 'login', 'message': 'Please re-login'});
        });
    });
}
