export const saveConfigData = ({commit, state, dispatch}, payload) => {
    showLoader();
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val() + 'api/leads/leadapiaccess/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken' : $('#lead-api-config-token').val(),
                'userId': payload.userId,
                'ipAddresses': payload.ipAddresses
            }
        }).done(async function (response) {
            hideLoader();
            if (response.status === 'error') {
                resolve(response);
            } else {
                resolve(response);
            }

        }).fail(async function(response){
            hideLoader();
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
}

export const deleteAllActiveTokens = ({commit, state, dispatch}, payload) => {
    showLoader();
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val() + 'api/leads/leadapitokens/id/' + payload.id+'/secureToken/'+ $('#lead-api-config-token').val(),
            'type': 'DELETE',
            'dataType': 'json'
        }).done(async function (response) {
            hideLoader();
            if (response.status === 'error') {
                resolve(response);
            } else {
                resolve(response);
            }

        }).fail(async function (response) {
            hideLoader();
            resolve({name: 'login', 'message': 'Please re-login'});
        });
    });
}

export const deleteConfigRecord = ({commit, state, dispatch}, payload) => {
        showLoader();
        return new Promise((resolve, reject) => {
            $.ajax({
                'url': $('#website_url').val() + 'api/leads/leadapiaccess/id/' + payload.id+'/secureToken/'+ $('#lead-api-config-token').val(),
                'type': 'DELETE',
                'dataType': 'json'
            }).done(async function (response) {
                hideLoader();
                if (response.status === 'error') {
                    resolve(response);
                } else {
                    resolve(response);
                }

            }).fail(async function (response) {
                hideLoader();
                resolve({name: 'login', 'message': 'Please re-login'});
            });
        });
}

export const getConfigSavedData = ({commit, state, dispatch}, payload) => {
    showLoader();

    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadapiaccess/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'limit': state.pagination.apiAccessConfig.itemsPerPage,
                'offset': (state.pagination.apiAccessConfig.currentPage - 1) * state.pagination.apiAccessConfig.itemsPerPage
            }
        }).done(async  function(response){
            hideLoader();
            if (response.status !== 'error') {
                console.log(response);
                commit('setPaginationData', {apiAccessConfig: {totalItems: response.apiAccessData.totalRecords}});
                commit('setConfigDataInfo', response.apiAccessData.data);
                commit('setUsersList', response.apiAccessData.usersList);
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
}

