import {mapGetters} from 'vuex';
import lodash from 'lodash';
import localeMapping from '../../../localizationLanguages';
import pagination from '../../pagination';
export default {
    data () {
        return {
            loadedForm: false,
            loadedGrid: false,
            addConfigBtnLabel: 'Add',
            cancelUpdate: false,
            isUpdate: false,
            emailsPath: '',
            historicalEmailsPath: '',
            statusConnection: 'loading...',
            imapId: 0,
            serviceName: '',
            leadOwner: 0,
            host: '',
            login: '',
            password: '',
            encryption: 'none',
            processAllEmails: false,
            websiteUrl: $('#website_url').val(),
            verificationDone: false,
            disabledOwner: false,
            localeMapping: localeMapping,
            locale: $('#system-language-sales-imap').val()
        }
    },
    components: {
        pagination: pagination
    },
    computed: {
        configDataInfo: function() {
            return this.$store.getters.getConfigDataInfo;
        },
        leadOwners: function() {
            return this.$store.getters.getLeadOwners;
        }
    },
    methods: {
        async imapCopyPathInfo(param, event){
            event.preventDefault();

            let emailPath = '';

            if(param == 'emailsPath') {
                emailPath = this.emailsPath;
            } else {
                emailPath = this.historicalEmailsPath;
            }

            if (document.queryCommandSupported("copy")) {
                let copyFromEl = $('<textarea/>');
                copyFromEl.text(emailPath);
                $('body').append(copyFromEl);
                copyFromEl.select();
                document.execCommand('copy', true);
                copyFromEl.remove();
                showMessage(this.$t('message.copiedToClipboard'), false, 2000);
            }

            return true;
        },
        async deleteConfigItem(id){
            showConfirm('Are you sure want to delete?', async () => {
                const result = await this.$store.dispatch('deleteConfigRecord', {'id': id});
                console.log('deleteTab',result);
                if (result.status === 'error') {
                    showMessage(result.message, true, 2000);
                    return false;
                } else {
                    showMessage(result.message, false, 2000);
                    const resultConfigData = await this.$store.dispatch('getConfigSavedData', {'router':this.$router});
                    if(result.status === 'error') {

                    } else {
                        this.loadedGrid = true;

                        this.imapId = 0;
                        this.serviceName = '';
                        this.leadOwner = 0;
                        this.host = '';
                        this.login = '';
                        this.password = '';
                        this.encryption = 'none';
                        this.processAllEmails = false;

                        this.addConfigBtnLabel = 'Add';
                        this.cancelUpdate =  false;
                    }
                }
            });
        },
        async checkImapStatus(id){
                const result = await this.$store.dispatch('checkImapStatusData', {'id': id});
                console.log('checkImapStatusData',result);
                if (result.status === 'error') {
                    showMessage(result.message, true, 2000);
                    return false;
                } else {
                    var self = this;
                    let connectionStatus = result.responseText.connectionStatus;
                    _.each(connectionStatus, function(status, key){
                        let statusColor = (status == 'Connected') ? 'success' : 'error';

                        self.$refs['connection-list-'+ key][0].className = statusColor;
                        self.$refs['connection-list-'+ key][0].innerText = status;
                    });
                }
        },
        async addNewImapConfig(){
            let countConfigRows = this.configDataInfo.length;
            let serviceName = this.serviceName;
            this.leadOwner = this.$refs['owner_id'][0].value;
            let host = this.host;
            let login = this.login;
            let password = this.password;

            if(countConfigRows == 3 && !this.isUpdate) {
                showMessage(this.$t('message.limitWasExceeded'), true, 2000);
                return false;
            }

            if(serviceName == '') {
                showMessage(this.$t('message.notEmptyService'), true, 2000);
                return false;
            }

            if(this.leadOwner == '') {
                showMessage(this.$t('message.selectLeadOwner'), true, 2000);
                return false;
            }

            if(host == '') {
                showMessage(this.$t('message.notEmptyHost'), true, 2000);
                return false;
            }

            if(login == '') {
                showMessage(this.$t('message.notEmptyLogin'), true, 2000);
                return false;
            }


            if(password == '' && !this.isUpdate) {
                showMessage(this.$t('message.notEmptyPassword'), true, 2000);
                return false;
            }

            let imapAction = 'saveConfigData';
            if(this.isUpdate) {
                imapAction = 'updateImapConfig';
            }

            const result = await this.$store.dispatch(imapAction, {
                'imapId'            :this.imapId,
                'serviceName'       :this.serviceName.replace(/[^a-zA-Z0-9-_ ]/g, ''),
                'leadOwner'         :this.leadOwner,
                'host'              :this.host,
                'login'             :this.login,
                'password'          :this.password,
                'encryption'        :this.encryption,
                'processAllEmails'  :(this.processAllEmails) ? 1 : 0
            });

            console.log(imapAction,result);

            if (result.status === 'error') {
                showMessage(result.message, true, 2000);
                return false;
            } else {
                this.imapId = 0;
                this.serviceName = '';
                this.leadOwner = 0;
                this.host = '';
                this.login = '';
                this.password = '';
                this.encryption = 'none';
                this.processAllEmails = false;

                this.addConfigBtnLabel = 'Add';
                this.cancelUpdate =  false;
                this.isUpdate = false;

                showMessage(result.message, false, 2000);

                const resultConfigData = await this.$store.dispatch('getConfigSavedData', {'router':this.$router});
                if(result.status === 'error') {

                } else {
                    this.loadedGrid = true;

                    this.verificationDone = false;

                    if(!this.verificationDone) {
                        var imapConfigInfo = this.$store.getters.getConfigDataInfo;
                        if(imapConfigInfo.length) {
                            var self = this;
                            _.each(imapConfigInfo, function(config, key){
                                self.checkImapStatus(config.id);
                            });
                        }

                        this.verificationDone = true;
                    }
                }
            }
        },
        async updateServiceName(id, oldName, event) {
            event.preventDefault();
            let serviceParam = event.target.value;

            serviceParam = serviceParam.replace(/[^a-zA-Z0-9'-_ ]/g, '');

            if(serviceParam.length < 1) {
                showMessage(this.$t('message.notEmptyPassword'), true, 2000);
                event.target.value = oldName;
                return false;
            } else {
                const result = await this.$store.dispatch('updateImapServiceName', {'id': id, 'serviceName': serviceParam});
                console.log('updateImapServiceName',result);

                if (result.status === 'error') {
                    event.target.value = oldName;
                    showMessage(result.message, true, 2000);
                    return false;
                } else {
                    event.target.value = serviceParam;
                    showMessage(result.message, false, 2000);

                    this.imapId = 0;
                    this.serviceName = '';
                    this.leadOwner = 0;
                    this.host = '';
                    this.login = '';
                    this.password = '';
                    this.encryption = 'none';
                    this.processAllEmails = false;

                    this.addConfigBtnLabel = 'Add';
                    this.cancelUpdate =  false;

                    return true;
                }
            }
        },
        async editImapConfig(id){
            const result = await this.$store.dispatch('getConfigSavedData', {'router':this.$router});
            console.log('editImapConfig', result);
            if(result.status === 'error') {
                showMessage(this.$t('message.pleaseRelogin'), true, 3000);
            } else {
                var self = this;

                if(result.data.length) {
                    _.each(result.data, function(data, key){
                        if(data.id == id) {
                            self.imapId = data.id;
                            self.serviceName = data.service_name;
                            self.leadOwner = data.owner_id;
                            self.host = data.host;
                            self.login = data.login;
                            self.encryption = data.encryption;

                            self.processAllEmails = false;
                            if(data.process_all_emails == 1) {
                                self.processAllEmails = true;
                            }

                            self.addConfigBtnLabel = 'Update';
                            self.cancelUpdate = true;
                            self.isUpdate = true;
                        }
                    });
                }
            }
        },
        async cancelUpdateConfig() {
            this.imapId = 0;
            this.serviceName = '';
            this.leadOwner = 0;
            this.host = '';
            this.login = '';
            this.password = '';
            this.encryption = 'none';
            this.processAllEmails = false;

            this.addConfigBtnLabel = 'Add';
            this.cancelUpdate =  false;
            this.isUpdate = false;
        }
    },
    async created(){
        if (typeof this.localeMapping[this.locale] !== 'undefined') {
            this.$i18n.locale = this.localeMapping[this.locale];
        }

        const result = await this.$store.dispatch('getConfigSavedData', {'router':this.$router});

        console.log('created', result);
        if(result.status === 'error') {
            showMessage(this.$t('message.pleaseRelogin'), true, 3000);
        } else {
            this.loadedForm = true;
            this.emailsPath = result.emailsPath;
            this.historicalEmailsPath = result.historicalEmailsPath;
        }
        if(result.status === 'error') {

        } else {
            this.loadedGrid = true;

            if(!this.verificationDone) {
                var imapConfigInfo = this.$store.getters.getConfigDataInfo;
                if(imapConfigInfo.length) {
                    var self = this;
                    _.each(imapConfigInfo, function(config, key){
                        self.checkImapStatus(config.id);
                    });
                }

                this.verificationDone = true;
            }
        }
    },
    async updated() {
        this.$nextTick(function () {
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        })
    }
}
