import {mapGetters} from 'vuex';
import lodash from 'lodash';
import localeMapping from '../../../localizationLanguages';
import pagination from '../../pagination';
export default {
    data () {
        return {
            loadedForm: false,
            loadedGrid: false,
            leadOwnerId: 0,
            password: '',
            websiteUrl: $('#website_url').val(),
            localeMapping: localeMapping,
            locale: $('#system-language-mobile-app').val()
        }
    },
    components: {
        pagination: pagination
    },
    computed: {
        configDataInfo: function() {
            return this.$store.getters.getConfigDataInfo;
        },
        leadOwners: function() {
            return this.$store.getters.getLeadOwners;
        },
        leadOwnersDropdown: function() {
            return this.$store.getters.getLeadOwnersDropdown;
        }
    },
    methods: {
        async updateConfig(id, status){

            if (status === 'disabled') {
                return false;
            }

            const result = await this.$store.dispatch('updateConfigData', {
                'id':id
            });

            if (result.status === 'error') {
                showMessage(result.message, true, 2000);
                return false;
            } else {
                this.password = '';

                showMessage(result.message, false, 2000);

                const resultConfigData = await this.$store.dispatch('getConfigSavedData', {'router':this.$router});
                if(result.status === 'error') {

                } else {
                    this.loadedGrid = true;
                }
            }

        },
        async changeAppAccessStatus(id, event){

            let status = event.target.checked,
                message = this.$t('message.changeStatusEnabled');

            if (status === false) {
                message = this.$t('message.changeStatusDisabled');
            }

            showConfirm(message, async () => {
                if (status === true) {
                    status = 'enabled';
                } else {
                    status = 'disabled';
                }

                const result = await this.$store.dispatch('changeConfigData', {'id': id, 'status':status});
                if (result.status === 'error') {
                    showMessage(result.message, true, 2000);
                    if (status === 'enabled') {
                        event.target.checked = false;
                    } else {
                        event.target.checked = true;
                    }
                    return false;
                } else {
                    showMessage(result.message, false, 2000);
                    const resultConfigData = await this.$store.dispatch('getConfigSavedData', {'router':this.$router});
                    if(result.status === 'error') {

                    } else {
                        this.loadedGrid = true;
                    }
                }
            }, function() {
                if (status === true) {
                    event.target.checked = false;
                } else {
                    event.target.checked = true;
                }
            });
        },
        async changeSocialAppAccessStatus(id, event){

            let status = event.target.checked,
                message = this.$t('message.changeSocialAppStatusEnabled');

            if (status === false) {
                message = this.$t('message.changeSocialAppStatusDisabled');
            }

            showConfirm(message, async () => {
                if (status === true) {
                    status = 'enabled';
                } else {
                    status = 'disabled';
                }

                const result = await this.$store.dispatch('changeSocialAppAccess', {'id': id, 'socialAppStatus':status});
                if (result.status === 'error') {
                    console.log(result.message);
                    showMessage(result.message, true, 2000);
                    if (status === 'enabled') {
                        event.target.checked = false;
                    } else {
                        event.target.checked = true;
                    }
                    return false;
                } else {
                    showMessage(result.message, false, 2000);
                    const resultConfigData = await this.$store.dispatch('getConfigSavedData', {'router':this.$router});
                    if(result.status === 'error') {

                    } else {
                        this.loadedGrid = true;
                    }
                }
            }, function() {
                if (status === true) {
                    event.target.checked = false;
                } else {
                    event.target.checked = true;
                }
            });
        },
        async addNewConfig(){
            if(this.leadOwnerId == '0') {
                showMessage(this.$t('message.specifyLeadOwner'), true, 2000);
                return false;
            }

            const result = await this.$store.dispatch('saveConfigData', {
                'leadOwnerId':this.leadOwnerId
            });

            if (result.status === 'error') {
                showMessage(result.message, true, 2000);
                return false;
            } else {
                this.password = '';

                showMessage(result.message, false, 2000);

                const resultConfigData = await this.$store.dispatch('getConfigSavedData', {'router':this.$router});
                if(result.status === 'error') {

                } else {
                    this.leadOwnerId = 0;
                    this.loadedGrid = true;
                }
            }
        }
    },
    async created(){
        this.$i18n.locale = this.localeMapping[this.locale];

        const result = await this.$store.dispatch('getConfigSavedData', {'router':this.$router});
        if(result.status === 'error') {
            showMessage('Please re-login', true, 3000);
        } else {
            this.loadedForm = true;
        }
        if(result.status === 'error') {

        } else {
            this.loadedGrid = true;
        }

    },
    async updated() {
        this.$nextTick(function () {
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        })
    }
}
