
export const saveConfigData = ({commit, state, dispatch}, payload) => {
    showLoader();
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val() + 'api/leads/leadadvertiseraccountsconfig/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken' : $('#advertiser-account-config-token').val(),
                'adAccountId': payload.adAccountId,
                'account': payload.account
            }
        }).done(async function (response) {
            hideLoader();
            if (response.status === 'error') {
                resolve(response);
            } else {
                resolve(response);
            }

        }).fail(async function(response){
            hideLoader();
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
}

export const addListToAccount = ({commit, state, dispatch}, payload) => {
    showLoader();
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val() + 'plugin/leads/run/addAdvertiserlist/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken' : $('#advertiser-account-config-token').val(),
                'listName': payload.listName,
                'account': payload.account
            }
        }).done(async function (response) {
            hideLoader();
            if (response.responseText.status === 'error') {
                resolve(response.responseText);
            } else {
                resolve(response.responseText);
            }

        }).fail(async function(response){
            hideLoader();
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
}

export const deleteConfigRecord = ({commit, state, dispatch}, payload) => {
        showLoader();
        return new Promise((resolve, reject) => {
            $.ajax({
                'url': $('#website_url').val() + 'api/leads/leadadvertiseraccountsconfig/id/' + payload.id+'/secureToken/'+ $('#advertiser-account-config-token').val(),
                'type': 'DELETE',
                'dataType': 'json'
            }).done(async function (response) {
                hideLoader();
                if (response.status === 'error') {
                    resolve(response);
                } else {
                    resolve(response);
                }
            }).fail(async function (response) {
                hideLoader();
                resolve({name: 'login', 'message': 'Please re-login'});
            });
        });
}

export const getConfigSavedData = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadadvertiseraccountsconfig/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'limit': state.pagination.advertiserAccountsConfig.itemsPerPage,
                'offset': (state.pagination.advertiserAccountsConfig.currentPage - 1) * state.pagination.advertiserAccountsConfig.itemsPerPage
            }
        }).done(async  function(response){
            if (response.status !== 'error') {
                commit('setPaginationData', {advertiserAccountsConfig: {totalItems: response.advertiserAccountsConfig.totalRecords}});
                commit('setConfigDataInfo', response.advertiserAccountsConfig.data);
                commit('setAdvertiserTypes', response.advertiserTypes);
                resolve(response);
            } else {
                resolve(response);
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
}

export const getVerification = ({commit, state, dispatch}, payload) => {
    showLoader();
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val() + 'plugin/leads/run/checkAdvertiserConnection/',
            'type': 'POST',
            'dataType': 'json',
            'data': {'advertiserId' : payload.id},
        }).done(async function (response) {
            hideLoader();
            if (response.error == 1) {
                resolve(response.responseText);
            } else {
                resolve(response.responseText);
            }
        }).fail(async function (response) {
            hideLoader();
            resolve({name: 'login', 'message': 'Please re-login'});
        });
    });
}

export const checkAdvertiserConnectionAccounts = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val() + 'plugin/leads/run/checkAdvertiserConnectionAccounts/',
            'type': 'POST',
            'dataType': 'json',
            'data': {},
        }).done(async function (response) {
            resolve(response.responseText);
        }).fail(async function (response) {
            resolve({name: 'login', 'message': 'Please re-login'});
        });
    });
}

export const getAdvAccountConnectionStatus = ({commit, state, dispatch}, payload) => {
    showLoader();
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val() + 'plugin/leads/run/getAdvAccountConnectionStatus/',
            'type': 'POST',
            'dataType': 'json',
            'data': {'advertiserType' : payload.advertiserType},
        }).done(async function (response) {
            hideLoader();
            if (response.error == 1) {
                resolve(response.responseText);
            } else {
                resolve(response.responseText);
            }
        }).fail(async function (response) {
            hideLoader();
            resolve({name: 'login', 'message': 'Please re-login'});
        });
    });
}

export const getAdvAccountCreatedListsData = ({commit, state, dispatch}, payload) => {
    showLoader();
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val() + 'plugin/leads/run/getAdvertisingService/',
            'type': 'POST',
            'dataType': 'json',
            'data': {'serviceName' : payload.serviceName},
        }).done(async function (response) {
            hideLoader();
            if (response.error == 1) {
                resolve(response.responseText);
            } else {
                resolve(response.responseText);
            }
        }).fail(async function (response) {
            hideLoader();
            resolve({name: 'login', 'message': 'Please re-login'});
        });
    });
}
