CREATE TABLE IF NOT EXISTS `plugin_leads_industry` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `label` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `type` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_lead_organization` (
`id` INT(10) UNSIGNED AUTO_INCREMENT,
`organization_name` VARCHAR (255) COLLATE utf8_unicode_ci NOT NULL,
`organization_address` VARCHAR (255) COLLATE utf8_unicode_ci DEFAULT NULL,
`organization_address1` VARCHAR (255) COLLATE utf8_unicode_ci DEFAULT NULL,
`organization_city` VARCHAR (255) COLLATE utf8_unicode_ci DEFAULT NULL,
`organization_domain` VARCHAR (64) COLLATE utf8_unicode_ci DEFAULT NULL,
`organization_domain1` VARCHAR (64) COLLATE utf8_unicode_ci DEFAULT NULL,
`organization_zip` VARCHAR (255) COLLATE utf8_unicode_ci DEFAULT NULL,
`organization_country_code` CHAR (2) COLLATE utf8_unicode_ci DEFAULT NULL,
`organization_state_code` VARCHAR (3) COLLATE utf8_unicode_ci DEFAULT NULL,
`organization_url` VARCHAR (255) COLLATE utf8_unicode_ci DEFAULT NULL,
`organization_email` VARCHAR (255) COLLATE utf8_unicode_ci DEFAULT NULL,
`organization_employees` INT (10) DEFAULT NULL,
`organization_state_id` INT (10) DEFAULT NULL,
`customer_group_id` INT(10) UNSIGNED DEFAULT NULL,
`organization_website` VARCHAR (255) COLLATE utf8_unicode_ci DEFAULT NULL,
`organization_website1` VARCHAR (255) COLLATE utf8_unicode_ci DEFAULT NULL,
`created_at` TIMESTAMP NULL,
`updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE NOW(),
`organization_industry_id` INT (10) UNSIGNED DEFAULT NULL,
`organization_phone` VARCHAR(20) COLLATE utf8_unicode_ci DEFAULT NULL,
`organization_phone_country_code` CHAR(2) COLLATE utf8_unicode_ci DEFAULT NULL,
`organization_phone_country_code_value` VARCHAR(4) COLLATE utf8_unicode_ci DEFAULT NULL,
`organization_phone_extension` VARCHAR(10) COLLATE utf8_unicode_ci DEFAULT NULL,
`organization_mobile` VARCHAR(20) COLLATE utf8_unicode_ci DEFAULT NULL,
`organization_mobile_country_code` CHAR(2) COLLATE utf8_unicode_ci DEFAULT NULL,
`organization_mobile_country_code_value` VARCHAR(4) COLLATE utf8_unicode_ci DEFAULT NULL,
`organization_notes` TEXT COLLATE utf8_unicode_ci DEFAULT NULL,
`external_id` VARCHAR (255) COLLATE utf8_bin DEFAULT NULL,
`creation_type` ENUM('local', 'import', 'user') DEFAULT 'local',
`primary_contact_id` INT(10) UNSIGNED DEFAULT NULL,
`first_contact_creation_date` TIMESTAMP NULL,
`address_hash` CHAR(40) NOT NULL,
`lat` VARCHAR(100) DEFAULT NULL,
`lng` VARCHAR(100) DEFAULT NULL,
`last_coordinates_processed_date` TIMESTAMP NULL DEFAULT '0000-00-00 00:00:00',
PRIMARY KEY(`id`),
UNIQUE(`organization_name`),
UNIQUE(`external_id`),
FOREIGN KEY (`organization_industry_id`) REFERENCES `plugin_leads_industry` (`id`) ON DELETE SET NULL ON UPDATE NO ACTION,
FOREIGN KEY (`customer_group_id`) REFERENCES `shopping_group` (`id`) ON DELETE SET NULL ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_stage` (
`id` INT(10) UNSIGNED AUTO_INCREMENT,
`stage_name` VARCHAR(255) DEFAULT NULL,
`default` ENUM('0', '1') DEFAULT '0',
PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_data` (
`id` INT(10) UNSIGNED AUTO_INCREMENT,
`lead_first_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
`lead_last_name` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL,
`middle_name` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL,
`prefix` VARCHAR (255) COLLATE utf8_unicode_ci DEFAULT NULL,
`lead_email` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL,
`lead_secondary_email` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL,
`lead_phone` VARCHAR(20) COLLATE utf8_unicode_ci DEFAULT NULL,
`lead_phone_country_code` CHAR(2) COLLATE utf8_unicode_ci DEFAULT NULL,
`lead_phone_country_code_value` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL,
`lead_phone_extension` VARCHAR(10) COLLATE utf8_unicode_ci DEFAULT NULL,
`lead_mobile` VARCHAR(20) COLLATE utf8_unicode_ci DEFAULT NULL,
`lead_mobile_country_code` CHAR(2) COLLATE utf8_unicode_ci DEFAULT NULL,
`lead_mobile_country_code_value` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL,
`lead_source` TEXT COLLATE utf8_unicode_ci DEFAULT NULL,
`lead_utm_source` TEXT COLLATE utf8_unicode_ci DEFAULT NULL,
`lead_utm_medium` TEXT COLLATE utf8_unicode_ci DEFAULT NULL,
`lead_utm_campaign` TEXT COLLATE utf8_unicode_ci DEFAULT NULL,
`lead_utm_term` TEXT COLLATE utf8_unicode_ci DEFAULT NULL,
`lead_utm_content` TEXT COLLATE utf8_unicode_ci DEFAULT NULL,
`lead_notes` TEXT COLLATE utf8_unicode_ci DEFAULT NULL,
`lead_position` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL,
`lead_zip` VARCHAR (10) COLLATE utf8_unicode_ci DEFAULT NULL,
`lead_city` VARCHAR (255) COLLATE utf8_unicode_ci DEFAULT NULL,
`lead_address` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL,
`lead_address1` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL,
`lead_ip_address` VARCHAR(45) COLLATE utf8_unicode_ci DEFAULT NULL,
`lead_country_code` CHAR (2) DEFAULT NULL,
`lead_state_code` VARCHAR (3) DEFAULT NULL,
`organization_id` INT(10) UNSIGNED DEFAULT NULL,
`user_id` INT(10) UNSIGNED DEFAULT NULL,
`owner_id` INT(10) UNSIGNED NOT NULL,
`lead_type_id` INT(10) UNSIGNED DEFAULT NULL,
`stage_id` INT(10) UNSIGNED DEFAULT NULL,
`customer_group_id` INT(10) UNSIGNED DEFAULT NULL,
`created_at` TIMESTAMP NULL,
`updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE NOW(),
`last_activity` TIMESTAMP NULL,
`last_activity_type_id` INT(10) UNSIGNED DEFAULT NULL,
`external_id` VARCHAR (255) COLLATE utf8_bin DEFAULT NULL,
`creation_type` ENUM('local', 'import', 'user', 'api') DEFAULT 'local',
`use_organization_address` ENUM('0', '1') DEFAULT '0' NOT NULL,
`last_activity_subtype` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL,
`last_activity_outbound` TIMESTAMP NULL DEFAULT '0000-00-00 00:00:00',
`score` INT(10) UNSIGNED DEFAULT NULL,
`score_processed_at` TIMESTAMP NULL,
`remote_authorization_token` CHAR(40) DEFAULT NULL,
`email_validated_status` ENUM('not_verified', 'valid', 'invalid', 'risky') DEFAULT 'not_verified',
`email_validated_date` TIMESTAMP NULL,
`email_validated_score` FLOAT,
`address_hash` CHAR(40) NOT NULL,
`lat` VARCHAR(100) DEFAULT NULL,
`lng` VARCHAR(100) DEFAULT NULL,
`last_coordinates_processed_date` TIMESTAMP NULL DEFAULT '0000-00-00 00:00:00',
`lead_sentiment_summary` TEXT COLLATE utf8_unicode_ci DEFAULT NULL,
`lead_sentiment_score` DECIMAL(10,2) NOT NULL DEFAULT '0.00',
`lead_sentiment_score_processed_date` TIMESTAMP NULL,
`lead_sentiment_short_log` TEXT COLLATE utf8_unicode_ci DEFAULT NULL,
`lead_sentiment_cycle` INT(10) UNSIGNED DEFAULT NULL,
FOREIGN KEY (`stage_id`) REFERENCES `plugin_leads_stage` (`id`) ON DELETE SET NULL ON UPDATE NO ACTION,
FOREIGN KEY (`organization_id`) REFERENCES `plugin_lead_organization` (`id`) ON DELETE SET NULL ON UPDATE NO ACTION,
FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE SET NULL ON UPDATE NO ACTION,
FOREIGN KEY (`customer_group_id`) REFERENCES `shopping_group` (`id`) ON DELETE SET NULL ON UPDATE NO ACTION,
PRIMARY KEY(`id`),
UNIQUE(`lead_email`),
UNIQUE KEY `lead_mobile_country_code_value_lead_mobile` (`lead_mobile_country_code_value`,`lead_mobile`),
UNIQUE KEY `lead_phone_country_code_value_lead_phone` (`lead_phone_country_code_value`,`lead_phone`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_products` (
`lead_id` INT(10) UNSIGNED NOT NULL,
`product_id` INT(10) UNSIGNED NOT NULL,
PRIMARY KEY(`lead_id`, `product_id`),
FOREIGN KEY (`lead_id`) REFERENCES `plugin_leads_data`(`id`) ON DELETE CASCADE ON UPDATE NO ACTION,
FOREIGN KEY (`product_id`) REFERENCES `shopping_product` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_type` (
`id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
`type_name` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL,
`type_label` VARCHAR (255) COLLATE utf8_unicode_ci DEFAULT NULL,
`system` ENUM('0','1') DEFAULT '0' NOT NULL,
`default` ENUM('0', '1') DEFAULT '0',
PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_source` (
`id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
`source_name` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL,
`system` ENUM('0','1') DEFAULT '0' NOT NULL,
PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `plugin_leads_source` (`source_name`, `system`) VALUES
('Referrer', '1'),
('Marketing asset', '1'),
('Ad campaign', '1');

CREATE TABLE IF NOT EXISTS `plugin_leads_notes` (
`id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
`note` TEXT DEFAULT NULL,
`lead_id` INT (10) UNSIGNED NOT NULL,
`date_created` timestamp NOT NULL,
`user_id` INT(10) UNSIGNED NOT NULL,
PRIMARY KEY(`id`),
FOREIGN KEY(`lead_id`) REFERENCES `plugin_leads_data` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_filter_preset` (
`id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
`creator_id` INT(10) UNSIGNED NOT NULL,
`filter_preset_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
`filter_preset_data` TEXT NOT NULL,
`is_default` ENUM('0', '1') DEFAULT '0',
`filter_preset_type` ENUM('lead', 'organization') DEFAULT 'lead',
`access` ENUM('all', 'individual') DEFAULT 'individual',
PRIMARY KEY (`id`),
FOREIGN KEY (`creator_id`) REFERENCES `user` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_opportunity_stage` (
  `id` int(10) unsigned NOT NULL,
  `description` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `default` ENUM('0', '1') DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `plugin_leads_opportunity_stage` (`id`, `description`) VALUES
  (1,	'Lost'),
  (10,	'Unqualified'),
  (20,	'Needs assessment'),
  (30,	'Qualified'),
  (40,	'Meeting set'),
  (50,	'Meeting held'),
  (60,	'Proposal sent'),
  (70,	'Proposal acknowledged'),
  (80,	'Objections raised'),
  (90,	'Objections overcame'),
  (100,	'Won');

CREATE TABLE IF NOT EXISTS `plugin_leads_opportunity` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `opportunity_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  `opportunity_stage_id` INT(10) UNSIGNED NOT NULL,
  `opportunity_value` DECIMAL(10,2) DEFAULT NULL,
  `expected_close_date` TIMESTAMP NULL,
  `creator_id` INT(10) UNSIGNED DEFAULT NULL,
  `lead_id` INT(10) UNSIGNED NOT NULL,
  `created_at` TIMESTAMP NULL,
  `change_stage_date` TIMESTAMP NULL,
  `opportunity_type_id` INT(10) UNSIGNED DEFAULT NULL,
  PRIMARY KEY(`id`),
  UNIQUE (`opportunity_name`, `opportunity_stage_id`, `lead_id`),
  FOREIGN KEY (`opportunity_stage_id`) REFERENCES `plugin_leads_opportunity_stage` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION,
  FOREIGN KEY (`creator_id`) REFERENCES `user` (`id`) ON DELETE SET NULL ON UPDATE NO ACTION,
  FOREIGN KEY (`lead_id`)  REFERENCES `plugin_leads_data` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_opportunity_quote` (
 `quote_id` VARCHAR (20),
 `opportunity_id` INT(10) UNSIGNED NOT NULL,
 `lead_id` INT(10) UNSIGNED NOT NULL,
 `cart_id` INT(10) UNSIGNED NOT NULL,
 `created_at` TIMESTAMP NULL,
 PRIMARY KEY (`quote_id`, `opportunity_id`),
 FOREIGN KEY (`lead_id`)  REFERENCES `plugin_leads_data` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION,
 FOREIGN KEY (`quote_id`)  REFERENCES `shopping_quote` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION,
 FOREIGN KEY (`opportunity_id`) REFERENCES `plugin_leads_opportunity` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `plugin_leads_type`  (`type_name`, `type_label`, `system`) VALUES
('inbound_email', 'Inbound email', '1'),
('inbound_call', 'Inbound call', '1'),
('inbound_sms', 'Inbound sms', '1'),
('inbound_quote', 'Inbound quote request', '1'),
('inbound_purchase', 'Inbound purchase', '1'),
('inbound_quote_view', 'Inbound quote view', '1'),
('inbound_registration', 'Inbound registration', '1'),
('inbound_form', 'Inbound form contact', '1'),
('inbound_downloader', 'Inbound document download', '1'),
('inbound_website_visit', 'Inbound website visit', '1'),
('inbound_external', 'External resource', '1'),
('outbound_email', 'Outbound email', '1'),
('outbound_call', 'Outbound call', '1'),
('outbound_sms', 'Outbound sms', '1'),
('outbound_quote', 'Outbound quote', '1'),
('outbound_meeting', 'Outbound meeting', '1'),
('outbound_task', 'Outbound task', '1'),
('inbound_chat', 'Inbound chat', '1');

INSERT INTO `plugin_leads_stage`  (`stage_name`) VALUES
('qualification'),
('quote sent'),
('closed won'),
('closed lost');

INSERT INTO `email_triggers` (`enabled`, `trigger_name`, `observer`) VALUES
('1', 'leads_contact', 'Tools_LeadsMailWatchdog'),
('1', 'leads_meeting', 'Tools_LeadsMailWatchdog'),
('1', 'leads_taskreminder', 'Tools_LeadsMailWatchdog'),
('1', 'leads_licenselimit', 'Tools_LeadsMailWatchdog'),
('1', 'leads_taskcompleted', 'Tools_LeadsMailWatchdog'),
('1', 'leads_taskreopened', 'Tools_LeadsMailWatchdog'),
('1', 'leads_taskcreated', 'Tools_LeadsMailWatchdog'),
('1', 'leads_imapcredentialsnotification', 'Tools_LeadsMailWatchdog'),
('1', 'leads_reviewrequest', 'Tools_LeadsMailWatchdog'),
('1', 'leads_npsreviewrequest', 'Tools_LeadsMailWatchdog'),
('1', 'leads_taskoverdue', 'Tools_LeadsMailWatchdog'),
('1', 'leads_taskstart', 'Tools_LeadsMailWatchdog'),
('1', 'leads_meetingreminder', 'Tools_LeadsMailWatchdog'),
('1', 'leads_emailsvalidationqueue', 'Tools_LeadsMailWatchdog'),
('1', 'leads_sequencemassactionnotification', 'Tools_LeadsMailWatchdog'),
('1', 'leads_useremailreport', 'Tools_LeadsMailWatchdog');

CREATE TABLE IF NOT EXISTS `plugin_leads_action_log` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `type` VARCHAR(64) COLLATE utf8_unicode_ci NOT NULL,
  `lead_id` INT(10) UNSIGNED NOT NULL,
  `created_at` TIMESTAMP NULL,
  `action_type` ENUM('inbound', 'outbound') DEFAULT 'inbound' NOT NULL,
  `additional_content` TEXT DEFAULT NULL,
  `event_type` ENUM('expired', 'upcoming') DEFAULT 'expired' NOT NULL,
  `lead_type` VARCHAR (255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  INDEX `lead_id` (`lead_id`),
  INDEX `created_at_lead_id` (`created_at`,`lead_id`),
  INDEX `lead_id_created_at` (`lead_id`,`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_tasks` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `title` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  `user_id` INT(10) UNSIGNED NOT NULL,
  `creator_id` INT(10) UNSIGNED NOT NULL,
  `expired_at` TIMESTAMP NULL,
  `due_date` TIMESTAMP NULL,
  `notes` TEXT DEFAULT NULL,
  `lead_id` INT(10) UNSIGNED NOT NULL,
  `creation_type` ENUM('local','import','user') DEFAULT 'local',
  `task_external_id` VARCHAR (255) COLLATE utf8_bin DEFAULT NULL,
  `is_task_completed` ENUM('0', '1') DEFAULT '0',
  `is_task_overdue` ENUM('0', '1') DEFAULT '0',
  `is_task_start_email_sent` ENUM('0', '1') DEFAULT '0',
  `task_completed_by` INT(10) UNSIGNED DEFAULT NULL,
  `completion_comment` TEXT COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `fk_plugin_leads_tasks_user_id` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION,
  CONSTRAINT `fk_plugin_leads_tasks_creator_id` FOREIGN KEY (`creator_id`) REFERENCES `user` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION,
  CONSTRAINT `fk_plugin_leads_tasks_lead_id` FOREIGN KEY (`lead_id`) REFERENCES `plugin_leads_data` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_meeting` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `lead_id` INT(10) UNSIGNED NOT NULL,
  `start_time_date` TIMESTAMP NULL,
  `end_time_date` TIMESTAMP NULL,
  `location` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `invite_attendees` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `period` ENUM('all_day', 'fixed') DEFAULT 'fixed',
  `subject` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `details` TEXT DEFAULT NULL,
  `google_calendar` ENUM ('0', '1') DEFAULT '0',
  `creator_id` INT(10) UNSIGNED NOT NULL,
  `first_notification_is_sent` ENUM('0', '1') DEFAULT '0',
  `second_notification_is_sent` ENUM('0', '1') DEFAULT '0',
  `send_notification_sms` ENUM('0', '1') DEFAULT '0',
  `send_sms` ENUM('0', '1') DEFAULT '0',
  `first_notification_date` TIMESTAMP NULL,
  `second_notification_date` TIMESTAMP NULL,
  `first_notification_sent_date` TIMESTAMP NULL,
  `second_notification_sent_date` TIMESTAMP NULL,
  `meeting_type` ENUM('auto', 'manual') DEFAULT 'auto',
  `additional_notes` TEXT DEFAULT NULL,
  `status` ENUM('no_show', 'rescheduled', 'completed') DEFAULT NULL,
  PRIMARY KEY(`id`),
  FOREIGN KEY (`lead_id`) REFERENCES `plugin_leads_data` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_tasks_log` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `title` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  `user_id` INT(10) UNSIGNED NOT NULL,
  `creator_id` INT(10) UNSIGNED NOT NULL,
  `expired_at` TIMESTAMP NULL,
  `due_date` TIMESTAMP NULL,
  `notes` TEXT DEFAULT NULL,
  `action_log_id` INT(10) UNSIGNED NOT NULL,
  `task_id` INT(10) UNSIGNED NOT NULL,
  `lead_id` INT(10) UNSIGNED NOT NULL,
  `is_task_completed` ENUM('0', '1') DEFAULT '0',
  `is_task_overdue` ENUM('0', '1') DEFAULT '0',
  `task_completed_by` INT(10) UNSIGNED DEFAULT NULL,
  `completion_comment` TEXT COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  INDEX `action_log_id` (`action_log_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_tasks_queue` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `task_id` INT(10) UNSIGNED NOT NULL,
  `to_send_date` TIMESTAMP NULL,
  `sent_date` TIMESTAMP NULL,
  `status` ENUM('processing', 'sent', 'error') DEFAULT 'processing' NOT NULL,
  `queue_type` ENUM('first_task_reminder', 'second_task_reminder', 'custom') DEFAULT 'custom' NOT NULL,
  PRIMARY KEY (`id`),
  FOREIGN KEY (`task_id`) REFERENCES `plugin_leads_tasks` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_config` (
	`name` VARCHAR(255) NOT NULL COLLATE 'utf8_unicode_ci',
	`value` VARCHAR(255) NOT NULL COLLATE 'utf8_unicode_ci',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_meeting_log` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `start_time_date` TIMESTAMP NULL,
  `end_time_date` TIMESTAMP NULL,
  `location` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `invite_attendees` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `period` ENUM('all_day', 'fixed') DEFAULT 'fixed',
  `subject` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `details` TEXT DEFAULT NULL,
  `google_calendar` ENUM ('0', '1') DEFAULT '0',
  `action_log_id` INT(10) UNSIGNED NOT NULL,
  `meeting_status` ENUM('created', 'finished', 'upcoming') DEFAULT 'created',
  `meeting_id` INT(10) UNSIGNED NOT NULL,
  `creator_id` INT(10) UNSIGNED NOT NULL,
  `lead_id` INT(10) UNSIGNED NOT NULL,
  `additional_content` TEXT DEFAULT NULL,
  PRIMARY KEY(`id`),
  INDEX `action_log_id` (`action_log_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_call_log` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `call_sid` VARCHAR(34) COLLATE utf8_unicode_ci DEFAULT NULL,
  `creator_id` INT(10) UNSIGNED DEFAULT NULL,
  `type` ENUM('call','sms','mms') DEFAULT 'call' NOT NULL,
  `sub_type` VARCHAR (255) DEFAULT NULL,
  `account_sid` VARCHAR(34) COLLATE utf8_unicode_ci DEFAULT NULL,
  `caller` VARCHAR(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `timestamp` TIMESTAMP NULL,
  `status` ENUM('queued','ringing','in-progress','canceled','completed','failed','busy','no-answer','sending','sent') DEFAULT 'queued',
  `score` ENUM('valid','invalid','review_requested','reviewed_validated') DEFAULT 'valid' NOT NULL,
  `link` TINYTEXT DEFAULT NULL,
  `call_duration` VARCHAR(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `action_log_id` INT(10) UNSIGNED NOT NULL,
  `lead_id` INT(10) UNSIGNED DEFAULT NULL,
  `details` TEXT DEFAULT NULL,
  `call_source` VARCHAR(255) DEFAULT NULL,
  `receiver` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_voip` ENUM('0', '1') DEFAULT '0',
  `is_mms` ENUM('0', '1') DEFAULT '0',
  `mms_files` TEXT DEFAULT NULL COLLATE 'utf8_unicode_ci',
  `call_transcription` MEDIUMTEXT DEFAULT NULL,
  `call_transcription_details` MEDIUMTEXT DEFAULT NULL,
  `call_summary` TEXT COLLATE utf8_unicode_ci NULL,
  `sentiment` VARCHAR(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  INDEX `action_log_id` (`action_log_id`),
  INDEX `lead_id` (`lead_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_quote_log` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `quote_id` VARCHAR (20),
  `title` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  `status` ENUM('new','sent','sold','lost', 'deleted', 'signature_only_signed') DEFAULT 'new',
  `created_at` TIMESTAMP NULL,
  `action_log_id` INT(10) UNSIGNED NOT NULL,
  `creator_id` INT(10) UNSIGNED DEFAULT NULL,
  `quote_link` VARCHAR (255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `quote_action_type` ENUM('view', 'change', 'deleted') DEFAULT 'change' NOT NULL,
  `lead_id` INT(10) UNSIGNED NOT NULL,
  `quote_sent` ENUM ('0', '1') DEFAULT '0' NOT NULL,
  `total` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT 'Sub Total + Total Tax + Shipping',
  `is_deleted` ENUM('0', '1') DEFAULT '0',
  `deleted_by` int(10) unsigned DEFAULT NULL,
  `force_display` ENUM('0', '1') DEFAULT '0',
  `signed_only_by` INT(10) UNSIGNED DEFAULT '0',
  PRIMARY KEY(`id`),
  INDEX `action_log_id` (`action_log_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_purchase_log` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `cart_id` INT (10) UNSIGNED NOT NULL,
  `created_at` TIMESTAMP NULL,
  `action_log_id` INT(10) UNSIGNED NOT NULL,
  `lead_id` INT(10) UNSIGNED NOT NULL,
  `status` VARCHAR (20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `total` DECIMAL(10,2) NOT NULL DEFAULT '0.00' COMMENT 'Sub Total + Total Tax + Shipping',
  `is_partial` ENUM('0', '1') DEFAULT '0',
  `is_manually_paid` ENUM('0', '1') DEFAULT '0',
  `partially_paid_amount` DECIMAL(10,2) NOT NULL DEFAULT '0.00',
  `signed_only_by` INT(10) UNSIGNED DEFAULT '0',
  `gateway` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY(`id`),
  INDEX `action_log_id` (`action_log_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_form_log` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `form_name` VARCHAR (40) COLLATE utf8_unicode_ci,
  `content` TEXT COLLATE utf8_unicode_ci NOT NULL,
  `form_url` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  `action_log_id` INT(10) UNSIGNED NOT NULL,
  `lead_id` INT(10) UNSIGNED NOT NULL,
  `form_type` ENUM('internal', 'external') DEFAULT 'internal',
  PRIMARY KEY(`id`),
  INDEX `action_log_id` (`action_log_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_downloader_log` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `file_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  `file_path` TEXT COLLATE utf8_unicode_ci NOT NULL,
  `page_url` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  `action_log_id` INT(10) UNSIGNED NOT NULL,
  `lead_id` INT(10) UNSIGNED NOT NULL,
  `page_id` INT(10) UNSIGNED NOT NULL,
  `content` TEXT COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY(`id`),
  INDEX `action_log_id` (`action_log_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_email_log` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `email_subject` VARCHAR (255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `content` TEXT DEFAULT NULL,
  `encoded_content` MEDIUMBLOB,
  `email_from` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  `email_from_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  `email_to` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  `email_bcc` VARCHAR (255) COLLATE utf8_unicode_ci NOT NULL,
  `email_template` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  `follow_up_sequences_id` INT(10) UNSIGNED DEFAULT NULL,
  `trigger_id` INT(10) UNSIGNED DEFAULT NULL,
  `email_client` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `action_log_id` INT(10) UNSIGNED NOT NULL,
  `lead_id` INT(10) UNSIGNED NOT NULL,
  `email_status` ENUM('sent', 'click', 'opened', 'openattachment', 'received', 'bounce', 'deferred', 'dropped', 'unsubscribed'),
  `tracking_code` CHAR(64) DEFAULT NULL,
  `attachment_id` INT(10) UNSIGNED DEFAULT NULL,
  `email_source_type` ENUM('internal', 'external') DEFAULT 'internal' NOT NULL,
  `external_source_name` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `campaign_name` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `list_names` TEXT COLLATE utf8_unicode_ci DEFAULT NULL,
  `message_id` TEXT COLLATE utf8_unicode_ci DEFAULT NULL,
  `reply_id` TEXT COLLATE utf8_unicode_ci DEFAULT NULL,
  `references` TEXT COLLATE utf8_unicode_ci DEFAULT NULL,
  `uid` INT(10) UNSIGNED DEFAULT NULL,
  `message_number` INT(10) UNSIGNED DEFAULT NULL,
  `creator_id` INT(10) UNSIGNED DEFAULT NULL,
  `account_id` INT(10) UNSIGNED DEFAULT NULL,
  `received_at` TIMESTAMP NULL,
  PRIMARY KEY(`id`),
  INDEX `action_log_id` (`action_log_id`),
  INDEX `tracking_code` (`tracking_code`),
  INDEX `message_id` (`message_id`(998)),
  INDEX `reply_id` (`reply_id`(998)),
  INDEX `lead_id` (`lead_id`),
  INDEX `follow_up_sequences_id` (`follow_up_sequences_id`),
  INDEX `attachment_id` (`attachment_id`),
  INDEX `trigger_id` (`trigger_id`),
  INDEX `email_client` (`email_client`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_registration_log` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `email` VARCHAR (255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `first_name` TEXT DEFAULT NULL,
  `last_name` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mobile` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `action_log_id` INT(10) UNSIGNED NOT NULL,
  `lead_id` INT(10) UNSIGNED NOT NULL,
  `user_role` VARCHAR(15) DEFAULT NULL,
  `user_id` INT(10) UNSIGNED DEFAULT NULL,
  `registration_page_url` VARCHAR (255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `registration_page_id` INT(10) UNSIGNED NOT NULL,
  PRIMARY KEY(`id`),
  INDEX `action_log_id` (`action_log_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_lead_custom_params_config` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `param_type` ENUM('text', 'date', 'input', 'checkbox', 'select', 'radio') DEFAULT 'input',
  `param_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  `label` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY(`id`),
  UNIQUE(`param_type`, `param_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_lead_custom_params_data` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `param_id` INT(10) UNSIGNED NOT NULL,
  `lead_id` INT(10) UNSIGNED NOT NULL,
  `param_value` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  `params_option_id` INT(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  FOREIGN KEY (`param_id`) REFERENCES `plugin_leads_lead_custom_params_config` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION,
  FOREIGN KEY (`lead_id`) REFERENCES `plugin_leads_data` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION,
  INDEX `param_value` (`param_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_lead_custom_params_options_data` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `custom_param_id` INT UNSIGNED NOT NULL,
  `option_value` VARCHAR(255) NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_plugin_leads_lead_custom_params_options_data_plugin_lead_idx` (`custom_param_id` ASC),
  CONSTRAINT `fk_plugin_leads_lead_custom_params_options_data_plugin_leads_1`
    FOREIGN KEY (`custom_param_id`) REFERENCES `plugin_leads_lead_custom_params_config` (`id`)
    ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE = InnoDB DEFAULT CHARSET = utf8 COLLATE = utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_organization_custom_params_config` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `param_type` ENUM('text', 'date', 'input', 'checkbox', 'select', 'radio') DEFAULT 'input',
  `param_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  `label` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY(`id`),
  UNIQUE(`param_type`, `param_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_organization_custom_params_data` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `param_id` INT(10) UNSIGNED NOT NULL,
  `organization_id` INT(10) UNSIGNED NOT NULL,
  `param_value` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  `params_option_id` INT(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  FOREIGN KEY (`param_id`) REFERENCES `plugin_leads_organization_custom_params_config` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION,
  FOREIGN KEY (`organization_id`) REFERENCES `plugin_lead_organization` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_organization_custom_params_options_data` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `custom_param_id` INT UNSIGNED NOT NULL,
  `option_value` VARCHAR(255) NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_plugin_leads_organ_custom_params_options_data_plugin_lead_idx` (`custom_param_id` ASC),
  CONSTRAINT `fk_plugin_leads_organ_custom_params_options_data_plugin_leads_1`
    FOREIGN KEY (`custom_param_id`) REFERENCES `plugin_leads_organization_custom_params_config` (`id`)
    ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE = InnoDB DEFAULT CHARSET = utf8 COLLATE = utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_ips` (
  `lead_id` INT(10) UNSIGNED NOT NULL,
  `lead_ip_address` VARCHAR(45) NOT NULL,
  `ip_quantity` INT(10) UNSIGNED NOT NULL,
  FOREIGN KEY(`lead_id`) REFERENCES `plugin_leads_data` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION,
  PRIMARY KEY(`lead_id`, `lead_ip_address`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_tags` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `tag_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  `label` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_has_tags` (
  `tag_id` INT(10) UNSIGNED NOT NULL,
  `lead_id` INT(10) UNSIGNED NOT NULL,
  PRIMARY KEY(`tag_id`, `lead_id`),
  FOREIGN KEY(`tag_id`) REFERENCES `plugin_leads_tags` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION,
  FOREIGN KEY (`lead_id`) REFERENCES `plugin_leads_data` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_social_services_config` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `service_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  `service_label` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  `image_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE (`service_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_has_social_service` (
  `lead_id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `service_id` INT(10) UNSIGNED NOT NULL,
  `service_link` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`lead_id`, `service_id`),
  FOREIGN KEY (`service_id`) REFERENCES `plugin_leads_social_services_config` (`id`) ON UPDATE NO ACTION ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_last_viewed` (
  `id` INT(10) UNSIGNED NOT NULL,
  `lead_type` ENUM('lead', 'organization') NOT NULL DEFAULT 'lead',
  `user_id` INT(10) UNSIGNED NOT NULL,
  `viewed_at` TIMESTAMP NOT NULL,
  PRIMARY KEY(`id`, `lead_type`, `user_id`, `viewed_at`),
  FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_ip_user_profile_log` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `visit_ip_address` VARCHAR(45) DEFAULT NULL,
  `website_id` INT(10) UNSIGNED NOT NULL,
  `id_visit` INT(10) UNSIGNED NOT NULL,
  `piwik_id_website` INT(10) UNSIGNED NOT NULL,
  `visitor_id` CHAR(16) NOT NULL,
  `goal_conversions` INT(10) UNSIGNED DEFAULT '0',
  `site_currency` CHAR(3) DEFAULT NULL,
  `server_date` DATE NULL,
  `piwik_user_id` INT(10) UNSIGNED DEFAULT NULL,
  `last_action_date_time` DATETIME DEFAULT NULL,
  `visitor_type` ENUM('new', 'returning') DEFAULT 'new',
  `visit_converted` ENUM('yes', 'no') DEFAULT 'no',
  `visit_count` INT(10) UNSIGNED DEFAULT '0',
  `first_action_timestamp` DATETIME NULL,
  `visit_ecommerce_status` ENUM('none', 'ordered', 'abandonedCart', 'orderedThenAbandonedCart') DEFAULT 'none',
  `days_since_first_visit` SMALLINT (6) UNSIGNED DEFAULT '0',
  `days_since_last_ecommerce_order` INT(10) UNSIGNED DEFAULT '0',
  `visit_duration` INT(10) UNSIGNED DEFAULT '0',
  `searches` INT(10) UNSIGNED DEFAULT '0',
  `actions` INT(10) UNSIGNED DEFAULT '0',
  `referrer_type` ENUM('search', 'direct', 'website', 'campaign') DEFAULT 'search',
  `referrer_type_name` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `referrer_name` VARCHAR (255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `referrer_keyword` VARCHAR (255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `referrer_keyword_position` INT(10) UNSIGNED DEFAULT '0',
  `referrer_url` VARCHAR (255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `referrer_search_engine_url` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `language_code` CHAR(5) DEFAULT NULL,
  `device_type` VARCHAR(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `device_brand` VARCHAR (100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `device_model` VARCHAR (100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `operating_system` VARCHAR(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `operating_system_name` VARCHAR (20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `operating_system_code` VARCHAR (20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `operating_system_version` VARCHAR (20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `browser_family` VARCHAR (40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `browser_family_description` VARCHAR (255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `browser` VARCHAR(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `browser_name` VARCHAR(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `browser_code` CHAR(2) DEFAULT NULL,
  `browser_version` VARCHAR (10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `events` INT(10) UNSIGNED DEFAULT '0',
  `continent_code` CHAR(3) DEFAULT NULL,
  `country_code` CHAR(2)  DEFAULT NULL,
  `region` VARCHAR (100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `city` VARCHAR (255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `location` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `latitude` 	DECIMAL(10,8) NULL,
  `longitude` DECIMAL(11,8) NULL,
  `server_timestamp` DATETIME NULL,
  `resolution` VARCHAR (50) NULL,
  `lead_id` INT(10) UNSIGNED NOT NULL,
  `days_since_last_visit` SMALLINT(6) UNSIGNED DEFAULT '0',
  `action_log_id` INT(10) UNSIGNED NOT NULL,
  PRIMARY KEY(`id`),
  INDEX `action_log_id` (`action_log_id`),
  FOREIGN KEY (`lead_id`) REFERENCES `plugin_leads_data` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_ip_user_profile_log_actions_details` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `type` VARCHAR (255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `domain_name` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `page_url` VARCHAR(255) COLLATE utf8_unicode_ci NULL,
  `page_title` VARCHAR(255) COLLATE utf8_unicode_ci NULL,
  `time_spent` INT(10) UNSIGNED NULL,
  `page_generation_time` decimal(10,2) DEFAULT '0',
  `page_id_action` INT(10) UNSIGNED DEFAULT '0',
  `user_profile_log_id` INT(10) UNSIGNED NOT NULL,
  `action_datetime` DATETIME NULL,
  FOREIGN KEY (`user_profile_log_id`) REFERENCES `plugin_leads_ip_user_profile_log` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION,
  PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `observers_queue` (`observable`, `observer`) VALUES
('Application_Model_Models_Form', 'Tools_LeadFormWatchdog'),
('Quote_Models_Model_Quote', 'Tools_LeadQuoteWatchdog'),
('Models_Model_Customer', 'Tools_LeadRegistrationWatchdog'),
('Application_Model_Models_User', 'Tools_LeadRegistrationWatchdog'),
('Models_Model_CartSession', 'Tools_LeadPurchaseWatchdog'),
('Downloader_Models_Model_DownloaderFilesModel', 'Tools_LeadDownloaderWatchdog');

INSERT INTO `plugin_leads_social_services_config` (`service_name`, `service_label`, `image_name`) VALUES
('X',	'X',	'icon-twitter.png'),
('linkedin',	'linkedin',	'icon-linkedin.png'),
('facebook',	'facebook',	'icon-facebook.png'),
('instagram',	'instagram',	'icon-instagram.png'),
('gmb', 'google my business', 'icon-gmb.png'),
('pinterest', 'pinterest', 'pinterest.png');

ALTER TABLE `plugin_lead_organization` ADD FOREIGN KEY (`primary_contact_id`) REFERENCES `plugin_leads_data` (`id`) ON DELETE SET NULL ON UPDATE NO ACTION;

CREATE TABLE IF NOT EXISTS `plugin_leads_has_email_sequence` (
  `lead_id` INT(10) UNSIGNED NOT NULL,
  `sequence_id` INT (10) UNSIGNED NOT NULL,
  `sequence_date` TIMESTAMP,
  PRIMARY KEY (`lead_id`, `sequence_id`),
  FOREIGN KEY (`lead_id`) REFERENCES `plugin_leads_data` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION,
  INDEX (`sequence_id`),
  INDEX (`lead_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_email_sequence_status` (
  `lead_id` INT(10) UNSIGNED NOT NULL,
  `sequence_id` INT (10) UNSIGNED NOT NULL,
  `cart_status_settings_id` INT(10) UNSIGNED NOT NULL,
  `sequence_applied_date` TIMESTAMP,
  PRIMARY KEY (`sequence_id`, `cart_status_settings_id`, `lead_id`),
  FOREIGN KEY (`lead_id`) REFERENCES `plugin_leads_data` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_email_link_attachment_log` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `file_name` VARCHAR (255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `file_folder_name` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `file_link` TEXT COLLATE utf8_unicode_ci DEFAULT NULL,
  `email_log_sent_hash` CHAR(64) NOT NULL,
  `file_hash` CHAR(64) NOT NULL,
  `source_type` ENUM('internal', 'external') DEFAULT 'internal' NOT NULL,
  `link_type` ENUM('click', 'attachment') DEFAULT 'attachment' NOT NULL,
  `created_datetime` DATETIME NULL,
  `archived` ENUM('0', '1') DEFAULT '0' NOT NULL,
  PRIMARY KEY(`id`),
  INDEX(`email_log_sent_hash`),
  INDEX(`file_hash`),
  UNIQUE(`email_log_sent_hash`, `file_hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `plugin_crm_checklist` (`checklist_status`, `closed_by`, `checklist_name`) VALUES
('0',	NULL,	'leads_import'),
('0',	NULL,	'add_products_screen'),
('0',	NULL,	'paypal_account_screen'),
('0',	NULL,	'dashboard_leads_tab'),
('0',	NULL,	'create_groups'),
('0',	NULL,	'manage_users_screen'),
('0',	NULL,	'mojo_registartion'),
('0',	NULL,	'imap_service');

INSERT INTO `plugin_leads_stage` (`stage_name`) VALUES
('1. Subscriber'),
('2. Lead'),
('3. Marketing qualified lead'),
('4. Sales qualified lead'),
('5. Opportunity'),
('6. Customer'),
('7. Evangelist'),
('8. Other');

INSERT INTO `plugin_leads_industry` (`type`, `label`) VALUES
('Accommodations', 'Accommodations'),
('Accounting', 'Accounting'),
('Advertising', 'Advertising'),
('Aerospace', 'Aerospace'),
('Agriculture_Agribusiness', 'Agriculture & Agribusiness'),
('Air_Transportation', 'Air Transportation'),
('Apparel_Accessories', 'Apparel & Accessories'),
('Auto', 'Auto'),
('Banking', 'Banking'),
('Beauty_Cosmetics', 'Beauty & Cosmetics'),
('Biotechnology', 'Biotechnology'),
('Chemical', 'Chemical'),
('Communications', 'Communications'),
('Computer', 'Computer'),
('Construction', 'Construction'),
('Consulting', 'Consulting'),
('Consumer Products', 'Consumer Products'),
('Education', 'Education'),
('Electronics', 'Electronics'),
('Employment', 'Employment'),
('Energy', 'Energy'),
('Entertainment_Recreation', 'Entertainment & Recreation'),
('Fashion', 'Fashion'),
('Financial_Services', 'Financial Services'),
('Fine_Arts', 'Fine Arts'),
('Food_Beverage', 'Food & Beverage'),
('Health', 'Health'),
('Information', 'Information'),
('Information_Technology', 'Information Technology'),
('Insurance', 'Insurance'),
('Journalism_News', 'Journalism & News'),
('Legal_Services', 'Legal Services'),
('Manufacturing', 'Manufacturing'),
('Media_Broadcasting', 'Media & Broadcasting'),
('Medical_Devices_Supplies', 'Medical Devices & Supplies'),
('Music', 'Music'),
('Pharmaceutical', 'Pharmaceutical'),
('Public_Administration', 'Public Administration'),
('Publishing', 'Publishing'),
('Real_Estate', 'Real Estate'),
('Retail', 'Retail'),
('Telecommunications', 'Telecommunications'),
('Tourism', 'Tourism'),
('Transportation', 'Transportation'),
('Web_Services', 'Web Services');

CREATE TABLE IF NOT EXISTS `plugin_leads_opportunity_type` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `type_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  `type_label` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `template` (`name`, `content`, `type`) VALUES
('CRM subscription',	'<html>\n\n<head>\n    <title>{$plugin:widcard:BizOrgName:notag}</title>\n</head>\n\n<body style="margin: 0;">\n    <table bgcolor="#FFFFFF" width="100%" border="0" cellpadding="0" cellspacing="0" style="font-size: 14px; font-family: Arial, Verdana, Sans-serif; color: #444; ">\n        <tr>\n            <td>\n\n                <!-- E-mail tempalte -->\n                <table align="center" width="600" border="0" cellpadding="0" cellspacing="0" style="margin: 0 auto;">\n                    <tr>\n                        <td height="20"></td>\n                    </tr>\n                    <!-- header -->\n\n                    <tr>\n                        <td>\n                            <table width="100%" border="0" cellpadding="0" cellspacing="0">\n                                <tr>\n                                    <td valign="bottom" width="100" style="padding: 40px 20px 40px 20px; text-align: center; color: #FFFFFF;background: #596B75;"  bgcolor="#596B75">\n                                        <h2 style="font-weight: normal;">You''re losing out on critical sales data.</h2>\n                                        <h3 style="margin: 0 0 0 0;">Upgrade your CRM subscription now</h3>\n                                    </td>\n                                </tr>\n                                <tr>\n                                	<td>\n                                		<img src="{$website:url}plugins/leads/web/images/header-bottom-arrow.png" alt="arrow">\n                                	</td>\n                                </tr>\n                            </table>\n                        </td>\n                    </tr>\n                    <!-- header -->\n\n                    <!-- content -->\n                    <tr>\n                        <td bgcolor="#FFFFFF" style="background: #FFFFFF;">\n                            <table width="100%" border="0" cellpadding="0" cellspacing="0">\n                                <tr>\n                                    <td colspan="4" align="left" style="padding:40px 40px 40px 40px; line-height: 1.75em;">\n                                    	\n										{emailmessage}\n\n                                    </td>\n                                </tr>\n                            </table>\n                        </td>\n                    </tr>\n                    <!-- content -->\n\n					<tr>\n                        <td bgcolor="#F9F9F9" style="background: #F9F9F9; padding: 40px 40px 20px 40px;">                        	 \n\n                        	<table width="100%" border="0" cellpadding="0" cellspacing="0">\n                                <tr>\n                                	<td style="text-align: center;">\n                                		<a href="{lead:subscriptionlink}" style="background: #4496AB; display: inline-block; padding: 15px 30px 15px 30px; text-decoration: none; color: #FFFFFF; -webkit-border-radius: 6px;-moz-border-radius: 6px; -ms-border-radius: 6px;border-radius: 6px;">Upgrade your CRM subscription now!</a> \n                                	</td>\n                                </tr>\n                                <tr>\n                                	<td style="text-align: center;">\n                                		<span href="" style="padding: 15px 30px 15px 30px; display: inline-block;  text-decoration: none; color: #222222;">Don''t lose any more valuable opportunities.</span> \n                                	</td>\n                                </tr>\n                            </table>\n                        </td>\n                    </tr>\n\n\n                    <!-- footer -->\n                    <tr>\n                        <td bgcolor="#596B75" style="padding: 40px 20px 40px 20px; text-align: center; color: #FFFFFF; background: url({$website:url}plugins/leads/web/images/puzzle.png) no-repeat scroll 470px 20px #596B75">\n                        <span>SeoSamba CRM</span>\n                        </td>\n                    </tr>\n                    <!-- footer -->\n\n                    <!-- space -->\n                    <tr>\n                        <td height="20"></td>\n                    </tr>\n                    <!-- space -->\n                </table>\n                <!-- E-mail tempalte -->\n\n            </td>\n        </tr>\n    </table>\n</body>\n\n</html>',	'typemail');

INSERT INTO `email_triggers_actions` (`service`, `trigger`, `template`, `recipient`, `message`, `from`, `subject`) VALUES
('email',	'leads_licenselimit',	'CRM subscription',	'admin',	'Congratulations! You''re getting noticed and folks are interested in what you''re doing.\r\n\r\nWe hope that you''re enjoying using our CRM at <a target=\"_blank\" href=\"{$website:url}\">{$website:host}</a>. Unfortunately, you''ve reached your software subscription limit.\r\nAs a result, no additional named lead contacts can be created. As it stands, you won''t be able to know what web pages your prospective clients have looked at, which documents they''ve downloaded, which emails and attachments they''ve opened. And you won''t have access to a history of phone conversations, all conveniently located under their client profiles.\r\nThe good news is that it''s super simple to fix this: Don''t lose any more valuable opportunities. Click <a href="{lead:subscriptionlink}">here </a>to upgrade your CRM subscription now',	'store@example.com',	'You''re losing out on critical sales data. Upgrade your CRM subscription now.');

CREATE TABLE IF NOT EXISTS `plugin_leads_form_rules_general_config` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `form_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  `form_type` ENUM('internal', 'external') DEFAULT 'internal',
  `rule_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  `created_at` TIMESTAMP NOT NULL,
  `creator_id` INT(10) UNSIGNED DEFAULT NULL,
  `updated_at` TIMESTAMP NOT NULL,
  `editor_id` INT(10) UNSIGNED DEFAULT NULL,
  PRIMARY KEY(`id`),
  FOREIGN KEY (`creator_id`) REFERENCES `user` (`id`) ON DELETE SET NULL ON UPDATE NO ACTION,
  FOREIGN KEY (`editor_id`) REFERENCES `user` (`id`) ON DELETE SET NULL ON UPDATE NO ACTION,
  UNIQUE (`rule_name`, `form_name`, `form_type`),
  INDEX (`form_name`, `form_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_form_rules_config` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `rule_id` INT(10) UNSIGNED NOT NULL,
  `field_name` VARCHAR (255) COLLATE utf8_unicode_ci NOT NULL,
  `rule_comparison_operator` ENUM('equal', 'notequal', 'like', 'in', 'greaterthan', 'lessthan') DEFAULT 'equal',
  `field_value` MEDIUMTEXT COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY(`id`),
  FOREIGN KEY (`rule_id`) REFERENCES `plugin_leads_form_rules_general_config` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_form_rules_actions` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `rule_id` INT(10) UNSIGNED NOT NULL,
  `action_type` ENUM ('assign_owner', 'assign_task', 'assign_tags', 'assign_lifecycle', 'assign_sequence', 'assign_email_list', 'assign_email_copy', 'assign_remarketing_list') DEFAULT 'assign_owner',
  `action_config` TEXT COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY(`id`),
  UNIQUE(`rule_id`, `action_type`),
  FOREIGN KEY (`rule_id`) REFERENCES `plugin_leads_form_rules_general_config` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_templates_and_directories_config` (
  `id` INT NOT NULL AUTO_INCREMENT,
  `type` VARCHAR(45) NOT NULL,
  `item_name` VARCHAR(255) NOT NULL,
  PRIMARY KEY (`id`)
)ENGINE = InnoDB DEFAULT CHARACTER SET = utf8 COLLATE = utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_events` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `event_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  `event_label` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_events_relation` (
  `event_id` INT(10) UNSIGNED NOT NULL,
  `external_id` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY(`event_id`, `external_id`),
  FOREIGN KEY(`event_id`) REFERENCES `plugin_leads_events` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_event_rules_general_config` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `event_id` INT(10) UNSIGNED NOT NULL,
  `rule_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  `created_at` TIMESTAMP NOT NULL,
  `creator_id` INT(10) UNSIGNED DEFAULT NULL,
  `updated_at` TIMESTAMP NOT NULL,
  `editor_id` INT(10) UNSIGNED DEFAULT NULL,
  PRIMARY KEY(`id`),
  FOREIGN KEY (`creator_id`) REFERENCES `user` (`id`) ON DELETE SET NULL ON UPDATE NO ACTION,
  FOREIGN KEY (`editor_id`) REFERENCES `user` (`id`) ON DELETE SET NULL ON UPDATE NO ACTION,
  FOREIGN KEY (`event_id`) REFERENCES `plugin_leads_events` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION,
  UNIQUE (`rule_name`, `event_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_event_rules_config` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `rule_id` INT(10) UNSIGNED NOT NULL,
  `field_name` VARCHAR (255) COLLATE utf8_unicode_ci NOT NULL,
  `rule_comparison_operator` ENUM('equal', 'notequal', 'like', 'in', 'greaterthan', 'lessthan') DEFAULT 'equal',
  `field_value` MEDIUMTEXT COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY(`id`),
  FOREIGN KEY (`rule_id`) REFERENCES `plugin_leads_event_rules_general_config` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_event_rules_actions` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `rule_id` INT(10) UNSIGNED NOT NULL,
  `action_type` ENUM ('assign_owner', 'assign_task', 'assign_tags', 'assign_lifecycle', 'assign_sequence', 'assign_email_list', 'assign_email_copy', 'assign_remarketing_list') DEFAULT 'assign_owner',
  `action_config` TEXT COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY(`id`),
  UNIQUE(`rule_id`, `action_type`),
  FOREIGN KEY (`rule_id`) REFERENCES `plugin_leads_event_rules_general_config` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_builder_form_general_config` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `form_type` enum('internal','external') COLLATE utf8_unicode_ci DEFAULT 'internal',
  `form_title` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `form_domain` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `form_button_label` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `form_code` MEDIUMTEXT COLLATE utf8_unicode_ci,
  `form_signature` char(40) COLLATE utf8_unicode_ci NOT NULL,
  `recaptcha_public_key` VARCHAR(255) DEFAULT NULL,
  `recaptcha_private_key` VARCHAR(255) DEFAULT NULL,
  `success_url` VARCHAR(255) DEFAULT NULL,
  `fail_url` VARCHAR(255) DEFAULT NULL,
  `sms_mobile` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Mobile numbers for sms',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `creator_id` int(10) unsigned DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `editor_id` int(10) unsigned DEFAULT NULL,
  `send_email` ENUM('0', '1') DEFAULT '0',
  `send_auto_reply` ENUM('0', '1') DEFAULT '0',
  `send_email_config` MEDIUMTEXT COLLATE utf8_unicode_ci DEFAULT NULL,
  `send_auto_reply_config` MEDIUMTEXT COLLATE utf8_unicode_ci DEFAULT NULL,
  `external_id` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'External id',
  PRIMARY KEY (`id`),
  UNIQUE KEY `form_name` (`form_name`),
  KEY `creator_id` (`creator_id`),
  KEY `editor_id` (`editor_id`),
  CONSTRAINT `plugin_leads_builder_form_general_config_ibfk_1` FOREIGN KEY (`creator_id`) REFERENCES `user` (`id`) ON DELETE SET NULL ON UPDATE NO ACTION,
  CONSTRAINT `plugin_leads_builder_form_general_config_ibfk_2` FOREIGN KEY (`editor_id`) REFERENCES `user` (`id`) ON DELETE SET NULL ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_builder_form_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` int(10) unsigned NOT NULL,
  `field_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `field_label` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `field_value` mediumtext COLLATE utf8_unicode_ci DEFAULT NULL,
  `field_data` text COLLATE utf8_unicode_ci NOT NULL,
  `field_type` VARCHAR (255) COLLATE utf8_unicode_ci NOT NULL,
  `system_type` VARCHAR (255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `form_id` (`form_id`),
  CONSTRAINT `plugin_leads_builder_form_fields_ibfk_1` FOREIGN KEY (`form_id`) REFERENCES `plugin_leads_builder_form_general_config` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_imap_config` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `service_name` VARCHAR (255) COLLATE utf8_unicode_ci NOT NULL,
  `owner_id` int(10) unsigned DEFAULT NULL,
  `host` VARCHAR (255) COLLATE utf8_unicode_ci NOT NULL,
  `encryption` ENUM('none', 'tls', 'ssl') NOT NULL DEFAULT 'none',
  `login` VARCHAR (255) COLLATE utf8_unicode_ci NOT NULL,
  `password` BLOB NOT NULL,
  `initial_data_processed` ENUM('0', '1') DEFAULT '0',
  `last_processed_date` TIMESTAMP NULL,
  `process_all_emails` ENUM('0', '1') DEFAULT '0',
  `notification_sent` TIMESTAMP NULL,
  `is_oauth2` ENUM('0', '1') DEFAULT '0',
  `access_token` TEXT DEFAULT NULL,
  `refresh_token` TEXT DEFAULT NULL,
  `oauth2_service_app_name` VARCHAR (255) COLLATE utf8_unicode_ci NULL,
  `created_at` TIMESTAMP NOT NULL,
  `updated_at` TIMESTAMP NOT NULL,
  `is_temporary` ENUM('0', '1') DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_additional_email_log` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `email_subject` VARCHAR (255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `content` TEXT DEFAULT NULL,
  `encoded_content` MEDIUMBLOB,
  `email_from` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  `email_from_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  `email_to` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  `email_bcc` VARCHAR (255) COLLATE utf8_unicode_ci NOT NULL,
  `lead_id` INT(10) UNSIGNED NOT NULL,
  `email_status` ENUM('sent', 'opened', 'openattachment', 'received'),
  `email_source_type` ENUM('internal', 'external') DEFAULT 'internal' NOT NULL,
  `external_source_name` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `message_id` VARCHAR(998) COLLATE utf8_unicode_ci DEFAULT NULL,
  `reply_id` TEXT COLLATE utf8_unicode_ci DEFAULT NULL,
  `references` TEXT COLLATE utf8_unicode_ci DEFAULT NULL,
  `uid` INT(10) UNSIGNED DEFAULT NULL,
  `message_number` INT(10) UNSIGNED DEFAULT NULL,
  `account_id` INT(10) UNSIGNED DEFAULT NULL,
  `received_at` TIMESTAMP NULL,
  PRIMARY KEY(`id`),
  INDEX `message_id` (`message_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_score_rules_general_config` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `rule_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  `created_at` TIMESTAMP NOT NULL,
  `creator_id` INT(10) UNSIGNED DEFAULT NULL,
  `updated_at` TIMESTAMP NOT NULL,
  `editor_id` INT(10) UNSIGNED DEFAULT NULL,
  `score` INT(10) UNSIGNED NOT NULL,
  `score_sign` ENUM('+', '-') DEFAULT '+',
  PRIMARY KEY(`id`),
  FOREIGN KEY (`creator_id`) REFERENCES `user` (`id`) ON DELETE SET NULL ON UPDATE NO ACTION,
  FOREIGN KEY (`editor_id`) REFERENCES `user` (`id`) ON DELETE SET NULL ON UPDATE NO ACTION,
  UNIQUE (`rule_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_score_rules_config` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `rule_id` INT(10) UNSIGNED NOT NULL,
  `rule_type` ENUM('lead_attribute', 'organization_attribute', 'action_type', 'lead_opportunities', 'lead_custom_attributes', 'organization_custom_attributes', 'form_name') DEFAULT 'lead_attribute',
  `rule_subtype` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `field_name` VARCHAR (255) COLLATE utf8_unicode_ci NOT NULL,
  `rule_comparison_operator` ENUM('equal', 'notequal', 'like', 'in', 'greaterthan', 'lessthan', 'notin') DEFAULT 'equal',
  `field_value` MEDIUMTEXT COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY(`id`),
  FOREIGN KEY (`rule_id`) REFERENCES `plugin_leads_score_rules_general_config` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_score_rules_log` (
`lead_id` INT(10) UNSIGNED NOT NULL,
`rule_id` INT(10) UNSIGNED NOT NULL,
PRIMARY KEY(`lead_id`, `rule_id`),
FOREIGN KEY (`lead_id`) REFERENCES `plugin_leads_data`(`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_documents` (
 `id` INT(10) unsigned AUTO_INCREMENT,
 `lead_id` INT(10) UNSIGNED NOT NULL,
 `file_stored_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL COMMENT 'Stored file name',
 `file_hash` CHAR(40) NOT NULL COMMENT 'Hash for download link',
 `original_file_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL COMMENT 'Original file name',
 `display_file_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL COMMENT 'Display file name',
 `uploaded_at` TIMESTAMP NOT NULL COMMENT 'Upload date',
 `external_url` TEXT DEFAULT NULL COMMENT 'External url',
   PRIMARY KEY (`id`),
   UNIQUE(`file_hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_custom_tabs_config` (
`id` INT(10) unsigned AUTO_INCREMENT,
`tab_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL COMMENT 'Crm tab name',
`tab_label` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL COMMENT 'Crm tab label',
`tab_type` ENUM('lead', 'organization') DEFAULT 'lead',
`draggable_params_ids` TEXT DEFAULT NULL COMMENT 'Draggable custom params ids',
PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_custom_tabs_has_custom_params` (
`tab_id` INT(10) UNSIGNED NOT NULL,
`custom_param_id` INT(10) UNSIGNED NOT NULL,
PRIMARY KEY (`tab_id`, `custom_param_id`),
FOREIGN KEY(`tab_id`) REFERENCES `plugin_leads_custom_tabs_config` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_workflow_general_config` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `rule_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  `created_at` TIMESTAMP NOT NULL,
  `creator_id` INT(10) UNSIGNED DEFAULT NULL,
  `updated_at` TIMESTAMP NOT NULL,
  `editor_id` INT(10) UNSIGNED DEFAULT NULL,
  `score` INT(10) UNSIGNED NOT NULL,
  `score_comparison_operator` ENUM('equal', 'greaterthan', 'lessthan') DEFAULT 'equal',
  PRIMARY KEY(`id`),
  FOREIGN KEY (`creator_id`) REFERENCES `user` (`id`) ON DELETE SET NULL ON UPDATE NO ACTION,
  FOREIGN KEY (`editor_id`) REFERENCES `user` (`id`) ON DELETE SET NULL ON UPDATE NO ACTION,
  UNIQUE (`rule_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_workflow_config` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `rule_id` INT(10) UNSIGNED NOT NULL,
  `rule_type` ENUM('lead_attribute', 'organization_attribute', 'action_type', 'lead_opportunities', 'lead_custom_attributes', 'organization_custom_attributes') DEFAULT 'lead_attribute',
  `rule_subtype` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `field_name` VARCHAR (255) COLLATE utf8_unicode_ci NOT NULL,
  `rule_comparison_operator` ENUM('equal','notequal','like','in','greaterthan','lessthan','notin','datebefore','dateafter', 'dategreaterthan', 'datelessthan') DEFAULT 'equal',
  `field_value` MEDIUMTEXT COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY(`id`),
  FOREIGN KEY (`rule_id`) REFERENCES `plugin_leads_workflow_general_config` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


CREATE TABLE IF NOT EXISTS `plugin_leads_workflow_actions` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `rule_id` INT(10) UNSIGNED NOT NULL,
  `action_type` ENUM ('assign_owner', 'assign_task', 'assign_tags', 'assign_lifecycle', 'assign_sequence', 'assign_email_list', 'assign_email_copy', 'send_review_request', 'assign_remarketing_list') DEFAULT 'assign_owner',
  `action_config` TEXT COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY(`id`),
  UNIQUE(`rule_id`, `action_type`),
  FOREIGN KEY (`rule_id`) REFERENCES `plugin_leads_workflow_general_config` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_workflow_rules_log` (
`lead_id` INT(10) UNSIGNED NOT NULL,
`rule_id` INT(10) UNSIGNED NOT NULL,
PRIMARY KEY(`lead_id`, `rule_id`),
FOREIGN KEY (`lead_id`) REFERENCES `plugin_leads_data`(`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_users_api_access` (
`id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
`user_id` INT(10) UNSIGNED NOT NULL,
`ip_addresses` TEXT COLLATE utf8_unicode_ci NOT NULL,
PRIMARY KEY(`id`),
FOREIGN KEY (`user_id`) REFERENCES `user`(`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_users_api_tokens` (
`api_user_id` INT(10) UNSIGNED NOT NULL,
`token` CHAR (255) COLLATE utf8_unicode_ci NOT NULL,
`expiration_date` TIMESTAMP NOT NULL,
`creation_date` TIMESTAMP NOT NULL,
`ip_address` VARCHAR(45) NOT NULL,
PRIMARY KEY (`api_user_id`, `token`),
UNIQUE (`token`),
FOREIGN KEY (`api_user_id`) REFERENCES `plugin_leads_users_api_access`(`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_api_access_list` (
`api_user_id` INT(10) UNSIGNED NOT NULL,
`resource` VARCHAR (255) COLLATE utf8_unicode_ci NOT NULL,
PRIMARY KEY(`api_user_id`, `resource`),
FOREIGN KEY (`api_user_id`) REFERENCES `plugin_leads_users_api_access`(`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_api_request_log` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `token` CHAR (255) COLLATE utf8_unicode_ci NOT NULL,
  `request` TEXT COLLATE utf8_unicode_ci NOT NULL,
  `endpoint` VARCHAR (255) COLLATE utf8_unicode_ci NOT NULL,
  `request_type` VARCHAR (10) COLLATE utf8_unicode_ci NOT NULL,
  `api_user_id` INT(10) UNSIGNED NOT NULL,
  `created_at` TIMESTAMP NOT NULL,
  `ip_address` VARCHAR(45) NOT NULL,
  PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_review_request` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `review_token` CHAR (40) COLLATE utf8_unicode_ci NOT NULL,
  `lead_id` INT(10) UNSIGNED NOT NULL,
  `status` ENUM('sent', 'reviewed') DEFAULT 'sent',
  `review_status` ENUM('sent', 'reviewed') DEFAULT NULL,
  `score` TINYINT DEFAULT '0' NOT NULL,
  `sent_at` TIMESTAMP NOT NULL,
  `reviewed_at` TIMESTAMP NOT NULL,
  `review_request_sent_at` TIMESTAMP NOT NULL,
  `request_reviewed_facebook_date` TIMESTAMP NOT NULL,
  `request_reviewed_gmb_date` TIMESTAMP NOT NULL,
  PRIMARY KEY(`id`),
  UNIQUE(`review_token`),
  KEY `pllr_special_index` (`lead_id`,`score`,`reviewed_at`,`sent_at`,`status`,`review_request_sent_at`,`request_reviewed_facebook_date`,`request_reviewed_gmb_date`,`review_status`),
  FOREIGN KEY (`lead_id`) REFERENCES `plugin_leads_data`(`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_organization_documents` (
 `id` INT(10) unsigned AUTO_INCREMENT,
 `organization_id` INT(10) UNSIGNED NOT NULL,
 `file_stored_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL COMMENT 'Stored file name',
 `file_hash` CHAR(40) NOT NULL COMMENT 'Hash for download link',
 `original_file_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL COMMENT 'Original file name',
 `display_file_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL COMMENT 'Display file name',
 `uploaded_at` TIMESTAMP NOT NULL COMMENT 'Upload date',
   PRIMARY KEY (`id`),
   FOREIGN KEY (`organization_id`) REFERENCES `plugin_lead_organization`(`id`) ON DELETE CASCADE ON UPDATE NO ACTION,
   UNIQUE(`file_hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT IGNORE INTO `template` (`name`, `content`, `type`)
SELECT CONCAT('email message'), CONCAT('<!DOCTYPE html>\n<html xmlns:v=\"urn:schemas-microsoft-com:vml\">\n<head>\n    <meta charset=\"UTF-8\">\n    <style type=\"”text/css”\">\n        v\\:* { behavior: url(#default#VML); display:inline-block}\n    </style>\n</head>\n<body>\n<style>\n    body{\n        margin: 0;\n        padding: 0 ;\n        background-color:#f8f8f8 ;\n    }\n    p{\n        margin : 5px 0;\n        line-height: 1.7em;\n    }\n    ul{\n        padding : 0 0 0 20px;\n        color: #83B21F;\n    }\n    ul li{\n        margin-bottom : 5px;\n    }\n    a{\n        margin : 0 0 5px;\n        color: #83B21F;\n    }\n    img{\n        border-style: none;\n    }\n    hr{\n        height: 1px;\n        background: #F4F4F4;\n        border: none;\n    }\n</style>\n<table cellpadding=\"0\" cellspacing=\"0\" bgcolor=\"#f8f8f8\" width=\"100%\" style=\" margin: 0; padding: 0 ; background-color:#f8f8f8 ; height : 100%;\">\n    <tr>\n        <td>&nbsp;</td>\n        <td style=\"width: 600px;\">\n            <table style=\"font-family: Arial, Helvetica, sans-serif; background: #ffffff; width: 600px; color: #7c7c7c; font-size: 14px; text-align: left; margin: 15px 0;\" border=\"0\" width=\"600px\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\">\n                <!-- Header -->\n                <thead>\n                <tr>\n                    <td style=\"padding: 20px;\">\n            			<a target=\"_blank\" href=\"{$website:url}\">\n            				<img src=\"{$plugin:widcard:bizLogo:url}\" alt=\"{$plugin:widcard:BizOrgName:notag}\" height=\"75\" style=\"vertical-align:middle;\">\n            			</a>\n            		</td>\n            		<td style=\"text-align: center;\">\n            		<a style=\"text-decoration:none;\" rel=\"noopener\" target=\"_blank\" href=\"{$plugin:widcard:BizFbAccount:notag}\">\n            		    <img src=\"{$website:url}system/images/w-facebook.png\" alt=\"facebook\" />\n            		</a>\n            		<a style=\"text-decoration:none;\" rel=\"noopener\" target=\"_blank\" href=\"{$plugin:widcard:BizGmbusiness:notag}\">\n            		    <img src=\"{$website:url}system/images/w-gmb.png\" alt=\"GMB\" />\n            		</a> \n            		<a style=\"text-decoration:none;\" rel=\"noopener\" target=\"_blank\" href=\"{$plugin:widcard:BizTwitterAccount:notag}\">\n            		    <img src=\"{$website:url}system/images/w-twitter.png\" alt=\"twitter\" />\n            		</a> \n            		<a style=\"text-decoration:none;\" rel=\"noopener\" target=\"_blank\" href=\"{$plugin:widcard:bizLinkedInAccount:notag}\">\n            		    <img src=\"{$website:url}system/images/w-linkedin.png\" alt=\"linkedin\" />\n            		</a>\n            		</td>\n                </tr>\n                <tr style=\"background: #f8f8f8;\">\n                    <td> </td>\n                    <td> </td>\n                </tr>\n                </thead> \n                <!-- Content -->\n                <tbody>\n                <tr>\n                    <td style=\"padding: 25px; color: #153643; font-family: Arial, sans-serif; font-size: 16px; line-height: 20px;\">\n						{emailmessage}\n					</td>\n                </tr>\n                </tbody>\n                <!-- Footer -->\n                <tfoot>\n                <tr>\n            		<td align=\"center\" bgcolor=\"#7c7c7c\" style=\"padding: 25px 25px 25px 25px; color: #ffffff; font-family: Arial, sans-serif; font-size: 12px; line-height: 20px;\"  colspan=\"2\">\n            			<address>\n            				<font color=\"#FFFFFF\">{$plugin:widcard:BizOrgName:notag} | {$plugin:widcard:BizAddress1:notag}, {$plugin:widcard:BizCity:notag}, {$plugin:widcard:BizState:notag} {$plugin:widcard:BizZip:notag} | Tel : <a style=\"color: #FFFFFF;\" href=\"tel:{$plugin:widcard:BizTelephone:notag}\">{$plugin:widcard:BizTelephone:notag}</a></address>\n            		</td>\n            	</tr>\n                </tfoot>\n                <!-- end Footer -->\n            </table>\n        </td>\n        <td>&nbsp;</td>\n    </tr>\n</table>\n</body>\n</html>'), CONCAT('typemail') FROM `template`
WHERE NOT EXISTS (SELECT `name`, `content`, `content` FROM `template`
WHERE `name` = 'email message') LIMIT 1;

INSERT IGNORE INTO `email_triggers_actions` (`service`, `trigger`, `template`, `recipient`, `message`, `from`, `subject`)
SELECT CONCAT('email'),	CONCAT('emailsequence_nocart'),	CONCAT('email message'),	CONCAT('customer'),	CONCAT(''),	CONCAT('store@example.com'),	CONCAT('') FROM email_triggers_actions
WHERE NOT EXISTS (SELECT `service`, `trigger`, `template`, `recipient`, `message`, `from`, `subject` FROM `email_triggers_actions`
WHERE `trigger` = 'emailsequence_nocart') LIMIT 1;

INSERT IGNORE INTO `plugin_leads_workflow_general_config` (`id`, `rule_name`, `created_at`, `creator_id`, `updated_at`, `editor_id`, `score`, `score_comparison_operator`) VALUES
(1,	'Review request',	'2020-04-06 00:00:00',	1,	'2020-04-06 00:00:00',	1,	0,	'equal');
INSERT IGNORE INTO `plugin_leads_workflow_config` (`id`, `rule_id`, `rule_type`, `rule_subtype`, `field_name`, `rule_comparison_operator`, `field_value`) VALUES
(1,	1,	'lead_attribute',	'',	'nps_review_score',	'greaterthan',	'9');
INSERT IGNORE INTO `plugin_leads_workflow_actions` (`id`, `rule_id`, `action_type`, `action_config`) VALUES
(1,	1,	'send_review_request',	'{\"sendReviewRequest\":\"1\"}');

INSERT IGNORE INTO `template` (`name`, `content`, `type`) VALUES
('NPS leave review system',	'<!DOCTYPE html>\n<html xmlns:v=\"urn:schemas-microsoft-com:vml\">\n<head>\n    <meta charset=\"UTF-8\">\n    <style type=\"”text/css”\">\n        v\\:* { behavior: url(#default#VML); display:inline-block}\n    </style>\n</head>\n<body>\n<style>\n    body{\n        margin: 0;\n        padding: 0 ;\n        background-color:#f8f8f8 ;\n    }\n    p{\n        margin : 5px 0;\n        line-height: 1.7em;\n    }\n    ul{\n        padding : 0 0 0 20px;\n        color: #83B21F;\n    }\n    ul li{\n        margin-bottom : 5px;\n    }\n    a{\n        margin : 0 0 5px;\n        color: #83B21F;\n    }\n    img{\n        border-style: none;\n    }\n    hr{\n        height: 1px;\n        background: #F4F4F4;\n        border: none;\n    }\n</style>\n<table cellpadding=\"0\" cellspacing=\"0\" bgcolor=\"#f8f8f8\" width=\"100%\" style=\" margin: 0; padding: 0 ; background-color:#f8f8f8 ; height : 100%;\">\n    <tr>\n        <td>&nbsp;</td>\n        <td style=\"width: 600px;\">\n            <table style=\"font-family: Arial, Helvetica, sans-serif; background: #ffffff; width: 600px; color: #7c7c7c; font-size: 14px; text-align: left; margin: 15px 0;\" border=\"0\" width=\"600px\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\">\n                <!-- Header -->\n                <thead>\n                <tr>\n                    <td style=\"padding: 20px;\">\n            			<a target=\"_blank\" href=\"{$website:url}\">\n            				<img src=\"{$plugin:widcard:bizLogo:url}\" alt=\"{$plugin:widcard:BizOrgName:notag}\" height=\"75\" style=\"vertical-align:middle;\">\n            			</a>\n            		</td>\n            		<td style=\"text-align: center;\">\n            		<a style=\"text-decoration:none;\" rel=\"noopener\" target=\"_blank\" href=\"{$plugin:widcard:BizFbAccount:notag}\">\n            		    <img src=\"{$website:url}system/images/w-facebook.png\" alt=\"facebook\" />\n            		</a>\n            		<a style=\"text-decoration:none;\" rel=\"noopener\" target=\"_blank\" href=\"{$plugin:widcard:BizGmbusiness:notag}\">\n            		    <img src=\"{$website:url}system/images/w-gmb.png\" alt=\"GMB\" />\n            		</a> \n            		<a style=\"text-decoration:none;\" rel=\"noopener\" target=\"_blank\" href=\"{$plugin:widcard:BizTwitterAccount:notag}\">\n            		    <img src=\"{$website:url}system/images/w-twitter.png\" alt=\"twitter\" />\n            		</a> \n            		<a style=\"text-decoration:none;\" rel=\"noopener\" target=\"_blank\" href=\"{$plugin:widcard:bizLinkedInAccount:notag}\">\n            		    <img src=\"{$website:url}system/images/w-linkedin.png\" alt=\"linkedin\" />\n            		</a>\n            		</td>\n                </tr>\n                <tr style=\"background: #f8f8f8;\">\n                    <td> </td>\n                    <td> </td>\n                </tr>\n                </thead> \n                <!-- Content -->\n                <tbody>\n                <tr>\n                    <td style=\"padding: 25px; font-size: 16px;\" colspan=\"2\">\n                        <p style=\"font-size:24px; font-weight:bold; color:#000000; text-align:center;\">Hello {$lead:firstname} {$lead:lastname},</p><br/>\n                        {$content:email_text}\n                        {emailmessage}\n                         <table border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\">\n                             <tr valign=\"top\">\n                                <td align=\"right\">\n                                    <a style=\"display:inline-block; background-color:#23589B; color: #fff; text-decoration: none; margin: 10px; font-size:0;\" href=\"{$widcard:param:facebook:readonly}\"><img src=\"{$website:url}system/images/fb-btn.jpg\" alt=\"facebook\" height=\"30px\" /></a>\n                                </td>\n                                <td>\n                                    <a style=\"display:inline-block; background-color:#4881E8; color: #fff; text-decoration: none; margin: 10px; font-size:0;\" href=\"{$widcard:param:google my business:readonly}\"><img  style=\"vertical-align: middle;\" src=\"{$website:url}system/images/gmb-btn.jpg\" alt=\"GMB\" height=\"30px\" /></a>\n                                </td>\n                             </tr>\n                         </table>\n                        <br/><br/>\n                    </td>\n                </tr>\n                </tbody>\n                <!-- Footer -->\n                <tfoot>\n                <tr>\n            		<td align=\"center\" bgcolor=\"#7c7c7c\" style=\"padding: 25px 25px 25px 25px; color: #ffffff; font-family: Arial, sans-serif; font-size: 12px; line-height: 20px;\"  colspan=\"2\">\n            			<address>\n            				<font color=\"#FFFFFF\">{$plugin:widcard:BizOrgName:notag} | {$plugin:widcard:BizAddress1:notag}, {$plugin:widcard:BizCity:notag}, {$plugin:widcard:BizState:notag} {$plugin:widcard:BizZip:notag} | Tel : <a style=\"color: #FFFFFF;\" href=\"tel:{$plugin:widcard:BizTelephone:notag}\">{$plugin:widcard:BizTelephone:notag}</a></address>\n            		</td>\n            	</tr>\n                </tfoot>\n                <!-- end Footer -->\n            </table>\n        </td>\n        <td>&nbsp;</td>\n    </tr>\n</table>\n</body>\n</html>',	'typemail'),
('NPS request system',	'<!DOCTYPE html>\n<html xmlns:v=\"urn:schemas-microsoft-com:vml\">\n<head>\n    <meta charset=\"UTF-8\">\n    <style type=\"”text/css”\">\n        v\\:* { behavior: url(#default#VML); display:inline-block}\n    </style>\n</head>\n<body>\n<style>\n    body{\n        margin: 0;\n        padding: 0 ;\n        background-color:#f8f8f8 ;\n    }\n    p{\n        margin : 5px 0;\n        line-height: 1.7em;\n    }\n    ul{\n        padding : 0 0 0 20px;\n        color: #83B21F;\n    }\n    ul li{\n        margin-bottom : 5px;\n    }\n    a{\n        margin : 0 0 5px;\n        color: #83B21F;\n    }\n    img{\n        border-style: none;\n    }\n    hr{\n        height: 1px;\n        background: #F4F4F4;\n        border: none;\n    }\n</style>\n<table cellpadding=\"0\" cellspacing=\"0\" bgcolor=\"#f8f8f8\" width=\"100%\" style=\" margin: 0; padding: 0 ; background-color:#f8f8f8 ; height : 100%;\">\n    <tr>\n        <td>&nbsp;</td>\n        <td style=\"width: 600px;\">\n            <table style=\"font-family: Arial, Helvetica, sans-serif; background: #ffffff; width: 600px; color: #7c7c7c; font-size: 14px; text-align: left; margin: 15px 0;\" border=\"0\" width=\"600px\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\">\n                <!-- Header -->\n                <thead>\n                <tr>\n                    <td style=\"padding: 20px;\">\n            			<a target=\"_blank\" href=\"{$website:url}\">\n            				<img src=\"{$plugin:widcard:bizLogo:url}\" alt=\"{$plugin:widcard:BizOrgName:notag}\" height=\"75\" style=\"vertical-align:middle;\">\n            			</a>\n            		</td>\n            		<td style=\"text-align: center;\">\n            		<a style=\"text-decoration:none;\" rel=\"noopener\" target=\"_blank\" href=\"{$plugin:widcard:BizFbAccount:notag}\">\n            		    <img src=\"{$website:url}system/images/w-facebook.png\" alt=\"facebook\" />\n            		</a>\n            		<a style=\"text-decoration:none;\" rel=\"noopener\" target=\"_blank\" href=\"{$plugin:widcard:BizGmbusiness:notag}\">\n            		    <img src=\"{$website:url}system/images/w-gmb.png\" alt=\"GMB\" />\n            		</a> \n            		<a style=\"text-decoration:none;\" rel=\"noopener\" target=\"_blank\" href=\"{$plugin:widcard:BizTwitterAccount:notag}\">\n            		    <img src=\"{$website:url}system/images/w-twitter.png\" alt=\"twitter\" />\n            		</a> \n            		<a style=\"text-decoration:none;\" rel=\"noopener\" target=\"_blank\" href=\"{$plugin:widcard:bizLinkedInAccount:notag}\">\n            		    <img src=\"{$website:url}system/images/w-linkedin.png\" alt=\"linkedin\" />\n            		</a>\n            		</td>\n                </tr>\n                <tr style=\"background: #f8f8f8;\">\n                    <td> </td>\n                    <td> </td>\n                </tr>\n                </thead> \n                <!-- Content -->\n                <tbody>\n                <tr>\n                    <td style=\"padding: 25px; font-size: 16px;\" colspan=\"2\">\n                        <h1 style=\"font-size: 32px; text-align: center; margin-bottom:0; color:#000000;\">Hello, {$lead:firstname}!</h1>\n                        <p style=\"font-size: 32px; text-align: center; color:#000000;\">Help us to improve our services</p>\n                        <br/>\n                        <p style=\"text-align: center; font-weight:bold;\">\n                            How likely is it that you would recommend<br/>\n                            {$plugin:widcard:BizOrgName:notag} to a friend or collegue?\n                        </p>\n                        <br/><br/>\n                        <table cellpadding=\"0\" cellspacing=\"0\"  width=\"100%\" border=\"0\" align=\"center\" >\n                        <tr>\n                            <td width=\"9%\" bgcolor=\"#FE0000\" style=\"height:38px; text-align:center;; border:1px solid #ffffff;\"><a style=\"display: block; width: 100%; margin:0; padding:0;  text-decoration: none; color: #ffffff; font-weight: bold\" href=\"{$lead:npsreviewrequest:0}\">0</a></td>\n                            <td width=\"9%\" bgcolor=\"#FE0000\" style=\"height:38px; text-align:center; border:1px solid #ffffff;\"><a style=\"display: block; width: 100%; margin:0; padding:0; text-decoration: none; color: #ffffff; font-weight: bold;\" href=\"{$lead:npsreviewrequest:1}\">1</a></td>\n                            <td width=\"9%\" bgcolor=\"#FE0000\" style=\"height:38px; text-align:center; border:1px solid #ffffff;\"><a style=\"display: block; width: 100%; margin:0; padding:0; text-decoration: none; color: #ffffff; font-weight: bold;\" href=\"{$lead:npsreviewrequest:2}\">2</a></td>\n                            <td width=\"9%\" bgcolor=\"#FE0000\" style=\"height:38px; text-align:center; border:1px solid #ffffff;\"><a style=\"display: block; width: 100%; margin:0; padding:0; text-decoration: none; color: #ffffff; font-weight: bold;\" href=\"{$lead:npsreviewrequest:3}\">3</a></td>\n                            <td width=\"9%\" bgcolor=\"#FE0000\" style=\"height:38px; text-align:center; border:1px solid #ffffff;\"><a style=\"display: block; width: 100%; margin:0; padding:0; text-decoration: none; color: #ffffff; font-weight: bold;\" href=\"{$lead:npsreviewrequest:4}\">4</a></td>\n                            <td width=\"9%\" bgcolor=\"#FE0000\" style=\"height:38px; text-align:center; border:1px solid #ffffff;\"><a style=\"display: block; width: 100%; margin:0; padding:0; text-decoration: none; color: #ffffff; font-weight: bold;\" href=\"{$lead:npsreviewrequest:5}\">5</a></td>\n                            <td width=\"9%\" bgcolor=\"#FE0000\" style=\"height:38px; text-align:center; border:1px solid #ffffff;\"><a style=\"display: block; width: 100%; margin:0; padding:0; text-decoration: none; color: #ffffff; font-weight: bold;\" href=\"{$lead:npsreviewrequest:6}\">6</a></td>\n                            <td width=\"9%\" bgcolor=\"#F0C409\" style=\"height:38px; text-align:center; border:1px solid #ffffff;\"><a style=\"display: block; width: 100%; margin:0; padding:0; text-decoration: none; color: #ffffff; font-weight: bold;\" href=\"{$lead:npsreviewrequest:7}\">7</a></td>\n                            <td width=\"9%\" bgcolor=\"#F0C409\" style=\"height:38px; text-align:center; border:1px solid #ffffff;\"><a style=\"display: block; width: 100%; margin:0; padding:0; text-decoration: none; color: #ffffff; font-weight: bold;\" href=\"{$lead:npsreviewrequest:8}\">8</a></td>\n                            <td width=\"9%\" bgcolor=\"#02A401\" style=\"height:38px; text-align:center; border:1px solid #ffffff;\"><a style=\"display: block; width: 100%; margin:0; padding:0; text-decoration: none; color: #ffffff; font-weight: bold;\" href=\"{$lead:npsreviewrequest:9}\">9</a></td>\n                            <td width=\"9%\" bgcolor=\"#02A401\" style=\"height:38px; text-align:center; border:1px solid #ffffff;\"><a style=\"display: block; width: 100%; margin:0; padding:0; text-decoration: none; color: #ffffff; font-weight: bold;\" href=\"{$lead:npsreviewrequest:10}\">10</a></td>\n                        </tr>    \n                        </table><br/>\n                        <table cellpadding=\"0\" cellspacing=\"0\"  width=\"100%\" >\n                            <tr>\n                                <td align=\"left\" width=\"50%\">Very Unlikely</td>\n                                <td align=\"right\" width=\"50%\">Extremely Likely</td>\n                            </tr>\n                        </table>\n                        <br/><br/><br/><br/>\n                        {$content:email_text}\n                        {emailmessage}\n                    </td>\n                </tr>\n                </tbody>\n                <!-- Footer -->\n                <tfoot>\n                <tr>\n            		<td align=\"center\" bgcolor=\"#7c7c7c\" style=\"padding: 25px 25px 25px 25px; color: #ffffff; font-family: Arial, sans-serif; font-size: 12px; line-height: 20px;\"  colspan=\"2\">\n            			<address>\n            				<font color=\"#FFFFFF\">{$plugin:widcard:BizOrgName:notag} | {$plugin:widcard:BizAddress1:notag}, {$plugin:widcard:BizCity:notag}, {$plugin:widcard:BizState:notag} {$plugin:widcard:BizZip:notag} | Tel : <a style=\"color: #FFFFFF;\" href=\"tel:{$plugin:widcard:BizTelephone:notag}\">{$plugin:widcard:BizTelephone:notag}</a></address>\n            		</td>\n            	</tr>\n                </tfoot>\n                <!-- end Footer -->\n            </table>\n        </td>\n        <td>&nbsp;</td>\n    </tr>\n</table>\n</body>\n</html>',	'typemail');

INSERT IGNORE INTO `email_triggers_actions` (`service`, `trigger`, `template`, `recipient`, `message`, `from`, `subject`)
SELECT CONCAT('email'),	CONCAT('leads_npsreviewrequest'),	CONCAT('NPS request system'),	CONCAT('guest'),	CONCAT('<p>Thank you so much for being a valuable customer. Please help us improve by sharing with others your experience about  {$plugin:widcard:BizOrgName:notag}. We would be extremely grateful if you could write a quick review.</p>'),	CONCAT('{$leadowner:email}'),	CONCAT('Please share your experience with others') FROM email_triggers_actions
WHERE NOT EXISTS (SELECT `service`, `trigger`, `template`, `recipient`, `message`, `from`, `subject` FROM `email_triggers_actions`
WHERE `trigger` = 'leads_npsreviewrequest') LIMIT 1;

INSERT IGNORE INTO `email_triggers_actions` (`service`, `trigger`, `template`, `recipient`, `message`, `from`, `subject`)
SELECT CONCAT('email'),	CONCAT('leads_reviewrequest'),	CONCAT('NPS leave review system'),	CONCAT('guest'),	CONCAT('<p>Thank you so much for being a valuable customer. Please help us improve by sharing with others your experience about  {$plugin:widcard:BizOrgName:notag}. We would be extremely grateful if you could write a quick review.</p>'),	CONCAT('{$leadowner:email}'),	CONCAT('Please share your experience with others') FROM email_triggers_actions
WHERE NOT EXISTS (SELECT `service`, `trigger`, `template`, `recipient`, `message`, `from`, `subject` FROM `email_triggers_actions`
WHERE `trigger` = 'leads_reviewrequest') LIMIT 1;

INSERT IGNORE INTO `plugin_cartstatusemail_settings` (`id`, `cartStatus`, `type`, `period`, `productsIds`, `emailTemplate`, `emailFrom`, `productsRule`, `emailMessage`, `schedulePeriod`, `schedulePeriodType`, `lagType`, `sequenceOnly`, `triggerName`, `subject`) VALUES
(1,	'no_cart',	'email',	1,	'',	'NPS request system',	'{$leadowner:email}',	'without',	'',	'sunday,monday,tuesday,wednesday,thursday,friday,saturday',	'anytime',	'hour',	'1',	'NPS request',	'Please share your experience with others');

INSERT IGNORE INTO `plugin_emailsequence_settings` (`id`, `sequence_name`, `archive`) VALUES
(1,	'NPS request',	'0');

INSERT IGNORE INTO `plugin_emailsequence_triggers` (`sequence_settings_id`, `trigger_id`, `trigger_enabled`) VALUES
(1,	1,	'1');

CREATE TABLE IF NOT EXISTS `plugin_leads_mobile_app_config` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `login` VARCHAR (255) COLLATE utf8_unicode_ci NOT NULL,
  `password` VARCHAR (255) NOT NULL,
  `status` ENUM('enabled', 'disabled') DEFAULT 'enabled' NOT NULL,
  `social_app_status` ENUM('enabled', 'disabled') DEFAULT 'enabled' NOT NULL,
  `created_at` TIMESTAMP NOT NULL,
  `updated_at` TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE (`login`),
  FOREIGN KEY (`user_id`) REFERENCES `user`(`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_advertiser_account_config` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `adv_id` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  `adv_name` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `adv_type` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  `adv_status` ENUM('pending', 'connected', 'disconnected') DEFAULT 'pending',
  `adv_verification_link` TEXT COLLATE utf8_unicode_ci DEFAULT NULL,
  `allow_delete` ENUM('0', '1') DEFAULT '1',
  PRIMARY KEY(`id`),
  UNIQUE(`adv_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_external_notifications` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `status` ENUM('scheduled', 'sent', 'failed') DEFAULT 'scheduled' NOT NULL,
  `lead_id` int(10) unsigned NOT NULL,
  `additional_info` TEXT COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_at` TIMESTAMP NOT NULL,
  `updated_at` TIMESTAMP,
  PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_external_notifications_endpoints` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `method_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT IGNORE INTO `plugin_leads_external_notifications_endpoints` (`method_name`) VALUES
('crmLeadInfo');

CREATE TABLE IF NOT EXISTS `plugin_leads_imap_rules_config` (
  `id` INT(10) unsigned AUTO_INCREMENT,
  `rule_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL COMMENT 'Rule name',
  `imap_config_id` int(10) unsigned NOT NULL COMMENT 'IMAP config id',
  `rule_email` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL COMMENT 'Rule email',
  `sub_rules_config` TEXT COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Rule subrules',
  `created_at` TIMESTAMP NOT NULL,
  `creator_id` INT(10) UNSIGNED DEFAULT NULL,
  `updated_at` TIMESTAMP NULL,
  `editor_id` INT(10) UNSIGNED DEFAULT NULL,
PRIMARY KEY(`id`),
FOREIGN KEY (`creator_id`) REFERENCES `user` (`id`) ON DELETE SET NULL ON UPDATE NO ACTION,
FOREIGN KEY (`editor_id`) REFERENCES `user` (`id`) ON DELETE SET NULL ON UPDATE NO ACTION,
FOREIGN KEY (`imap_config_id`) REFERENCES `plugin_leads_imap_config` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_owner_goals` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `user_id` INT(10) UNSIGNED NOT NULL,
  `quote_objective` INT(10) UNSIGNED NOT NULL,
  `quotes_amount` INT(10) UNSIGNED NOT NULL,
  `meetings_held` INT(10) UNSIGNED NOT NULL,
  `calls_placed` INT(10) UNSIGNED NOT NULL,
  `emails_sent` INT(10) UNSIGNED NOT NULL,
PRIMARY KEY(`id`),
UNIQUE (`user_id`),
FOREIGN KEY (`user_id`) REFERENCES `user`(`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_owner_goals_opportunities` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `owner_goals_id` INT(10) UNSIGNED NOT NULL,
  `opportunity_amount` INT(10) UNSIGNED NOT NULL,
  `opportunity_count` INT(10) UNSIGNED NOT NULL,
  `opportunity_type_id` INT(10) UNSIGNED NOT NULL,
PRIMARY KEY(`id`),
FOREIGN KEY (`owner_goals_id`) REFERENCES `plugin_leads_owner_goals`(`id`) ON DELETE CASCADE ON UPDATE NO ACTION,
FOREIGN KEY (`opportunity_type_id`) REFERENCES `plugin_leads_opportunity_type`(`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_internal_notifications` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `status` ENUM('scheduled', 'sent', 'failed') DEFAULT 'scheduled' NOT NULL,
  `lead_id` int(10) unsigned NOT NULL,
  `additional_info` TEXT COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_at` TIMESTAMP NOT NULL,
  `updated_at` TIMESTAMP,
  PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_hidden_opportunities` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `opportunity_id` int(10) UNSIGNED NOT NULL,
  PRIMARY KEY(`id`),
  FOREIGN KEY (`opportunity_id`) REFERENCES `plugin_leads_opportunity` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT IGNORE INTO `config` (`name`, `value`) VALUES ('redirectAdminAfterLogin', '');

CREATE TABLE IF NOT EXISTS `plugin_leads_table_columns_order` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `table_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  `preset_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  `is_default` ENUM('0', '1') DEFAULT '0',
  `fields_data` TEXT COLLATE utf8_unicode_ci DEFAULT NULL,
  `user_id` INT(10) UNSIGNED DEFAULT NULL,
  `apply_to_all` ENUM('0', '1') DEFAULT '0',
  `created_at` TIMESTAMP NOT NULL,
  PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `plugin_leads_table_columns_order` ( `table_name`, `preset_name`, `is_default`, `fields_data`, `user_id`, `apply_to_all`, `created_at`) VALUES
('dashboard_latest_leads',	'corporate',	'0',	'[\"placeholder\",\"id\",\"name\",\"organization\",\"leadEmail\",\"leadPhone\",\"leadCreatedAt\",\"leadType\",\"leadOwner\",\"actions\"]',	NULL,	'1',	'2022-01-27 11:29:02');

INSERT INTO `plugin_leads_table_columns_order` ( `table_name`, `preset_name`, `is_default`, `fields_data`, `user_id`, `apply_to_all`, `created_at`) VALUES
('dashboard_engaged_leads',	'corporate',	'0',	'[\"placeholder\",\"id\",\"score\",\"name\",\"organization\",\"leadEmail\",\"leadPhone\",\"totalOppsAmount\",\"leadLastActivity\",\"engagedLifecycle\",\"actions\"]',	NULL,	'1',	'2022-01-27 11:29:02');

INSERT INTO `plugin_leads_table_columns_order` ( `table_name`, `preset_name`, `is_default`, `fields_data`, `user_id`, `apply_to_all`, `created_at`) VALUES
('dashboard_leads_grid',	'corporate',	'0',	'[\"placeholder\",\"id\",\"name\",\"organization\",\"leadEmail\",\"leadMobile\",\"lifecycle\",\"totalOppsAmount\",\"leadGroup\",\"totalSpend\",\"leadType\",\"leadSource\",\"leadLastActivity\",\"leadNextAction\",\"actions\"]',	NULL,	'1',	'2025-02-10 11:29:02');

CREATE TABLE IF NOT EXISTS `plugin_leads_remarketing_audiences` (
    `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
    `type` ENUM('facebook', 'adwords') DEFAULT 'facebook' NOT NULL,
    `action` ENUM('add', 'remove') DEFAULT 'add',
    `audience_id` TEXT COLLATE utf8_unicode_ci NOT NULL,
    `list_content` LONGTEXT COLLATE utf8_unicode_ci DEFAULT NULL,
    `additional_info` TEXT COLLATE utf8_unicode_ci DEFAULT NULL,
    `created_at` TIMESTAMP NOT NULL,
    PRIMARY KEY(`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT IGNORE INTO `plugin_leads_config` (`name`, `value`) VALUES
    ('remarketingAudiencesFacebookProcessedDate', ''),
    ('remarketingAudiencesFacebookProcessedCount', '0'),
    ('remarketingAudiencesAdwordsProcessedDate', ''),
    ('remarketingAudiencesAdwordsProcessedCount', '0'),
    ('enableAiChat', '1'),
    ('enableProcessLeadSourceUtmTags', '1');

CREATE TABLE IF NOT EXISTS `plugin_leads_hashed_address_coordinates` (
    `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
    `address_hash` CHAR(40) NOT NULL,
    `lat` VARCHAR(100) DEFAULT NULL,
    `lng` VARCHAR(100) DEFAULT NULL,
    PRIMARY KEY(`id`),
    UNIQUE (`address_hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_clean_up_fields_log` (
    `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
    `created_at` TIMESTAMP NULL,
    `logged_user_id` INT(10) UNSIGNED NOT NULL,
    `type` VARCHAR(64) COLLATE utf8_unicode_ci NOT NULL,
    `ip_address` VARCHAR(45) NOT NULL,
    `deleted_items_info` MEDIUMTEXT COLLATE utf8_unicode_ci DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_organize_custom_fields_config` (
    `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
    `type` VARCHAR(255) DEFAULT NULL,
    `draggable_params_ids` TEXT DEFAULT NULL COMMENT 'Draggable custom params ids',
    PRIMARY KEY(`id`),
    UNIQUE (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_emailsequence_ban_ips` (
  `ip_address` VARCHAR(45) NOT NULL,
  PRIMARY KEY(`ip_address`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_tasks_presets` (
  `id` INT(10) unsigned AUTO_INCREMENT,
  `preset_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL COMMENT 'Preset name',
  `task_title` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL COMMENT 'Task title',
  `task_note` TEXT COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Task notes',
  `created_at` TIMESTAMP NOT NULL,
  `creator_id` INT(10) UNSIGNED DEFAULT NULL,
  `updated_at` TIMESTAMP NULL,
  `editor_id` INT(10) UNSIGNED DEFAULT NULL,
PRIMARY KEY(`id`),
FOREIGN KEY (`creator_id`) REFERENCES `user` (`id`) ON DELETE SET NULL ON UPDATE NO ACTION,
FOREIGN KEY (`editor_id`) REFERENCES `user` (`id`) ON DELETE SET NULL ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_webhook_urls` (
    `id` INT(10) unsigned AUTO_INCREMENT,
    `webhook_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
    `webhook_type` ENUM('lead', 'organization', 'order') DEFAULT 'lead',
    `webhook_action_type` VARCHAR (255) COLLATE utf8_unicode_ci NOT NULL,
    `action_url` TEXT COLLATE utf8_unicode_ci DEFAULT NULL,
    `created_at` TIMESTAMP NOT NULL,
    `creator_id` INT(10) UNSIGNED DEFAULT NULL,
    `updated_at` TIMESTAMP NOT NULL,
    `editor_id` INT(10) UNSIGNED DEFAULT NULL,
    PRIMARY KEY(`id`),
    FOREIGN KEY (`creator_id`) REFERENCES `user` (`id`) ON DELETE SET NULL ON UPDATE NO ACTION,
    FOREIGN KEY (`editor_id`) REFERENCES `user` (`id`) ON DELETE SET NULL ON UPDATE NO ACTION
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_webhook_notifications` (
    `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
    `status` ENUM('scheduled', 'sent', 'failed') DEFAULT 'scheduled' NOT NULL,
    `webhook_type` ENUM('lead', 'organization', 'order') DEFAULT 'lead',
    `resource_id` int(10) unsigned NOT NULL,
    `webhook_action_type` VARCHAR (255) COLLATE utf8_unicode_ci NOT NULL,
    `additional_info` MEDIUMTEXT COLLATE utf8_unicode_ci DEFAULT NULL,
    `created_at` TIMESTAMP NOT NULL,
    `updated_at` TIMESTAMP,
    `sent_notifications_data` TEXT COLLATE utf8_unicode_ci NULL,
    `sent_at` TIMESTAMP NULL,
    PRIMARY KEY(`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_validate_emails_queue` (
 `id` INT(10) unsigned AUTO_INCREMENT,
 `creator_id` INT(10) UNSIGNED DEFAULT NULL,
 `created_at` TIMESTAMP NOT NULL COMMENT 'Record added to queue date',
 `process_at` TIMESTAMP NOT NULL COMMENT 'To process item',
 `processed_at` TIMESTAMP NULL COMMENT 'Processed at item',
 `delayed_to` TIMESTAMP NULL COMMENT 'Delayed to item',
 `lead_ids` MEDIUMTEXT DEFAULT NULL,
 `status` ENUM('new', 'processing', 'delayed', 'processed', 'error') DEFAULT 'new' NOT NULL,
 `processed_leads` INT(10) UNSIGNED DEFAULT NULL,
 `not_processed_leads` INT(10) UNSIGNED DEFAULT NULL,
 `balance` INT(10) UNSIGNED DEFAULT NULL,
 `error_info` TEXT DEFAULT NULL,
 PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_mass_actions_queue` (
 `id` INT(10) unsigned AUTO_INCREMENT,
 `creator_id` INT(10) UNSIGNED DEFAULT NULL,
 `type` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL COMMENT 'Name of mass action',
 `created_at` TIMESTAMP NOT NULL COMMENT 'Record added to queue date',
 `process_at` TIMESTAMP NOT NULL COMMENT 'To process item',
 `processed_at` TIMESTAMP NULL COMMENT 'Processed at item',
 `delayed_to` TIMESTAMP NULL COMMENT 'Delayed to item',
 `lead_ids` MEDIUMTEXT DEFAULT NULL,
 `status` ENUM('new', 'processing', 'delayed', 'processed', 'error') DEFAULT 'new' NOT NULL,
 `processed_leads` INT(10) UNSIGNED DEFAULT NULL,
 `not_processed_leads` INT(10) UNSIGNED DEFAULT NULL,
 `additional_data` TEXT DEFAULT NULL,
 `error_info` TEXT DEFAULT NULL,
 PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_email_report_log` (
`id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
`user_id` INT(10) UNSIGNED NOT NULL,
`status` ENUM('processed', 'processing', 'delayed') DEFAULT 'processing' NOT NULL,
`sent_at_date` TIMESTAMP NOT NULL,
`processed_at` TIMESTAMP,
PRIMARY KEY(`id`),
FOREIGN KEY (`user_id`) REFERENCES `user`(`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_oauth2_apps_config` (
`id` int(10) unsigned NOT NULL AUTO_INCREMENT,
`service_app_name` VARCHAR (255) COLLATE utf8_unicode_ci NOT NULL,
`client_secret` TEXT DEFAULT NULL,
`client_id` TEXT DEFAULT NULL,
`is_imap` ENUM('0', '1') DEFAULT '0',
`is_system` ENUM('0', '1') DEFAULT '0',
PRIMARY KEY (`id`),
UNIQUE (`service_app_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT IGNORE INTO `plugin_leads_oauth2_apps_config` (`id`, `service_app_name`, `client_secret`, `client_id`, `is_imap`, `is_system`) VALUES
(1,	'outlook',	'',	'',	'1', '1'),
(2,	'gmail',	'',	'',	'1', '1');

CREATE TABLE IF NOT EXISTS `plugin_leads_apps_notification_queue` (
`id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
`lead_id` INT(10) UNSIGNED NOT NULL,
`type` ENUM('new_lead', 'update_lead') DEFAULT 'new_lead' NOT NULL,
`status` ENUM('scheduled', 'sent', 'failed') DEFAULT 'scheduled' NOT NULL,
`created_at` TIMESTAMP NOT NULL,
PRIMARY KEY (`id`),
UNIQUE(`lead_id`, `type`),
FOREIGN KEY (`lead_id`) REFERENCES `plugin_leads_data`(`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

UPDATE `plugin` SET `tags`='crm,hiddenemail,emaillog,userdelete,assigngroup,userupdate' WHERE `name` = 'leads';
UPDATE `plugin` SET `version` = '2.3.1' WHERE `name` = 'leads';
