define([
	'underscore',
	'backbone',
    'text!../templates/product-listing-template.html',
    'i18n!../../../nls/dashboard_'+$('#email-sequence-dashboard-system-language').val()+'_ln'
], function(_, Backbone, ProductListingTemplate, i18n){
	
	var ProductView = Backbone.View.extend({
		tagName: 'div',
		className: 'productlisting',
		template: _.template(ProductListingTemplate),
        container: $('#product-list-holder'),
		events: {},
		initialize: function(){
			this.model.on('change', this.render, this);
            this.model.on('remove', this.remove, this);
		},
		render: function(){
            var data = {
                websiteUrl: $('#website_url').val(),
                mediaPath: $('#media-path').val(),
                showDelete: _.has(this.options, 'showDelete') ? this.options.showDelete : false
            };
            if (!this.model.has('rendered')){
                data.lazy = true;
                this.model.set({rendered: true}, {silent: true});
            }
            data.i18n = i18n;
			$(this.el).html(this.template(_.extend(data, this.model.toJSON())));
			return this;
		}
	});
	
	return ProductView;
});