define([
	'backbone',
    '../collections/email_sequence.js',
    './email_sequence_triggers.js',
    'text!../templates/email-sequence-form.html',
    'text!../templates/email-sequence-triggers-placeholder.html'
], function(Backbone, EmailSequenceCollection, EmailSequenceTriggersView,  EmailSequenceFormTmpl, EmailSequenceTriggersPlaceholderTmpl){
    var EmailSequenceFormView = Backbone.View.extend({
        el: $('#email-sequence-form-block'),
        events: {
            'submit #sequence-form': 'saveSequence',
            'change #existing-sequence-name':'changeSequence',
            'change input.sequence-status': 'switchOldNewSequence',
            'keyup .new-sequence-name': 'showTriggersForNewSequence',
            'submit #triggers-form': 'addTriggerToSequence',
            'click .sequence-status-create' : 'createNewSequence',
            'click .sequence-status-delete' : 'deleteSequence',
            'click #new-sequence-close' : 'closeNewSequence'
        },
        templates: {

        },
        initialize: function(){
           this.$el = $('#email-sequence-form-block');
           this.emailSequenceCollection = new EmailSequenceCollection();
           this.emailSequenceCollection.on('reset', this.render, this);
           this.emailSequenceCollection.on('add', this.render, this);
           this.emailSequenceCollection.on('destroy', this.render, this);
           this.emailSequenceCollection.pager();
        },
        render: function(){
            this.$el = $('#email-sequence-form-block');
            this.$el.empty();
            this.emailSequenceCollection.triggersArray = this.alphabeticalSort(this.emailSequenceCollection.triggers);
            this.$el.html(_.template(EmailSequenceFormTmpl, {'sequencesModels':this.emailSequenceCollection}));
            return this;
        },
        alphabeticalSort: function(obj){
            // convert object into array
            var sortable=[];
            for(var key in obj)
                if(obj.hasOwnProperty(key))
                    sortable.push([key, obj[key]]); // each item is an array in format [key, value]

            // sort items by value
            sortable.sort(function(a, b)
            {
                var x=a[1].toLowerCase(),
                    y=b[1].toLowerCase();
                return x<y ? -1 : x>y ? 1 : 0;
            });
            return sortable; // array in format [ [ key1, val1 ], [ key2, val2 ], ... ]
        },
        changeSequence: function(e) {
            e.preventDefault();
            var sequenceId = $(e.currentTarget).val();
            if (sequenceId != 0) {
                this.showTriggers();
                $('.sequence-status-delete').removeAttr('disabled');
            } else {
                this.hideTriggers();
                $('#email-sequence-triggers-block').empty();
                $('.sequence-status-delete').attr('disabled', true);
            }
            if (typeof this.emailSequenceTriggersView !== 'undefined') {
                this.emailSequenceTriggersView.$el.unbind();
            }
            this.emailSequenceTriggersView = new EmailSequenceTriggersView(sequenceId);
            this.emailSequenceTriggersView.render();
        },
        showTriggersForNewSequence: function(e){
            var newSequenceName = $(e.currentTarget).val();
            if (newSequenceName) {
                this.showTriggers();
            } else {
                this.hideTriggers();
            }

        },
        showTriggers: function() {
            $('#triggers-list').prop('disabled', false);
            $('#triggers-list-submit').prop('disabled', false);
        },
        hideTriggers: function() {
            $('#triggers-list').prop('disabled', true);
            $('#triggers-list-submit').prop('disabled', true);
        },
        createNewSequence: function(e) {
            e.preventDefault();
            $('#sequence-form').removeClass('hidden');
            $('#existing-sequence-name').closest('p').addClass('hidden').val(0).trigger('change');
            $('#triggers-form').addClass('hidden');
            $('.sequence-status-delete').attr('disabled', true);
            $('#email-sequence-triggers-block').html(_.template(EmailSequenceTriggersPlaceholderTmpl, {}));
            $('#existing-sequence-name').val('0');
        },
        closeNewSequence:function(e) {
            $('#sequence-form').addClass('hidden');
            $('#existing-sequence-name').closest('p').removeClass('hidden');
            if ($('#existing-sequence-name').val() == '0') {
                this.hideTriggers();
            } else {
                this.showTriggers();
            }
            $('#triggers-form').removeClass('hidden');
        },
        deleteSequence: function(e){
            e.preventDefault();
            var sequenceId = $('#existing-sequence-name').val(),
                self = this;

            if (sequenceId == '0') {
                return false;
            }

            showConfirm("Are you sure you want to delete the email sequence?", function() {
                $.ajax({
                    'url': $('#website_url').val()+'/api/emailsequence/emailsequence/id/'+sequenceId,
                    'type' : 'DELETE',
                    'dataType' : 'json',
                    'data' : {}
                }).done(function(response){
                    showMessage(response.responseText, false, 5000);
                    $('#email-sequence-triggers-block').empty();
                    $('.sequence-status-delete').attr('disabled', true);
                    $('#email-sequence-triggers-block').html(_.template(EmailSequenceTriggersPlaceholderTmpl, {}));
                    self.emailSequenceCollection.fetch();
                }).fail(function(response){
                    showMessage(response.responseJSON, true, 5000);
                });
            });
        },
        switchOldNewSequence: function(e) {
            var switchVal = $(e.currentTarget).val();
            if (switchVal === 'new_sequence') {
                $('#sequence-form').removeClass('hidden');
                $('#existing-sequence-name').addClass('hidden').val(0).trigger('change');
                $('#triggers-form').addClass('hidden');
            } else {
                $('#sequence-form').addClass('hidden');
                $('#existing-sequence-name').removeClass('hidden');
                if ($('#existing-sequence-name').val() == '0') {
                    this.hideTriggers();
                } else {
                    this.showTriggers();
                }
                $('#triggers-form').removeClass('hidden');
             }
        },
        addTriggerToSequence: function(e)
        {
            e.preventDefault();

            var self = this,
                form = $(e.currentTarget),
                isValid = true,
                sequenceSettingsId = $('#existing-sequence-name').val();

            _.each(form.find('.required'), function(el){
                if (!$(el).val()){
                    isValid = false;
                }
            });

            if (!isValid){
                showMessage('Missing required field', true);
                return false;
            }
            showSpinner();

            $.ajax({
                url: $('#website_url').val()+'api/emailsequence/emailsequencetrigger/',
                data: {
                    'trigger_id': form.find('#triggers-list').val(),
                    'sequence_settings_id' : sequenceSettingsId,
                    'secureToken': $('#email-sequence-secure-token').val()
                },
                type: 'POST',
                dataType: 'json'
            }).done(function(responseData) {
                hideSpinner();
                showMessage('Trigger added');
                self.emailSequenceTriggersView.$el.unbind();
                self.emailSequenceTriggersView = new EmailSequenceTriggersView(sequenceSettingsId);
                self.emailSequenceTriggersView.render();

            }).fail(function(response){
                hideSpinner();
                showMessage(response.responseJSON, true, 5000);
            });
        },
        saveSequence: function(e) {
            e.preventDefault();
            var self = this,
                form = $(e.currentTarget),
                isValid = true;

            _.each(form.find('.required'), function(el){
                if (!$(el).val()){
                    isValid = false;
                }
            });

            if (!isValid){
                showMessage('Missing required field', true);
                return false;
            }
            showSpinner();

            $.ajax({
                url: $('#website_url').val()+'api/emailsequence/emailsequence/',
                data: {
                    'sequence_name': form.find('.new-sequence-name').val(),
                    'secureToken': $('#email-sequence-secure-token').val()
                },
                type: 'POST',
                dataType: 'json'
            }).done(function(responseData) {
                hideSpinner();
                showMessage('Saved');
                self.emailSequenceCollection.fetch({
                    success: function(response){
                       self.render();
                       $('#existing-sequence-name').val(responseData.responseText.sequenceId);
                       $('.sequence-status-delete').removeAttr('disabled');
                       self.showTriggers();
                       if (typeof self.emailSequenceTriggersView !== 'undefined') {
                           self.emailSequenceTriggersView.$el.unbind();
                       }
                       self.emailSequenceTriggersView = new EmailSequenceTriggersView(responseData.responseText.sequenceId);
                       self.emailSequenceTriggersView.render();
                    }
                });
            }).fail(function(response){
                hideSpinner();
                showMessage(response.responseJSON, true, 5000);
            });

        }

    });

    return EmailSequenceFormView;
});