define([
	'backbone',
    '../collections/email-sequence',
    './email-sequence-triggers',
    'text!../templates/email-sequence-form.html',
    'text!../templates/email-sequence-triggers-placeholder.html',
    'i18n!../../../nls/dashboard_'+$('#email-sequence-dashboard-system-language').val()+'_ln'
], function(Backbone, EmailSequenceCollection, EmailSequenceTriggersView,  EmailSequenceFormTmpl, EmailSequenceTriggersPlaceholderTmpl, i18n){
    var EmailSequenceFormView = Backbone.View.extend({
        el: $('#email-sequence-form-block'),
        events: {
            'submit #sequence-form': 'saveSequence',
            'change #existing-sequence-name':'changeSequence',
            'change input.sequence-status': 'switchOldNewSequence',
            'keyup .new-sequence-name': 'showTriggersForNewSequence',
            'submit #triggers-form': 'addTriggerToSequence',
            'click .sequence-status-create' : 'createNewSequence',
            'click .sequence-status-delete' : 'deleteSequence',
            'click #new-sequence-close' : 'closeNewSequence',
            'change input.rename-email-sequence': 'renameSequence',
        },
        templates: {

        },
        initialize: function(emailSequenceId){
           this.$el.unbind();
           this.$el = $('#email-sequence-form-block');
           this.emailSequenceCollection = new EmailSequenceCollection();
           this.emailSequenceCollection.on('reset', this.render, this);
           this.emailSequenceCollection.on('add', this.render, this);
           this.emailSequenceCollection.on('destroy', this.render, this);
           if (typeof emailSequenceId !== 'undefined') {
               this.emailSequenceCollection.emailSequenceId = emailSequenceId;
           }
           this.emailSequenceCollection.pager();
        },
        render: function(){
            this.$el = $('#email-sequence-form-block');
            this.$el.empty();
            this.emailSequenceCollection.triggersArray = this.alphabeticalSort(this.emailSequenceCollection.triggers);
            this.$el.html(_.template(EmailSequenceFormTmpl, {
                'sequencesModels':this.emailSequenceCollection,
                'limitedAccess' : this.emailSequenceCollection.limitedAccess,
                'i18n': i18n
            }));

            if (typeof this.emailSequenceCollection.emailSequenceId !== 'undefined') {
                this.$el.find('#existing-sequence-name').val(this.emailSequenceCollection.emailSequenceId).trigger('change');
            }
            return this;
        },
        alphabeticalSort: function(obj){
            // convert object into array
            var sortable=[];
            for(var key in obj)
                if(obj.hasOwnProperty(key))
                    sortable.push([key, obj[key]]); // each item is an array in format [key, value]

            // sort items by value
            sortable.sort(function(a, b)
            {
                var x=a[1].toLowerCase(),
                    y=b[1].toLowerCase();
                return x<y ? -1 : x>y ? 1 : 0;
            });
            return sortable; // array in format [ [ key1, val1 ], [ key2, val2 ], ... ]
        },
        changeSequence: function(e) {
            e.preventDefault();
            var sequenceId = $(e.currentTarget).val();
            if (sequenceId != 0) {
                var selectedOptionName = $("#existing-sequence-name option:selected").text();
                this.showTriggers();
                $('.sequence-status-delete').removeAttr('disabled');
                $('.rename-email-sequence').data('sequence-id', sequenceId).val(selectedOptionName).removeAttr('disabled');
            } else {
                this.hideTriggers();
                $('#email-sequence-triggers-block').empty();
                $('.sequence-status-delete').attr('disabled', true);
                $('.rename-email-sequence').data('sequence-id', '').val('').attr('disabled', true);
            }
            if (typeof this.emailSequenceTriggersView !== 'undefined') {
                this.emailSequenceTriggersView.$el.unbind();
            }
            this.emailSequenceTriggersView = new EmailSequenceTriggersView(sequenceId);
            this.emailSequenceTriggersView.render();
        },
        renameSequence: function (e) {
            var currentEl = $(e.currentTarget),
                sequenceName = currentEl.val(),
                sequenceId = currentEl.data('sequence-id'),
                existingSequenceName = $('#existing-sequence-name').find(":selected").text();

            if(sequenceName == '') {
                $('.rename-email-sequence').val(existingSequenceName);
                return false;
            }

            $.ajax({
                url: $('#website_url').val()+'api/emailsequence/emailsequence/',
                data: {
                    'sequence_name': sequenceName,
                    'sequenceId': sequenceId,
                    'renameSequence': 1,
                    'secureToken': $('#email-sequence-secure-token').val()
                },
                type: 'POST',
                dataType: 'json'
            }).done(function(responseData) {
                $('#existing-sequence-name').find(":selected").text(sequenceName);
                showMessage(responseData.responseText.message, false, 2000);
            }).fail(function(response){
                $('.rename-email-sequence').val(existingSequenceName);
                showMessage(response.responseJSON, true, 5000);
            });
        },
        showTriggersForNewSequence: function(e){
            var newSequenceName = $(e.currentTarget).val();
            if (newSequenceName) {
                this.showTriggers();
            } else {
                this.hideTriggers();
            }

        },
        showTriggers: function() {
            $('#triggers-list').prop('disabled', false);
            $('#triggers-list-submit').prop('disabled', false);
        },
        hideTriggers: function() {
            $('#triggers-list').prop('disabled', true);
            $('#triggers-list-submit').prop('disabled', true);
        },
        createNewSequence: function(e) {
            e.preventDefault();
            $('#sequence-form').removeClass('hidden');
            $('#existing-sequence-name').closest('p').addClass('hidden').val(0).trigger('change');
            $('#triggers-form').addClass('hidden');
            $('.sequence-status-delete').attr('disabled', true);
            $('#email-sequence-triggers-block').html(_.template(EmailSequenceTriggersPlaceholderTmpl, {'i18n': i18n}));
            $('#existing-sequence-name').val('0');
            $('.rename-email-sequence').attr('disabled', true).hide();
        },
        closeNewSequence:function(e) {
            $('#sequence-form').addClass('hidden');
            $('#existing-sequence-name').closest('p').removeClass('hidden');
            if ($('#existing-sequence-name').val() == '0') {
                this.hideTriggers();
            } else {
                this.showTriggers();
            }
            $('#triggers-form').removeClass('hidden');
            $('.rename-email-sequence').data('sequence-id', '').val('').show();
        },
        deleteSequence: function(e){
            e.preventDefault();
            var sequenceId = $('#existing-sequence-name').val(),
                self = this;

            if (sequenceId == '0') {
                return false;
            }

            smoke.quiz(_.isUndefined(i18n['Do you want to archive or delete sequence?'])?'Do you want to archive or delete sequence?':i18n['Do you want to archive or delete sequence?'], function(e){
                var actionType = '';

                if(!e){
                    return false;
                }

                if(e == 'Archive'){
                    actionType = 'archive';
                }
                if(e == 'Delete'){
                    actionType = 'delete';
                }

                $.ajax({
                    'url': $('#website_url').val()+'/api/emailsequence/emailsequence/id/'+sequenceId+'/actionType/'+actionType,
                    'type' : 'DELETE',
                    'dataType' : 'json'
                }).done(function(response){
                    showMessage(response.responseText, false, 5000);
                    $('#email-sequence-triggers-block').empty();
                    $('.sequence-status-delete').attr('disabled', true);
                    $('#email-sequence-triggers-block').html(_.template(EmailSequenceTriggersPlaceholderTmpl, {'i18n': i18n}));
                    self.emailSequenceCollection.fetch();
                }).fail(function(response){
                    showMessage(response.responseJSON, true, 5000);
                });
            }, {
                button_1       : (_.isUndefined(i18n['Archive'])?'Archive':i18n['Archive']),
                button_2       : (_.isUndefined(i18n['Delete'])?'Delete':i18n['Delete']),
                button_cancel  : (_.isUndefined(i18n['Cancel'])?'Cancel':i18n['Cancel']),
                reverseButtons : true
            });
        },
        switchOldNewSequence: function(e) {
            var switchVal = $(e.currentTarget).val();
            if (switchVal === 'new_sequence') {
                $('#sequence-form').removeClass('hidden');
                $('#existing-sequence-name').addClass('hidden').val(0).trigger('change');
                $('#triggers-form').addClass('hidden');
            } else {
                $('#sequence-form').addClass('hidden');
                $('#existing-sequence-name').removeClass('hidden');
                if ($('#existing-sequence-name').val() == '0') {
                    this.hideTriggers();
                } else {
                    this.showTriggers();
                }
                $('#triggers-form').removeClass('hidden');
             }
        },
        addTriggerToSequence: function(e)
        {
            e.preventDefault();

            var self = this,
                form = $(e.currentTarget),
                isValid = true,
                sequenceSettingsId = $('#existing-sequence-name').val();

            _.each(form.find('.required'), function(el){
                if (!$(el).val()){
                    isValid = false;
                }
            });

            if (!isValid){
                showMessage(_.isUndefined(i18n['Missing required field'])?'Missing required field':i18n['Missing required field'], true);
                return false;
            }
            showSpinner();

            $.ajax({
                url: $('#website_url').val()+'api/emailsequence/emailsequencetrigger/',
                data: {
                    'trigger_id': form.find('#triggers-list').val(),
                    'sequence_settings_id' : sequenceSettingsId,
                    'secureToken': $('#email-sequence-secure-token').val()
                },
                type: 'POST',
                dataType: 'json'
            }).done(function(responseData) {
                hideSpinner();
                showMessage(_.isUndefined(i18n['Trigger added'])?'Trigger added':i18n['Trigger added']);
                self.emailSequenceTriggersView.$el.unbind();
                self.emailSequenceTriggersView = new EmailSequenceTriggersView(sequenceSettingsId);
                self.emailSequenceTriggersView.render();

            }).fail(function(response){
                hideSpinner();
                showMessage(response.responseJSON, true, 5000);
            });
        },
        saveSequence: function(e) {
            e.preventDefault();
            var self = this,
                form = $(e.currentTarget),
                isValid = true;

            _.each(form.find('.required'), function(el){
                if (!$(el).val()){
                    isValid = false;
                }
            });

            if (!isValid){
                showMessage(_.isUndefined(i18n['Missing required field'])?'Missing required field':i18n['Missing required field'], true);
                return false;
            }
            showSpinner();

            $.ajax({
                url: $('#website_url').val()+'api/emailsequence/emailsequence/',
                data: {
                    'sequence_name': form.find('.new-sequence-name').val(),
                    'secureToken': $('#email-sequence-secure-token').val()
                },
                type: 'POST',
                dataType: 'json'
            }).done(function(responseData) {
                hideSpinner();
                showMessage(_.isUndefined(i18n['Saved'])?'Saved':i18n['Saved']);
                self.emailSequenceCollection.fetch({
                    success: function(response){
                       self.render();
                       $('#existing-sequence-name').val(responseData.responseText.sequenceId);
                       $('.rename-email-sequence').val(form.find('.new-sequence-name').val()).data('sequence-id', responseData.responseText.sequenceId).removeAttr('disabled');
                       $('.sequence-status-delete').removeAttr('disabled');
                       self.showTriggers();
                       if (typeof self.emailSequenceTriggersView !== 'undefined') {
                           self.emailSequenceTriggersView.$el.unbind();
                       }
                       self.emailSequenceTriggersView = new EmailSequenceTriggersView(responseData.responseText.sequenceId);
                       self.emailSequenceTriggersView.render();
                    }
                });
            }).fail(function(response){
                hideSpinner();
                showMessage(response.responseJSON, true, 5000);
            });

        }

    });

    return EmailSequenceFormView;
});
