define([
    'backbone',
    '../models/email-trigger',
    'backbone.paginator'
], function(Backbone, EmailTriggerModel){

    var EmailTriggerCollection = Backbone.Paginator.requestPager.extend({
        model: EmailTriggerModel,
        paginator_core: {
            type: 'GET',
            dataType: 'json',
            url: function(){
                return $('#website_url').val() + 'api/emailtrigger/emailtrigger/id/';
            }
        },
        paginator_ui: {
            firstPage:    0,
            currentPage:  0,
            perPage:     10,
            totalPages:  10,
            filterSequenceNames:{},
            filterTemplateNames:{},
        },
        server_api: {
            count: true,
            limit: function() { return this.perPage; },
            offset: function() { return this.currentPage * this.perPage },
            key: function(){ return this.key; },
            isGrid: function(){ return this.isGrid; },
            detailedInfo: function(){ return this.detailedInfo; },
            order: function(){ return this.order; },
            customPaginate: function(){ return this.customPaginate; },
            filterType: function(){ return this.filterType },
            filterSequenceName: function(){ return this.filterSequenceName },
            filterTemplate: function(){ return this.filterTemplate },
        },
        parse: function(response, xhr){
            if (this.server_api.count){
                this.totalRecords = response.totalRecords;
            } else {
                this.totalRecords = response.length;
            }
            if(this.customPaginate) {
                this.perPage = this.customPaginate;
            }

            this.filterSequenceNames = response.sequenceNames;
            this.filterTemplateNames = response.templateNames;
            this.limitedAccess = response.limitedAccess;
            this.totalPages = Math.floor(this.totalRecords / this.perPage);
            return this.server_api.count ? response.data : response;
        }
    });

    return EmailTriggerCollection;
});
