<?php


class Emailsequence_Models_Mapper_EmailsequenceQueueMapper extends Application_Model_Mappers_Abstract {

    protected $_dbTable = 'Emailsequence_Models_Dbtables_EmailsequenceQueueDbtable';

    protected $_model   = 'Emailsequence_Models_Models_EmailsequenceQueueModel';

    public function save($queue) {
        if(!$queue instanceof $this->_model) {
            throw new Exceptions_SeotoasterException('Given parameter should be ' . $this->_model . ' instance');
        }
        $data = array(
            'cartStatusId'    => $queue->getCartStatusId(),
            'status'          => $queue->getStatus(),
            'cartId'          => $queue->getCartId(),
            'type'            => $queue->getType(),
            'userEmail'       => $queue->getUserEmail(),
            'userFullName'    => $queue->getUserFullName(),
            'userPhoneNumber' => $queue->getUserPhoneNumber(),
            'cartStatus'      => $queue->getCartStatus(),
            'emailTemplate'   => $queue->getEmailTemplate(),
            'emailFrom'       => $queue->getEmailFrom(),
            'emailFromLabel'  => $queue->getEmailFromLabel(),
            'emailMessage'    => $queue->getEmailMessage(),
            'sentAt'          => $queue->getSentAt(),
            'delayDelivery'   => $queue->getDelayDelivery(),
            'delayedTo'       => $queue->getDelayedTo(),
            'externalId'      => $queue->getExternalId(),
            'externalType'    => $queue->getExternalType(),
            'sequence_id'     => $queue->getSequenceId(),
            'subject'         => $queue->getSubject(),
            'preheader'       => $queue->getPreheader()
        );

        $id = $queue->getId();
        if (!empty($id)) {
            $where = $this->getDbTable()->getAdapter()->quoteInto('id = ?', $id);
            $this->getDbTable()->update($data, $where);
        } else {
            $id = $this->getDbTable()->insert($data);
            $queue->setId($id);
        }

        return $queue;

    }

    public function deleteQueueByCartStatusId($cartStatusId, array $withStatus = array())
    {
        $where = $this->getDbTable()->getAdapter()->quoteInto("cartStatusId=?", $cartStatusId);
        if (!empty($withStatus)) {
            $where .= ' AND '. $this->getDbTable()->getAdapter()->quoteInto("status IN (?)", $withStatus);
        }

        return $this->getDbTable()->delete($where);
    }

    public function selectFromQueue($cartStatusId, $cartId, $userEmail){
        $where = $this->getDbTable()->getAdapter()->quoteInto("cartStatusId=?", $cartStatusId);
        $where .= ' AND '. $this->getDbTable()->getAdapter()->quoteInto("cartId=?", $cartId);
        $where .= ' AND '. $this->getDbTable()->getAdapter()->quoteInto("userEmail=?", $userEmail);
        return $this->fetchAll($where);
    }

    /**
     * Select unique sequence record
     *
     * @param int $cartStatusId cart session config id
     * @param int $externalId (any external id Ex: lead id)
     * @param int $sequenceId sequence id
     * @param string $externalType external type
     * @return array|null
     * @throws Exception
     */
    public function selectUniqueSequence($cartStatusId, $externalId, $sequenceId, $externalType = '')
    {
        $where = '';
        if(!empty($cartStatusId)) {
            $where = $this->getDbTable()->getAdapter()->quoteInto("cartStatusId = ?", $cartStatusId);
            $where .= ' AND ';
        }

        $where .= $this->getDbTable()->getAdapter()->quoteInto("externalId = ?", $externalId);
        $where .= ' AND ' . $this->getDbTable()->getAdapter()->quoteInto("sequence_id = ?", $sequenceId);
        if (!empty($externalType)) {
            $where .= ' AND ' . $this->getDbTable()->getAdapter()->quoteInto("externalType = ?", $externalType);
        }

        return $this->fetchAll($where);
    }

    public function getAllQueue($excludeDelayDelivery = false, $delayedTo = '', $withoutLimit = false){
        $where = $this->getDbTable()->getAdapter()->quoteInto("status=?", '0');
        if ($excludeDelayDelivery) {
            $where .= ' AND '. $this->getDbTable()->getAdapter()->quoteInto("delayDelivery <> ?", '1');
        }
        if (!empty($delayedTo)) {
            $where .= ' AND '. $this->getDbTable()->getAdapter()->quoteInto("delayedTo < ?", $delayedTo);
        }

        $select = $this->getDbTable()->getAdapter()->select()->from('plugin_cartstatusemail_queue')->where($where);

        if(!$withoutLimit) {
            $select->limit(3, 0);
        }

        $resultSet =  $this->getDbTable()->getAdapter()->fetchAll($select);
        $entries = array();
        foreach ($resultSet as $row) {
            $entries[] = new $this->_model($row);
        }
        return $entries;
    }

    /**
     * Update queue status
     *
     * @param int $queueId queue id
     * @param string $sentStatus (0,1,2)
     * @param bool $setSentDate assign date
     * @throws Exception
     */
    public function updateQueueStatus($queueId, $sentStatus, $setSentDate = false)
    {
        $where = $this->getDbTable()->getAdapter()->quoteInto("id=?", $queueId);
        if ($setSentDate) {
            $data = array('status' => $sentStatus, 'sentAt' => Tools_System_Tools::convertDateFromTimezone('now'));
        } else {
            $data = array('status' => $sentStatus);
        }

        $this->getDbTable()->update($data, $where);
    }

    /**
     * Update queue delivery
     *
     * @param int $queueId queue id
     * @param int $delayDelivery delay delivery flag
     * @param string $delayTo mysql date format
     * @throws Exception
     */
    public function updateQueueDelivery($queueId, $delayDelivery, $delayTo)
    {
        $where = $this->getDbTable()->getAdapter()->quoteInto("id=?", $queueId);
        $data = array('delayDelivery' => $delayDelivery, 'delayedTo' => $delayTo);

        $this->getDbTable()->update($data, $where);
    }

    public function cleanQueueByCartIdStatus($cartId, $cartStatus){
        $cacheHelper = Zend_Controller_Action_HelperBroker::getExistingHelper('cache');
        $where = $this->getDbTable()->getAdapter()->quoteInto("cartId=?", $cartId);
        $cartInQueueExist = $this->fetchAll($where);
        if(!empty($cartInQueueExist)){
            if($cartInQueueExist[0]->getCartStatus() != $cartStatus){
                $this->getDbTable()->delete($where);
                $cacheHelper->clean('cartstatus_configdata', 'cart_status');
            }
        }
    }

    /**
     * Update queue status by email
     *
     * @param string $email user email
     * @param string $status queue status (0, 1, 2)
     */
    public function updateQueueStatusByEmail($email, $status = Emailsequence::QUEUE_STATUS_NOT_SENT)
    {
        $where = $this->getDbTable()->getAdapter()->quoteInto("userEmail = ?", $email);
        return $this->getDbTable()->update(array('status' => $status), $where);
    }

    /**
     * Update queue status for not sent emails by email
     *
     * @param string $email user email
     * @param string $status queue status (0, 1, 2)
     */
    public function updateNotSentQueueStatusByEmail($email, $status = Emailsequence::QUEUE_STATUS_NOT_SENT)
    {
        $where = $this->getDbTable()->getAdapter()->quoteInto("userEmail = ?", $email);
        $where .= ' AND '. $this->getDbTable()->getAdapter()->quoteInto("status = ?", Emailsequence::QUEUE_STATUS_NOT_SENT);
        return $this->getDbTable()->update(array('status' => $status), $where);
    }

    /**
     * Delete sequence by sequence id
     *
     * @param $sequenceId
     * @param array $withStatus
     * @return mixed
     * @throws Exception
     */
    public function deleteQueueBySequenceId($sequenceId, array $withStatus = array())
    {
        $where = $this->getDbTable()->getAdapter()->quoteInto("sequence_id = ?", $sequenceId);
        if (!empty($withStatus)) {
            $where .= ' AND '. $this->getDbTable()->getAdapter()->quoteInto("status IN (?)", $withStatus);
        }

        return $this->getDbTable()->delete($where);
    }

    /**
     * Delete sequence by sequence id and externalId with external type and woth status 0
     *
     * @param $sequenceId
     * @param $externalId
     * @param string $externalType
     * @param array $withStatus
     * @return mixed
     * @throws Exception
     */
    public function deleteQueueBySequenceIdAndExternalId($sequenceId, $externalId, $externalType = '', array $withStatus = array())
    {
        $where = $this->getDbTable()->getAdapter()->quoteInto("sequence_id = ?", $sequenceId);
        $where .= ' AND ' . $this->getDbTable()->getAdapter()->quoteInto("externalId = ?", $externalId);

        if (!empty($externalType)) {
            $where .= ' AND ' . $this->getDbTable()->getAdapter()->quoteInto("externalType = ?", $externalType);
        }

        if (!empty($withStatus)) {
            $where .= ' AND '. $this->getDbTable()->getAdapter()->quoteInto("status IN (?)", $withStatus);
        }

        return $this->getDbTable()->delete($where);
    }

    /**
     * @param string $mobileNumber mobile number
     * @param string $status '0', '1', '2'
     * @return mixed
     * @throws Exception
     */
    public function deleteByPhoneNumber($mobileNumber, $status = '0')
    {
        $where = $this->getDbTable()->getAdapter()->quoteInto("userPhoneNumber = ?", $mobileNumber);
        $where .= ' AND '. $this->getDbTable()->getAdapter()->quoteInto("status = ?", $status);
        return $this->getDbTable()->delete($where);
    }


    /**
     * Delete queue record
     *
     * @param int $id queue id
     * @return mixed
     * @throws Exception
     */
    public function delete($id)
    {
        $where = $this->getDbTable()->getAdapter()->quoteInto('id = ?', $id);

        return $this->getDbTable()->getAdapter()->delete('plugin_cartstatusemail_queue', $where);
    }

}

