<?php
class Api_Emailtrigger_Emailtriggerstats extends Api_Service_Abstract
{

    /**
     * @var array Access Control List
     */
    protected $_accessList = array(
        Tools_Security_Acl::ROLE_SUPERADMIN => array(
            'allow' => array('get', 'post', 'put', 'delete')
        ),
        Tools_Security_Acl::ROLE_ADMIN => array(
            'allow' => array('get', 'post', 'put', 'delete')
        ),
        Shopping::ROLE_SALESPERSON => array(
            'allow' => array('get', 'post', 'put', 'delete')
        )
    );

    /**
     * User restricted id access
     *
     * @var null
     */
    protected $_restrictedUserId = null;

    /**
     * System translate helper
     *
     * @var null
     */
    protected $_translator = null;

    /**
     * System response helper
     *
     * @var null
     */
    protected $_responseHelper = null;


    /**
     * init
     */
    public function init()
    {
        parent::init();
        $this->_responseHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('response');
        $this->_translator = Zend_Registry::get('Zend_Translate');
        $this->_restrictedUserId = Tools_EmailSequenceTools::getUserIdIfActionNotAllowed(Shopping::ROLE_SALESPERSON);
    }

    /**
     * Get email trigger stats
     *
     * Resourse:
     * : /api/emailtrigger/emailtriggerstats/id/:id
     *
     * HttpMethod:
     * : GET
     *
     * ## Parameters:
     * * id (type integer)
     * : id
     *
     *
     * @return JSON
     */
    public function getAction()
    {
        $id = filter_var($this->_request->getParam('id'), FILTER_SANITIZE_NUMBER_INT);
        $startDate = filter_var($this->_request->getParam('startDate'), FILTER_SANITIZE_STRING);
        $endDate = filter_var($this->_request->getParam('endDate'), FILTER_SANITIZE_STRING);
        $openedByEmailClientsType = filter_var($this->_request->getParam('openedByEmailClientsType'), FILTER_SANITIZE_STRING);
        $sequenceIds = $this->_request->getParam('sequenceIds');

        if (empty($id)) {
            $this->_responseHelper->fail('Id is required');
        }

        if (!empty($startDate)) {
            $startDate = Tools_System_Tools::convertDateFromTimezone($startDate);
        }

        if (!empty($endDate)) {
            $endDate = Tools_System_Tools::convertDateFromTimezone($endDate.' 23:59:59');
        }

        $emailStats = Tools_EmailStatsTools::getEmailStats($id, $sequenceIds, $startDate, $endDate);
        $data['emailStats'] = $emailStats;
        $openByEmailClientData = Tools_EmailStatsTools::getOpenByEmailClient($id, $openedByEmailClientsType, $sequenceIds, $startDate, $endDate);
        $data['openedByEmailClientsData'] = json_encode($openByEmailClientData);

        if (empty($data)) {
            $data = array();
        }

        return $data;

    }

    /**
     *
     * Resourse:
     * : /api/emailtrigger/emailtriggerstats/
     *
     * HttpMethod:
     * : POST
     *
     * @return JSON
     */
    public function postAction()
    {


    }

    public function putAction()
    {

    }

    /**
     *
     * Resourse:
     * : /api/emailtrigger/emailtriggerstats/
     *
     * HttpMethod:
     * : DELETE
     *
     * ## Parameters:
     * id (type integer)
     *
     * @return JSON
     */
    public function deleteAction()
    {

    }

}
