<?php

class Api_Emailsequence_Emailsequencetrigger extends Api_Service_Abstract
{


    /**
     * System response helper
     *
     * @var null
     */
    protected $_responseHelper = null;

    /**
     * System translate helper
     *
     * @var null
     */
    protected $_translator = null;


    /**
     * Mandatory fields
     *
     * @var array
     */
    protected $_mandatoryParams = array('trigger_id', 'sequence_settings_id');

    /**
     * Email sequence secure token
     */
    const EMAIL_SEQUENCE_SECURE_TOKEN = 'EmailSequenceToken';

    /**
     * @var array Access Control List
     */
    protected $_accessList = array(
        Tools_Security_Acl::ROLE_SUPERADMIN => array(
            'allow' => array('get', 'post', 'put', 'delete')
        ),
        Tools_Security_Acl::ROLE_ADMIN => array(
            'allow' => array('get', 'post', 'put', 'delete')
        ),
        Shopping::ROLE_SALESPERSON => array(
            'allow' => array('get', 'post', 'put', 'delete')
        )
    );

    /**
     * User restricted id access
     *
     * @var null
     */
    protected $_restrictedUserId = null;

    /**
     * init
     */
    public function init()
    {
        parent::init();
        $this->_responseHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('response');
        $this->_translator = Zend_Registry::get('Zend_Translate');
        $this->_restrictedUserId = Tools_EmailSequenceTools::getUserIdIfActionNotAllowed(Shopping::ROLE_SALESPERSON);
    }

    /**
     * Get email sequence triggers
     *
     * Resourse:
     * : /api/emailsequence/emailsequencetrigger/sequenceId/:sequenceId
     *
     * HttpMethod:
     * : GET
     *
     * ## Parameters:
     * * id (type integer)
     * : id
     *
     * @return JSON List of groups
     */
    public function getAction()
    {
        $sequenceId = filter_var($this->_request->getParam('sequenceId'), FILTER_SANITIZE_NUMBER_INT);
        $emailSequenceTriggersMapper = Emailsequence_Models_Mapper_EmailSequenceTriggersMapper::getInstance();
        $data = array();
        if (!empty($sequenceId)) {
            $where = $emailSequenceTriggersMapper->getDbTable()->getAdapter()->quoteInto('sequence_settings_id = ?',
                $sequenceId);
            $data = $emailSequenceTriggersMapper->getBySequenceId($where, array('cartStatus', 'calculatedPeriod'));
            if (!empty($data['data'])) {
                $productIds = array();
                foreach ($data['data'] as $key => $singleSequence) {
                    $data['data'][$key]['cartStatusLabel'] = Tools_EmailSequenceTools::getCartStatusLabel($singleSequence['cartStatus']);

                    if (!empty($singleSequence['productsIds'])) {
                        $productIds = array_merge($productIds, explode(',', $singleSequence['productsIds']));
                    }
                }
                if (!empty($productIds)) {
                    $productIds = array_unique($productIds);
                    $select = $emailSequenceTriggersMapper->getDbTable()->getAdapter()->select()
                        ->from(array('p' => 'page'), array('productId' => 'product.id', 'pageUrl' => 'p.url'))
                        ->join(array('product' => 'shopping_product'), 'product.page_id = p.id')
                        ->where('product.id IN (?)', $productIds);
                    $productsData = $emailSequenceTriggersMapper->getDbTable()->getAdapter()->fetchAssoc($select);
                }
            }

            if (!empty($productsData)) {
                $data['productsData'] = $productsData;
            } else {
                $data['productsData'] = array();
            }

            $data['limitedAccess'] =  $this->_restrictedUserId;

        }

        return $data;

    }

    /**
     * Change email sequence triggers
     *
     * Resourse:
     * : /api/emailsequence/emailsequencetrigger/
     *
     * HttpMethod:
     * : POST
     *
     * @return JSON Email sequence model
     */
    public function postAction()
    {
        if (!empty($this->_restrictedUserId)) {
            $this->_error($this->_translator->translate(Emailsequence::TRANSLATION_PREFIX.'You don\'t have permission to create trigger'));
        }

        $data = filter_var_array($this->getRequest()->getParams(), FILTER_SANITIZE_STRING);


        $fieldDataMissing = array_filter($this->_mandatoryParams, function ($param) use ($data) {
            if (!array_key_exists($param, $data) || empty($data[$param])) {
                return $param;
            }
        });

        if (!empty($fieldDataMissing)) {
            $this->_error($this->_translator->translate(Emailsequence::TRANSLATION_PREFIX.'Missing mandatory params'));
        }

        $emailSequenceTriggerMapper = Emailsequence_Models_Mapper_EmailSequenceTriggersMapper::getInstance();
        $emailSequenceTriggerModel = $emailSequenceTriggerMapper->getBySequenceTriggerId($data['sequence_settings_id'],
            $data['trigger_id']);
        if ($emailSequenceTriggerModel instanceof Emailsequence_Models_Models_EmailSequenceTriggersModel) {
            $this->_error($this->_translator->translate(Emailsequence::TRANSLATION_PREFIX.'Trigger with such name already exists in the sequence'));
        }

        $emailSequenceModel = new Emailsequence_Models_Models_EmailSequenceTriggersModel();
        $emailSequenceModel->setSequenceSettingsId($data['sequence_settings_id']);
        if (empty($data['trigger_enabled'])) {
            $emailSequenceModel->setTriggerEnabled('0');
        } else {
            $emailSequenceModel->setTriggerEnabled('1');
        }
        $emailSequenceModel->setTriggerId($data['trigger_id']);
        $emailSequenceModel = $emailSequenceTriggerMapper->save($emailSequenceModel);

        $this->_responseHelper->success(array(
            'message' => $this->_translator->translate(Emailsequence::TRANSLATION_PREFIX.'Sequence has been created')
        ));
    }

    /**
     *
     * Resourse:
     * : /api/emailsequence/emailsequencetrigger/
     *
     * HttpMethod:
     * : PUT
     *
     * @return  JSON Email sequence model
     */
    public function putAction()
    {
        if (!empty($this->_restrictedUserId)) {
            $this->_error($this->_translator->translate(Emailsequence::TRANSLATION_PREFIX.'You don\'t have permission to edit email sequence trigger'));
        }

        $data = json_decode($this->_request->getRawBody(), true);
        $fieldDataMissing = array_filter($this->_mandatoryParams, function ($param) use ($data) {
            if (!array_key_exists($param, $data) || empty($data[$param])) {
                return $param;
            }
        });

        if (!empty($fieldDataMissing)) {
            $this->_error($this->_translator->translate(Emailsequence::TRANSLATION_PREFIX.'Missing mandatory params'));
        }

        $emailSequenceTriggerMapper = Emailsequence_Models_Mapper_EmailSequenceTriggersMapper::getInstance();
        $emailSequenceTriggerModel = $emailSequenceTriggerMapper->getBySequenceTriggerId($data['sequence_settings_id'],
            $data['trigger_id']);
        if (!$emailSequenceTriggerModel instanceof Emailsequence_Models_Models_EmailSequenceTriggersModel) {
            $this->_error($this->_translator->translate(Emailsequence::TRANSLATION_PREFIX.'Trigger with such name doesn\'t exist'));
        }

        if (empty($data['trigger_enabled'])) {
            $emailSequenceTriggerModel->setTriggerEnabled('0');
        } else {
            $emailSequenceTriggerModel->setTriggerEnabled('1');
        }

        $emailSequenceModel = $emailSequenceTriggerMapper->save($emailSequenceTriggerModel);

        $this->_responseHelper->success(array(
            'message' => $this->_translator->translate(Emailsequence::TRANSLATION_PREFIX.'Status of the trigger has been changed')
        ));
    }

    /**
     * Delete email sequence trigger
     *
     * Resourse:
     * : /api/emailsequence/emailsequencetrigger/
     *
     * HttpMethod:
     * : DELETE
     *
     * ## Parameters:
     * id (type integer)
     * : sequence id to delete
     *
     * @return JSON Result of removing cart status email
     */
    public function deleteAction()
    {
        if (!empty($this->_restrictedUserId)) {
            $this->_error($this->_translator->translate(Emailsequence::TRANSLATION_PREFIX.'You don\'t have permission to delete email sequence trigger'));
        }

        $triggerId = filter_var($this->_request->getParam('trigger_id'), FILTER_SANITIZE_NUMBER_INT);
        $sequenceId = filter_var($this->_request->getParam('sequence_id'), FILTER_SANITIZE_NUMBER_INT);

        if (empty($triggerId) || empty($sequenceId)) {
            $this->_error($this->_translator->translate(Emailsequence::TRANSLATION_PREFIX.'Sequence or trigger id missing'));
        }
        $emailSequenceTriggersMapper = Emailsequence_Models_Mapper_EmailSequenceTriggersMapper::getInstance();
        $emailSequenceTriggerModel = $emailSequenceTriggersMapper->getBySequenceTriggerId($sequenceId, $triggerId);
        if ($emailSequenceTriggerModel instanceof Emailsequence_Models_Models_EmailSequenceTriggersModel) {
            $emailSequenceTriggersMapper->deleteTrigger($triggerId, $sequenceId);
            $this->_responseHelper->success($this->_translator->translate(Emailsequence::TRANSLATION_PREFIX.'Trigger has been deleted from the sequence'));
        }

        $this->_error($this->_translator->translate(Emailsequence::TRANSLATION_PREFIX.'Sequence trigger doesn\'t exist'));
    }

}
