<?php

class Api_Emailsequence_Emailsequence extends Api_Service_Abstract
{


    /**
     * System response helper
     *
     * @var null
     */
    protected $_responseHelper = null;

    /**
     * System translate helper
     *
     * @var null
     */
    protected $_translator = null;


    /**
     * Mandatory fields
     *
     * @var array
     */
    protected $_mandatoryParams = array('sequence_name');

    /**
     * Email sequence secure token
     */
    const EMAIL_SEQUENCE_SECURE_TOKEN = 'EmailSequenceToken';

    /**
     * @var array Access Control List
     */
    protected $_accessList = array(
        Tools_Security_Acl::ROLE_SUPERADMIN => array(
            'allow' => array('get', 'post', 'put', 'delete')
        ),
        Tools_Security_Acl::ROLE_ADMIN => array(
            'allow' => array('get', 'post', 'put', 'delete')
        ),
        Shopping::ROLE_SALESPERSON => array(
            'allow' => array('get', 'post', 'put', 'delete')
        )
    );

    /**
     * User restricted id access
     *
     * @var null
     */
    protected $_restrictedUserId = null;

    /**
     * init
     */
    public function init()
    {
        parent::init();
        $this->_responseHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('response');
        $this->_translator = Zend_Registry::get('Zend_Translate');
        $this->_restrictedUserId = Tools_EmailSequenceTools::getUserIdIfActionNotAllowed(Shopping::ROLE_SALESPERSON);
    }

    /**
     * Get email sequence
     *
     * Resourse:
     * : /api/emailsequence/emailsequence/id/:id
     *
     * HttpMethod:
     * : GET
     *
     * ## Parameters:
     * * id (type integer)
     * : id
     *
     * @return JSON List of groups
     */
    public function getAction()
    {
        $id = filter_var($this->_request->getParam('id'), FILTER_SANITIZE_NUMBER_INT);
        $withoutPagination = filter_var($this->_request->getParam('withoutPagination'), FILTER_SANITIZE_NUMBER_INT);
        $searchTerm = filter_var($this->_request->getParam('searchTerm'), FILTER_SANITIZE_STRING);
        $emailSequenceMapper = Emailsequence_Models_Mapper_EmailSequenceSettingsMapper::getInstance();
        $data = array();
        if (!empty($id)) {
            $data = $emailSequenceMapper->find($id);
            if (!empty($data)) {
                $data = $data->toArray();
            }
        } elseif(!empty($withoutPagination)) {
            if (!empty($searchTerm)) {
                $where = $emailSequenceMapper->getDbTable()->getAdapter()->quoteInto('sequence_name LIKE ?', '%'.$searchTerm.'%');
                $data = $emailSequenceMapper->getSequences($where);
            } else {
                $data = $emailSequenceMapper->getSequences();
            }
        } else {
            $where = $emailSequenceMapper->getDbTable()->getAdapter()->quoteInto('archive = ?', '0');
            $data = $emailSequenceMapper->getEmailSequenceList($where);
        }

        if (!empty($data) && empty($withoutPagination)) {
            $data['triggers'] = $emailSequenceMapper->getAllTriggers();
        }

        $data['limitedAccess'] =  $this->_restrictedUserId;

        return $data;

    }

    /**
     * New email sequence config settings
     *
     * Resourse:
     * : /api/emailsequence/emailsequence/
     *
     * HttpMethod:
     * : POST
     *
     * @return JSON Email sequence model
     */
    public function postAction()
    {
        if (!empty($this->_restrictedUserId)) {
            $this->_error($this->_translator->translate(Emailsequence::TRANSLATION_PREFIX.'You don\'t have permission to create sequence'));
        }

        $data = filter_var_array($this->getRequest()->getParams(), FILTER_SANITIZE_STRING);


        $fieldDataMissing = array_filter($this->_mandatoryParams, function ($param) use ($data) {
            if (!array_key_exists($param, $data) || empty($data[$param])) {
                return $param;
            }
        });

        if (!empty($fieldDataMissing)) {
            $this->_error($this->_translator->translate(Emailsequence::TRANSLATION_PREFIX.'Missing mandatory params'));
        }

        $emailSequenceMapper = Emailsequence_Models_Mapper_EmailSequenceSettingsMapper::getInstance();
        $data['sequence_name'] = trim($data['sequence_name']);
        $emailSequenceModel = $emailSequenceMapper->findBySequenceName($data['sequence_name']);
        if ($emailSequenceModel instanceof Emailsequence_Models_Models_EmailSequenceSettingsModel) {
            $this->_error($this->_translator->translate(Emailsequence::TRANSLATION_PREFIX.'Sequence with such name already exists'));
        }

        if(!empty($data['renameSequence']) && !empty($data['sequenceId'])) {
            $emailSequenceModel = $emailSequenceMapper->find($data['sequenceId']);

            if($emailSequenceModel instanceof Emailsequence_Models_Models_EmailSequenceSettingsModel) {
                $emailSequenceModel->setSequenceName($data['sequence_name']);
                $emailSequenceModel = $emailSequenceMapper->save($emailSequenceModel);

                $this->_responseHelper->success(array(
                    'message' => $this->_translator->translate(Emailsequence::TRANSLATION_PREFIX.'Sequence has been updated'),
                    'sequenceId' => $emailSequenceModel->getId()
                ));
            }
        } else {
            $emailSequenceModel = new Emailsequence_Models_Models_EmailSequenceSettingsModel();
            $emailSequenceModel->setSequenceName($data['sequence_name']);
            $emailSequenceModel = $emailSequenceMapper->save($emailSequenceModel);

            $this->_responseHelper->success(array(
                'message' => $this->_translator->translate(Emailsequence::TRANSLATION_PREFIX.'Sequence has been created'),
                'sequenceId' => $emailSequenceModel->getId()
            ));
        }
    }

    /**
     *
     * Resourse:
     * : /api/emailsequence/emailsequence/
     *
     * HttpMethod:
     * : PUT
     *
     * @return  JSON Email sequence model
     */
    public function putAction()
    {

    }

    /**
     * Delete email sequence
     *
     * Resourse:
     * : /api/emailsequence/emailsequence/
     *
     * HttpMethod:
     * : DELETE
     *
     * ## Parameters:
     * id (type integer)
     * : sequence id to delete
     *
     * @return JSON Result of removing cart status email
     */
    public function deleteAction()
    {
        if (!empty($this->_restrictedUserId)) {
            $this->_error($this->_translator->translate(Emailsequence::TRANSLATION_PREFIX.'You don\'t have permission to delete sequence'));
        }

        $id = filter_var($this->_request->getParam('id'), FILTER_SANITIZE_NUMBER_INT);
        $actionType = filter_var($this->_request->getParam('actionType'), FILTER_SANITIZE_STRING);

        if (empty($id)) {
            $this->_error($this->_translator->translate(Emailsequence::TRANSLATION_PREFIX.'id is missing'));
        }

        if(empty($actionType)) {
            $this->_error($this->_translator->translate(Emailsequence::TRANSLATION_PREFIX.'Action type is missing'));
        }

        $emailSequenceMapper = Emailsequence_Models_Mapper_EmailSequenceSettingsMapper::getInstance();
        $emailSequenceModel = $emailSequenceMapper->find($id);
        if ($emailSequenceModel instanceof Emailsequence_Models_Models_EmailSequenceSettingsModel) {
            if($actionType == 'archive') {
                $emailSequenceModel->setArchive('1');
                $emailSequenceMapper->save($emailSequenceModel);

                $this->_responseHelper->success($this->_translator->translate(Emailsequence::TRANSLATION_PREFIX.'Sequence has been archived'));
            } else {
                $emailSequenceMapper->deleteSequence($id);
                Emailsequence_Models_Mapper_EmailsequenceQueueMapper::getInstance()->deleteQueueBySequenceId($id, array('0'));

                $this->_responseHelper->success($this->_translator->translate(Emailsequence::TRANSLATION_PREFIX.'Sequence has been deleted'));
            }
        }

        $this->_error($this->_translator->translate(Emailsequence::TRANSLATION_PREFIX.'Sequence doesn\'t exist'));
    }

}
