<?php

class Crm_Model_ChecklistModel extends Application_Model_Models_Abstract
{
    const CHECKLIST_CLOSED_BY_AUTOMATICALLY = 'automatically';

    const CHECKLIST_CLOSED_BY_MANUALLY = 'manually';

    protected $_checklistStatus = '';

    protected $_checklistName = '';

    protected $_closedBy = self::CHECKLIST_CLOSED_BY_MANUALLY;

    /**
     * @return string
     */
    public function getChecklistStatus()
    {
        return $this->_checklistStatus;
    }

    /**
     * @param string $checklistStatus
     * @return string
     */
    public function setChecklistStatus($checklistStatus)
    {
        $this->_checklistStatus = $checklistStatus;

        return $this;
    }

    /**
     * @return string
     */
    public function getClosedBy()
    {
        return $this->_closedBy;
    }

    /**
     * @param string $closedBy
     * @return string
     */
    public function setClosedBy($closedBy)
    {
        $this->_closedBy = $closedBy;

        return $this;
    }

    /**
     * @return string
     */
    public function getChecklistName()
    {
        return $this->_checklistName;
    }

    /**
     * @param string $checklistName
     * @return string
     */
    public function setChecklistName($checklistName)
    {
        $this->_checklistName = $checklistName;

        return $this;
    }
}