<?php

class Crm extends Tools_Plugins_Abstract
{

    /**
     * Secure token
     */
    const CRM_SECURE_TOKEN = 'CrmToken';

    /**
     * config section
     */
    const SECTION_CRM_CONFIG = 'config';

    /**
     * @var array
     */
    private $_websiteConfig;


    public function  __construct($options, $seotoasterData)
    {
        parent::__construct($options, $seotoasterData);

        $this->_layout = new Zend_Layout();
        $this->_layout->setLayoutPath(Zend_Layout::getMvcInstance()->getLayoutPath());

        if ($viewScriptPath = Zend_Layout::getMvcInstance()->getView()->getScriptPaths()) {
            $this->_view->setScriptPath($viewScriptPath);
        }
        $this->_view->addScriptPath(__DIR__ . '/system/views/');

        $this->_jsonHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('json');
        $this->_websiteConfig = Zend_Registry::get('website');

    }


    public function configAction()
    {
        $currentUserRole = $this->_sessionHelper->getCurrentUser()->getRoleId();
        if ($currentUserRole === Tools_Security_Acl::ROLE_ADMIN || $currentUserRole === Tools_Security_Acl::ROLE_SUPERADMIN) {
            $this->_view->plugins = array();
            foreach (Tools_Plugins_Tools::getPluginsByTags(array('crm')) as $plugin) {
                $tags = $plugin->getTags();
                if (!empty($tags) && in_array('crm', $tags)) {
                    array_push($this->_view->plugins, $plugin->getName());
                }
            }

            $data = $this->_request->getParams();

            $tabName = '';
            if (!empty($data['tabName'])) {
                $tabName = $data['tabName'];
            }

            $tabPosition = 0;
            if (!empty($data['tabPosition'])) {
                $tabPosition = $data['tabPosition'];
            }

            $checklistDataElementsResult = array();
            if (!empty($this->_view->plugins)) {
                foreach ($this->_view->plugins as $plugin) {
                    $className = ucfirst(strtolower($plugin));
                    $methodName = 'crmCheckList';
                    $pluginClass = new Zend_Reflection_Class($className);
                    $crmConfigActions = $pluginClass->hasMethod($methodName);
                    if (!$crmConfigActions) {
                        continue;
                    }

                    $verifyConfigActions = $pluginClass->getMethod($methodName);
                    if (!$verifyConfigActions->isStatic()) {
                        continue;
                    }
                    $checklistElementsData = $className::$methodName();
                    $checklistDataElementsResult = array_merge($checklistDataElementsResult, $checklistElementsData);
                }
            }

            $this->_view->checklistDataElementsResult = $checklistDataElementsResult;
            $this->_view->checklistItems = Crm_Mapper_ChecklistMapper::getInstance()->fetchAll();
            $this->_view->websiteUrl = $this->_websiteUrl;
            $this->_view->helpSection = self::SECTION_CRM_CONFIG;
            $this->_view->tabName = $tabName;
            $this->_view->tabPosition = $tabPosition;
            $this->_view->currentHelpLinkUrl = self::$_helpHashMap[self::SECTION_CRM_CONFIG];
            $this->_layout->content = $this->_view->render('config.phtml');
            echo $this->_layout->render();
        }
    }

    /**
     * Save checklist config
     */
    public function checklistConfigAction()
    {
        if (Tools_Security_Acl::isAllowed(Shopping::RESOURCE_STORE_MANAGEMENT) && $this->_request->isPost()) {
            $this->_validateToken();
            $checklistId = filter_var($this->_request->getParam('checklistId'), FILTER_SANITIZE_NUMBER_INT);
            $checkListStatus = filter_var($this->_request->getParam('checkListStatus'), FILTER_SANITIZE_NUMBER_INT);
            if (!empty($checklistId)) {
                $checkListMapper = Crm_Mapper_ChecklistMapper::getInstance();
                $checkListModel = $checkListMapper->find($checklistId);
                if ($checkListModel instanceof Crm_Model_ChecklistModel) {
                    $checkListModel->setChecklistStatus($checkListStatus);
                    $checkListModel->setClosedBy(Crm_Model_ChecklistModel::CHECKLIST_CLOSED_BY_MANUALLY);
                    $checkListMapper->save($checkListModel);
                    $this->_responseHelper->success($this->_translator->translate('Checklist updated'));
                } else {
                    $this->_responseHelper->fail($this->_translator->translate('Checklist doesn\'t exists'));
                }

            }

            $this->_responseHelper->fail($this->_translator->translate('Checklist id is missing'));
        }
    }

    /**
     * validate secure token for all actions
     */
    private function _validateToken()
    {
        $secureToken = $this->_request->getParam('secureToken', false);
        $tokenValid = Tools_System_Tools::validateToken($secureToken, self::CRM_SECURE_TOKEN);
        if (!$tokenValid) {
            $this->_responseHelper->response($this->_translator->translate('Invalid token'), 1, 400);
        }
    }

    public static $_helpHashMap = array(
        self::SECTION_CRM_CONFIG => 'crm-config.html',
    );


}
